/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Properties;
import joptsimple.OptionException;
import kafka.admin.ConsumerGroupCommand;
import kafka.admin.ConsumerGroupCommandTest;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.errors.GroupIdNotFoundException;
import org.apache.kafka.common.errors.GroupNotEmptyException;
import org.apache.kafka.common.protocol.Errors;
import org.junit.Assert;
import org.junit.Test;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001!3A!\u0004\b\u0001'!)\u0001\u0004\u0001C\u00013!)1\u0004\u0001C\u00019!)A\u0007\u0001C\u00019!)a\u0007\u0001C\u00019!)\u0001\b\u0001C\u00019!)!\b\u0001C\u00019!)A\b\u0001C\u00019!)a\b\u0001C\u00019!)\u0001\t\u0001C\u00019!)!\t\u0001C\u00019!)A\t\u0001C\u00019!)a\t\u0001C\u00019\tAB)\u001a7fi\u0016\u001cuN\\:v[\u0016\u0014xI]8vaN$Vm\u001d;\u000b\u0005=\u0001\u0012!B1e[&t'\"A\t\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0006\t\u0003+Yi\u0011AD\u0005\u0003/9\u0011\u0001dQ8ogVlWM]$s_V\u00048i\\7nC:$G+Z:u\u0003\u0019a\u0014N\\5u}Q\t!\u0004\u0005\u0002\u0016\u0001\u0005IB/Z:u\t\u0016dW\r^3XSRDGk\u001c9jG>\u0003H/[8o)\u0005i\u0002C\u0001\u0010\"\u001b\u0005y\"\"\u0001\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\tz\"\u0001B+oSRDCA\u0001\u0013-[A\u0011QEK\u0007\u0002M)\u0011q\u0005K\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002S\u0005\u0019qN]4\n\u0005-2#\u0001\u0002+fgR\f\u0001\"\u001a=qK\u000e$X\rZ\u0012\u0002]A\u0011qFM\u0007\u0002a)\t\u0011'\u0001\u0006k_B$8/[7qY\u0016L!a\r\u0019\u0003\u001f=\u0003H/[8o\u000bb\u001cW\r\u001d;j_:\fQ\u0004^3ti\u0012+G.\u001a;f\u00076$gj\u001c8Fq&\u001cH/\u001b8h\u000fJ|W\u000f\u001d\u0015\u0003\u0007\u0011\n!\u0004^3ti\u0012+G.\u001a;f\u001d>tW\t_5ti&twm\u0012:pkBD#\u0001\u0002\u0013\u00025Q,7\u000f\u001e#fY\u0016$XmQ7e\u001d>tW)\u001c9us\u001e\u0013x.\u001e9)\u0005\u0015!\u0013a\u0006;fgR$U\r\\3uK:{g.R7qif<%o\\;qQ\t1A%A\fuKN$H)\u001a7fi\u0016\u001cU\u000eZ#naRLxI]8va\"\u0012q\u0001J\u0001\u0017i\u0016\u001cH\u000fR3mKR,7)\u001c3BY2<%o\\;qg\"\u0012\u0001\u0002J\u0001\u0015i\u0016\u001cH\u000fR3mKR,W)\u001c9us\u001e\u0013x.\u001e9)\u0005%!\u0013!\n;fgR$U\r\\3uK\u000ekGmV5uQ6K\u0007p\u00144Tk\u000e\u001cWm]:B]\u0012,%O]8sQ\tQA%\u0001\u0012uKN$H)\u001a7fi\u0016<\u0016\u000e\u001e5NSb|emU;dG\u0016\u001c8/\u00118e\u000bJ\u0014xN\u001d\u0015\u0003\u0017\u0011\n1\u0006^3ti\u0012+G.\u001a;f/&$\b.\u00168sK\u000e|wM\\5{K\u0012tUm^\"p]N,X.\u001a:PaRLwN\u001c\u0015\u0005\u0019\u0011bS\u0006")
public class DeleteConsumerGroupsTest
extends ConsumerGroupCommandTest {
    @Test(expected=OptionException.class)
    public void testDeleteWithTopicOption() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", this.group(), "--topic"});
        this.getConsumerGroupService(cgcArgs);
    }

    @Test
    public void testDeleteCmdNonExistingGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        String missingGroup = "missing.group";
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", missingGroup});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> service.deleteGroups());
        Assert.assertTrue((String)new StringBuilder(68).append("The expected error (").append(Errors.GROUP_ID_NOT_FOUND).append(") was not detected while deleting consumer group").toString(), (output.contains(new StringBuilder(37).append("Group '").append(missingGroup).append("' could not be deleted due to:").toString()) && output.contains(Errors.GROUP_ID_NOT_FOUND.message()) ? 1 : 0) != 0);
    }

    @Test
    public void testDeleteNonExistingGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        String missingGroup = "missing.group";
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", missingGroup});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        Map result = service.deleteGroups();
        Assert.assertTrue((String)new StringBuilder(68).append("The expected error (").append(Errors.GROUP_ID_NOT_FOUND).append(") was not detected while deleting consumer group").toString(), (result.size() == 1 && result.keySet().contains((Object)missingGroup) && ((Throwable)result.apply((Object)missingGroup)).getCause() instanceof GroupIdNotFoundException ? 1 : 0) != 0);
    }

    @Test
    public void testDeleteCmdNonEmptyGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> ((SeqLike)((Option)service.collectGroupMembers(this.group(), false)._2()).get()).size() == 1, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "The group did not initialize as expected.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> service.deleteGroups());
        Assert.assertTrue((String)new StringBuilder(84).append("The expected error (").append(Errors.NON_EMPTY_GROUP).append(") was not detected while deleting consumer group. Output was: (").append(output).append(")").toString(), (output.contains(new StringBuilder(37).append("Group '").append(this.group()).append("' could not be deleted due to:").toString()) && output.contains(Errors.NON_EMPTY_GROUP.message()) ? 1 : 0) != 0);
    }

    @Test
    public void testDeleteNonEmptyGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> ((SeqLike)((Option)service.collectGroupMembers(this.group(), false)._2()).get()).size() == 1, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "The group did not initialize as expected.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        Map result = service.deleteGroups();
        Assert.assertNotNull((String)new StringBuilder(73).append("Group was deleted successfully, but it shouldn't have been. Result was:(").append(result).append(")").toString(), (Object)result.apply((Object)this.group()));
        Assert.assertTrue((String)new StringBuilder(83).append("The expected error (").append(Errors.NON_EMPTY_GROUP).append(") was not detected while deleting consumer group. Result was:(").append(result).append(")").toString(), (result.size() == 1 && result.keySet().contains((Object)this.group()) && ((Throwable)result.apply((Object)this.group())).getCause() instanceof GroupNotEmptyException ? 1 : 0) != 0);
    }

    @Test
    public void testDeleteCmdEmptyGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            if (!service.listGroups().contains((Object)this.group())) return false;
            String string = service.collectGroupState(this.group()).state();
            String string2 = "Stable";
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "The group did not initialize as expected.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        executor.shutdown();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            String string = service.collectGroupState(this.group()).state();
            String string2 = "Empty";
            return !(string != null ? !string.equals(string2) : string2 != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "The group did not become empty as expected.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> service.deleteGroups());
        Assert.assertTrue((String)"The consumer group could not be deleted as expected", (boolean)output.contains(new StringBuilder(58).append("Deletion of requested consumer groups ('").append(this.group()).append("') was successful.").toString()));
    }

    /*
     * Unable to fully structure code
     */
    @Test
    public void testDeleteCmdAllGroups() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        groups = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 3).map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testDeleteCmdAllGroups$1$adapted(kafka.admin.DeleteConsumerGroupsTest java.lang.Object ), (Ljava/lang/Object;)Lscala/Tuple2;)((DeleteConsumerGroupsTest)this), IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--all-groups"});
        service = this.getConsumerGroupService(cgcArgs);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Z, $anonfun$testDeleteCmdAllGroups$2(kafka.admin.ConsumerGroupCommand$ConsumerGroupService scala.collection.immutable.Map ), ()Z)((ConsumerGroupCommand.ConsumerGroupService)service, (scala.collection.immutable.Map)groups), (Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$testDeleteCmdAllGroups$4(), ()Ljava/lang/String;)(), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        groups.values().foreach((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testDeleteCmdAllGroups$5$adapted(kafka.admin.ConsumerGroupCommandTest$ConsumerGroupExecutor ), (Lkafka/admin/ConsumerGroupCommandTest$ConsumerGroupExecutor;)Ljava/lang/Object;)());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Z, $anonfun$testDeleteCmdAllGroups$6(scala.collection.immutable.Map kafka.admin.ConsumerGroupCommand$ConsumerGroupService ), ()Z)((scala.collection.immutable.Map)groups, (ConsumerGroupCommand.ConsumerGroupService)service), (Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$testDeleteCmdAllGroups$8(), ()Ljava/lang/String;)(), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$testDeleteCmdAllGroups$9(kafka.admin.ConsumerGroupCommand$ConsumerGroupService ), ()V)((ConsumerGroupCommand.ConsumerGroupService)service)).trim();
        expectedGroupsForDeletion = groups.keySet();
        deletedGroupsGrepped = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(output.substring(output.indexOf(40) + 1, output.indexOf(41)))).split(','))).map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testDeleteCmdAllGroups$10(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toSet();
        if (!output.matches("Deletion of requested consumer groups (.*) was successful.")) ** GOTO lbl-1000
        v0 = deletedGroupsGrepped;
        var7_7 = expectedGroupsForDeletion;
        if (!(v0 != null ? v0.equals(var7_7) == false : var7_7 != null)) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        Assert.assertTrue((String)"The consumer group(s) could not be deleted as expected", (boolean)v1);
    }

    @Test
    public void testDeleteEmptyGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            if (!service.listGroups().contains((Object)this.group())) return false;
            String string = service.collectGroupState(this.group()).state();
            String string2 = "Stable";
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "The group did not initialize as expected.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        executor.shutdown();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            String string = service.collectGroupState(this.group()).state();
            String string2 = "Empty";
            return !(string != null ? !string.equals(string2) : string2 != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "The group did not become empty as expected.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        Map result = service.deleteGroups();
        Assert.assertTrue((String)"The consumer group could not be deleted as expected", (result.size() == 1 && result.keySet().contains((Object)this.group()) && result.apply((Object)this.group()) == null ? 1 : 0) != 0);
    }

    @Test
    public void testDeleteCmdWithMixOfSuccessAndError() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        String missingGroup = "missing.group";
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            if (!service.listGroups().contains((Object)this.group())) return false;
            String string = service.collectGroupState(this.group()).state();
            String string2 = "Stable";
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "The group did not initialize as expected.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        executor.shutdown();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            String string = service.collectGroupState(this.group()).state();
            String string2 = "Empty";
            return !(string != null ? !string.equals(string2) : string2 != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "The group did not become empty as expected.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        ConsumerGroupCommand.ConsumerGroupService service2 = this.getConsumerGroupService((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cgcArgs)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--group", missingGroup})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> service2.deleteGroups());
        Assert.assertTrue((String)"The consumer group deletion did not work as expected", (output.contains(new StringBuilder(37).append("Group '").append(missingGroup).append("' could not be deleted due to:").toString()) && output.contains(Errors.GROUP_ID_NOT_FOUND.message()) && output.contains(new StringBuilder(51).append("These consumer groups were deleted successfully: '").append(this.group()).append("'").toString()) ? 1 : 0) != 0);
    }

    @Test
    public void testDeleteWithMixOfSuccessAndError() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        String missingGroup = "missing.group";
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            if (!service.listGroups().contains((Object)this.group())) return false;
            String string = service.collectGroupState(this.group()).state();
            String string2 = "Stable";
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "The group did not initialize as expected.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        executor.shutdown();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            String string = service.collectGroupState(this.group()).state();
            String string2 = "Empty";
            return !(string != null ? !string.equals(string2) : string2 != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "The group did not become empty as expected.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        ConsumerGroupCommand.ConsumerGroupService service2 = this.getConsumerGroupService((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cgcArgs)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--group", missingGroup})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        Map result = service2.deleteGroups();
        Assert.assertTrue((String)"The consumer group deletion did not work as expected", (result.size() == 2 && result.keySet().contains((Object)this.group()) && result.apply((Object)this.group()) == null && result.keySet().contains((Object)missingGroup) && ((Throwable)result.apply((Object)missingGroup)).getMessage().contains(Errors.GROUP_ID_NOT_FOUND.message()) ? 1 : 0) != 0);
    }

    @Test(expected=OptionException.class)
    public void testDeleteWithUnrecognizedNewConsumerOption() {
        String[] cgcArgs = (String[])((Object[])new String[]{"--new-consumer", "--bootstrap-server", this.brokerList(), "--delete", "--group", this.group()});
        this.getConsumerGroupService(cgcArgs);
    }

    public static final /* synthetic */ Tuple2 $anonfun$testDeleteCmdAllGroups$1(DeleteConsumerGroupsTest $this, int i) {
        String group = new StringBuilder(0).append($this.group()).append(i).toString();
        int x$1 = 1;
        String x$2 = group;
        String x$3 = $this.addConsumerGroupExecutor$default$2();
        String x$4 = $this.addConsumerGroupExecutor$default$4();
        Option<Properties> x$5 = $this.addConsumerGroupExecutor$default$5();
        boolean x$6 = $this.addConsumerGroupExecutor$default$6();
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = $this.addConsumerGroupExecutor(x$1, x$3, x$2, x$4, x$5, x$6);
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)group), (Object)executor);
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteCmdAllGroups$3(ConsumerGroupCommand.ConsumerGroupService service$5, String groupId) {
        String string = service$5.collectGroupState(groupId).state();
        String string2 = "Stable";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteCmdAllGroups$2(ConsumerGroupCommand.ConsumerGroupService service$5, scala.collection.immutable.Map groups$1) {
        Set set = service$5.listGroups().toSet();
        Set set2 = groups$1.keySet();
        return !(set != null ? !set.equals(set2) : set2 != null) && groups$1.keySet().forall((Function1 & Serializable & scala.Serializable)groupId -> BoxesRunTime.boxToBoolean((boolean)DeleteConsumerGroupsTest.$anonfun$testDeleteCmdAllGroups$3(service$5, groupId)));
    }

    public static final /* synthetic */ String $anonfun$testDeleteCmdAllGroups$4() {
        return "The group did not initialize as expected.";
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteCmdAllGroups$7(ConsumerGroupCommand.ConsumerGroupService service$5, String groupId) {
        String string = service$5.collectGroupState(groupId).state();
        String string2 = "Empty";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteCmdAllGroups$6(scala.collection.immutable.Map groups$1, ConsumerGroupCommand.ConsumerGroupService service$5) {
        return groups$1.keySet().forall((Function1 & Serializable & scala.Serializable)groupId -> BoxesRunTime.boxToBoolean((boolean)DeleteConsumerGroupsTest.$anonfun$testDeleteCmdAllGroups$7(service$5, groupId)));
    }

    public static final /* synthetic */ String $anonfun$testDeleteCmdAllGroups$8() {
        return "The group did not become empty as expected.";
    }

    public static final /* synthetic */ void $anonfun$testDeleteCmdAllGroups$9(ConsumerGroupCommand.ConsumerGroupService service$5) {
        service$5.deleteGroups();
    }

    public static final /* synthetic */ String $anonfun$testDeleteCmdAllGroups$10(String x$1) {
        return x$1.replaceAll("'", "").trim();
    }

    public static final /* synthetic */ Tuple2 $anonfun$testDeleteCmdAllGroups$1$adapted(DeleteConsumerGroupsTest $this, Object i) {
        return DeleteConsumerGroupsTest.$anonfun$testDeleteCmdAllGroups$1($this, BoxesRunTime.unboxToInt((Object)i));
    }

    public static final /* synthetic */ Object $anonfun$testDeleteCmdAllGroups$5$adapted(ConsumerGroupCommandTest.ConsumerGroupExecutor executor) {
        executor.shutdown();
        return BoxedUnit.UNIT;
    }
}

