/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import java.util.Properties;
import kafka.admin.AdminOperationException;
import kafka.admin.BrokerMetadata;
import kafka.admin.RackAwareMode;
import kafka.admin.RackAwareTest;
import kafka.admin.ReplicaDistributions;
import kafka.admin.TopicCommand;
import kafka.server.ConfigType$;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.ConfigEntityChangeNotificationZNode$;
import kafka.zk.DeleteTopicsTopicZNode$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidReplicationFactorException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\u0005-e\u0001B\u0015+\u0001=BQ\u0001\u0011\u0001\u0005\u0002\u0005C\u0011b\u0011\u0001A\u0002\u0003\u0007I\u0011\u0002#\t\u0013M\u0003\u0001\u0019!a\u0001\n\u0013!\u0006\"C/\u0001\u0001\u0004\u0005\t\u0015)\u0003F\u0011%q\u0006\u00011AA\u0002\u0013%q\fC\u0005i\u0001\u0001\u0007\t\u0019!C\u0005S\"I1\u000e\u0001a\u0001\u0002\u0003\u0006K\u0001\u0019\u0005\bY\u0002\u0011\r\u0011\"\u0003n\u0011\u0019A\b\u0001)A\u0005]\")\u0011\u0010\u0001C\u0001[\"1q\u0010\u0001C\u0001\u0003\u0003Aq!a\u0003\u0001\t\u0003\t\t\u0001C\u0004\u0002\u0016\u0001!\t!!\u0001\t\u000f\u0005}\u0001\u0001\"\u0001\u0002\u0002!9\u00111\u0005\u0001\u0005\u0002\u0005\u0005\u0001bBA\u0014\u0001\u0011\u0005\u0011\u0011\u0001\u0005\b\u0003W\u0001A\u0011AA\u0001\u0011\u001d\ty\u0003\u0001C\u0001\u0003\u0003Aq!a\r\u0001\t\u0003\t\t\u0001C\u0004\u00028\u0001!\t!!\u0001\t\u000f\u0005m\u0002\u0001\"\u0001\u0002\u0002!9\u0011q\b\u0001\u0005\u0002\u0005\u0005\u0001bBA\"\u0001\u0011\u0005\u0011\u0011\u0001\u0005\b\u0003\u000f\u0002A\u0011AA\u0001\u0011\u001d\tY\u0005\u0001C\u0001\u0003\u0003Aq!a\u0014\u0001\t\u0003\t\t\u0001C\u0004\u0002T\u0001!\t!!\u0001\t\u000f\u0005]\u0003\u0001\"\u0001\u0002\u0002!9\u00111\f\u0001\u0005\u0002\u0005\u0005\u0001bBA0\u0001\u0011\u0005\u0011\u0011\u0001\u0005\b\u0003G\u0002A\u0011AA\u0001\u0011\u001d\t9\u0007\u0001C\u0001\u0003\u0003Aq!a\u001b\u0001\t\u0003\t\t\u0001C\u0004\u0002p\u0001!\t!!\u0001\t\u000f\u0005M\u0004\u0001\"\u0001\u0002\u0002!9\u0011q\u000f\u0001\u0005\u0002\u0005\u0005\u0001bBA>\u0001\u0011\u0005\u0011\u0011\u0001\u0005\b\u0003\u007f\u0002A\u0011AA\u0001\u0011\u001d\t\u0019\t\u0001C\u0001\u0003\u0003Aq!a\"\u0001\t\u0003\t\tA\u0001\tU_BL7mQ8n[\u0006tG\rV3ti*\u00111\u0006L\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0002[\u0005)1.\u00194lC\u000e\u00011\u0003\u0002\u00011mq\u0002\"!\r\u001b\u000e\u0003IR!a\r\u0017\u0002\u0005i\\\u0017BA\u001b3\u0005QQvn\\&fKB,'\u000fV3ti\"\u000b'O\\3tgB\u0011qGO\u0007\u0002q)\u0011\u0011\bL\u0001\u0006kRLGn]\u0005\u0003wa\u0012q\u0001T8hO&tw\r\u0005\u0002>}5\t!&\u0003\u0002@U\ti!+Y2l\u0003^\f'/\u001a+fgR\fa\u0001P5oSRtD#\u0001\"\u0011\u0005u\u0002\u0011\u0001\u0004;pa&\u001c7+\u001a:wS\u000e,W#A#\u0011\u0005\u0019\u0003fBA$O\u001d\tAUJ\u0004\u0002J\u00196\t!J\u0003\u0002L]\u00051AH]8pizJ\u0011!L\u0005\u0003W1J!a\u0014\u0016\u0002\u0019Q{\u0007/[2D_6l\u0017M\u001c3\n\u0005E\u0013&!\u0006.p_.,W\r]3s)>\u0004\u0018nY*feZL7-\u001a\u0006\u0003\u001f*\n\u0001\u0003^8qS\u000e\u001cVM\u001d<jG\u0016|F%Z9\u0015\u0005U[\u0006C\u0001,Z\u001b\u00059&\"\u0001-\u0002\u000bM\u001c\u0017\r\\1\n\u0005i;&\u0001B+oSRDq\u0001X\u0002\u0002\u0002\u0003\u0007Q)A\u0002yIE\nQ\u0002^8qS\u000e\u001cVM\u001d<jG\u0016\u0004\u0013!\u0004;fgR$v\u000e]5d\u001d\u0006lW-F\u0001a!\t\tWM\u0004\u0002cGB\u0011\u0011jV\u0005\u0003I^\u000ba\u0001\u0015:fI\u00164\u0017B\u00014h\u0005\u0019\u0019FO]5oO*\u0011AmV\u0001\u0012i\u0016\u001cH\u000fV8qS\u000et\u0015-\\3`I\u0015\fHCA+k\u0011\u001daf!!AA\u0002\u0001\fa\u0002^3tiR{\u0007/[2OC6,\u0007%A\u0005`i\u0016\u001cHOT1nKV\ta\u000e\u0005\u0002pm6\t\u0001O\u0003\u0002re\u0006)!/\u001e7fg*\u00111\u000f^\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002k\u0006\u0019qN]4\n\u0005]\u0004(\u0001\u0003+fgRt\u0015-\\3\u0002\u0015}#Xm\u001d;OC6,\u0007%\u0001\u0005uKN$h*Y7fQ\tQ1\u0010\u0005\u0002}{6\t!/\u0003\u0002\u007fe\n!!+\u001e7f\u0003\u0015\u0019X\r^;q)\u0005)\u0006fA\u0006\u0002\u0006A\u0019A0a\u0002\n\u0007\u0005%!O\u0001\u0004CK\u001a|'/Z\u0001\ti\u0016\f'\u000fZ8x]\"\u001aA\"a\u0004\u0011\u0007q\f\t\"C\u0002\u0002\u0014I\u0014Q!\u00114uKJ\f!\u0002^3ti\u000e\u0013X-\u0019;fQ\ri\u0011\u0011\u0004\t\u0004y\u0006m\u0011bAA\u000fe\n!A+Z:u\u0003U!Xm\u001d;De\u0016\fG/Z,ji\"\u001cuN\u001c4jOND3ADA\r\u0003U!Xm\u001d;De\u0016\fG/Z%g\u001d>$X\t_5tiND3aDA\r\u0003}!Xm\u001d;De\u0016\fG/Z,ji\"\u0014V\r\u001d7jG\u0006\f5o]5h]6,g\u000e\u001e\u0015\u0004!\u0005e\u0011A\n;fgR\u001c%/Z1uK^KG\u000f[%om\u0006d\u0017\u000e\u001a*fa2L7-\u0019;j_:4\u0015m\u0019;pe\"\u001a\u0011#!\u0007\u0002OQ,7\u000f^\"sK\u0006$XmV5uQ:+w-\u0019;jm\u0016\u0014V\r\u001d7jG\u0006$\u0018n\u001c8GC\u000e$xN\u001d\u0015\u0004%\u0005e\u0011\u0001\n;fgR\u001c%/Z1uK^KG\u000f\u001b(fO\u0006$\u0018N^3QCJ$\u0018\u000e^5p]\u000e{WO\u001c;)\u0007M\tI\"A\u000euKN$\u0018J\u001c<bY&$Gk\u001c9jG2+g/\u001a7D_:4\u0017n\u001a\u0015\u0004)\u0005e\u0011A\u0004;fgRd\u0015n\u001d;U_BL7m\u001d\u0015\u0004+\u0005e\u0011a\u0007;fgRd\u0015n\u001d;U_BL7m],ji\"<\u0006.\u001b;fY&\u001cH\u000fK\u0002\u0017\u00033\t\u0011\u0005^3ti2K7\u000f\u001e+pa&\u001c7oV5uQ\u0016C8\r\\;eK&sG/\u001a:oC2D3aFA\r\u0003]!Xm\u001d;BYR,'\u000fU1si&$\u0018n\u001c8D_VtG\u000fK\u0002\u0019\u00033\t1\u0003^3ti\u0006cG/\u001a:BgNLwM\\7f]RD3!GA\r\u0003\t\"Xm\u001d;BYR,'oV5uQ&sg/\u00197jIB\u000b'\u000f^5uS>t7i\\;oi\"\u001a!$!\u0007\u0002#Q,7\u000f^!mi\u0016\u0014\u0018JZ#ySN$8\u000fK\u0002\u001c\u00033\t\u0001\u0003^3ti\u0006cG/\u001a:D_:4\u0017nZ:)\u0007q\tI\"A\u0018uKN$8i\u001c8gS\u001e\u0004&/Z:feZ\fG/[8o\u0003\u000e\u0014xn]:QCJ$\u0018\u000e^5p]\u0006cG/\u001a:bi&|g\u000eK\u0002\u001e\u00033\t\u0011\u0003^3tiR{\u0007/[2EK2,G/[8oQ\rq\u0012\u0011D\u0001\u0013i\u0016\u001cH\u000fR3mKR,\u0017JZ#ySN$8\u000fK\u0002 \u00033\tq\u0003^3ti\u0012+G.\u001a;f\u0013:$XM\u001d8bYR{\u0007/[2)\u0007\u0001\nI\"\u0001\u000fuKN$H)Z:de&\u0014W-\u00134U_BL7MT8u\u000bbL7\u000f^:)\u0007\u0005\nI\"A\u0011uKN$8I]3bi\u0016\fE\u000e^3s)>\u0004\u0018nY,ji\"\u0014\u0016mY6Bo\u0006\u0014X\rK\u0002#\u00033\tA\u0002^3ti\u0012+7o\u0019:jE\u0016D3aIA\r\u0003\r\"Xm\u001d;EKN\u001c'/\u001b2f%\u0016\u0004xN\u001d;Pm\u0016\u0014(/\u001b3eK:\u001cuN\u001c4jOND3\u0001JA\r\u0003)\"Xm\u001d;EKN\u001c'/\u001b2f\u0003:$G*[:u)>\u0004\u0018nY:NCJ\\W\r\u001a$pe\u0012+G.\u001a;j_:D3!JA\r\u00039\"Xm\u001d;EKN\u001c'/\u001b2f\u0003:$G*[:u)>\u0004\u0018nY:XSRDw.\u001e;J]R,'O\\1m)>\u0004\u0018nY:)\u0007\u0019\nI\"A\u0017uKN$Hk\u001c9jG>\u0003XM]1uS>t7oV5uQJ+w-\u001a=Ts6\u0014w\u000e\\%o)>\u0004\u0018n\u0019(b[\u0016D3aJA\r\u0003\u0011\"Xm\u001d;BYR,'/\u00138uKJt\u0017\r\u001c+pa&\u001c\u0007+\u0019:uSRLwN\\\"pk:$\bf\u0001\u0015\u0002\u001a\u0001")
public class TopicCommandTest
extends ZooKeeperTestHarness
implements RackAwareTest {
    private TopicCommand.ZookeeperTopicService topicService;
    private String testTopicName;
    private final TestName _testName;

    @Override
    public void checkReplicaDistribution(Map<Object, Seq<Object>> assignment, Map<Object, String> brokerRackMapping, int numBrokers, int numPartitions, int replicationFactor, boolean verifyRackAware, boolean verifyLeaderDistribution, boolean verifyReplicasDistribution) {
        RackAwareTest.checkReplicaDistribution$(this, assignment, brokerRackMapping, numBrokers, numPartitions, replicationFactor, verifyRackAware, verifyLeaderDistribution, verifyReplicasDistribution);
    }

    @Override
    public boolean checkReplicaDistribution$default$6() {
        return RackAwareTest.checkReplicaDistribution$default$6$(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$7() {
        return RackAwareTest.checkReplicaDistribution$default$7$(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$8() {
        return RackAwareTest.checkReplicaDistribution$default$8$(this);
    }

    @Override
    public ReplicaDistributions getReplicaDistribution(Map<Object, Seq<Object>> assignment, Map<Object, String> brokerRackMapping) {
        return RackAwareTest.getReplicaDistribution$(this, assignment, brokerRackMapping);
    }

    @Override
    public Seq<BrokerMetadata> toBrokerMetadata(Map<Object, String> rackMap, Seq<Object> brokersWithoutRack) {
        return RackAwareTest.toBrokerMetadata$(this, rackMap, brokersWithoutRack);
    }

    @Override
    public Seq<Object> toBrokerMetadata$default$2() {
        return RackAwareTest.toBrokerMetadata$default$2$(this);
    }

    private TopicCommand.ZookeeperTopicService topicService() {
        return this.topicService;
    }

    private void topicService_$eq(TopicCommand.ZookeeperTopicService x$1) {
        this.topicService = x$1;
    }

    private String testTopicName() {
        return this.testTopicName;
    }

    private void testTopicName_$eq(String x$1) {
        this.testTopicName = x$1;
    }

    private TestName _testName() {
        return this._testName;
    }

    @Rule
    public TestName testName() {
        return this._testName();
    }

    @Before
    public void setup() {
        this.topicService_$eq(new TopicCommand.ZookeeperTopicService(this.zkClient()));
        this.testTopicName_$eq(new StringBuilder(1).append(this.testName().getMethodName()).append("-").append(Random$.MODULE$.alphanumeric().take(10).mkString()).toString());
    }

    @After
    public void teardown() {
        block0: {
            if (this.topicService() == null) break block0;
            this.topicService().close();
        }
    }

    @Test
    public void testCreate() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        this.topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "2", "--replication-factor", "1", "--topic", this.testTopicName()})));
        Assert.assertTrue((boolean)this.zkClient().getAllTopicsInCluster().contains((Object)this.testTopicName()));
    }

    @Test
    public void testCreateWithConfigs() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.TOPIC, this.testTopicName());
        this.topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "2", "--replication-factor", "2", "--topic", configResource.name(), "--config", "delete.retention.ms=1000"})));
        Properties configs = this.zkClient().getEntityConfigs(ConfigType$.MODULE$.Topic(), this.testTopicName());
        Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)1000), (Object)Integer.valueOf(configs.getProperty("delete.retention.ms")));
    }

    @Test
    public void testCreateIfNotExists() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        int numPartitions = 1;
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)numPartitions)).toString(), "--replication-factor", "1", "--topic", this.testTopicName()}));
        this.topicService().createTopic(createOpts);
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().createTopic(createOpts), ClassTag$.MODULE$.apply(TopicExistsException.class), new Position("TopicCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
        TopicCommand.TopicCommandOptions createNotExistsOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)numPartitions)).toString(), "--replication-factor", "1", "--topic", this.testTopicName(), "--if-not-exists"}));
        this.topicService().createTopic(createNotExistsOpts);
    }

    @Test
    public void testCreateWithReplicaAssignment() {
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--replica-assignment", "5:4,3:2,1:0", "--topic", this.testTopicName()}));
        this.topicService().createTopic(createOpts);
        Seq replicas0 = this.zkClient().getReplicasForPartition(new TopicPartition(this.testTopicName(), 0));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 4})), (Object)replicas0);
        Seq replicas1 = this.zkClient().getReplicasForPartition(new TopicPartition(this.testTopicName(), 1));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2})), (Object)replicas1);
        Seq replicas2 = this.zkClient().getReplicasForPartition(new TopicPartition(this.testTopicName(), 2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0})), (Object)replicas2);
    }

    @Test
    public void testCreateWithInvalidReplicationFactor() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "2", "--replication-factor", ((Object)BoxesRunTime.boxToInteger((int)32768)).toString(), "--topic", this.testTopicName()}))), ClassTag$.MODULE$.apply(InvalidReplicationFactorException.class), new Position("TopicCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
    }

    @Test
    public void testCreateWithNegativeReplicationFactor() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "2", "--replication-factor", "-1", "--topic", this.testTopicName()}))), ClassTag$.MODULE$.apply(InvalidReplicationFactorException.class), new Position("TopicCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
    }

    @Test
    public void testCreateWithNegativePartitionCount() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "-1", "--replication-factor", "1", "--topic", this.testTopicName()}))), ClassTag$.MODULE$.apply(InvalidPartitionsException.class), new Position("TopicCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
    }

    @Test
    public void testInvalidTopicLevelConfig() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName(), "--config", "message.timestamp.type=boom"}));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().createTopic(createOpts), ClassTag$.MODULE$.apply(ConfigException.class), new Position("TopicCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
        TopicCommand.TopicCommandOptions createOpts2 = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName(), "--config", "message.format.version=boom"}));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().createTopic(createOpts2), ClassTag$.MODULE$.apply(ConfigException.class), new Position("TopicCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166));
    }

    @Test
    public void testListTopics() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        this.topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()})));
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)))));
        Assert.assertTrue((boolean)output.contains(this.testTopicName()));
    }

    @Test
    public void testListTopicsWithWhitelist() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        String topic1 = "kafka.testTopic1";
        String topic2 = "kafka.testTopic2";
        String topic3 = "oooof.testTopic1";
        AdminZkClient qual$1 = this.adminZkClient();
        String x$1 = topic1;
        int x$2 = 2;
        int x$3 = 2;
        Properties x$4 = qual$1.createTopic$default$4();
        RackAwareMode x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5);
        AdminZkClient qual$2 = this.adminZkClient();
        String x$6 = topic2;
        int x$7 = 2;
        int x$8 = 2;
        Properties x$9 = qual$2.createTopic$default$4();
        RackAwareMode x$10 = qual$2.createTopic$default$5();
        qual$2.createTopic(x$6, x$7, x$8, x$9, x$10);
        AdminZkClient qual$3 = this.adminZkClient();
        String x$11 = topic3;
        int x$12 = 2;
        int x$13 = 2;
        Properties x$14 = qual$3.createTopic$default$4();
        RackAwareMode x$15 = qual$3.createTopic$default$5();
        qual$3.createTopic(x$11, x$12, x$13, x$14, x$15);
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", "kafka.*"}))));
        Assert.assertTrue((boolean)output.contains(topic1));
        Assert.assertTrue((boolean)output.contains(topic2));
        Assert.assertFalse((boolean)output.contains(topic3));
    }

    @Test
    public void testListTopicsWithExcludeInternal() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        AdminZkClient qual$1 = this.adminZkClient();
        String x$1 = this.testTopicName();
        int x$2 = 2;
        int x$3 = 2;
        Properties x$4 = qual$1.createTopic$default$4();
        RackAwareMode x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5);
        AdminZkClient qual$2 = this.adminZkClient();
        String x$6 = "__consumer_offsets";
        int x$7 = 2;
        int x$8 = 2;
        Properties x$9 = qual$2.createTopic$default$4();
        RackAwareMode x$10 = qual$2.createTopic$default$5();
        qual$2.createTopic(x$6, x$7, x$8, x$9, x$10);
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--exclude-internal"}))));
        Assert.assertTrue((boolean)output.contains(this.testTopicName()));
        Assert.assertFalse((boolean)output.contains("__consumer_offsets"));
    }

    @Test
    public void testAlterPartitionCount() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        AdminZkClient qual$1 = this.adminZkClient();
        String x$1 = this.testTopicName();
        int x$2 = 2;
        int x$3 = 2;
        Properties x$4 = qual$1.createTopic$default$4();
        RackAwareMode x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5);
        this.topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--partitions", "3"})));
        Assert.assertEquals((long)3L, (long)((SeqLike)this.zkClient().getPartitionsForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.testTopicName()}))).apply((Object)this.testTopicName())).size());
    }

    @Test
    public void testAlterAssignment() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4, 5}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        AdminZkClient qual$1 = this.adminZkClient();
        String x$1 = this.testTopicName();
        int x$2 = 2;
        int x$3 = 2;
        Properties x$4 = qual$1.createTopic$default$4();
        RackAwareMode x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5);
        this.topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--replica-assignment", "5:3,3:1,4:2", "--partitions", "3"})));
        Seq replicas0 = this.zkClient().getReplicasForPartition(new TopicPartition(this.testTopicName(), 2));
        Assert.assertEquals((long)3L, (long)((SeqLike)this.zkClient().getPartitionsForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.testTopicName()}))).apply((Object)this.testTopicName())).size());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 2})), (Object)replicas0);
    }

    @Test
    public void testAlterWithInvalidPartitionCount() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        this.topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()})));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "-1", "--topic", this.testTopicName()}))), ClassTag$.MODULE$.apply(InvalidPartitionsException.class), new Position("TopicCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 256));
    }

    @Test
    public void testAlterIfExists() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--partitions", "1"}));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().alterTopic(alterOpts), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TopicCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 270));
        TopicCommand.TopicCommandOptions alterExistsOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--partitions", "1", "--if-exists"}));
        this.topicService().alterTopic(alterExistsOpts);
    }

    @Test
    public void testAlterConfigs() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        this.topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()})));
        this.topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--config", "cleanup.policy=compact"})));
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName()}))));
        Assert.assertTrue((String)"The output should contain the modified config", (boolean)output.contains("Configs: cleanup.policy=compact"));
        this.topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--config", "cleanup.policy=delete"})));
        String output2 = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName()}))));
        Assert.assertTrue((String)"The output should contain the modified config", (boolean)output2.contains("Configs: cleanup.policy=delete"));
    }

    @Test
    public void testConfigPreservationAcrossPartitionAlteration() {
        int numPartitionsOriginal = 1;
        String cleanupKey = "cleanup.policy";
        String cleanupVal = "compact";
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)numPartitionsOriginal)).toString(), "--replication-factor", "1", "--config", new StringBuilder(1).append(cleanupKey).append("=").append(cleanupVal).toString(), "--topic", this.testTopicName()}));
        this.topicService().createTopic(createOpts);
        Properties props = this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Topic(), this.testTopicName());
        Assert.assertTrue((String)new StringBuilder(40).append("Properties after creation don't contain ").append(cleanupKey).toString(), (boolean)props.containsKey(cleanupKey));
        Assert.assertTrue((String)"Properties after creation have incorrect value", (boolean)props.getProperty(cleanupKey).equals(cleanupVal));
        this.zkClient().makeSurePersistentPathExists(ConfigEntityChangeNotificationZNode$.MODULE$.path());
        int numPartitionsModified = 3;
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)numPartitionsModified)).toString(), "--topic", this.testTopicName()}));
        this.topicService().alterTopic(alterOpts);
        Properties newProps = this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Topic(), this.testTopicName());
        Assert.assertTrue((String)new StringBuilder(34).append("Updated properties do not contain ").append(cleanupKey).toString(), (boolean)newProps.containsKey(cleanupKey));
        Assert.assertTrue((String)"Updated properties have incorrect value", (boolean)newProps.getProperty(cleanupKey).equals(cleanupVal));
    }

    @Test
    public void testTopicDeletion() {
        int numPartitionsOriginal = 1;
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)numPartitionsOriginal)).toString(), "--replication-factor", "1", "--topic", this.testTopicName()}));
        this.topicService().createTopic(createOpts);
        TopicCommand.TopicCommandOptions deleteOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName()}));
        String deletePath = DeleteTopicsTopicZNode$.MODULE$.path(this.testTopicName());
        Assert.assertFalse((String)"Delete path for topic shouldn't exist before deletion.", (boolean)this.zkClient().pathExists(deletePath));
        this.topicService().deleteTopic(deleteOpts);
        Assert.assertTrue((String)"Delete path for topic should exist after deletion.", (boolean)this.zkClient().pathExists(deletePath));
        TopicCommand.TopicCommandOptions createOffsetTopicOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)numPartitionsOriginal)).toString(), "--replication-factor", "1", "--topic", "__consumer_offsets"}));
        this.topicService().createTopic(createOffsetTopicOpts);
        TopicCommand.TopicCommandOptions deleteOffsetTopicOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", "__consumer_offsets"}));
        String deleteOffsetTopicPath = DeleteTopicsTopicZNode$.MODULE$.path("__consumer_offsets");
        Assert.assertFalse((String)"Delete path for topic shouldn't exist before deletion.", (boolean)this.zkClient().pathExists(deleteOffsetTopicPath));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().deleteTopic(deleteOffsetTopicOpts), ClassTag$.MODULE$.apply(AdminOperationException.class), new Position("TopicCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 365));
        Assert.assertFalse((String)"Delete path for topic shouldn't exist after deletion.", (boolean)this.zkClient().pathExists(deleteOffsetTopicPath));
    }

    @Test
    public void testDeleteIfExists() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        TopicCommand.TopicCommandOptions deleteOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName()}));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().deleteTopic(deleteOpts), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TopicCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 379));
        TopicCommand.TopicCommandOptions deleteExistsOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--if-exists"}));
        this.topicService().deleteTopic(deleteExistsOpts);
    }

    @Test
    public void testDeleteInternalTopic() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        TopicCommand.TopicCommandOptions createOffsetTopicOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", "__consumer_offsets"}));
        this.topicService().createTopic(createOffsetTopicOpts);
        TopicCommand.TopicCommandOptions deleteOffsetTopicOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", "__consumer_offsets"}));
        String deleteOffsetTopicPath = DeleteTopicsTopicZNode$.MODULE$.path("__consumer_offsets");
        Assert.assertFalse((String)"Delete path for topic shouldn't exist before deletion.", (boolean)this.zkClient().pathExists(deleteOffsetTopicPath));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().deleteTopic(deleteOffsetTopicOpts), ClassTag$.MODULE$.apply(AdminOperationException.class), new Position("TopicCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 402));
    }

    @Test
    public void testDescribeIfTopicNotExists() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        TopicCommand.TopicCommandOptions describeOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName()}));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(describeOpts), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TopicCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 415));
        TopicCommand.TopicCommandOptions describeOptsAllTopics = new TopicCommand.TopicCommandOptions((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)));
        this.topicService().describeTopic(describeOptsAllTopics);
        TopicCommand.TopicCommandOptions describeOptsWithExists = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--if-exists"}));
        this.topicService().describeTopic(describeOptsWithExists);
    }

    @Test
    public void testCreateAlterTopicWithRackAware() {
        scala.collection.immutable.Map rackInfo = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)"rack3")}));
        TestUtils$.MODULE$.createBrokersInZk(this.toBrokerMetadata((Map<Object, String>)rackInfo, this.toBrokerMetadata$default$2()), this.zkClient());
        int numPartitions = 18;
        int replicationFactor = 3;
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)numPartitions)).toString(), "--replication-factor", ((Object)BoxesRunTime.boxToInteger((int)replicationFactor)).toString(), "--topic", this.testTopicName()}));
        this.topicService().createTopic(createOpts);
        Map assignment = (Map)this.zkClient().getReplicaAssignmentForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.testTopicName()}))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            Seq replicas = (Seq)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)replicas);
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
        this.checkReplicaDistribution((Map<Object, Seq<Object>>)assignment, (Map<Object, String>)rackInfo, rackInfo.size(), numPartitions, replicationFactor, this.checkReplicaDistribution$default$6(), this.checkReplicaDistribution$default$7(), this.checkReplicaDistribution$default$8());
        int alteredNumPartitions = 36;
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)alteredNumPartitions)).toString(), "--topic", this.testTopicName()}));
        this.topicService().alterTopic(alterOpts);
        assignment = (Map)this.zkClient().getReplicaAssignmentForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.testTopicName()}))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            Seq replicas = (Seq)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)replicas);
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
        this.checkReplicaDistribution((Map<Object, Seq<Object>>)assignment, (Map<Object, String>)rackInfo, rackInfo.size(), alteredNumPartitions, replicationFactor, this.checkReplicaDistribution$default$6(), this.checkReplicaDistribution$default$7(), this.checkReplicaDistribution$default$8());
    }

    @Test
    public void testDescribe() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        AdminZkClient qual$1 = this.adminZkClient();
        String x$1 = this.testTopicName();
        int x$2 = 2;
        int x$3 = 2;
        Properties x$4 = qual$1.createTopic$default$4();
        RackAwareMode x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5);
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName()}))));
        String[] rows = output.split("\n");
        Assert.assertEquals((long)3L, (long)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rows)).size());
        rows[0].startsWith("Topic:testTopic\tPartitionCount:2");
    }

    @Test
    public void testDescribeReportOverriddenConfigs() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        String config = "file.delete.delay.ms=1000";
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.TOPIC, this.testTopicName());
        this.topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "2", "--replication-factor", "2", "--topic", configResource.name(), "--config", config})));
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)))));
        Assert.assertTrue((boolean)output.contains(config));
    }

    @Test
    public void testDescribeAndListTopicsMarkedForDeletion() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}));
        String markedForDeletionDescribe = "MarkedForDeletion";
        String markedForDeletionList = "marked for deletion";
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()}));
        this.topicService().createTopic(createOpts);
        TestUtils$.MODULE$.deleteBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        this.topicService().deleteTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName()})));
        String outputWithConfig = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.describeTopicsWithConfig$1());
        Assert.assertTrue((outputWithConfig.contains(this.testTopicName()) && outputWithConfig.contains(markedForDeletionDescribe) ? 1 : 0) != 0);
        String outputNoConfig = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.describeTopicsNoConfig$1());
        Assert.assertTrue((outputNoConfig.contains(this.testTopicName()) && outputNoConfig.contains(markedForDeletionDescribe) ? 1 : 0) != 0);
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.listTopics$1());
        Assert.assertTrue((output.contains(this.testTopicName()) && output.contains(markedForDeletionList) ? 1 : 0) != 0);
    }

    @Test
    public void testDescribeAndListTopicsWithoutInternalTopics() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        this.topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()})));
        this.topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", "__consumer_offsets"})));
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--describe", "--exclude-internal"}))));
        Assert.assertTrue((boolean)output.contains(this.testTopicName()));
        Assert.assertFalse((boolean)output.contains("__consumer_offsets"));
        output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--list", "--exclude-internal"}))));
        Assert.assertTrue((boolean)output.contains(this.testTopicName()));
        Assert.assertFalse((boolean)output.contains("__consumer_offsets"));
    }

    @Test
    public void testTopicOperationsWithRegexSymbolInTopicName() {
        String topic1 = "test.topic";
        String topic2 = "test-topic";
        String escapedTopic = "\"test\\.topic\"";
        String unescapedTopic = "test.topic";
        int numPartitionsOriginal = 1;
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)numPartitionsOriginal)).toString(), "--replication-factor", "1", "--topic", topic1}));
        this.topicService().createTopic(createOpts);
        TopicCommand.TopicCommandOptions createOpts2 = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)numPartitionsOriginal)).toString(), "--replication-factor", "1", "--topic", topic2}));
        this.topicService().createTopic(createOpts2);
        TopicCommand.TopicCommandOptions escapedCommandOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", escapedTopic}));
        TopicCommand.TopicCommandOptions unescapedCommandOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", unescapedTopic}));
        Assert.assertFalse((boolean)TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(escapedCommandOpts)).contains(topic2));
        Assert.assertTrue((boolean)TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(unescapedCommandOpts)).contains(topic2));
        Assert.assertFalse((boolean)TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().deleteTopic(escapedCommandOpts)).contains(topic2));
        Assert.assertTrue((boolean)TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().deleteTopic(unescapedCommandOpts)).contains(topic2));
    }

    @Test
    public void testAlterInternalTopicPartitionCount() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        AdminZkClient qual$1 = this.adminZkClient();
        String x$1 = "__consumer_offsets";
        int x$2 = 1;
        int x$3 = 1;
        Properties x$4 = qual$1.createTopic$default$4();
        RackAwareMode x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5);
        AdminZkClient qual$2 = this.adminZkClient();
        String x$6 = "__transaction_state";
        int x$7 = 1;
        int x$8 = 1;
        Properties x$9 = qual$2.createTopic$default$4();
        RackAwareMode x$10 = qual$2.createTopic$default$5();
        qual$2.createTopic(x$6, x$7, x$8, x$9, x$10);
        this.expectAlterInternalTopicPartitionCountFailed$1("__consumer_offsets");
        this.expectAlterInternalTopicPartitionCountFailed$1("__transaction_state");
    }

    private final void describeTopicsWithConfig$1() {
        this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--describe"})));
    }

    private final void describeTopicsNoConfig$1() {
        this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--describe", "--unavailable-partitions"})));
    }

    private final void listTopics$1() {
        this.topicService().listTopics(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--list"})));
    }

    private final void expectAlterInternalTopicPartitionCountFailed$1(String topic) {
        try {
            this.topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", topic, "--partitions", "2"})));
            Assert.fail((String)"Should have thrown an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public TopicCommandTest() {
        RackAwareTest.$init$(this);
        this._testName = new TestName();
    }
}

