/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.admin.AdminOperationException;
import kafka.admin.BrokerMetadata;
import kafka.admin.RackAwareTest;
import kafka.admin.ReplicaDistributions;
import kafka.admin.TopicCommand;
import kafka.admin.TopicCommand$;
import kafka.common.AdminCommandFailedException;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.ConfigType$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.MetadataCache;
import kafka.utils.Exit$;
import kafka.utils.TestUtils$;
import kafka.zk.ConfigEntityChangeNotificationZNode$;
import kafka.zk.DeleteTopicsTopicZNode$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\tme\u0001\u0002#F\u0001)CQa\u0017\u0001\u0005\u0002qCQA\u0018\u0001\u0005B}CqA\u001c\u0001C\u0002\u0013%q\u000e\u0003\u0004u\u0001\u0001\u0006I\u0001\u001d\u0005\bk\u0002\u0011\r\u0011\"\u0003w\u0011\u0019Q\b\u0001)A\u0005o\"I1\u0010\u0001a\u0001\u0002\u0004%I\u0001 \u0005\f\u0003/\u0001\u0001\u0019!a\u0001\n\u0013\tI\u0002\u0003\u0006\u0002&\u0001\u0001\r\u0011!Q!\nuD1\"a\n\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002*!Y\u00111\t\u0001A\u0002\u0003\u0007I\u0011BA#\u0011-\tI\u0005\u0001a\u0001\u0002\u0003\u0006K!a\u000b\t\u0017\u0005-\u0003\u00011AA\u0002\u0013%\u0011Q\n\u0005\f\u0003?\u0002\u0001\u0019!a\u0001\n\u0013\t\t\u0007C\u0006\u0002f\u0001\u0001\r\u0011!Q!\n\u0005=\u0003\"CA4\u0001\t\u0007I\u0011BA5\u0011!\tY\b\u0001Q\u0001\n\u0005-\u0004bBA?\u0001\u0011\u0005\u0011\u0011\u000e\u0005\b\u0003\u0013\u0003A\u0011AAF\u0011\u001d\tY\n\u0001C\u0001\u0003;Cq!a+\u0001\t\u0003\ti\u000bC\u0004\u00024\u0002!\t!!.\t\u0013\u0005}\u0006!%A\u0005\u0002\u0005\u0005\u0007bBAl\u0001\u0011\u0005\u0011\u0011\u001c\u0005\b\u0003G\u0004A\u0011AAm\u0011\u001d\ti\u000f\u0001C\u0001\u00033Dq!a>\u0001\t\u0003\tI\u000eC\u0004\u0002|\u0002!\t!!7\t\u000f\u0005}\b\u0001\"\u0001\u0002Z\"9!1\u0001\u0001\u0005\u0002\u0005e\u0007b\u0002B\u0004\u0001\u0011\u0005\u0011\u0011\u001c\u0005\b\u0005\u0017\u0001A\u0011AAm\u0011\u001d\u0011y\u0001\u0001C\u0001\u00033DqAa\u0005\u0001\t\u0003\tI\u000eC\u0004\u0003\u0018\u0001!\t!!7\t\u000f\tm\u0001\u0001\"\u0001\u0002Z\"9!q\u0004\u0001\u0005\u0002\u0005e\u0007b\u0002B\u0012\u0001\u0011\u0005\u0011\u0011\u001c\u0005\b\u0005O\u0001A\u0011AAm\u0011\u001d\u0011Y\u0003\u0001C\u0001\u00033DqAa\f\u0001\t\u0003\tI\u000eC\u0004\u00034\u0001!\t!!7\t\u000f\t]\u0002\u0001\"\u0001\u0002Z\"9!1\b\u0001\u0005\u0002\u0005e\u0007b\u0002B \u0001\u0011\u0005\u0011\u0011\u001c\u0005\b\u0005\u0007\u0002A\u0011AAm\u0011\u001d\u00119\u0005\u0001C\u0001\u00033DqAa\u0013\u0001\t\u0003\tI\u000eC\u0004\u0003P\u0001!\t!!7\t\u000f\tM\u0003\u0001\"\u0001\u0002Z\"9!q\u000b\u0001\u0005\u0002\u0005e\u0007b\u0002B.\u0001\u0011\u0005\u0011\u0011\u001c\u0005\b\u0005?\u0002A\u0011AAm\u0011\u001d\u0011\u0019\u0007\u0001C\u0001\u00033DqAa\u001a\u0001\t\u0003\tI\u000eC\u0004\u0003l\u0001!\t!!7\t\u000f\t=\u0004\u0001\"\u0001\u0002Z\"9!1\u000f\u0001\u0005\u0002\u0005e\u0007b\u0002B<\u0001\u0011\u0005\u0011\u0011\u001c\u0005\b\u0005w\u0002A\u0011AAm\u0011\u001d\u0011y\b\u0001C\u0001\u00033DqAa!\u0001\t\u0003\tI\u000eC\u0004\u0003\b\u0002!\t!!7\t\u000f\t-\u0005\u0001\"\u0001\u0002Z\"9!q\u0012\u0001\u0005\u0002\u0005e\u0007b\u0002BJ\u0001\u0011\u0005\u0011\u0011\u001c\u0005\b\u0005/\u0003A\u0011AAm\u0005}!v\u000e]5d\u0007>lW.\u00198e/&$\b.\u00113nS:\u001cE.[3oiR+7\u000f\u001e\u0006\u0003\r\u001e\u000bQ!\u00193nS:T\u0011\u0001S\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u00011*U,\u0011\u00051{U\"A'\u000b\u00059;\u0015aC5oi\u0016<'/\u0019;j_:L!\u0001U'\u0003--\u000bgm[1TKJ4XM\u001d+fgRD\u0015M\u001d8fgN\u0004\"AU+\u000e\u0003MS!\u0001V$\u0002\u000bU$\u0018\u000e\\:\n\u0005Y\u001b&a\u0002'pO\u001eLgn\u001a\t\u00031fk\u0011!R\u0005\u00035\u0016\u0013QBU1dW\u0006;\u0018M]3UKN$\u0018A\u0002\u001fj]&$h\bF\u0001^!\tA\u0006!A\bhK:,'/\u0019;f\u0007>tg-[4t+\u0005\u0001\u0007cA1gQ6\t!M\u0003\u0002dI\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u0003\u0015\fQa]2bY\u0006L!a\u001a2\u0003\u0007M+\u0017\u000f\u0005\u0002jY6\t!N\u0003\u0002l\u000f\u000611/\u001a:wKJL!!\u001c6\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\u000e]Vl\u0007+\u0019:uSRLwN\\:\u0016\u0003A\u0004\"!\u001d:\u000e\u0003\u0011L!a\u001d3\u0003\u0007%sG/\u0001\bok6\u0004\u0016M\u001d;ji&|gn\u001d\u0011\u00021\u0011,g-Y;miJ+\u0007\u000f\\5dCRLwN\u001c$bGR|'/F\u0001x!\t\t\b0\u0003\u0002zI\n)1\u000b[8si\u0006IB-\u001a4bk2$(+\u001a9mS\u000e\fG/[8o\r\u0006\u001cGo\u001c:!\u00031!x\u000e]5d'\u0016\u0014h/[2f+\u0005i\bc\u0001@\u0002\u00129\u0019q0!\u0004\u000f\t\u0005\u0005\u00111\u0002\b\u0005\u0003\u0007\tI!\u0004\u0002\u0002\u0006)\u0019\u0011qA%\u0002\rq\u0012xn\u001c;?\u0013\u0005A\u0015B\u0001$H\u0013\r\ty!R\u0001\r)>\u0004\u0018nY\"p[6\fg\u000eZ\u0005\u0005\u0003'\t)BA\fBI6Lgn\u00117jK:$Hk\u001c9jGN+'O^5dK*\u0019\u0011qB#\u0002!Q|\u0007/[2TKJ4\u0018nY3`I\u0015\fH\u0003BA\u000e\u0003C\u00012!]A\u000f\u0013\r\ty\u0002\u001a\u0002\u0005+:LG\u000f\u0003\u0005\u0002$!\t\t\u00111\u0001~\u0003\rAH%M\u0001\u000ei>\u0004\u0018nY*feZL7-\u001a\u0011\u0002\u0017\u0005$W.\u001b8DY&,g\u000e^\u000b\u0003\u0003W\u0001B!!\f\u0002@5\u0011\u0011q\u0006\u0006\u0004\r\u0006E\"\u0002BA\u001a\u0003k\tqa\u00197jK:$8OC\u0002I\u0003oQA!!\u000f\u0002<\u00051\u0011\r]1dQ\u0016T!!!\u0010\u0002\u0007=\u0014x-\u0003\u0003\u0002B\u0005=\"!B!e[&t\u0017aD1e[&t7\t\\5f]R|F%Z9\u0015\t\u0005m\u0011q\t\u0005\n\u0003GY\u0011\u0011!a\u0001\u0003W\tA\"\u00193nS:\u001cE.[3oi\u0002\nQ\u0002^3tiR{\u0007/[2OC6,WCAA(!\u0011\t\t&!\u0017\u000f\t\u0005M\u0013Q\u000b\t\u0004\u0003\u0007!\u0017bAA,I\u00061\u0001K]3eK\u001aLA!a\u0017\u0002^\t11\u000b\u001e:j]\u001eT1!a\u0016e\u0003E!Xm\u001d;U_BL7MT1nK~#S-\u001d\u000b\u0005\u00037\t\u0019\u0007C\u0005\u0002$9\t\t\u00111\u0001\u0002P\u0005qA/Z:u)>\u0004\u0018n\u0019(b[\u0016\u0004\u0013!C0uKN$h*Y7f+\t\tY\u0007\u0005\u0003\u0002n\u0005]TBAA8\u0015\u0011\t\t(a\u001d\u0002\u000bI,H.Z:\u000b\t\u0005U\u00141H\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003s\nyG\u0001\u0005UKN$h*Y7f\u0003)yF/Z:u\u001d\u0006lW\rI\u0001\ti\u0016\u001cHOT1nK\"\u001a!#!!\u0011\t\u0005\r\u0015QQ\u0007\u0003\u0003gJA!a\"\u0002t\t!!+\u001e7f\u00039\t7o]3si\u0016C\u0018\u000e^\"pI\u0016$b!a\u0007\u0002\u000e\u0006E\u0005BBAH'\u0001\u0007\u0001/\u0001\u0005fqB,7\r^3e\u0011\u001d\t\u0019j\u0005a\u0001\u0003+\u000ba!\\3uQ>$\u0007#B9\u0002\u0018\u0006m\u0011bAAMI\nIa)\u001e8di&|g\u000eM\u0001\u0018CN\u001cXM\u001d;DQ\u0016\u001c7.\u0011:hg\u0016C\u0018\u000e^\"pI\u0016$b!a\u0007\u0002 \u0006\u0005\u0006BBAH)\u0001\u0007\u0001\u000fC\u0004\u0002$R\u0001\r!!*\u0002\u000f=\u0004H/[8ogB\u0019a0a*\n\t\u0005%\u0016Q\u0003\u0002\u0014)>\u0004\u0018nY\"p[6\fg\u000eZ(qi&|gn]\u0001\u0013GJ,\u0017\r^3B]\u0012<\u0016-\u001b;U_BL7\r\u0006\u0003\u0002\u001c\u0005=\u0006bBAY+\u0001\u0007\u0011QU\u0001\u0005_B$8/A\nxC&$hi\u001c:U_BL7m\u0011:fCR,G\r\u0006\u0004\u0002\u001c\u0005]\u00161\u0018\u0005\b\u0003s3\u0002\u0019AA(\u0003%!x\u000e]5d\u001d\u0006lW\r\u0003\u0005\u0002>Z\u0001\n\u00111\u0001q\u0003\u001d!\u0018.\\3pkR\fQd^1ji\u001a{'\u000fV8qS\u000e\u001c%/Z1uK\u0012$C-\u001a4bk2$HEM\u000b\u0003\u0003\u0007T3\u0001]AcW\t\t9\r\u0005\u0003\u0002J\u0006MWBAAf\u0015\u0011\ti-a4\u0002\u0013Ut7\r[3dW\u0016$'bAAiI\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005U\u00171\u001a\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!B:fiV\u0004HCAA\u000eQ\rA\u0012Q\u001c\t\u0005\u0003\u0007\u000by.\u0003\u0003\u0002b\u0006M$A\u0002\"fM>\u0014X-A\u0003dY>\u001cX\rK\u0002\u001a\u0003O\u0004B!a!\u0002j&!\u00111^A:\u0005\u0015\te\r^3s\u0003M!Xm\u001d;QCJ\u001cX-Q:tS\u001etW.\u001a8uQ\rQ\u0012\u0011\u001f\t\u0005\u0003\u0007\u000b\u00190\u0003\u0003\u0002v\u0006M$\u0001\u0002+fgR\f1\u0005^3tiB\u000b'o]3BgNLwM\\7f]R$U\u000f\u001d7jG\u0006$X-\u00128ue&,7\u000fK\u0002\u001c\u0003c\fA\u0006^3tiB\u000b'o]3BgNLwM\\7f]R\u0004\u0016M\u001d;ji&|gn](g\t&4g-\u001a:f]R\u001c\u0016N_3)\u0007q\t\t0A\u0011uKN$8i\u001c8gS\u001e|\u0005\u000f^,ji\"\u0014un\u001c;tiJ\f\u0007oU3sm\u0016\u00148\u000fK\u0002\u001e\u0003c\f!\u0002^3ti\u000e\u0013X-\u0019;fQ\rq\u0012\u0011_\u0001\u0017i\u0016\u001cHo\u0011:fCR,w+\u001b;i\t\u00164\u0017-\u001e7ug\"\u001aq$!=\u0002AQ,7\u000f^\"sK\u0006$XmV5uQ\u0012+g-Y;miJ+\u0007\u000f\\5dCRLwN\u001c\u0015\u0004A\u0005E\u0018a\b;fgR\u001c%/Z1uK^KG\u000f\u001b#fM\u0006,H\u000e\u001e)beRLG/[8og\"\u001a\u0011%!=\u0002+Q,7\u000f^\"sK\u0006$XmV5uQ\u000e{gNZ5hg\"\u001a!%!=\u00027Q,7\u000f^\"sK\u0006$X-\u00134Ji\u0006c'/Z1es\u0016C\u0018n\u001d;tQ\r\u0019\u0013\u0011_\u0001 i\u0016\u001cHo\u0011:fCR,w+\u001b;i%\u0016\u0004H.[2b\u0003N\u001c\u0018n\u001a8nK:$\bf\u0001\u0013\u0002r\u00061C/Z:u\u0007J,\u0017\r^3XSRD\u0017J\u001c<bY&$'+\u001a9mS\u000e\fG/[8o\r\u0006\u001cGo\u001c:)\u0007\u0015\n\t0A\u0014uKN$8I]3bi\u0016<\u0016\u000e\u001e5OK\u001e\fG/\u001b<f%\u0016\u0004H.[2bi&|gNR1di>\u0014\bf\u0001\u0014\u0002r\u0006IC/Z:u\u0007J,\u0017\r^3XSRD\u0017i]:jO:lWM\u001c;B]\u0012\u0004\u0016M\u001d;ji&|gnQ8v]RD3aJAy\u00031\"Xm\u001d;De\u0016\fG/Z,ji\"\f5o]5h]6,g\u000e^!oIJ+\u0007\u000f\\5dCRLwN\u001c$bGR|'\u000fK\u0002)\u0003c\fA\u0005^3ti\u000e\u0013X-\u0019;f/&$\bNT3hCRLg/\u001a)beRLG/[8o\u0007>,h\u000e\u001e\u0015\u0004S\u0005E\u0018a\u0011;fgR\u001c%/Z1uK^KG\u000f[+ogB,7-\u001b4jK\u0012\u0014V\r\u001d7jG\u0006$\u0018n\u001c8GC\u000e$xN]!oIB\u000b'\u000f^5uS>t7oV5uQj[7\t\\5f]RD3AKAy\u0003m!Xm\u001d;J]Z\fG.\u001b3U_BL7\rT3wK2\u001cuN\u001c4jO\"\u001a1&!=\u0002\u001dQ,7\u000f\u001e'jgR$v\u000e]5dg\"\u001aA&!=\u00027Q,7\u000f\u001e'jgR$v\u000e]5dg^KG\u000f[,iSR,G.[:uQ\ri\u0013\u0011_\u0001\"i\u0016\u001cH\u000fT5tiR{\u0007/[2t/&$\b.\u0012=dYV$W-\u00138uKJt\u0017\r\u001c\u0015\u0004]\u0005E\u0018a\u0006;fgR\fE\u000e^3s!\u0006\u0014H/\u001b;j_:\u001cu.\u001e8uQ\ry\u0013\u0011_\u0001\u0014i\u0016\u001cH/\u00117uKJ\f5o]5h]6,g\u000e\u001e\u0015\u0004a\u0005E\u0018a\r;fgR\fE\u000e^3s\u0003N\u001c\u0018n\u001a8nK:$x+\u001b;i\u001b>\u0014X-Q:tS\u001etW.\u001a8u)\"\fg\u000eU1si&$\u0018n\u001c8tQ\r\t\u0014\u0011_\u00014i\u0016\u001cH/\u00117uKJ\f5o]5h]6,g\u000e^,ji\"luN]3QCJ$\u0018\u000e^5p]N$\u0006.\u00198BgNLwM\\7f]RD3AMAy\u0003\t\"Xm\u001d;BYR,'oV5uQ&sg/\u00197jIB\u000b'\u000f^5uS>t7i\\;oi\"\u001a1'!=\u0002MQ,7\u000f^!mi\u0016\u0014x+\u001b;i+:\u001c\b/Z2jM&,G\rU1si&$\u0018n\u001c8D_VtG\u000fK\u00025\u0003c\fQ\u0004^3ti\u0006cG/\u001a:XQ\u0016tGk\u001c9jG\u0012{Wm\u001d8u\u000bbL7\u000f\u001e\u0015\u0004k\u0005E\u0018\u0001\u0010;fgRLe-\u0012=jgR\u001c\u0018I\u001c3JM:{G/\u0012=jgR\u001cx\n\u001d;j_:\u001c\u0018J\u001c<bY&$w+\u001b;i\u0005>|Go\u001d;sCB\u001cVM\u001d<feND3ANAy\u0003\u0005\"Xm\u001d;De\u0016\fG/Z!mi\u0016\u0014Hk\u001c9jG^KG\u000f\u001b*bG.\fu/\u0019:fQ\r9\u0014\u0011_\u00010i\u0016\u001cHoQ8oM&<\u0007K]3tKJ4\u0018\r^5p]\u0006\u001b'o\\:t!\u0006\u0014H/\u001b;j_:\fE\u000e^3sCRLwN\u001c\u0015\u0004q\u0005E\u0018!\u0005;fgR$v\u000e]5d\t\u0016dW\r^5p]\"\u001a\u0011(!=\u0002/Q,7\u000f\u001e#fY\u0016$X-\u00138uKJt\u0017\r\u001c+pa&\u001c\u0007f\u0001\u001e\u0002r\u0006\u0011B/Z:u\t\u0016dW\r^3JM\u0016C\u0018n\u001d;tQ\rY\u0014\u0011_\u0001\ri\u0016\u001cH\u000fR3tGJL'-\u001a\u0015\u0004y\u0005E\u0018!\t;fgR$Um]2sS\n,WK\\1wC&d\u0017M\u00197f!\u0006\u0014H/\u001b;j_:\u001c\bfA\u001f\u0002r\u0006)C/Z:u\t\u0016\u001c8M]5cKVsG-\u001a:SKBd\u0017nY1uK\u0012\u0004\u0016M\u001d;ji&|gn\u001d\u0015\u0004}\u0005E\u0018!\t;fgR$Um]2sS\n,WK\u001c3fe6Kg.S:s!\u0006\u0014H/\u001b;j_:\u001c\bfA \u0002r\u0006qB/Z:u\t\u0016\u001c8M]5cK\u0006#X*\u001b8JgJ\u0004\u0016M\u001d;ji&|gn\u001d\u0015\u0004\u0001\u0006E\u0018A\n;fgR$Um]2sS\n,WK\u001c3fe6Kg.S:s!\u0006\u0014H/\u001b;j_:\u001cX*\u001b=fI\"\u001a\u0011)!=\u0002GQ,7\u000f\u001e#fg\u000e\u0014\u0018NY3SKB|'\u000f^(wKJ\u0014\u0018\u000e\u001a3f]\u000e{gNZ5hg\"\u001a!)!=\u0002]Q,7\u000f\u001e#fg\u000e\u0014\u0018NY3B]\u0012d\u0015n\u001d;U_BL7m],ji\"|W\u000f^%oi\u0016\u0014h.\u00197U_BL7m\u001d\u0015\u0004\u0007\u0006E\b")
public class TopicCommandWithAdminClientTest
extends KafkaServerTestHarness
implements RackAwareTest {
    private final int numPartitions;
    private final short defaultReplicationFactor;
    private TopicCommand.AdminClientTopicService topicService;
    private Admin adminClient;
    private String testTopicName;
    private final TestName _testName;

    @Override
    public void checkReplicaDistribution(Map<Object, Seq<Object>> assignment, Map<Object, String> brokerRackMapping, int numBrokers, int numPartitions, int replicationFactor, boolean verifyRackAware, boolean verifyLeaderDistribution, boolean verifyReplicasDistribution) {
        RackAwareTest.checkReplicaDistribution$(this, assignment, brokerRackMapping, numBrokers, numPartitions, replicationFactor, verifyRackAware, verifyLeaderDistribution, verifyReplicasDistribution);
    }

    @Override
    public boolean checkReplicaDistribution$default$6() {
        return RackAwareTest.checkReplicaDistribution$default$6$(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$7() {
        return RackAwareTest.checkReplicaDistribution$default$7$(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$8() {
        return RackAwareTest.checkReplicaDistribution$default$8$(this);
    }

    @Override
    public ReplicaDistributions getReplicaDistribution(Map<Object, Seq<Object>> assignment, Map<Object, String> brokerRackMapping) {
        return RackAwareTest.getReplicaDistribution$(this, assignment, brokerRackMapping);
    }

    @Override
    public Seq<BrokerMetadata> toBrokerMetadata(Map<Object, String> rackMap, Seq<Object> brokersWithoutRack) {
        return RackAwareTest.toBrokerMetadata$(this, rackMap, brokersWithoutRack);
    }

    @Override
    public Seq<Object> toBrokerMetadata$default$2() {
        return RackAwareTest.toBrokerMetadata$default$2$(this);
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        int x$1 = 6;
        String x$2 = this.zkConnect();
        scala.collection.immutable.Map x$3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)"rack3")}));
        int x$4 = this.numPartitions();
        short x$5 = this.defaultReplicationFactor();
        boolean x$6 = TestUtils$.MODULE$.createBrokerConfigs$default$3();
        boolean x$7 = TestUtils$.MODULE$.createBrokerConfigs$default$4();
        Option<SecurityProtocol> x$8 = TestUtils$.MODULE$.createBrokerConfigs$default$5();
        Option<File> x$9 = TestUtils$.MODULE$.createBrokerConfigs$default$6();
        Option<Properties> x$10 = TestUtils$.MODULE$.createBrokerConfigs$default$7();
        boolean x$11 = TestUtils$.MODULE$.createBrokerConfigs$default$8();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfigs$default$9();
        boolean x$13 = TestUtils$.MODULE$.createBrokerConfigs$default$10();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfigs$default$11();
        int x$15 = TestUtils$.MODULE$.createBrokerConfigs$default$13();
        boolean x$16 = TestUtils$.MODULE$.createBrokerConfigs$default$14();
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(x$1, x$2, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Map<Object, String>)x$3, x$15, x$16, x$4, x$5).map((Function1 & Serializable & scala.Serializable)props -> KafkaConfig$.MODULE$.fromProps(props), Seq$.MODULE$.canBuildFrom());
    }

    private int numPartitions() {
        return this.numPartitions;
    }

    private short defaultReplicationFactor() {
        return this.defaultReplicationFactor;
    }

    private TopicCommand.AdminClientTopicService topicService() {
        return this.topicService;
    }

    private void topicService_$eq(TopicCommand.AdminClientTopicService x$1) {
        this.topicService = x$1;
    }

    private Admin adminClient() {
        return this.adminClient;
    }

    private void adminClient_$eq(Admin x$1) {
        this.adminClient = x$1;
    }

    private String testTopicName() {
        return this.testTopicName;
    }

    private void testTopicName_$eq(String x$1) {
        this.testTopicName = x$1;
    }

    private TestName _testName() {
        return this._testName;
    }

    @Rule
    public TestName testName() {
        return this._testName();
    }

    public void assertExitCode(int expected, Function0<BoxedUnit> method) {
        Exit$.MODULE$.setExitProcedure((Function2 & Serializable & scala.Serializable)(exitCode, exitMessage) -> TopicCommandWithAdminClientTest.mockExitProcedure$1(BoxesRunTime.unboxToInt((Object)exitCode), exitMessage, expected));
        try {
            Assertions$.MODULE$.intercept(method, ClassTag$.MODULE$.apply(RuntimeException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
        }
        finally {
            Exit$.MODULE$.resetExitProcedure();
        }
    }

    public void assertCheckArgsExitCode(int expected, TopicCommand.TopicCommandOptions options) {
        this.assertExitCode(expected, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> options.checkArgs());
    }

    public void createAndWaitTopic(TopicCommand.TopicCommandOptions opts) {
        this.topicService().createTopic(opts);
        this.waitForTopicCreated((String)opts.topic().get(), this.waitForTopicCreated$default$2());
    }

    public void waitForTopicCreated(String topicName, int timeout) {
        long finishTime = System.currentTimeMillis() + (long)timeout;
        boolean result = false;
        while (System.currentTimeMillis() < finishTime || !result) {
            java.util.Set topics = (java.util.Set)this.adminClient().listTopics(new ListTopicsOptions().listInternal(true)).names().get();
            result = topics.contains(topicName);
            Thread.sleep(100L);
        }
        Assert.assertTrue((String)new StringBuilder(50).append("Topic ").append(topicName).append(" has not been created within the given ").append(timeout).append(" time").toString(), (boolean)result);
    }

    public int waitForTopicCreated$default$2() {
        return 10000;
    }

    @Before
    public void setup() {
        Properties props = new Properties();
        props.put("bootstrap.servers", this.brokerList());
        this.adminClient_$eq((Admin)AdminClient.create((Properties)props));
        this.topicService_$eq(TopicCommand.AdminClientTopicService$.MODULE$.apply(this.adminClient()));
        this.testTopicName_$eq(new StringBuilder(1).append(this.testName().getMethodName()).append("-").append(Random$.MODULE$.alphanumeric().take(10).mkString()).toString());
    }

    @After
    public void close() {
        block0: {
            if (this.topicService() == null) break block0;
            this.topicService().close();
        }
    }

    @Test
    public void testParseAssignment() {
        Map actualAssignment = TopicCommand$.MODULE$.parseReplicaAssignment("5:4,3:2,1:0");
        scala.collection.immutable.Map expectedAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 4}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0})))}));
        Assert.assertEquals((Object)expectedAssignment, (Object)actualAssignment);
    }

    @Test
    public void testParseAssignmentDuplicateEntries() {
        Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> TopicCommand$.MODULE$.parseReplicaAssignment("5:5"), ClassTag$.MODULE$.apply(AdminCommandFailedException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129));
    }

    @Test
    public void testParseAssignmentPartitionsOfDifferentSize() {
        Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> TopicCommand$.MODULE$.parseReplicaAssignment("5:4:3,2:1"), ClassTag$.MODULE$.apply(AdminOperationException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
    }

    @Test
    public void testConfigOptWithBootstrapServers() {
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--alter", "--topic", this.testTopicName(), "--partitions", "3", "--config", "cleanup.policy=compact"})));
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--alter", "--topic", this.testTopicName(), "--partitions", "3", "--delete-config", "cleanup.policy"})));
        TopicCommand.TopicCommandOptions opts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--create", "--topic", this.testTopicName(), "--partitions", "3", "--replication-factor", "3", "--config", "cleanup.policy=compact"}));
        opts.checkArgs();
        Assert.assertTrue((boolean)opts.hasCreateOption());
        Assert.assertEquals((Object)this.brokerList(), (Object)opts.bootstrapServer().get());
        Assert.assertEquals((Object)"cleanup.policy=compact", ((java.util.List)opts.topicConfig().get()).get(0));
    }

    @Test
    public void testCreate() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "2", "--replication-factor", "1", "--topic", this.testTopicName()})));
        ((java.util.Set)this.adminClient().listTopics().names().get()).contains(this.testTopicName());
    }

    @Test
    public void testCreateWithDefaults() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName()})));
        java.util.List partitions = ((TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).all().get()).get(this.testTopicName())).partitions();
        Assert.assertEquals((long)partitions.size(), (long)this.numPartitions());
        Assert.assertEquals((long)((TopicPartitionInfo)partitions.get(0)).replicas().size(), (long)this.defaultReplicationFactor());
    }

    @Test
    public void testCreateWithDefaultReplication() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--partitions", "2"})));
        java.util.List partitions = ((TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).all().get()).get(this.testTopicName())).partitions();
        Assert.assertEquals((long)partitions.size(), (long)2L);
        Assert.assertEquals((long)((TopicPartitionInfo)partitions.get(0)).replicas().size(), (long)this.defaultReplicationFactor());
    }

    @Test
    public void testCreateWithDefaultPartitions() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--replication-factor", "2"})));
        java.util.List partitions = ((TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).all().get()).get(this.testTopicName())).partitions();
        Assert.assertEquals((long)partitions.size(), (long)this.numPartitions());
        Assert.assertEquals((long)((TopicPartitionInfo)partitions.get(0)).replicas().size(), (long)2L);
    }

    @Test
    public void testCreateWithConfigs() {
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.TOPIC, this.testTopicName());
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "2", "--replication-factor", "2", "--topic", this.testTopicName(), "--config", "delete.retention.ms=1000"})));
        Config configs = (Config)((java.util.Map)this.adminClient().describeConfigs(Collections.singleton(configResource)).all().get()).get(configResource);
        Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)1000), (Object)Integer.valueOf(configs.get("delete.retention.ms").value()));
    }

    @Test
    public void testCreateIfItAlreadyExists() {
        int numPartitions = 1;
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)numPartitions)).toString(), "--replication-factor", "1", "--topic", this.testTopicName()}));
        this.createAndWaitTopic(createOpts);
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().createTopic(createOpts), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 232));
    }

    @Test
    public void testCreateWithReplicaAssignment() {
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--replica-assignment", "5:4,3:2,1:0", "--topic", this.testTopicName()}));
        this.createAndWaitTopic(createOpts);
        java.util.List partitions = ((TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).all().get()).get(this.testTopicName())).partitions();
        Assert.assertEquals((long)3L, (long)partitions.size());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 4})), (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)partitions.get(0)).replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.id()), Buffer$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2})), (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)partitions.get(1)).replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.id()), Buffer$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0})), (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)partitions.get(2)).replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.id()), Buffer$.MODULE$.canBuildFrom()));
    }

    @Test
    public void testCreateWithInvalidReplicationFactor() {
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "2", "--replication-factor", ((Object)BoxesRunTime.boxToInteger((int)32768)).toString(), "--topic", this.testTopicName()}))), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 258));
    }

    @Test
    public void testCreateWithNegativeReplicationFactor() {
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "2", "--replication-factor", "-1", "--topic", this.testTopicName()}))), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 266));
    }

    @Test
    public void testCreateWithAssignmentAndPartitionCount() {
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--create", "--replica-assignment", "3:0,5:1", "--partitions", "2", "--topic", "testTopic"})));
    }

    @Test
    public void testCreateWithAssignmentAndReplicationFactor() {
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--create", "--replica-assignment", "3:0,5:1", "--replication-factor", "2", "--topic", "testTopic"})));
    }

    @Test
    public void testCreateWithNegativePartitionCount() {
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "-1", "--replication-factor", "1", "--topic", this.testTopicName()}))), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 296));
    }

    @Test
    public void testCreateWithUnspecifiedReplicationFactorAndPartitionsWithZkClient() {
        this.assertExitCode(1, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--create", "--zookeeper", "zk", "--topic", this.testTopicName()})).checkArgs());
    }

    @Test
    public void testInvalidTopicLevelConfig() {
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName(), "--config", "message.timestamp.type=boom"}));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().createTopic(createOpts), ClassTag$.MODULE$.apply(ConfigException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 314));
    }

    @Test
    public void testListTopics() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()})));
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)))));
        Assert.assertTrue((boolean)output.contains(this.testTopicName()));
    }

    @Test
    public void testListTopicsWithWhitelist() {
        String topic1 = "kafka.testTopic1";
        String topic2 = "kafka.testTopic2";
        String topic3 = "oooof.testTopic1";
        this.adminClient().createTopics(JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new NewTopic(topic1, 2, (short)2), (List)new .colon.colon((Object)new NewTopic(topic2, 2, (short)2), (List)new .colon.colon((Object)new NewTopic(topic3, 2, (short)2), (List)Nil$.MODULE$)))).asJavaCollection()).all().get();
        this.waitForTopicCreated(topic1, this.waitForTopicCreated$default$2());
        this.waitForTopicCreated(topic2, this.waitForTopicCreated$default$2());
        this.waitForTopicCreated(topic3, this.waitForTopicCreated$default$2());
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", "kafka.*"}))));
        Assert.assertTrue((boolean)output.contains(topic1));
        Assert.assertTrue((boolean)output.contains(topic2));
        Assert.assertFalse((boolean)output.contains(topic3));
    }

    @Test
    public void testListTopicsWithExcludeInternal() {
        String topic1 = "kafka.testTopic1";
        this.adminClient().createTopics(JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new NewTopic(topic1, 2, (short)2), (List)new .colon.colon((Object)new NewTopic("__consumer_offsets", 2, (short)2), (List)Nil$.MODULE$))).asJavaCollection()).all().get();
        this.waitForTopicCreated(topic1, this.waitForTopicCreated$default$2());
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--exclude-internal"}))));
        Assert.assertTrue((boolean)output.contains(topic1));
        Assert.assertFalse((boolean)output.contains("__consumer_offsets"));
    }

    @Test
    public void testAlterPartitionCount() {
        this.adminClient().createTopics(JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new NewTopic(this.testTopicName(), 2, (short)2), (List)Nil$.MODULE$)).asJavaCollection()).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        this.topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--partitions", "3"})));
        TopicDescription topicDescription = (TopicDescription)((KafkaFuture)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).values().get(this.testTopicName())).get();
        Assert.assertTrue((topicDescription.partitions().size() == 3 ? 1 : 0) != 0);
    }

    @Test
    public void testAlterAssignment() {
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 2, (short)2))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        this.topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--replica-assignment", "5:3,3:1,4:2", "--partitions", "3"})));
        TopicDescription topicDescription = (TopicDescription)((KafkaFuture)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).values().get(this.testTopicName())).get();
        Assert.assertTrue((topicDescription.partitions().size() == 3 ? 1 : 0) != 0);
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 2})), (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)topicDescription.partitions().get(2)).replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.id()), Buffer$.MODULE$.canBuildFrom()));
    }

    @Test
    public void testAlterAssignmentWithMoreAssignmentThanPartitions() {
        this.adminClient().createTopics(JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new NewTopic(this.testTopicName(), 2, (short)2), (List)Nil$.MODULE$)).asJavaCollection()).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--replica-assignment", "5:3,3:1,4:2,3:2", "--partitions", "3"}))), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 401));
    }

    @Test
    public void testAlterAssignmentWithMorePartitionsThanAssignment() {
        this.adminClient().createTopics(JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new NewTopic(this.testTopicName(), 2, (short)2), (List)Nil$.MODULE$)).asJavaCollection()).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--replica-assignment", "5:3,3:1,4:2", "--partitions", "6"}))), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 413));
    }

    @Test
    public void testAlterWithInvalidPartitionCount() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()})));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "-1", "--topic", this.testTopicName()}))), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 424));
    }

    @Test
    public void testAlterWithUnspecifiedPartitionCount() {
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--alter", "--topic", this.testTopicName()})));
    }

    @Test
    public void testAlterWhenTopicDoesntExist() {
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--partitions", "1"}));
        TopicCommand.AdminClientTopicService topicService = TopicCommand.AdminClientTopicService$.MODULE$.apply(this.adminClient());
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> topicService.alterTopic(alterOpts), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 441));
    }

    @Test
    public void testIfExistsAndIfNotExistsOptionsInvalidWithBootstrapServers() {
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", "server1:9092", "--alter", "--if-exists", "--topic", this.testTopicName(), "--partitions", "1"})));
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", "server1:9092", "--create", "--if-not-exists", "--topic", this.testTopicName(), "--partitions", "1", "--replication-factor", "1"})));
    }

    @Test
    public void testCreateAlterTopicWithRackAware() {
        scala.collection.immutable.Map rackInfo = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)"rack3")}));
        int numPartitions = 18;
        int replicationFactor = 3;
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)numPartitions)).toString(), "--replication-factor", ((Object)BoxesRunTime.boxToInteger((int)replicationFactor)).toString(), "--topic", this.testTopicName()}));
        this.createAndWaitTopic(createOpts);
        Map assignment = (Map)this.zkClient().getReplicaAssignmentForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.testTopicName()}))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            Seq replicas = (Seq)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)replicas);
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
        this.checkReplicaDistribution((Map<Object, Seq<Object>>)assignment, (Map<Object, String>)rackInfo, rackInfo.size(), numPartitions, replicationFactor, this.checkReplicaDistribution$default$6(), this.checkReplicaDistribution$default$7(), this.checkReplicaDistribution$default$8());
        int alteredNumPartitions = 36;
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)alteredNumPartitions)).toString(), "--topic", this.testTopicName()}));
        this.topicService().alterTopic(alterOpts);
        assignment = (Map)this.zkClient().getReplicaAssignmentForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.testTopicName()}))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            Seq replicas = (Seq)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)replicas);
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
        this.checkReplicaDistribution((Map<Object, Seq<Object>>)assignment, (Map<Object, String>)rackInfo, rackInfo.size(), alteredNumPartitions, replicationFactor, this.checkReplicaDistribution$default$6(), this.checkReplicaDistribution$default$7(), this.checkReplicaDistribution$default$8());
    }

    @Test
    public void testConfigPreservationAcrossPartitionAlteration() {
        int numPartitionsOriginal = 1;
        String cleanupKey = "cleanup.policy";
        String cleanupVal = "compact";
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)numPartitionsOriginal)).toString(), "--replication-factor", "1", "--config", new StringBuilder(1).append(cleanupKey).append("=").append(cleanupVal).toString(), "--topic", this.testTopicName()}));
        this.createAndWaitTopic(createOpts);
        Properties props = this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Topic(), this.testTopicName());
        Assert.assertTrue((String)new StringBuilder(40).append("Properties after creation don't contain ").append(cleanupKey).toString(), (boolean)props.containsKey(cleanupKey));
        Assert.assertTrue((String)"Properties after creation have incorrect value", (boolean)props.getProperty(cleanupKey).equals(cleanupVal));
        this.zkClient().makeSurePersistentPathExists(ConfigEntityChangeNotificationZNode$.MODULE$.path());
        int numPartitionsModified = 3;
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)numPartitionsModified)).toString(), "--topic", this.testTopicName()}));
        this.topicService().alterTopic(alterOpts);
        Properties newProps = this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Topic(), this.testTopicName());
        Assert.assertTrue((String)new StringBuilder(34).append("Updated properties do not contain ").append(cleanupKey).toString(), (boolean)newProps.containsKey(cleanupKey));
        Assert.assertTrue((String)"Updated properties have incorrect value", (boolean)newProps.getProperty(cleanupKey).equals(cleanupVal));
    }

    @Test
    public void testTopicDeletion() {
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()}));
        this.createAndWaitTopic(createOpts);
        TopicCommand.TopicCommandOptions deleteOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName()}));
        String deletePath = DeleteTopicsTopicZNode$.MODULE$.path(this.testTopicName());
        Assert.assertFalse((String)"Delete path for topic shouldn't exist before deletion.", (boolean)this.zkClient().pathExists(deletePath));
        this.topicService().deleteTopic(deleteOpts);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), this.testTopicName(), 1, (Seq<KafkaServer>)this.servers());
    }

    @Test
    public void testDeleteInternalTopic() {
        TopicCommand.TopicCommandOptions createOffsetTopicOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", "__consumer_offsets"}));
        this.createAndWaitTopic(createOffsetTopicOpts);
        TopicCommand.TopicCommandOptions deleteOffsetTopicOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", "__consumer_offsets"}));
        String deleteOffsetTopicPath = DeleteTopicsTopicZNode$.MODULE$.path("__consumer_offsets");
        Assert.assertFalse((String)"Delete path for topic shouldn't exist before deletion.", (boolean)this.zkClient().pathExists(deleteOffsetTopicPath));
        this.topicService().deleteTopic(deleteOffsetTopicOpts);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), "__consumer_offsets", 1, (Seq<KafkaServer>)this.servers());
    }

    @Test
    public void testDeleteIfExists() {
        TopicCommand.TopicCommandOptions deleteOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName()}));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().deleteTopic(deleteOpts), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 549));
    }

    @Test
    public void testDescribe() {
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 2, (short)2))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName()}))));
        String[] rows = output.split("\n");
        Assert.assertEquals((long)3L, (long)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rows)).size());
        rows[0].startsWith(new StringBuilder(23).append("Topic:").append(this.testTopicName()).append("\tPartitionCount:2").toString());
    }

    @Test
    public void testDescribeUnavailablePartitions() {
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 6, (short)1))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        try {
            TopicDescription testTopicDescription = (TopicDescription)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).all().get()).asScala()).apply((Object)this.testTopicName());
            int partitionOnBroker0 = ((TopicPartitionInfo)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(testTopicDescription.partitions()).asScala()).find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandWithAdminClientTest.$anonfun$testDescribeUnavailablePartitions$1(x$5))).get()).partition();
            this.killBroker(0);
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToBoolean((Object)((TraversableOnce)this.servers().filterNot((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandWithAdminClientTest.$anonfun$testDescribeUnavailablePartitions$3(x$6)))).foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2 & Serializable & scala.Serializable)(result, server) -> BoxesRunTime.boxToBoolean((boolean)TopicCommandWithAdminClientTest.$anonfun$testDescribeUnavailablePartitions$4(this, partitionOnBroker0, BoxesRunTime.unboxToBoolean((Object)result), server)))), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Partition metadata for ").append(this.testTopicName()).append(" is not propagated").toString(), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
            String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--unavailable-partitions"}))));
            String[] rows = output.split("\n");
            Assert.assertTrue((boolean)rows[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()));
            Assert.assertTrue((boolean)rows[0].contains("Leader: none\tReplicas: 0\tIsr:"));
        }
        finally {
            this.restartDeadBrokers();
        }
    }

    @Test
    public void testDescribeUnderReplicatedPartitions() {
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 1, (short)6))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        try {
            this.killBroker(0);
            Buffer aliveServers = (Buffer)this.servers().filterNot((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandWithAdminClientTest.$anonfun$testDescribeUnderReplicatedPartitions$1(x$9)));
            TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)aliveServers, this.testTopicName(), 0, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
            String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--under-replicated-partitions"}))));
            String[] rows = output.split("\n");
            Assert.assertTrue((boolean)rows[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()));
        }
        finally {
            this.restartDeadBrokers();
        }
    }

    @Test
    public void testDescribeUnderMinIsrPartitions() {
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("min.insync.replicas", "6");
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 1, (short)6).configs(configMap))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        try {
            this.killBroker(0);
            Buffer aliveServers = (Buffer)this.servers().filterNot((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandWithAdminClientTest.$anonfun$testDescribeUnderMinIsrPartitions$1(x$10)));
            TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)aliveServers, this.testTopicName(), 0, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
            String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--under-min-isr-partitions"}))));
            String[] rows = output.split("\n");
            Assert.assertTrue((boolean)rows[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()));
        }
        finally {
            this.restartDeadBrokers();
        }
    }

    @Test
    public void testDescribeAtMinIsrPartitions() {
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("min.insync.replicas", "4");
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 1, (short)6).configs(configMap))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        try {
            this.killBroker(0);
            this.killBroker(1);
            String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--at-min-isr-partitions"}))));
            String[] rows = output.split("\n");
            Assert.assertTrue((boolean)rows[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()));
            Assert.assertEquals((long)1L, (long)rows.length);
        }
        finally {
            this.restartDeadBrokers();
        }
    }

    @Test
    public void testDescribeUnderMinIsrPartitionsMixed() {
        String underMinIsrTopic = "under-min-isr-topic";
        String notUnderMinIsrTopic = "not-under-min-isr-topic";
        String offlineTopic = "offline-topic";
        String fullyReplicatedTopic = "fully-replicated-topic";
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("min.insync.replicas", "6");
        this.adminClient().createTopics(Arrays.asList((Object[])new NewTopic[]{new NewTopic(underMinIsrTopic, 1, (short)6).configs(configMap), new NewTopic(notUnderMinIsrTopic, 1, (short)6), new NewTopic(offlineTopic, Collections.singletonMap(Predef$.MODULE$.int2Integer(0), Collections.singletonList(Predef$.MODULE$.int2Integer(0)))), new NewTopic(fullyReplicatedTopic, Collections.singletonMap(Predef$.MODULE$.int2Integer(0), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3)})))})).all().get();
        this.waitForTopicCreated(underMinIsrTopic, this.waitForTopicCreated$default$2());
        this.waitForTopicCreated(notUnderMinIsrTopic, this.waitForTopicCreated$default$2());
        this.waitForTopicCreated(offlineTopic, this.waitForTopicCreated$default$2());
        this.waitForTopicCreated(fullyReplicatedTopic, this.waitForTopicCreated$default$2());
        try {
            this.killBroker(0);
            Buffer aliveServers = (Buffer)this.servers().filterNot((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandWithAdminClientTest.$anonfun$testDescribeUnderMinIsrPartitionsMixed$1(x$11)));
            TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)aliveServers, underMinIsrTopic, 0, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
            String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--under-min-isr-partitions"}))));
            String[] rows = output.split("\n");
            Assert.assertTrue((boolean)rows[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(underMinIsrTopic).toString()));
            Assert.assertTrue((boolean)rows[1].startsWith(new StringBuilder(8).append("\tTopic: ").append(offlineTopic).toString()));
            Assert.assertEquals((long)2L, (long)rows.length);
        }
        finally {
            this.restartDeadBrokers();
        }
    }

    @Test
    public void testDescribeReportOverriddenConfigs() {
        String config = "file.delete.delay.ms=1000";
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "2", "--replication-factor", "2", "--topic", this.testTopicName(), "--config", config})));
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)))));
        Assert.assertTrue((String)new StringBuilder(38).append("Describe output should have contained ").append(config).toString(), (boolean)output.contains(config));
    }

    @Test
    public void testDescribeAndListTopicsWithoutInternalTopics() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()})));
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", "__consumer_offsets"})));
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--describe", "--exclude-internal"}))));
        Assert.assertTrue((String)new StringBuilder(29).append("Output should have contained ").append(this.testTopicName()).toString(), (boolean)output.contains(this.testTopicName()));
        Assert.assertFalse((boolean)output.contains("__consumer_offsets"));
        output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--list", "--exclude-internal"}))));
        Assert.assertTrue((boolean)output.contains(this.testTopicName()));
        Assert.assertFalse((boolean)output.contains("__consumer_offsets"));
    }

    private static final Nothing$ mockExitProcedure$1(int exitCode, Option exitMessage, int expected$1) {
        Assert.assertEquals((long)expected$1, (long)exitCode);
        throw new RuntimeException();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$1(TopicPartitionInfo x$5) {
        return x$5.leader().id() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$3(KafkaServer x$6) {
        return x$6.config().brokerId() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$5(TopicCommandWithAdminClientTest $this, MetadataResponse.TopicMetadata x$7) {
        return x$7.topic().equals($this.testTopicName());
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$6(int partitionOnBroker0$1, MetadataResponse.PartitionMetadata x$8) {
        return x$8.partition() == partitionOnBroker0$1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$4(TopicCommandWithAdminClientTest $this, int partitionOnBroker0$1, boolean result, KafkaServer server) {
        boolean x$4;
        boolean x$3;
        ListenerName x$2;
        MetadataCache qual$1 = server.dataPlaneRequestProcessor().metadataCache();
        scala.collection.immutable.Set x$1 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{$this.testTopicName()}));
        Seq topicMetadatas = qual$1.getTopicMetadata((Set)x$1, x$2 = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), x$3 = qual$1.getTopicMetadata$default$3(), x$4 = qual$1.getTopicMetadata$default$4());
        Option testPartitionMetadata = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((MetadataResponse.TopicMetadata)topicMetadatas.find((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandWithAdminClientTest.$anonfun$testDescribeUnavailablePartitions$5($this, x$7))).get()).partitionMetadata()).asScala()).find((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandWithAdminClientTest.$anonfun$testDescribeUnavailablePartitions$6(partitionOnBroker0$1, x$8)));
        Option option = testPartitionMetadata;
        if (None$.MODULE$.equals(option)) {
            throw Assertions$.MODULE$.fail("Partition metadata is not found in metadata cache", new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 591));
        }
        if (!(option instanceof Some)) throw new MatchError((Object)option);
        Some some = (Some)option;
        MetadataResponse.PartitionMetadata metadata = (MetadataResponse.PartitionMetadata)some.value();
        if (!result) return false;
        Errors errors = metadata.error();
        Errors errors2 = Errors.LEADER_NOT_AVAILABLE;
        if (errors != null) {
            if (!errors.equals(errors2)) return false;
            return true;
        }
        if (errors2 == null) return true;
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnderReplicatedPartitions$1(KafkaServer x$9) {
        return x$9.config().brokerId() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnderMinIsrPartitions$1(KafkaServer x$10) {
        return x$10.config().brokerId() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnderMinIsrPartitionsMixed$1(KafkaServer x$11) {
        return x$11.config().brokerId() == 0;
    }

    public TopicCommandWithAdminClientTest() {
        RackAwareTest.$init$(this);
        this.numPartitions = 1;
        this.defaultReplicationFactor = (short)1;
        this._testName = new TestName();
    }
}

