/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.api.AdminClientIntegrationTest$;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.LogConfig$;
import kafka.server.Defaults$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.AlterConfigsOptions;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.PolicyViolationException;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.policy.AlterConfigPolicy;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005Eg\u0001B\u000f\u001f\u0001\rBQ\u0001\r\u0001\u0005\u0002EBq\u0001\u000e\u0001A\u0002\u0013\u0005Q\u0007C\u0004D\u0001\u0001\u0007I\u0011\u0001#\t\r5\u0003\u0001\u0015)\u00037\u0011\u001dq\u0005A1A\u0005\u0002=Caa\u0015\u0001!\u0002\u0013\u0001\u0006\"\u0002+\u0001\t\u0003)\u0006\"B2\u0001\t\u0003\"\u0007\"B5\u0001\t\u0003\"\u0007\"\u00028\u0001\t\u0003y\u0007bBA\n\u0001\u0011\u0005\u0013Q\u0003\u0005\u0007\u0003_\u0001A\u0011\u00013\t\r\u0005e\u0002\u0001\"\u0001e\u0011\u0019\ti\u0004\u0001C\u0001I\u001e9\u0011\u0011\t\u0010\t\u0002\u0005\rcAB\u000f\u001f\u0011\u0003\t)\u0005\u0003\u00041!\u0011\u0005\u0011Q\n\u0004\u0007\u0003\u001f\u0002\u0002!!\u0015\t\rA\u0012B\u0011AA1\u0011-\t9G\u0005a\u0001\u0002\u0004%\t!!\u001b\t\u0017\u0005%%\u00031AA\u0002\u0013\u0005\u00111\u0012\u0005\f\u0003s\u0012\u0002\u0019!A!B\u0013\tY\u0007C\u0005\u0002\u0018J\u0001\r\u0011\"\u0001\u0002\u001a\"I\u0011\u0011\u0015\nA\u0002\u0013\u0005\u00111\u0015\u0005\t\u0003O\u0013\u0002\u0015)\u0003\u0002\u001c\"9\u0011\u0011\u0016\n\u0005\u0002\u0005-\u0006bBA]%\u0011\u0005\u00111\u0018\u0005\u0007\u0003\u001f\u0014B\u0011\u00013\u0003M\u0005#W.\u001b8DY&,g\u000e^,ji\"\u0004v\u000e\\5dS\u0016\u001c\u0018J\u001c;fOJ\fG/[8o)\u0016\u001cHO\u0003\u0002 A\u0005\u0019\u0011\r]5\u000b\u0003\u0005\nQa[1gW\u0006\u001c\u0001aE\u0002\u0001I)\u0002\"!\n\u0015\u000e\u0003\u0019R!a\n\u0011\u0002\u0017%tG/Z4sCRLwN\\\u0005\u0003S\u0019\u0012acS1gW\u0006\u001cVM\u001d<feR+7\u000f\u001e%be:,7o\u001d\t\u0003W9j\u0011\u0001\f\u0006\u0003[\u0001\nQ!\u001e;jYNL!a\f\u0017\u0003\u000f1{wmZ5oO\u00061A(\u001b8jiz\"\u0012A\r\t\u0003g\u0001i\u0011AH\u0001\u0007G2LWM\u001c;\u0016\u0003Y\u0002\"aN!\u000e\u0003aR!!\u000f\u001e\u0002\u000b\u0005$W.\u001b8\u000b\u0005mb\u0014aB2mS\u0016tGo\u001d\u0006\u0003CuR!AP \u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0015aA8sO&\u0011!\t\u000f\u0002\u0006\u0003\u0012l\u0017N\\\u0001\u000bG2LWM\u001c;`I\u0015\fHCA#L!\t1\u0015*D\u0001H\u0015\u0005A\u0015!B:dC2\f\u0017B\u0001&H\u0005\u0011)f.\u001b;\t\u000f1\u001b\u0011\u0011!a\u0001m\u0005\u0019\u0001\u0010J\u0019\u0002\u000f\rd\u0017.\u001a8uA\u0005Y!M]8lKJ\u001cu.\u001e8u+\u0005\u0001\u0006C\u0001$R\u0013\t\u0011vIA\u0002J]R\fAB\u0019:pW\u0016\u00148i\\;oi\u0002\nQb\u001a7pE\u0006dG+[7f_V$X#\u0001,\u0011\u0005]cV\"\u0001-\u000b\u0005eS\u0016!\u0002:vY\u0016\u001c(BA.@\u0003\u0015QWO\\5u\u0013\ti\u0006LA\u0004US6,w.\u001e;)\u0005\u001dy\u0006C\u00011b\u001b\u0005Q\u0016B\u00012[\u0005\u0011\u0011V\u000f\\3\u0002\u000bM,G/\u00169\u0015\u0003\u0015C#\u0001\u00034\u0011\u0005\u0001<\u0017B\u00015[\u0005\u0019\u0011UMZ8sK\u0006AA/Z1s\t><h\u000e\u000b\u0002\nWB\u0011\u0001\r\\\u0005\u0003[j\u0013Q!\u00114uKJ\fAb\u0019:fCR,7i\u001c8gS\u001e,\u0012\u0001\u001d\t\u0006cZD\u0018qA\u0007\u0002e*\u00111\u000f^\u0001\u0005kRLGNC\u0001v\u0003\u0011Q\u0017M^1\n\u0005]\u0014(aA'baB\u0019\u00110!\u0001\u000f\u0005it\bCA>H\u001b\u0005a(BA?#\u0003\u0019a$o\\8u}%\u0011qpR\u0001\u0007!J,G-\u001a4\n\t\u0005\r\u0011Q\u0001\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005}<\u0005\u0003BA\u0005\u0003\u001fi!!a\u0003\u000b\u0007\u00055A/\u0001\u0003mC:<\u0017\u0002BA\t\u0003\u0017\u0011aa\u00142kK\u000e$\u0018aD4f]\u0016\u0014\u0018\r^3D_:4\u0017nZ:\u0016\u0005\u0005]\u0001CBA\r\u0003?\t\u0019#\u0004\u0002\u0002\u001c)\u0019\u0011QD$\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\"\u0005m!aA*fcB!\u0011QEA\u0016\u001b\t\t9CC\u0002\u0002*\u0001\naa]3sm\u0016\u0014\u0018\u0002BA\u0017\u0003O\u00111bS1gW\u0006\u001cuN\u001c4jO\u0006)B/Z:u-\u0006d\u0017\u000eZ!mi\u0016\u00148i\u001c8gS\u001e\u001c\bf\u0001\u0007\u00024A\u0019\u0001-!\u000e\n\u0007\u0005]\"L\u0001\u0003UKN$\u0018a\u0006;fgRLeN^1mS\u0012\fE\u000e^3s\u0007>tg-[4tQ\ri\u00111G\u0001#i\u0016\u001cH/\u00138wC2LG-\u00117uKJ\u001cuN\u001c4jON$U/\u001a+p!>d\u0017nY=)\u00079\t\u0019$\u0001\u0014BI6Lgn\u00117jK:$x+\u001b;i!>d\u0017nY5fg&sG/Z4sCRLwN\u001c+fgR\u0004\"a\r\t\u0014\u0007A\t9\u0005E\u0002G\u0003\u0013J1!a\u0013H\u0005\u0019\te.\u001f*fMR\u0011\u00111\t\u0002\u0007!>d\u0017nY=\u0014\u000bI\t9!a\u0015\u0011\t\u0005U\u0013QL\u0007\u0003\u0003/RA!!\u0017\u0002\\\u00051\u0001o\u001c7jGfT1!!\u000b=\u0013\u0011\ty&a\u0016\u0003#\u0005cG/\u001a:D_:4\u0017n\u001a)pY&\u001c\u0017\u0010\u0006\u0002\u0002dA\u0019\u0011Q\r\n\u000e\u0003A\tqaY8oM&<7/\u0006\u0002\u0002lA\"\u0011QNA;!\u0019I\u0018q\u000e=\u0002r%\u0019q/!\u0002\u0011\t\u0005M\u0014Q\u000f\u0007\u0001\t-\t9HFA\u0001\u0002\u0003\u0015\t!a\u001f\u0003\u0007}#\u0013'\u0001\u0005d_:4\u0017nZ:!#\u0011\ti(a!\u0011\u0007\u0019\u000by(C\u0002\u0002\u0002\u001e\u0013qAT8uQ&tw\rE\u0002G\u0003\u000bK1!a\"H\u0005\r\te._\u0001\fG>tg-[4t?\u0012*\u0017\u000fF\u0002F\u0003\u001bC\u0001\u0002T\u000b\u0002\u0002\u0003\u0007\u0011q\u0012\u0019\u0005\u0003#\u000b)\n\u0005\u0004z\u0003_B\u00181\u0013\t\u0005\u0003g\n)\n\u0002\u0007\u0002x\u00055\u0015\u0011!A\u0001\u0006\u0003\tY(\u0001\u0004dY>\u001cX\rZ\u000b\u0003\u00037\u00032ARAO\u0013\r\tyj\u0012\u0002\b\u0005>|G.Z1o\u0003)\u0019Gn\\:fI~#S-\u001d\u000b\u0004\u000b\u0006\u0015\u0006\u0002\u0003'\u0019\u0003\u0003\u0005\r!a'\u0002\u000f\rdwn]3eA\u0005I1m\u001c8gS\u001e,(/\u001a\u000b\u0004\u000b\u00065\u0006bBA45\u0001\u0007\u0011q\u0016\u0019\u0005\u0003c\u000b)\fE\u0003rmb\f\u0019\f\u0005\u0003\u0002t\u0005UF\u0001DA\\\u0003[\u000b\t\u0011!A\u0003\u0002\u0005m$aA0%e\u0005Aa/\u00197jI\u0006$X\rF\u0002F\u0003{Cq!a0\u001c\u0001\u0004\t\t-A\bsKF,Xm\u001d;NKR\fG-\u0019;b!\u0011\t\u0019-!3\u000f\t\u0005U\u0013QY\u0005\u0005\u0003\u000f\f9&A\tBYR,'oQ8oM&<\u0007k\u001c7jGfLA!a3\u0002N\ny!+Z9vKN$X*\u001a;bI\u0006$\u0018M\u0003\u0003\u0002H\u0006]\u0013!B2m_N,\u0007")
public class AdminClientWithPoliciesIntegrationTest
extends KafkaServerTestHarness {
    private Admin client = null;
    private final int brokerCount;

    public Admin client() {
        return this.client;
    }

    public void client_$eq(Admin x$1) {
        this.client = x$1;
    }

    public int brokerCount() {
        return this.brokerCount;
    }

    @Rule
    public Timeout globalTimeout() {
        return Timeout.millis((long)120000L);
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated$default$2());
    }

    @Override
    @After
    public void tearDown() {
        if (this.client() != null) {
            Utils.closeQuietly((AutoCloseable)this.client(), (String)"AdminClient");
        }
        super.tearDown();
    }

    public java.util.Map<String, Object> createConfig() {
        return (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)this.brokerList())}))).asJava();
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        Seq<Properties> configs = TestUtils$.MODULE$.createBrokerConfigs(this.brokerCount(), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16());
        configs.foreach((Function1 & Serializable & scala.Serializable)props -> props.put(KafkaConfig$.MODULE$.AlterConfigPolicyClassNameProp(), Policy.class));
        return (Seq)configs.map((Function1 & Serializable & scala.Serializable)props -> KafkaConfig$.MODULE$.fromProps(props), Seq$.MODULE$.canBuildFrom());
    }

    @Test
    public void testValidAlterConfigs() {
        this.client_$eq((Admin)AdminClient.create(this.createConfig()));
        String topic1 = "describe-alter-configs-topic-1";
        ConfigResource topicResource1 = new ConfigResource(ConfigResource.Type.TOPIC, topic1);
        Properties topicConfig1 = new Properties();
        topicConfig1.setProperty(LogConfig$.MODULE$.MaxMessageBytesProp(), "500000");
        topicConfig1.setProperty(LogConfig$.MODULE$.RetentionMsProp(), "60000000");
        this.createTopic(topic1, 1, 1, topicConfig1);
        String topic2 = "describe-alter-configs-topic-2";
        ConfigResource topicResource2 = new ConfigResource(ConfigResource.Type.TOPIC, topic2);
        this.createTopic(topic2, 1, 1, this.createTopic$default$4());
        AdminClientIntegrationTest$.MODULE$.checkValidAlterConfigs(this.client(), topicResource1, topicResource2);
    }

    @Test
    public void testInvalidAlterConfigs() {
        this.client_$eq((Admin)AdminClient.create(this.createConfig()));
        AdminClientIntegrationTest$.MODULE$.checkInvalidAlterConfigs(this.zkClient(), (Seq<KafkaServer>)this.servers(), this.client());
    }

    @Test
    public void testInvalidAlterConfigsDueToPolicy() {
        this.client_$eq((Admin)AdminClient.create(this.createConfig()));
        String topic1 = "invalid-alter-configs-due-to-policy-topic-1";
        ConfigResource topicResource1 = new ConfigResource(ConfigResource.Type.TOPIC, topic1);
        this.createTopic(topic1, 1, 1, this.createTopic$default$4());
        String topic2 = "invalid-alter-configs-due-to-policy-topic-2";
        ConfigResource topicResource2 = new ConfigResource(ConfigResource.Type.TOPIC, topic2);
        this.createTopic(topic2, 1, 1, this.createTopic$default$4());
        String topic3 = "invalid-alter-configs-due-to-policy-topic-3";
        ConfigResource topicResource3 = new ConfigResource(ConfigResource.Type.TOPIC, topic3);
        this.createTopic(topic3, 1, 1, this.createTopic$default$4());
        List topicConfigEntries1 = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigEntry[]{new ConfigEntry(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), "0.9"), new ConfigEntry(LogConfig$.MODULE$.MinInSyncReplicasProp(), "2")}))).asJava();
        List topicConfigEntries2 = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigEntry[]{new ConfigEntry(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), "0.8")}))).asJava();
        List topicConfigEntries3 = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigEntry[]{new ConfigEntry(LogConfig$.MODULE$.MinInSyncReplicasProp(), "-1")}))).asJava();
        ConfigResource brokerResource = new ConfigResource(ConfigResource.Type.BROKER, ((Object)BoxesRunTime.boxToInteger((int)((KafkaServer)this.servers().head()).config().brokerId())).toString());
        List brokerConfigEntries = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigEntry[]{new ConfigEntry(KafkaConfig$.MODULE$.SslTruststorePasswordProp(), "12313")}))).asJava();
        ObjectRef alterResult = ObjectRef.create((Object)this.client().alterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource1), (Object)new Config((Collection)topicConfigEntries1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource2), (Object)new Config((Collection)topicConfigEntries2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource3), (Object)new Config((Collection)topicConfigEntries3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)brokerResource), (Object)new Config((Collection)brokerConfigEntries))}))).asJava()));
        Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topicResource1, topicResource2, topicResource3, brokerResource}))).asJava(), ((AlterConfigsResult)alterResult.elem).values().keySet());
        Assert.assertTrue((boolean)(((Throwable)Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> (Void)((KafkaFuture)((AlterConfigsResult)alterResult$1.elem).values().get(topicResource1)).get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientWithPoliciesIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133))).getCause() instanceof PolicyViolationException));
        ((KafkaFuture)((AlterConfigsResult)alterResult.elem).values().get(topicResource2)).get();
        Assert.assertTrue((boolean)(((Throwable)Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> (Void)((KafkaFuture)((AlterConfigsResult)alterResult$1.elem).values().get(topicResource3)).get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientWithPoliciesIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135))).getCause() instanceof InvalidRequestException));
        Assert.assertTrue((boolean)(((Throwable)Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> (Void)((KafkaFuture)((AlterConfigsResult)alterResult$1.elem).values().get(brokerResource)).get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientWithPoliciesIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136))).getCause() instanceof InvalidRequestException));
        DescribeConfigsResult describeResult = this.client().describeConfigs((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topicResource1, topicResource2, topicResource3, brokerResource}))).asJava());
        java.util.Map configs = (java.util.Map)describeResult.all().get();
        Assert.assertEquals((long)4L, (long)configs.size());
        Assert.assertEquals((Object)((Object)BoxesRunTime.boxToDouble((double)Defaults$.MODULE$.LogCleanerMinCleanRatio())).toString(), (Object)((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.MinCleanableDirtyRatioProp()).value());
        Assert.assertEquals((Object)((Object)BoxesRunTime.boxToInteger((int)Defaults$.MODULE$.MinInSyncReplicas())).toString(), (Object)((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.MinInSyncReplicasProp()).value());
        Assert.assertEquals((Object)"0.8", (Object)((Config)configs.get(topicResource2)).get(LogConfig$.MODULE$.MinCleanableDirtyRatioProp()).value());
        Assert.assertNull((Object)((Config)configs.get(brokerResource)).get(KafkaConfig$.MODULE$.SslTruststorePasswordProp()).value());
        topicConfigEntries2 = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigEntry[]{new ConfigEntry(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), "0.7")}))).asJava();
        alterResult.elem = this.client().alterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource1), (Object)new Config((Collection)topicConfigEntries1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource2), (Object)new Config((Collection)topicConfigEntries2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)brokerResource), (Object)new Config((Collection)brokerConfigEntries)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource3), (Object)new Config((Collection)topicConfigEntries3))}))).asJava(), new AlterConfigsOptions().validateOnly(true));
        Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topicResource1, topicResource2, topicResource3, brokerResource}))).asJava(), ((AlterConfigsResult)alterResult.elem).values().keySet());
        Assert.assertTrue((boolean)(((Throwable)Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> (Void)((KafkaFuture)((AlterConfigsResult)alterResult$1.elem).values().get(topicResource1)).get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientWithPoliciesIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163))).getCause() instanceof PolicyViolationException));
        ((KafkaFuture)((AlterConfigsResult)alterResult.elem).values().get(topicResource2)).get();
        Assert.assertTrue((boolean)(((Throwable)Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> (Void)((KafkaFuture)((AlterConfigsResult)alterResult$1.elem).values().get(topicResource3)).get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientWithPoliciesIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165))).getCause() instanceof InvalidRequestException));
        Assert.assertTrue((boolean)(((Throwable)Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> (Void)((KafkaFuture)((AlterConfigsResult)alterResult$1.elem).values().get(brokerResource)).get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientWithPoliciesIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166))).getCause() instanceof InvalidRequestException));
        describeResult = this.client().describeConfigs((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topicResource1, topicResource2, topicResource3, brokerResource}))).asJava());
        configs = (java.util.Map)describeResult.all().get();
        Assert.assertEquals((long)4L, (long)configs.size());
        Assert.assertEquals((Object)((Object)BoxesRunTime.boxToDouble((double)Defaults$.MODULE$.LogCleanerMinCleanRatio())).toString(), (Object)((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.MinCleanableDirtyRatioProp()).value());
        Assert.assertEquals((Object)((Object)BoxesRunTime.boxToInteger((int)Defaults$.MODULE$.MinInSyncReplicas())).toString(), (Object)((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.MinInSyncReplicasProp()).value());
        Assert.assertEquals((Object)"0.8", (Object)((Config)configs.get(topicResource2)).get(LogConfig$.MODULE$.MinCleanableDirtyRatioProp()).value());
        Assert.assertNull((Object)((Config)configs.get(brokerResource)).get(KafkaConfig$.MODULE$.SslTruststorePasswordProp()).value());
    }

    public AdminClientWithPoliciesIntegrationTest() {
        this.brokerCount = 3;
    }

    public static class Policy
    implements AlterConfigPolicy {
        private scala.collection.immutable.Map<String, ?> configs;
        private boolean closed = false;

        public scala.collection.immutable.Map<String, ?> configs() {
            return this.configs;
        }

        public void configs_$eq(scala.collection.immutable.Map<String, ?> x$1) {
            this.configs = x$1;
        }

        public boolean closed() {
            return this.closed;
        }

        public void closed_$eq(boolean x$1) {
            this.closed = x$1;
        }

        public void configure(java.util.Map<String, ?> configs) {
            this.configs_$eq(((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(configs).asScala()).toMap(Predef$.MODULE$.$conforms()));
        }

        public void validate(AlterConfigPolicy.RequestMetadata requestMetadata) {
            Predef$.MODULE$.require(!this.closed(), (Function0 & Serializable & scala.Serializable)() -> "Policy should not be closed");
            Predef$.MODULE$.require(!this.configs().isEmpty(), (Function0 & Serializable & scala.Serializable)() -> "configure should have been called with non empty configs");
            Predef$.MODULE$.require(!requestMetadata.configs().isEmpty(), (Function0 & Serializable & scala.Serializable)() -> "request configs should not be empty");
            Predef$.MODULE$.require(new StringOps(Predef$.MODULE$.augmentString(requestMetadata.resource().name())).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "resource name should not be empty");
            Predef$.MODULE$.require(requestMetadata.resource().name().contains("topic"));
            if (requestMetadata.configs().containsKey("min.insync.replicas")) {
                throw new PolicyViolationException("Min in sync replicas cannot be updated");
            }
        }

        public void close() {
            this.closed_$eq(true);
        }
    }
}

