/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.controller.AutoPreferredReplicaLeaderElection$;
import kafka.controller.BrokerChange$;
import kafka.controller.ControllerEvent;
import kafka.controller.ControllerEventManager;
import kafka.controller.ControllerEventProcessor;
import kafka.controller.ControllerState;
import kafka.controller.ControllerStats;
import kafka.controller.TopicChange$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001!4A\u0001D\u0007\u0001%!)\u0011\u0004\u0001C\u00015!IQ\u0004\u0001a\u0001\u0002\u0004%IA\b\u0005\nE\u0001\u0001\r\u00111A\u0005\n\rB\u0011\"\u000b\u0001A\u0002\u0003\u0005\u000b\u0015B\u0010\t\u000b)\u0002A\u0011A\u0016\t\u000bU\u0002A\u0011A\u0016\t\u000bi\u0002A\u0011A\u0016\t\u000bq\u0002A\u0011A\u0016\t\u000by\u0002A\u0011A\u0016\t\u000b\u0001\u0003A\u0011B!\t\u000be\u0003A\u0011\u0002.\u00035\r{g\u000e\u001e:pY2,'/\u0012<f]Rl\u0015M\\1hKJ$Vm\u001d;\u000b\u00059y\u0011AC2p]R\u0014x\u000e\u001c7fe*\t\u0001#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\u0019\u0002C\u0001\u000b\u0018\u001b\u0005)\"\"\u0001\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005a)\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u00027A\u0011A\u0004A\u0007\u0002\u001b\u000512m\u001c8ue>dG.\u001a:Fm\u0016tG/T1oC\u001e,'/F\u0001 !\ta\u0002%\u0003\u0002\"\u001b\t12i\u001c8ue>dG.\u001a:Fm\u0016tG/T1oC\u001e,'/\u0001\u000ed_:$(o\u001c7mKJ,e/\u001a8u\u001b\u0006t\u0017mZ3s?\u0012*\u0017\u000f\u0006\u0002%OA\u0011A#J\u0005\u0003MU\u0011A!\u00168ji\"9\u0001fAA\u0001\u0002\u0004y\u0012a\u0001=%c\u000592m\u001c8ue>dG.\u001a:Fm\u0016tG/T1oC\u001e,'\u000fI\u0001\ti\u0016\f'\u000fR8x]R\tA\u0005\u000b\u0002\u0006[A\u0011afM\u0007\u0002_)\u0011\u0001'M\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002e\u0005\u0019qN]4\n\u0005Qz#!B!gi\u0016\u0014\u0018!\u0007;fgRlU\r\u001e:jGN\u001cE.Z1oK\u0012|en\u00117pg\u0016D#AB\u001c\u0011\u00059B\u0014BA\u001d0\u0005\u0011!Vm\u001d;\u0002%Q,7\u000f^#wK:$\u0018+^3vKRKW.\u001a\u0015\u0003\u000f]\n1\u0003^3tiN+8mY3tg\u001a,H.\u0012<f]RD#\u0001C\u001c\u00029Q,7\u000f^#wK:$H\u000b[1u)\"\u0014xn^:Fq\u000e,\u0007\u000f^5p]\"\u0012\u0011bN\u0001\u0006G\",7m\u001b\u000b\u0005I\t{E\u000bC\u0003D\u0015\u0001\u0007A)\u0001\u0006nKR\u0014\u0018n\u0019(b[\u0016\u0004\"!\u0012'\u000f\u0005\u0019S\u0005CA$\u0016\u001b\u0005A%BA%\u0012\u0003\u0019a$o\\8u}%\u00111*F\u0001\u0007!J,G-\u001a4\n\u00055s%AB*ue&twM\u0003\u0002L+!)\u0001K\u0003a\u0001#\u0006)QM^3oiB\u0011ADU\u0005\u0003'6\u0011qbQ8oiJ|G\u000e\\3s\u000bZ,g\u000e\u001e\u0005\u0006+*\u0001\rAV\u0001\u0005MVt7\rE\u0002\u0015/\u0012J!\u0001W\u000b\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0014!\u0002;j[\u0016\u0014HCA.h!\taV-D\u0001^\u0015\tqv,\u0001\u0003d_J,'B\u00011b\u0003\u001diW\r\u001e:jGNT!AY2\u0002\re\fW.\\3s\u0015\u0005!\u0017aA2p[&\u0011a-\u0018\u0002\u0006)&lWM\u001d\u0005\u0006\u0007.\u0001\r\u0001\u0012")
public class ControllerEventManagerTest {
    private ControllerEventManager controllerEventManager;

    private ControllerEventManager controllerEventManager() {
        return this.controllerEventManager;
    }

    private void controllerEventManager_$eq(ControllerEventManager x$1) {
        this.controllerEventManager = x$1;
    }

    @After
    public void tearDown() {
        block0: {
            if (this.controllerEventManager() == null) break block0;
            this.controllerEventManager().close();
        }
    }

    @Test
    public void testMetricsCleanedOnClose() {
        MockTime time = new MockTime();
        ControllerStats controllerStats = new ControllerStats();
        ControllerEventProcessor eventProcessor = new ControllerEventProcessor(null){

            public void process(ControllerEvent event) {
            }

            public void preempt(ControllerEvent event) {
            }
        };
        this.controllerEventManager_$eq(new ControllerEventManager(0, eventProcessor, (Time)time, controllerStats.rateAndTimeMetrics()));
        this.controllerEventManager().start();
        Assert.assertTrue((boolean)ControllerEventManagerTest.allEventManagerMetrics$1().nonEmpty());
        this.controllerEventManager().close();
        Assert.assertTrue((boolean)ControllerEventManagerTest.allEventManagerMetrics$1().isEmpty());
    }

    @Test
    public void testEventQueueTime() {
        String metricName = "kafka.controller:type=ControllerEventManager,name=EventQueueTimeMs";
        ControllerStats controllerStats = new ControllerStats();
        MockTime time = new MockTime();
        CountDownLatch latch = new CountDownLatch(1);
        AtomicInteger processedEvents = new AtomicInteger();
        ControllerEventProcessor eventProcessor = new ControllerEventProcessor(null, latch, time, processedEvents){
            private final CountDownLatch latch$1;
            private final MockTime time$1;
            private final AtomicInteger processedEvents$1;

            public void process(ControllerEvent event) {
                this.latch$1.await();
                this.time$1.sleep(500L);
                this.processedEvents$1.incrementAndGet();
            }

            public void preempt(ControllerEvent event) {
            }
            {
                this.latch$1 = latch$1;
                this.time$1 = time$1;
                this.processedEvents$1 = processedEvents$1;
            }
        };
        Assert.assertTrue((boolean)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala()).filterKeys((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ControllerEventManagerTest.$anonfun$testEventQueueTime$1(metricName, x$2))).values().isEmpty());
        this.controllerEventManager_$eq(new ControllerEventManager(0, eventProcessor, (Time)time, controllerStats.rateAndTimeMetrics()));
        this.controllerEventManager().start();
        this.controllerEventManager().put((ControllerEvent)TopicChange$.MODULE$);
        this.controllerEventManager().put((ControllerEvent)TopicChange$.MODULE$);
        latch.countDown();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> processedEvents.get() == 2, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Timed out waiting for processing of all events", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        Histogram queueTimeHistogram = (Histogram)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala()).filterKeys((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ControllerEventManagerTest.$anonfun$testEventQueueTime$4(metricName, x$3))).values().headOption().getOrElse((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Assert.fail((String)new StringBuilder(22).append("Unable to find metric ").append(metricName).toString()));
        Assert.assertEquals((long)2L, (long)queueTimeHistogram.count());
        Assert.assertEquals((double)0.0, (double)queueTimeHistogram.min(), (double)0.01);
        Assert.assertEquals((double)500.0, (double)queueTimeHistogram.max(), (double)0.01);
    }

    @Test
    public void testSuccessfulEvent() {
        this.check("kafka.controller:type=ControllerStats,name=AutoLeaderBalanceRateAndTimeMs", (ControllerEvent)AutoPreferredReplicaLeaderElection$.MODULE$, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {});
    }

    @Test
    public void testEventThatThrowsException() {
        this.check("kafka.controller:type=ControllerStats,name=LeaderElectionRateAndTimeMs", (ControllerEvent)BrokerChange$.MODULE$, (Function0<BoxedUnit>)(Function0 & Serializable & scala.Serializable)() -> {
            throw new NullPointerException();
        });
    }

    private void check(String metricName, ControllerEvent event, Function0<BoxedUnit> func) {
        ControllerStats controllerStats = new ControllerStats();
        AtomicInteger eventProcessedListenerCount = new AtomicInteger();
        CountDownLatch latch = new CountDownLatch(1);
        ControllerEventProcessor eventProcessor = new ControllerEventProcessor(null, latch, eventProcessedListenerCount, func){
            private final CountDownLatch latch$2;
            private final AtomicInteger eventProcessedListenerCount$1;
            private final Function0 func$1;

            public void process(ControllerEvent event) {
                this.latch$2.await();
                this.eventProcessedListenerCount$1.incrementAndGet();
                this.func$1.apply$mcV$sp();
            }

            public void preempt(ControllerEvent event) {
            }
            {
                this.latch$2 = latch$2;
                this.eventProcessedListenerCount$1 = eventProcessedListenerCount$1;
                this.func$1 = func$1;
            }
        };
        this.controllerEventManager_$eq(new ControllerEventManager(0, eventProcessor, (Time)new MockTime(), controllerStats.rateAndTimeMetrics()));
        this.controllerEventManager().start();
        long initialTimerCount = this.timer(metricName).count();
        this.controllerEventManager().put(event);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            ControllerState controllerState = this.controllerEventManager().state();
            ControllerState controllerState2 = event.state();
            return !(controllerState != null ? !controllerState.equals(controllerState2) : controllerState2 != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Controller state is not ").append(event.state()).toString(), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        latch.countDown();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            ControllerState controllerState = this.controllerEventManager().state();
            ControllerState.Idle$ idle$ = ControllerState.Idle$.MODULE$;
            return !(controllerState != null ? !controllerState.equals(idle$) : idle$ != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Controller state has not changed back to Idle", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        Assert.assertEquals((long)1L, (long)eventProcessedListenerCount.get());
        Assert.assertEquals((String)"Timer has not been updated", (long)(initialTimerCount + 1L), (long)this.timer(metricName).count());
    }

    private Timer timer(String metricName) {
        return (Timer)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala()).filterKeys((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ControllerEventManagerTest.$anonfun$timer$1(metricName, x$4))).values().headOption().getOrElse((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Assert.fail((String)new StringBuilder(22).append("Unable to find metric ").append(metricName).toString()));
    }

    public static final /* synthetic */ boolean $anonfun$testMetricsCleanedOnClose$1(MetricName x$1) {
        return x$1.getMBeanName().startsWith("kafka.controller:type=ControllerEventManager");
    }

    private static final Set allEventManagerMetrics$1() {
        return ((TraversableOnce)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala()).keySet().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ControllerEventManagerTest.$anonfun$testMetricsCleanedOnClose$1(x$1)))).toSet();
    }

    public static final /* synthetic */ boolean $anonfun$testEventQueueTime$1(String metricName$1, MetricName x$2) {
        String string = x$2.getMBeanName();
        String string2 = metricName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testEventQueueTime$4(String metricName$1, MetricName x$3) {
        String string = x$3.getMBeanName();
        String string2 = metricName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$timer$1(String metricName$2, MetricName x$4) {
        String string = x$4.getMBeanName();
        String string2 = metricName$2;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }
}

