/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.group;

import java.io.Serializable;
import kafka.common.OffsetAndMetadata;
import kafka.common.OffsetAndMetadata$;
import kafka.coordinator.group.CommitRecordMetadataAndOffset;
import kafka.coordinator.group.CompletingRebalance$;
import kafka.coordinator.group.Dead$;
import kafka.coordinator.group.Empty$;
import kafka.coordinator.group.GroupCoordinator$;
import kafka.coordinator.group.GroupMetadata;
import kafka.coordinator.group.GroupState;
import kafka.coordinator.group.JoinGroupResult;
import kafka.coordinator.group.MemberMetadata;
import kafka.coordinator.group.PreparingRebalance$;
import kafka.coordinator.group.Stable$;
import kafka.coordinator.group.SyncGroupResult;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.Time;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSetLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\teb\u0001B$I\u0001=CQA\u0016\u0001\u0005\u0002]CqA\u0017\u0001C\u0002\u0013%1\f\u0003\u0004e\u0001\u0001\u0006I\u0001\u0018\u0005\bK\u0002\u0011\r\u0011\"\u0003\\\u0011\u00191\u0007\u0001)A\u00059\"9q\r\u0001b\u0001\n\u0013A\u0007B\u00027\u0001A\u0003%\u0011\u000eC\u0004n\u0001\t\u0007I\u0011B.\t\r9\u0004\u0001\u0015!\u0003]\u0011\u001dy\u0007A1A\u0005\nmCa\u0001\u001d\u0001!\u0002\u0013a\u0006bB9\u0001\u0005\u0004%Ia\u0017\u0005\u0007e\u0002\u0001\u000b\u0011\u0002/\t\u000fM\u0004!\u0019!C\u0005i\"1\u0001\u0010\u0001Q\u0001\nUDq!\u001f\u0001C\u0002\u0013%A\u000f\u0003\u0004{\u0001\u0001\u0006I!\u001e\u0005\b\u0013\u0002\u0001\r\u0011\"\u0003|\u0011!y\b\u00011A\u0005\n\u0005\u0005\u0001bBA\u0007\u0001\u0001\u0006K\u0001 \u0005\n\u0003\u001f\u0001\u0001\u0019!C\u0005\u0003#A\u0011\"!\u0007\u0001\u0001\u0004%I!a\u0007\t\u0011\u0005}\u0001\u0001)Q\u0005\u0003'Aq!!\t\u0001\t\u0003\t\u0019\u0003C\u0004\u00028\u0001!\t!a\t\t\u000f\u0005\u0005\u0003\u0001\"\u0001\u0002$!9\u0011Q\t\u0001\u0005\u0002\u0005\r\u0002bBA%\u0001\u0011\u0005\u00111\u0005\u0005\b\u0003\u001b\u0002A\u0011AA\u0012\u0011\u001d\t\t\u0006\u0001C\u0001\u0003GAq!!\u0016\u0001\t\u0003\t\u0019\u0003C\u0004\u0002Z\u0001!\t!a\t\t\u000f\u0005u\u0003\u0001\"\u0001\u0002$!9\u0011\u0011\r\u0001\u0005\u0002\u0005\r\u0002bBA3\u0001\u0011\u0005\u00111\u0005\u0005\b\u0003S\u0002A\u0011AA\u0012\u0011\u001d\t9\b\u0001C\u0001\u0003GAq!a\u001f\u0001\t\u0003\t\u0019\u0003C\u0004\u0002\u0000\u0001!\t!a\t\t\u000f\u0005\r\u0005\u0001\"\u0001\u0002$!9\u0011q\u0011\u0001\u0005\u0002\u0005\r\u0002bBAF\u0001\u0011\u0005\u00111\u0005\u0005\b\u0003\u001b\u0003A\u0011AA\u0012\u0011\u001d\t\t\n\u0001C\u0001\u0003GAq!!&\u0001\t\u0003\t\u0019\u0003C\u0004\u0002\u001a\u0002!\t!a\t\t\u000f\u0005u\u0005\u0001\"\u0001\u0002$!9\u0011\u0011\u0015\u0001\u0005\u0002\u0005\r\u0002bBAS\u0001\u0011\u0005\u00111\u0005\u0005\b\u0003S\u0003A\u0011AA\u0012\u0011\u001d\ti\u000b\u0001C\u0001\u0003GAq!!-\u0001\t\u0003\t\u0019\u0003C\u0004\u00026\u0002!\t!a\t\t\u000f\u0005e\u0006\u0001\"\u0001\u0002$!9\u0011Q\u0018\u0001\u0005\u0002\u0005\r\u0002bBAa\u0001\u0011\u0005\u00111\u0005\u0005\b\u0003\u000b\u0004A\u0011AA\u0012\u0011\u001d\tI\r\u0001C\u0001\u0003GAq!!4\u0001\t\u0003\t\u0019\u0003C\u0004\u0002R\u0002!\t!a\t\t\u000f\u0005U\u0007\u0001\"\u0001\u0002$!9\u0011\u0011\u001c\u0001\u0005\u0002\u0005\r\u0002bBA|\u0001\u0011\u0005\u00111\u0005\u0005\b\u0003w\u0004A\u0011AA\u0012\u0011\u001d\ty\u0010\u0001C\u0001\u0003GAqAa\u0001\u0001\t\u0003\t\u0019\u0003C\u0004\u0003\b\u0001!\t!a\t\t\u000f\t-\u0001\u0001\"\u0001\u0002$!9!q\u0002\u0001\u0005\n\tE\u0001b\u0002B\u0010\u0001\u0011%!\u0011\u0005\u0002\u0012\u000fJ|W\u000f]'fi\u0006$\u0017\r^1UKN$(BA%K\u0003\u00159'o\\;q\u0015\tYE*A\u0006d_>\u0014H-\u001b8bi>\u0014(\"A'\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0015\t\u0003#Rk\u0011A\u0015\u0006\u0002'\u0006)1oY1mC&\u0011QK\u0015\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005A\u0006CA-\u0001\u001b\u0005A\u0015\u0001\u00049s_R|7m\u001c7UsB,W#\u0001/\u0011\u0005u\u0013W\"\u00010\u000b\u0005}\u0003\u0017\u0001\u00027b]\u001eT\u0011!Y\u0001\u0005U\u00064\u0018-\u0003\u0002d=\n11\u000b\u001e:j]\u001e\fQ\u0002\u001d:pi>\u001cw\u000e\u001c+za\u0016\u0004\u0013aB4s_V\u0004\u0018\nZ\u0001\tOJ|W\u000f]%eA\u0005yqM]8va&s7\u000f^1oG\u0016LE-F\u0001j!\r\t&\u000eX\u0005\u0003WJ\u0013AaU8nK\u0006\u0001rM]8va&s7\u000f^1oG\u0016LE\rI\u0001\t[\u0016l'-\u001a:JI\u0006IQ.Z7cKJLE\rI\u0001\tG2LWM\u001c;JI\u0006I1\r\\5f]RLE\rI\u0001\u000bG2LWM\u001c;I_N$\u0018aC2mS\u0016tG\u000fS8ti\u0002\n!C]3cC2\fgnY3US6,w.\u001e;NgV\tQ\u000f\u0005\u0002Rm&\u0011qO\u0015\u0002\u0004\u0013:$\u0018a\u0005:fE\u0006d\u0017M\\2f)&lWm\\;u\u001bN\u0004\u0013\u0001E:fgNLwN\u001c+j[\u0016|W\u000f^'t\u0003E\u0019Xm]:j_:$\u0016.\\3pkRl5\u000fI\u000b\u0002yB\u0011\u0011,`\u0005\u0003}\"\u0013Qb\u0012:pkBlU\r^1eCR\f\u0017!C4s_V\u0004x\fJ3r)\u0011\t\u0019!!\u0003\u0011\u0007E\u000b)!C\u0002\u0002\bI\u0013A!\u00168ji\"A\u00111B\n\u0002\u0002\u0003\u0007A0A\u0002yIE\naa\u001a:pkB\u0004\u0013AB7f[\n,'/\u0006\u0002\u0002\u0014A\u0019\u0011,!\u0006\n\u0007\u0005]\u0001J\u0001\bNK6\u0014WM]'fi\u0006$\u0017\r^1\u0002\u00155,WNY3s?\u0012*\u0017\u000f\u0006\u0003\u0002\u0004\u0005u\u0001\"CA\u0006-\u0005\u0005\t\u0019AA\n\u0003\u001diW-\u001c2fe\u0002\nQa]3u+B$\"!a\u0001)\u0007a\t9\u0003\u0005\u0003\u0002*\u0005MRBAA\u0016\u0015\u0011\ti#a\f\u0002\u000b),h.\u001b;\u000b\u0005\u0005E\u0012aA8sO&!\u0011QGA\u0016\u0005\u0019\u0011UMZ8sK\u0006QB/Z:u\u0007\u0006t'+\u001a2bY\u0006t7-Z,iK:\u001cF/\u00192mK\"\u001a\u0011$a\u000f\u0011\t\u0005%\u0012QH\u0005\u0005\u0003\u007f\tYC\u0001\u0003UKN$\u0018a\n;fgR\u001c\u0015M\u001c*fE\u0006d\u0017M\\2f/\",gnQ8na2,G/\u001b8h%\u0016\u0014\u0017\r\\1oG\u0016D3AGA\u001e\u0003%\"Xm\u001d;DC:tw\u000e\u001e*fE\u0006d\u0017M\\2f/\",g\u000e\u0015:fa\u0006\u0014\u0018N\\4SK\n\fG.\u00198dK\"\u001a1$a\u000f\u00027Q,7\u000f^\"b]:|GOU3cC2\fgnY3XQ\u0016tG)Z1eQ\ra\u00121H\u0001)i\u0016\u001cHo\u0015;bE2,Gk\u001c)sKB\f'/\u001b8h%\u0016\u0014\u0017\r\\1oG\u0016$&/\u00198tSRLwN\u001c\u0015\u0004;\u0005m\u0012A\u0007;fgR\u001cF/\u00192mKR{G)Z1e)J\fgn]5uS>t\u0007f\u0001\u0010\u0002<\u0005\u0019D/Z:u\u0003^\f\u0017\u000e^5oOJ+'-\u00197b]\u000e,Gk\u001c)sKB\f'/\u001b8h%\u0016\u0014\u0017\r\\1oG\u0016$&/\u00198tSRLwN\u001c\u0015\u0004?\u0005m\u0012A\n;fgR\u0004&/\u001a9be&twMU3cC2\fgnY3U_\u0012+\u0017\r\u001a+sC:\u001c\u0018\u000e^5p]\"\u001a\u0001%a\u000f\u0002OQ,7\u000f\u001e)sKB\f'/\u001b8h%\u0016\u0014\u0017\r\\1oG\u0016$v.R7qif$&/\u00198tSRLwN\u001c\u0015\u0004C\u0005m\u0012!\u0007;fgR,U\u000e\u001d;z)>$U-\u00193Ue\u0006t7/\u001b;j_:D3AIA\u001e\u0003\u001d\"Xm\u001d;Bo\u0006LG/\u001b8h%\u0016\u0014\u0017\r\\1oG\u0016$vn\u0015;bE2,GK]1og&$\u0018n\u001c8)\u0007\r\nY$\u0001\u0012uKN$X)\u001c9usR{7\u000b^1cY\u0016LE\u000e\\3hC2$&/\u00198tSRLwN\u001c\u0015\bI\u0005m\u0012QNA8\u0003!)\u0007\u0010]3di\u0016$7EAA9!\ri\u00161O\u0005\u0004\u0003kr&!F%mY\u0016<\u0017\r\\*uCR,W\t_2faRLwN\\\u0001$i\u0016\u001cHo\u0015;bE2,Gk\\*uC\ndW-\u00137mK\u001e\fG\u000e\u0016:b]NLG/[8oQ\r)\u00131H\u0001.i\u0016\u001cH/R7qif$v.Q<bSRLgn\u001a*fE\u0006d\u0017M\\2f\u00132dWmZ1m)J\fgn]5uS>t\u0007f\u0002\u0014\u0002<\u00055\u0014qN\u0001<i\u0016\u001cH\u000f\u0015:fa\u0006\u0014\u0018N\\4SK\n\fG.\u00198dKR{\u0007K]3qCJLgn\u001a*fE\u0006d\u0017M\\2f\u00132dWmZ1m)J\fgn]5uS>t\u0007fB\u0014\u0002<\u00055\u0014qN\u00010i\u0016\u001cH\u000f\u0015:fa\u0006\u0014\u0018N\\4SK\n\fG.\u00198dKR{7\u000b^1cY\u0016LE\u000e\\3hC2$&/\u00198tSRLwN\u001c\u0015\bQ\u0005m\u0012QNA8\u0003e\"Xm\u001d;Bo\u0006LG/\u001b8h%\u0016\u0014\u0017\r\\1oG\u0016$v.Q<bSRLgn\u001a*fE\u0006d\u0017M\\2f\u00132dWmZ1m)J\fgn]5uS>t\u0007fB\u0015\u0002<\u00055\u0014qN\u0001 i\u0016\u001cH\u000fR3bIR{G)Z1e\u00132dWmZ1m)J\fgn]5uS>t\u0017!\t;fgR$U-\u00193U_N#\u0018M\u00197f\u00132dWmZ1m)J\fgn]5uS>t\u0007fB\u0016\u0002<\u00055\u0014qN\u0001.i\u0016\u001cH\u000fR3bIR{\u0007K]3qCJLgn\u001a*fE\u0006d\u0017M\\2f\u00132dWmZ1m)J\fgn]5uS>t\u0007f\u0002\u0017\u0002<\u00055\u0014qN\u0001-i\u0016\u001cH\u000fR3bIR{\u0017i^1ji&twMU3cC2\fgnY3JY2,w-\u00197Ue\u0006t7/\u001b;j_:Ds!LA\u001e\u0003[\ny'\u0001\nuKN$8+\u001a7fGR\u0004&o\u001c;pG>d\u0007f\u0001\u0018\u0002<\u0005\u0019C/Z:u'\u0016dWm\u0019;Qe>$xnY8m%\u0006L7/Z:JM:{W*Z7cKJ\u001c\bfB\u0018\u0002<\u00055\u0014qN\u0001,i\u0016\u001cHoU3mK\u000e$\bK]8u_\u000e|Gn\u00115p_N,7oQ8na\u0006$\u0018N\u00197f!J|Go\\2pY\"\u001a\u0001'a\u000f\u0002+Q,7\u000f^*vaB|'\u000f^:Qe>$xnY8mg\"\u001a\u0011'a\u000f\u0002)Q,7\u000f^*vEN\u001c'/\u001b2fIR{\u0007/[2tQ\r\u0011\u00141H\u0001%i\u0016\u001cHoU;cg\u000e\u0014\u0018NY3e)>\u0004\u0018nY:O_:\u001cuN\\:v[\u0016\u0014xI]8va\"\u001a1'a\u000f\u0002-Q,7\u000f^%oSRtU\r\u001f;HK:,'/\u0019;j_:D3\u0001NA\u001e\u0003\u0001\"Xm\u001d;J]&$h*\u001a=u\u000f\u0016tWM]1uS>tW)\u001c9us\u001e\u0013x.\u001e9)\u0007U\nY$\u0001\tuKN$xJ\u001a4tKR\u001cu.\\7ji\"\u001aa'a\u000f\u0002/Q,7\u000f^(gMN,GoQ8n[&$h)Y5mkJ,\u0007fA\u001c\u0002<\u0005IC/Z:u\u001f\u001a47/\u001a;D_6l\u0017\u000e\u001e$bS2,(/Z,ji\"\fen\u001c;iKJ\u0004VM\u001c3j]\u001eD3\u0001OA\u001e\u0003\t\"Xm\u001d;PM\u001a\u001cX\r^\"p[6LGoV5uQ\u0006sw\u000e\u001e5feB+g\u000eZ5oO\"\u001a\u0011(a\u000f\u0002UQ,7\u000f^\"p]N,X.\u001a:CK\u0006$8\u000f\u0016:b]N\f7\r^5p]\u0006dwJ\u001a4tKR\u001cu.\\7ji\"\u001a!(a\u000f\u0002QQ,7\u000f\u001e+sC:\u001c\u0018m\u0019;j_:\u0014U-\u0019;t\u0007>t7/^7fe>3gm]3u\u0007>lW.\u001b;)\u0007m\nY$A\u001buKN$HK]1og\u0006\u001cG/[8oC2\u001cu.\\7ji&\u001b\u0018IY8si\u0016$\u0017I\u001c3D_:\u001cX/\\3s\u0007>lW.\u001b;XS:\u001c\bf\u0001\u001f\u0002<\u0005iC/Z:u\r\u0006LG.\u001a3Uq:|eMZ:fi\u000e{W.\\5u\u0019\u0016\fg/Z:O_B+g\u000eZ5oON#\u0018\r^3)\u0007u\nY$\u0001\u0019uKN$(+\u001a9mC\u000e,wI]8va&s7\u000f^1oG\u0016<\u0016\u000e\u001e5F[B$\u0018p\u0012:pkBLen\u001d;b]\u000e,\u0017\n\u001a\u0015\b}\u0005m\u0012QNAoG\t\ty\u000e\u0005\u0003\u0002b\u0006Eh\u0002BAr\u0003[tA!!:\u0002l6\u0011\u0011q\u001d\u0006\u0004\u0003St\u0015A\u0002\u001fs_>$h(C\u0001T\u0013\r\tyOU\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\u00190!>\u00031%cG.Z4bY\u0006\u0013x-^7f]R,\u0005pY3qi&|gNC\u0002\u0002pJ\u000bQ\u0006^3tiJ+\u0007\u000f\\1dK\u001e\u0013x.\u001e9J]N$\u0018M\\2f/&$\bNT8o\u000bbL7\u000f^5oO6+WNY3sQ\u001dy\u00141HA7\u0003;\f\u0001\u0004^3tiJ+\u0007\u000f\\1dK\u001e\u0013x.\u001e9J]N$\u0018M\\2fQ\r\u0001\u00151H\u0001\u0017i\u0016\u001cH/\u00138w_.,'j\\5o\u0007\u0006dGNY1dW\"\u001a\u0011)a\u000f\u00023Q,7\u000f\u001e(pi&sgo\\6f\u0015>LgnQ1mY\n\f7m\u001b\u0015\u0004\u0005\u0006m\u0012A\u0006;fgRLeN^8lKNKhnY\"bY2\u0014\u0017mY6)\u0007\r\u000bY$A\ruKN$hj\u001c;J]Z|7.Z*z]\u000e\u001c\u0015\r\u001c7cC\u000e\\\u0007f\u0001#\u0002<\u0005Y\u0011m]:feR\u001cF/\u0019;f)\u0019\t\u0019Aa\u0005\u0003\u0016!)\u0011*\u0012a\u0001y\"9!qC#A\u0002\te\u0011a\u0003;be\u001e,Go\u0015;bi\u0016\u00042!\u0017B\u000e\u0013\r\u0011i\u0002\u0013\u0002\u000b\u000fJ|W\u000f]*uCR,\u0017!E8gMN,G/\u00118e\u001b\u0016$\u0018\rZ1uCR!!1\u0005B\u0018!\u0011\u0011)Ca\u000b\u000e\u0005\t\u001d\"b\u0001B\u0015\u0019\u000611m\\7n_:LAA!\f\u0003(\t\trJ\u001a4tKR\fe\u000eZ'fi\u0006$\u0017\r^1\t\u000f\tEb\t1\u0001\u00034\u00051qN\u001a4tKR\u00042!\u0015B\u001b\u0013\r\u00119D\u0015\u0002\u0005\u0019>tw\r")
public class GroupMetadataTest {
    private final String protocolType;
    private final String groupId;
    private final Some<String> groupInstanceId = new Some((Object)"groupInstanceId");
    private final String memberId;
    private final String clientId;
    private final String clientHost;
    private final int rebalanceTimeoutMs;
    private final int sessionTimeoutMs;
    private GroupMetadata group = null;
    private MemberMetadata member = null;

    private String protocolType() {
        return this.protocolType;
    }

    private String groupId() {
        return this.groupId;
    }

    private Some<String> groupInstanceId() {
        return this.groupInstanceId;
    }

    private String memberId() {
        return this.memberId;
    }

    private String clientId() {
        return this.clientId;
    }

    private String clientHost() {
        return this.clientHost;
    }

    private int rebalanceTimeoutMs() {
        return this.rebalanceTimeoutMs;
    }

    private int sessionTimeoutMs() {
        return this.sessionTimeoutMs;
    }

    private GroupMetadata group() {
        return this.group;
    }

    private void group_$eq(GroupMetadata x$1) {
        this.group = x$1;
    }

    private MemberMetadata member() {
        return this.member;
    }

    private void member_$eq(MemberMetadata x$1) {
        this.member = x$1;
    }

    @Before
    public void setUp() {
        this.group_$eq(new GroupMetadata("groupId", (GroupState)Empty$.MODULE$, Time.SYSTEM));
        this.member_$eq(new MemberMetadata(this.memberId(), this.groupId(), this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$))));
    }

    @Test
    public void testCanRebalanceWhenStable() {
        Assert.assertTrue((boolean)this.group().canRebalance());
    }

    @Test
    public void testCanRebalanceWhenCompletingRebalance() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
        Assert.assertTrue((boolean)this.group().canRebalance());
    }

    @Test
    public void testCannotRebalanceWhenPreparingRebalance() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        Assert.assertFalse((boolean)this.group().canRebalance());
    }

    @Test
    public void testCannotRebalanceWhenDead() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Empty$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        Assert.assertFalse((boolean)this.group().canRebalance());
    }

    @Test
    public void testStableToPreparingRebalanceTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.assertState(this.group(), (GroupState)PreparingRebalance$.MODULE$);
    }

    @Test
    public void testStableToDeadTransition() {
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.assertState(this.group(), (GroupState)Dead$.MODULE$);
    }

    @Test
    public void testAwaitingRebalanceToPreparingRebalanceTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.assertState(this.group(), (GroupState)PreparingRebalance$.MODULE$);
    }

    @Test
    public void testPreparingRebalanceToDeadTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.assertState(this.group(), (GroupState)Dead$.MODULE$);
    }

    @Test
    public void testPreparingRebalanceToEmptyTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Empty$.MODULE$);
        this.assertState(this.group(), (GroupState)Empty$.MODULE$);
    }

    @Test
    public void testEmptyToDeadTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Empty$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.assertState(this.group(), (GroupState)Dead$.MODULE$);
    }

    @Test
    public void testAwaitingRebalanceToStableTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Stable$.MODULE$);
        this.assertState(this.group(), (GroupState)Stable$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testEmptyToStableIllegalTransition() {
        this.group().transitionTo((GroupState)Stable$.MODULE$);
    }

    @Test
    public void testStableToStableIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Stable$.MODULE$);
        try {
            this.group().transitionTo((GroupState)Stable$.MODULE$);
            Assert.fail((String)"should have failed due to illegal transition");
        }
        catch (IllegalStateException illegalStateException) {}
    }

    @Test(expected=IllegalStateException.class)
    public void testEmptyToAwaitingRebalanceIllegalTransition() {
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testPreparingRebalanceToPreparingRebalanceIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testPreparingRebalanceToStableIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Stable$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testAwaitingRebalanceToAwaitingRebalanceIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
    }

    public void testDeadToDeadIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.assertState(this.group(), (GroupState)Dead$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testDeadToStableIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.group().transitionTo((GroupState)Stable$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testDeadToPreparingRebalanceIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testDeadToAwaitingRebalanceIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
    }

    @Test
    public void testSelectProtocol() {
        String memberId = "memberId";
        MemberMetadata member = new MemberMetadata(memberId, this.groupId(), this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)));
        GroupMetadata qual$1 = this.group();
        MemberMetadata x$1 = member;
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(x$1, x$2);
        Assert.assertEquals((Object)"range", (Object)this.group().selectProtocol());
        String otherMemberId = "otherMemberId";
        MemberMetadata otherMember = new MemberMetadata(otherMemberId, this.groupId(), this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)));
        GroupMetadata qual$2 = this.group();
        MemberMetadata x$3 = otherMember;
        Function1 x$4 = qual$2.add$default$2();
        qual$2.add(x$3, x$4);
        Assert.assertTrue((boolean)((GenSetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"range", "roundrobin"}))).apply((Object)this.group().selectProtocol()));
        String lastMemberId = "lastMemberId";
        MemberMetadata lastMember = new MemberMetadata(lastMemberId, this.groupId(), this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)));
        GroupMetadata qual$3 = this.group();
        MemberMetadata x$5 = lastMember;
        Function1 x$6 = qual$3.add$default$2();
        qual$3.add(x$5, x$6);
        Assert.assertEquals((Object)"roundrobin", (Object)this.group().selectProtocol());
    }

    @Test(expected=IllegalStateException.class)
    public void testSelectProtocolRaisesIfNoMembers() {
        this.group().selectProtocol();
        Assert.fail();
    }

    @Test
    public void testSelectProtocolChoosesCompatibleProtocol() {
        String memberId = "memberId";
        MemberMetadata member = new MemberMetadata(memberId, this.groupId(), this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)));
        String otherMemberId = "otherMemberId";
        MemberMetadata otherMember = new MemberMetadata(otherMemberId, this.groupId(), this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"blah", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)));
        GroupMetadata qual$1 = this.group();
        MemberMetadata x$1 = member;
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(x$1, x$2);
        GroupMetadata qual$2 = this.group();
        MemberMetadata x$3 = otherMember;
        Function1 x$4 = qual$2.add$default$2();
        qual$2.add(x$3, x$4);
        Assert.assertEquals((Object)"roundrobin", (Object)this.group().selectProtocol());
    }

    @Test
    public void testSupportsProtocols() {
        Assert.assertTrue((boolean)this.group().supportsProtocols(this.protocolType(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"roundrobin", "range"}))));
        GroupMetadata qual$1 = this.group();
        MemberMetadata x$1 = this.member();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(x$1, x$2);
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        Assert.assertTrue((boolean)this.group().supportsProtocols(this.protocolType(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"roundrobin", "foo"}))));
        Assert.assertTrue((boolean)this.group().supportsProtocols(this.protocolType(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"range", "foo"}))));
        Assert.assertFalse((boolean)this.group().supportsProtocols(this.protocolType(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))));
        String otherMemberId = "otherMemberId";
        MemberMetadata otherMember = new MemberMetadata(otherMemberId, this.groupId(), this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"blah", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)));
        GroupMetadata qual$2 = this.group();
        MemberMetadata x$3 = otherMember;
        Function1 x$4 = qual$2.add$default$2();
        qual$2.add(x$3, x$4);
        Assert.assertTrue((boolean)this.group().supportsProtocols(this.protocolType(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"roundrobin", "foo"}))));
        Assert.assertFalse((boolean)this.group().supportsProtocols("invalid_type", (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"roundrobin", "foo"}))));
        Assert.assertFalse((boolean)this.group().supportsProtocols(this.protocolType(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"range", "foo"}))));
    }

    @Test
    public void testSubscribedTopics() {
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().getSubscribedTopics());
        String memberId = "memberId";
        MemberMetadata member = new MemberMetadata(memberId, this.groupId(), this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", (Object)ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)"foo", (List)Nil$.MODULE$)).asJava())).array()), (List)Nil$.MODULE$));
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        GroupMetadata qual$1 = this.group();
        MemberMetadata x$1 = member;
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(x$1, x$2);
        this.group().initNextGeneration();
        Assert.assertEquals((Object)new Some((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"}))), (Object)this.group().getSubscribedTopics());
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().remove(memberId);
        this.group().initNextGeneration();
        Assert.assertEquals((Object)new Some((Object)Predef$.MODULE$.Set().empty()), (Object)this.group().getSubscribedTopics());
        MemberMetadata memberWithFaultyProtocol = new MemberMetadata(memberId, this.groupId(), this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$));
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        GroupMetadata qual$2 = this.group();
        MemberMetadata x$3 = memberWithFaultyProtocol;
        Function1 x$4 = qual$2.add$default$2();
        qual$2.add(x$3, x$4);
        this.group().initNextGeneration();
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().getSubscribedTopics());
    }

    @Test
    public void testSubscribedTopicsNonConsumerGroup() {
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().getSubscribedTopics());
        String memberId = "memberId";
        MemberMetadata member = new MemberMetadata(memberId, this.groupId(), this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), "My Protocol", (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$));
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        GroupMetadata qual$1 = this.group();
        MemberMetadata x$1 = member;
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(x$1, x$2);
        this.group().initNextGeneration();
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().getSubscribedTopics());
    }

    @Test
    public void testInitNextGeneration() {
        this.member().supportedProtocols_$eq((List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$));
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().add(this.member(), (Function1 & Serializable & scala.Serializable)x$1 -> {
            GroupMetadataTest.$anonfun$testInitNextGeneration$1(x$1);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((long)0L, (long)this.group().generationId());
        Assert.assertNull((Object)this.group().protocolOrNull());
        this.group().initNextGeneration();
        Assert.assertEquals((long)1L, (long)this.group().generationId());
        Assert.assertEquals((Object)"roundrobin", (Object)this.group().protocolOrNull());
    }

    @Test
    public void testInitNextGenerationEmptyGroup() {
        Assert.assertEquals((Object)Empty$.MODULE$, (Object)this.group().currentState());
        Assert.assertEquals((long)0L, (long)this.group().generationId());
        Assert.assertNull((Object)this.group().protocolOrNull());
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().initNextGeneration();
        Assert.assertEquals((long)1L, (long)this.group().generationId());
        Assert.assertNull((Object)this.group().protocolOrNull());
    }

    @Test
    public void testOffsetCommit() {
        TopicPartition partition = new TopicPartition("foo", 0);
        OffsetAndMetadata offset = this.offsetAndMetadata(37L);
        int commitRecordOffset = 3;
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)offset)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)commitRecordOffset)), offset));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)new Some((Object)offset), (Object)this.group().offset(partition));
    }

    @Test
    public void testOffsetCommitFailure() {
        TopicPartition partition = new TopicPartition("foo", 0);
        OffsetAndMetadata offset = this.offsetAndMetadata(37L);
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)offset)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().failPendingOffsetWrite(partition, offset);
        Assert.assertFalse((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
    }

    @Test
    public void testOffsetCommitFailureWithAnotherPending() {
        TopicPartition partition = new TopicPartition("foo", 0);
        OffsetAndMetadata firstOffset = this.offsetAndMetadata(37L);
        OffsetAndMetadata secondOffset = this.offsetAndMetadata(57L);
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)firstOffset)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)secondOffset)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        this.group().failPendingOffsetWrite(partition, firstOffset);
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)3L)), secondOffset));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)new Some((Object)secondOffset), (Object)this.group().offset(partition));
    }

    @Test
    public void testOffsetCommitWithAnotherPending() {
        TopicPartition partition = new TopicPartition("foo", 0);
        OffsetAndMetadata firstOffset = this.offsetAndMetadata(37L);
        OffsetAndMetadata secondOffset = this.offsetAndMetadata(57L);
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)firstOffset)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)secondOffset)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), firstOffset));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)new Some((Object)firstOffset), (Object)this.group().offset(partition));
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)5L)), secondOffset));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)new Some((Object)secondOffset), (Object)this.group().offset(partition));
    }

    @Test
    public void testConsumerBeatsTransactionalOffsetCommit() {
        TopicPartition partition = new TopicPartition("foo", 0);
        long producerId = 13232L;
        OffsetAndMetadata txnOffsetCommit = this.offsetAndMetadata(37L);
        OffsetAndMetadata consumerOffsetCommit = this.offsetAndMetadata(57L);
        this.group().prepareTxnOffsetCommit(producerId, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)txnOffsetCommit)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)consumerOffsetCommit)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        this.group().onTxnOffsetCommitAppend(producerId, partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)3L)), txnOffsetCommit));
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), consumerOffsetCommit));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().offset(partition));
        this.group().completePendingTxnOffsetCommit(producerId, true);
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().offset(partition));
    }

    @Test
    public void testTransactionBeatsConsumerOffsetCommit() {
        TopicPartition partition = new TopicPartition("foo", 0);
        long producerId = 13232L;
        OffsetAndMetadata txnOffsetCommit = this.offsetAndMetadata(37L);
        OffsetAndMetadata consumerOffsetCommit = this.offsetAndMetadata(57L);
        this.group().prepareTxnOffsetCommit(producerId, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)txnOffsetCommit)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)consumerOffsetCommit)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)3L)), consumerOffsetCommit));
        this.group().onTxnOffsetCommitAppend(producerId, partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), txnOffsetCommit));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().offset(partition));
        this.group().completePendingTxnOffsetCommit(producerId, true);
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)new Some((Object)txnOffsetCommit), (Object)this.group().offset(partition));
    }

    @Test
    public void testTransactionalCommitIsAbortedAndConsumerCommitWins() {
        TopicPartition partition = new TopicPartition("foo", 0);
        long producerId = 13232L;
        OffsetAndMetadata txnOffsetCommit = this.offsetAndMetadata(37L);
        OffsetAndMetadata consumerOffsetCommit = this.offsetAndMetadata(57L);
        this.group().prepareTxnOffsetCommit(producerId, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)txnOffsetCommit)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)consumerOffsetCommit)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)3L)), consumerOffsetCommit));
        this.group().onTxnOffsetCommitAppend(producerId, partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), txnOffsetCommit));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().offset(partition));
        this.group().completePendingTxnOffsetCommit(producerId, false);
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertFalse((boolean)this.group().hasPendingOffsetCommitsFromProducer(producerId));
        Assert.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().offset(partition));
    }

    @Test
    public void testFailedTxnOffsetCommitLeavesNoPendingState() {
        TopicPartition partition = new TopicPartition("foo", 0);
        long producerId = 13232L;
        OffsetAndMetadata txnOffsetCommit = this.offsetAndMetadata(37L);
        this.group().prepareTxnOffsetCommit(producerId, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)txnOffsetCommit)})));
        Assert.assertTrue((boolean)this.group().hasPendingOffsetCommitsFromProducer(producerId));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().failPendingTxnOffsetCommit(producerId, partition);
        Assert.assertFalse((boolean)this.group().hasOffsets());
        Assert.assertFalse((boolean)this.group().hasPendingOffsetCommitsFromProducer(producerId));
        this.group().completePendingTxnOffsetCommit(producerId, true);
        Assert.assertFalse((boolean)this.group().hasOffsets());
        Assert.assertFalse((boolean)this.group().hasPendingOffsetCommitsFromProducer(producerId));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testReplaceGroupInstanceWithEmptyGroupInstanceId() {
        GroupMetadata qual$1 = this.group();
        MemberMetadata x$1 = this.member();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(x$1, x$2);
        this.group().addStaticMember(this.groupInstanceId(), this.memberId());
        Assert.assertTrue((boolean)this.group().isLeader(this.memberId()));
        Assert.assertEquals((Object)this.memberId(), (Object)this.group().getStaticMemberId(this.groupInstanceId()));
        String newMemberId = "newMemberId";
        this.group().replaceGroupInstance(this.memberId(), newMemberId, Option$.MODULE$.empty());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testReplaceGroupInstanceWithNonExistingMember() {
        String newMemberId = "newMemberId";
        this.group().replaceGroupInstance(this.memberId(), newMemberId, this.groupInstanceId());
    }

    @Test
    public void testReplaceGroupInstance() {
        BooleanRef joinAwaitingMemberFenced = BooleanRef.create((boolean)false);
        this.group().add(this.member(), (Function1 & Serializable & scala.Serializable)joinGroupResult -> {
            GroupMetadataTest.$anonfun$testReplaceGroupInstance$1(joinAwaitingMemberFenced, joinGroupResult);
            return BoxedUnit.UNIT;
        });
        BooleanRef syncAwaitingMemberFenced = BooleanRef.create((boolean)false);
        this.member().awaitingSyncCallback_$eq((Function1 & Serializable & scala.Serializable)syncGroupResult -> {
            GroupMetadataTest.$anonfun$testReplaceGroupInstance$2(syncAwaitingMemberFenced, syncGroupResult);
            return BoxedUnit.UNIT;
        });
        this.group().addStaticMember(this.groupInstanceId(), this.memberId());
        Assert.assertTrue((boolean)this.group().isLeader(this.memberId()));
        Assert.assertEquals((Object)this.memberId(), (Object)this.group().getStaticMemberId(this.groupInstanceId()));
        String newMemberId = "newMemberId";
        this.group().replaceGroupInstance(this.memberId(), newMemberId, this.groupInstanceId());
        Assert.assertTrue((boolean)this.group().isLeader(newMemberId));
        Assert.assertEquals((Object)newMemberId, (Object)this.group().getStaticMemberId(this.groupInstanceId()));
        Assert.assertTrue((boolean)joinAwaitingMemberFenced.elem);
        Assert.assertTrue((boolean)syncAwaitingMemberFenced.elem);
        Assert.assertFalse((boolean)this.member().isAwaitingJoin());
        Assert.assertFalse((boolean)this.member().isAwaitingSync());
    }

    @Test
    public void testInvokeJoinCallback() {
        BooleanRef invoked = BooleanRef.create((boolean)false);
        this.group().add(this.member(), (Function1 & Serializable & scala.Serializable)x$2 -> {
            invoked.elem = true;
            return BoxedUnit.UNIT;
        });
        Assert.assertTrue((boolean)this.group().hasAllMembersJoined());
        this.group().maybeInvokeJoinCallback(this.member(), GroupCoordinator$.MODULE$.joinError(this.member().memberId(), Errors.NONE));
        Assert.assertTrue((boolean)invoked.elem);
        Assert.assertFalse((boolean)this.member().isAwaitingJoin());
    }

    @Test
    public void testNotInvokeJoinCallback() {
        GroupMetadata qual$1 = this.group();
        MemberMetadata x$1 = this.member();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(x$1, x$2);
        Assert.assertFalse((boolean)this.member().isAwaitingJoin());
        this.group().maybeInvokeJoinCallback(this.member(), GroupCoordinator$.MODULE$.joinError(this.member().memberId(), Errors.NONE));
        Assert.assertFalse((boolean)this.member().isAwaitingJoin());
    }

    @Test
    public void testInvokeSyncCallback() {
        GroupMetadata qual$1 = this.group();
        MemberMetadata x$1 = this.member();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(x$1, x$2);
        this.member().awaitingSyncCallback_$eq((Function1 & Serializable & scala.Serializable)x$3 -> {
            GroupMetadataTest.$anonfun$testInvokeSyncCallback$1(x$3);
            return BoxedUnit.UNIT;
        });
        boolean invoked = this.group().maybeInvokeSyncCallback(this.member(), new SyncGroupResult((byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), Errors.NONE));
        Assert.assertTrue((boolean)invoked);
        Assert.assertFalse((boolean)this.member().isAwaitingSync());
    }

    @Test
    public void testNotInvokeSyncCallback() {
        GroupMetadata qual$1 = this.group();
        MemberMetadata x$1 = this.member();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(x$1, x$2);
        boolean invoked = this.group().maybeInvokeSyncCallback(this.member(), new SyncGroupResult((byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), Errors.NONE));
        Assert.assertFalse((boolean)invoked);
        Assert.assertFalse((boolean)this.member().isAwaitingSync());
    }

    private void assertState(GroupMetadata group, GroupState targetState) {
        Set states = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GroupState[]{Stable$.MODULE$, PreparingRebalance$.MODULE$, CompletingRebalance$.MODULE$, Dead$.MODULE$}));
        Set otherStates = (Set)states.$minus((Object)targetState);
        otherStates.foreach((Function1 & Serializable & scala.Serializable)otherState -> {
            GroupMetadataTest.$anonfun$assertState$1(group, otherState);
            return BoxedUnit.UNIT;
        });
        Assert.assertTrue((boolean)group.is(targetState));
    }

    private OffsetAndMetadata offsetAndMetadata(long offset) {
        return OffsetAndMetadata$.MODULE$.apply(offset, "", Time.SYSTEM.milliseconds());
    }

    public static final /* synthetic */ void $anonfun$testInitNextGeneration$1(JoinGroupResult x$1) {
    }

    public static final /* synthetic */ void $anonfun$testReplaceGroupInstance$1(BooleanRef joinAwaitingMemberFenced$1, JoinGroupResult joinGroupResult) {
        Errors errors = joinGroupResult.error();
        Errors errors2 = Errors.FENCED_INSTANCE_ID;
        joinAwaitingMemberFenced$1.elem = !(errors != null ? !errors.equals(errors2) : errors2 != null);
    }

    public static final /* synthetic */ void $anonfun$testReplaceGroupInstance$2(BooleanRef syncAwaitingMemberFenced$1, SyncGroupResult syncGroupResult) {
        Errors errors = syncGroupResult.error();
        Errors errors2 = Errors.FENCED_INSTANCE_ID;
        syncAwaitingMemberFenced$1.elem = !(errors != null ? !errors.equals(errors2) : errors2 != null);
    }

    public static final /* synthetic */ void $anonfun$testInvokeSyncCallback$1(SyncGroupResult x$3) {
    }

    public static final /* synthetic */ void $anonfun$assertState$1(GroupMetadata group$1, GroupState otherState) {
        Assert.assertFalse((boolean)group$1.is(otherState));
    }

    public GroupMetadataTest() {
        this.protocolType = "consumer";
        this.groupId = "groupId";
        this.memberId = "memberId";
        this.clientId = "clientId";
        this.clientHost = "clientHost";
        this.rebalanceTimeoutMs = 60000;
        this.sessionTimeoutMs = 10000;
    }
}

