/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import kafka.log.BrokerCompressionTest$;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager$;
import kafka.message.BrokerCompressionCodec$;
import kafka.message.CompressionCodec;
import kafka.message.CompressionCodec$;
import kafka.server.BrokerTopicStats;
import kafka.server.FetchDataInfo;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.LogDirFailureChannel;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.reflect.ScalaSignature;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005ma\u0001\u0002\n\u0014\u0001aA\u0001b\b\u0001\u0003\u0002\u0003\u0006I\u0001\t\u0005\tW\u0001\u0011\t\u0011)A\u0005A!)A\u0006\u0001C\u0001[!9!\u0007\u0001b\u0001\n\u0003\u0019\u0004B\u0002\u001f\u0001A\u0003%A\u0007C\u0004>\u0001\t\u0007I\u0011A\u001a\t\ry\u0002\u0001\u0015!\u00035\u0011\u001dy\u0004A1A\u0005\u0002\u0001Caa\u0012\u0001!\u0002\u0013\t\u0005b\u0002%\u0001\u0005\u0004%\t!\u0013\u0005\u0007\u001b\u0002\u0001\u000b\u0011\u0002&\t\u000b9\u0003A\u0011A(\t\u000bq\u0003A\u0011A(\b\u000bA\u001c\u0002\u0012A9\u0007\u000bI\u0019\u0002\u0012\u0001:\t\u000b1zA\u0011A:\t\u000bQ|A\u0011A;\u0003+\t\u0013xn[3s\u0007>l\u0007O]3tg&|g\u000eV3ti*\u0011A#F\u0001\u0004Y><'\"\u0001\f\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\u0007\t\u00035ui\u0011a\u0007\u0006\u00029\u0005)1oY1mC&\u0011ad\u0007\u0002\u0007\u0003:L(+\u001a4\u0002%5,7o]1hK\u000e{W\u000e\u001d:fgNLwN\u001c\t\u0003C!r!A\t\u0014\u0011\u0005\rZR\"\u0001\u0013\u000b\u0005\u0015:\u0012A\u0002\u001fs_>$h(\u0003\u0002(7\u00051\u0001K]3eK\u001aL!!\u000b\u0016\u0003\rM#(/\u001b8h\u0015\t93$A\tce>\\WM]\"p[B\u0014Xm]:j_:\fa\u0001P5oSRtDc\u0001\u00181cA\u0011q\u0006A\u0007\u0002'!)qd\u0001a\u0001A!)1f\u0001a\u0001A\u00051A/\u001c9ESJ,\u0012\u0001\u000e\t\u0003kij\u0011A\u000e\u0006\u0003oa\n!![8\u000b\u0003e\nAA[1wC&\u00111H\u000e\u0002\u0005\r&dW-A\u0004u[B$\u0015N\u001d\u0011\u0002\r1|w\rR5s\u0003\u001dawn\u001a#je\u0002\nA\u0001^5nKV\t\u0011\t\u0005\u0002C\u000b6\t1I\u0003\u0002E+\u0005)Q\u000f^5mg&\u0011ai\u0011\u0002\t\u001b>\u001c7\u000eV5nK\u0006)A/[7fA\u0005IAn\\4D_:4\u0017nZ\u000b\u0002\u0015B\u0011qfS\u0005\u0003\u0019N\u0011\u0011\u0002T8h\u0007>tg-[4\u0002\u00151|wmQ8oM&<\u0007%\u0001\u0005uK\u0006\u0014Hi\\<o)\u0005\u0001\u0006C\u0001\u000eR\u0013\t\u00116D\u0001\u0003V]&$\bF\u0001\u0007U!\t)&,D\u0001W\u0015\t9\u0006,A\u0003kk:LGOC\u0001Z\u0003\ry'oZ\u0005\u00037Z\u0013Q!\u00114uKJ\f\u0011\u0004^3ti\n\u0013xn[3s'&$WmQ8naJ,7o]5p]\"\u0012QB\u0018\t\u0003+~K!\u0001\u0019,\u0003\tQ+7\u000f\u001e\u0015\u0005\u0001\tD\u0017\u000e\u0005\u0002dM6\tAM\u0003\u0002f-\u00061!/\u001e8oKJL!a\u001a3\u0003\u000fI+hnV5uQ\u0006)a/\u00197vK\u000e\n!\u000e\u0005\u0002l]6\tAN\u0003\u0002n-\u00069!/\u001e8oKJ\u001c\u0018BA8m\u00055\u0001\u0016M]1nKR,'/\u001b>fI\u0006)\"I]8lKJ\u001cu.\u001c9sKN\u001c\u0018n\u001c8UKN$\bCA\u0018\u0010'\ty\u0011\u0004F\u0001r\u0003)\u0001\u0018M]1nKR,'o]\u000b\u0002mB\u0019qO\u001f?\u000e\u0003aT!!\u001f\u001d\u0002\tU$\u0018\u000e\\\u0005\u0003wb\u0014!bQ8mY\u0016\u001cG/[8o!\rQR\u0010I\u0005\u0003}n\u0011Q!\u0011:sCfD3!EA\u0001!\u0011\t\u0019!!\u0006\u000f\t\u0005\u0015\u0011\u0011\u0003\b\u0005\u0003\u000f\tyA\u0004\u0003\u0002\n\u00055abA\u0012\u0002\f%\t\u0011,\u0003\u0002X1&\u0011QNV\u0005\u0004\u0003'a\u0017!\u0004)be\u0006lW\r^3sSj,G-\u0003\u0003\u0002\u0018\u0005e!A\u0003)be\u0006lW\r^3sg*\u0019\u00111\u00037")
public class BrokerCompressionTest {
    private final String messageCompression;
    private final String brokerCompression;
    private final File tmpDir;
    private final File logDir;
    private final MockTime time;
    private final LogConfig logConfig;

    @Parameterized.Parameters
    public static Collection<String[]> parameters() {
        return BrokerCompressionTest$.MODULE$.parameters();
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public MockTime time() {
        return this.time;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    @After
    public void tearDown() {
        Utils.delete((File)this.tmpDir());
    }

    @Test
    public void testBrokerSideCompression() {
        CompressionCodec messageCompressionCode = CompressionCodec$.MODULE$.getCompressionCodec(this.messageCompression);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.CompressionTypeProp(), this.brokerCompression);
        File x$1 = this.logDir();
        LogConfig x$2 = new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2());
        long x$3 = 0L;
        long x$4 = 0L;
        MockScheduler x$5 = this.time().scheduler();
        MockTime x$6 = this.time();
        BrokerTopicStats x$7 = new BrokerTopicStats();
        int x$8 = 3600000;
        int x$9 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$10 = new LogDirFailureChannel(10);
        Log log = Log$.MODULE$.apply(x$1, x$2, x$3, x$4, (Scheduler)x$5, x$7, (Time)x$6, x$8, x$9, x$10);
        log.appendAsLeader(MemoryRecords.withRecords((CompressionType)CompressionType.forId((int)messageCompressionCode.codec()), (int)0, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("hello".getBytes()), new SimpleRecord("there".getBytes())}), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        if (!this.brokerCompression.equals("producer")) {
            CompressionCodec brokerCompressionCode = BrokerCompressionCodec$.MODULE$.getCompressionCodec(this.brokerCompression);
            Assert.assertEquals((String)new StringBuilder(39).append("Compression at offset 0 should produce ").append(brokerCompressionCode.name()).toString(), (long)brokerCompressionCode.codec(), (long)BrokerCompressionTest.readBatch$1((int)0, (Log)log).compressionType().id);
        } else {
            Assert.assertEquals((String)new StringBuilder(39).append("Compression at offset 0 should produce ").append(messageCompressionCode.name()).toString(), (long)messageCompressionCode.codec(), (long)BrokerCompressionTest.readBatch$1((int)0, (Log)log).compressionType().id);
        }
    }

    private static final RecordBatch readBatch$1(int offset, Log log$1) {
        FetchDataInfo fetchInfo = log$1.read((long)offset, 4096, (FetchIsolation)FetchLogEnd$.MODULE$, true);
        return (RecordBatch)fetchInfo.records().batches().iterator().next();
    }

    public BrokerCompressionTest(String messageCompression, String brokerCompression) {
        this.messageCompression = messageCompression;
        this.brokerCompression = brokerCompression;
        this.tmpDir = TestUtils$.MODULE$.tempDir();
        this.logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
        this.time = new MockTime(0L, 0L);
        this.logConfig = LogConfig$.MODULE$.apply();
    }
}

