/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import kafka.log.Log;
import kafka.log.LogManager;
import kafka.network.SocketServer;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AlterReplicaLogDirsRequest;
import org.apache.kafka.common.requests.AlterReplicaLogDirsResponse;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001Q4A\u0001D\u0007\u0001%!)q\u0003\u0001C\u00011!9!\u0004\u0001b\u0001\n\u0003Z\u0002B\u0002\u0012\u0001A\u0003%A\u0004C\u0004$\u0001\t\u0007I\u0011I\u000e\t\r\u0011\u0002\u0001\u0015!\u0003\u001d\u0011\u001d)\u0003A1A\u0005\u0002\u0019Baa\f\u0001!\u0002\u00139\u0003\"\u0002\u0019\u0001\t\u0003\t\u0004\"\u0002 \u0001\t\u0003\t\u0004\"\u0002!\u0001\t\u0013\t\u0005b\u00025\u0001#\u0003%I!\u001b\u0002\u001f\u00032$XM\u001d*fa2L7-\u0019'pO\u0012K'o\u001d*fcV,7\u000f\u001e+fgRT!AD\b\u0002\rM,'O^3s\u0015\u0005\u0001\u0012!B6bM.\f7\u0001A\n\u0003\u0001M\u0001\"\u0001F\u000b\u000e\u00035I!AF\u0007\u0003\u001f\t\u000b7/\u001a*fcV,7\u000f\u001e+fgR\fa\u0001P5oSRtD#A\r\u0011\u0005Q\u0001\u0011a\u00037pO\u0012K'oQ8v]R,\u0012\u0001\b\t\u0003;\u0001j\u0011A\b\u0006\u0002?\u0005)1oY1mC&\u0011\u0011E\b\u0002\u0004\u0013:$\u0018\u0001\u00047pO\u0012K'oQ8v]R\u0004\u0013a\u00032s_.,'oQ8v]R\fAB\u0019:pW\u0016\u00148i\\;oi\u0002\nQ\u0001^8qS\u000e,\u0012a\n\t\u0003Q5j\u0011!\u000b\u0006\u0003U-\nA\u0001\\1oO*\tA&\u0001\u0003kCZ\f\u0017B\u0001\u0018*\u0005\u0019\u0019FO]5oO\u00061Ao\u001c9jG\u0002\na\u0004^3ti\u0006cG/\u001a:SKBd\u0017nY1M_\u001e$\u0015N]:SKF,Xm\u001d;\u0015\u0003I\u0002\"!H\u001a\n\u0005Qr\"\u0001B+oSRD#\u0001\u0003\u001c\u0011\u0005]bT\"\u0001\u001d\u000b\u0005eR\u0014!\u00026v]&$(\"A\u001e\u0002\u0007=\u0014x-\u0003\u0002>q\t!A+Z:u\u0003\u001d\"Xm\u001d;BYR,'OU3qY&\u001c\u0017\rT8h\t&\u00148OU3rk\u0016\u001cH/\u0012:s_J\u001cu\u000eZ3)\u0005%1\u0014AH:f]\u0012\fE\u000e^3s%\u0016\u0004H.[2b\u0019><G)\u001b:t%\u0016\fX/Z:u)\r\u0011U\n\u0019\t\u0003\u0007.k\u0011\u0001\u0012\u0006\u0003\u000b\u001a\u000b\u0001B]3rk\u0016\u001cHo\u001d\u0006\u0003\u000f\"\u000baaY8n[>t'B\u0001\tJ\u0015\tQ%(\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003\u0019\u0012\u00131$\u00117uKJ\u0014V\r\u001d7jG\u0006dun\u001a#jeN\u0014Vm\u001d9p]N,\u0007\"\u0002(\u000b\u0001\u0004y\u0015!\u00049beRLG/[8o\t&\u00148\u000f\u0005\u0003Q/jsfBA)V!\t\u0011f$D\u0001T\u0015\t!\u0016#\u0001\u0004=e>|GOP\u0005\u0003-z\ta\u0001\u0015:fI\u00164\u0017B\u0001-Z\u0005\ri\u0015\r\u001d\u0006\u0003-z\u0001\"a\u0017/\u000e\u0003\u0019K!!\u0018$\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]B\u0011\u0001kX\u0005\u0003]eCq!\u0019\u0006\u0011\u0002\u0003\u0007!-\u0001\u0007t_\u000e\\W\r^*feZ,'\u000f\u0005\u0002dM6\tAM\u0003\u0002f\u001f\u00059a.\u001a;x_J\\\u0017BA4e\u00051\u0019vnY6fiN+'O^3s\u0003!\u001aXM\u001c3BYR,'OU3qY&\u001c\u0017\rT8h\t&\u00148OU3rk\u0016\u001cH\u000f\n3fM\u0006,H\u000e\u001e\u00133+\u0005Q'F\u00012lW\u0005a\u0007CA7s\u001b\u0005q'BA8q\u0003%)hn\u00195fG.,GM\u0003\u0002r=\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005Mt'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class AlterReplicaLogDirsRequestTest
extends BaseRequestTest {
    private final int logDirCount;
    private final int brokerCount;
    private final String topic;

    @Override
    public int logDirCount() {
        return this.logDirCount;
    }

    @Override
    public int brokerCount() {
        return this.brokerCount;
    }

    public String topic() {
        return this.topic;
    }

    @Test
    public void testAlterReplicaLogDirsRequest() {
        int partitionNum = 5;
        String logDir1 = new File((String)((KafkaServer)this.servers().head()).config().logDirs().apply(Random$.MODULE$.nextInt(this.logDirCount()))).getAbsolutePath();
        Map partitionDirs1 = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), partitionNum).map((Function1 & Serializable & scala.Serializable)partition -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), BoxesRunTime.unboxToInt((Object)partition))), (Object)logDir1), IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        AlterReplicaLogDirsResponse alterReplicaLogDirsResponse1 = this.sendAlterReplicaLogDirsRequest((Map<TopicPartition, String>)partitionDirs1, this.sendAlterReplicaLogDirsRequest$default$2());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), partitionNum).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partition -> {
            TopicPartition tp = new TopicPartition(this.topic(), partition);
            Assert.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, alterReplicaLogDirsResponse1.responses().get(tp));
            LogManager qual$1 = ((KafkaServer)this.servers().head()).logManager();
            TopicPartition x$1 = tp;
            boolean x$2 = qual$1.getLog$default$2();
            Assert.assertTrue((boolean)qual$1.getLog(x$1, x$2).isEmpty());
        });
        this.createTopic(this.topic(), partitionNum, 1, this.createTopic$default$4());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), partitionNum).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partition -> {
            LogManager qual$2 = ((KafkaServer)this.servers().head()).logManager();
            TopicPartition x$3 = new TopicPartition(this.topic(), partition);
            boolean x$4 = qual$2.getLog$default$2();
            Assert.assertEquals((Object)logDir1, (Object)((Log)qual$2.getLog(x$3, x$4).get()).dir().getParent());
        });
        String logDir2 = new File((String)((KafkaServer)this.servers().head()).config().logDirs().apply(Random$.MODULE$.nextInt(this.logDirCount()))).getAbsolutePath();
        Map partitionDirs2 = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), partitionNum).map((Function1 & Serializable & scala.Serializable)partition -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), BoxesRunTime.unboxToInt((Object)partition))), (Object)logDir2), IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        AlterReplicaLogDirsResponse alterReplicaLogDirsResponse2 = this.sendAlterReplicaLogDirsRequest((Map<TopicPartition, String>)partitionDirs2, this.sendAlterReplicaLogDirsRequest$default$2());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), partitionNum).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partition -> {
            TopicPartition tp = new TopicPartition(this.topic(), partition);
            Assert.assertEquals((Object)Errors.NONE, alterReplicaLogDirsResponse2.responses().get(tp));
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                String string = logDir2;
                LogManager qual$3 = ((KafkaServer)this.servers().head()).logManager();
                TopicPartition x$5 = new TopicPartition(this.topic(), partition);
                boolean x$6 = qual$3.getLog$default$2();
                String string2 = ((Log)qual$3.getLog(x$5, x$6).get()).dir().getParent();
                return !(string != null ? !string.equals(string2) : string2 != null);
            }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "timed out waiting for replica movement", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        });
    }

    @Test
    public void testAlterReplicaLogDirsRequestErrorCode() {
        String offlineDir = new File((String)((IterableLike)((KafkaServer)this.servers().head()).config().logDirs().tail()).head()).getAbsolutePath();
        String validDir1 = new File((String)((KafkaServer)this.servers().head()).config().logDirs().apply(1)).getAbsolutePath();
        String validDir2 = new File((String)((KafkaServer)this.servers().head()).config().logDirs().apply(2)).getAbsolutePath();
        String validDir3 = new File((String)((KafkaServer)this.servers().head()).config().logDirs().apply(3)).getAbsolutePath();
        scala.collection.mutable.Map partitionDirs1 = Map$.MODULE$.empty();
        partitionDirs1.put((Object)new TopicPartition(this.topic(), 0), (Object)"invalidDir");
        partitionDirs1.put((Object)new TopicPartition(this.topic(), 1), (Object)validDir1);
        AlterReplicaLogDirsResponse alterReplicaDirResponse1 = this.sendAlterReplicaLogDirsRequest((Map<TopicPartition, String>)partitionDirs1.toMap(Predef$.MODULE$.$conforms()), this.sendAlterReplicaLogDirsRequest$default$2());
        Assert.assertEquals((Object)Errors.LOG_DIR_NOT_FOUND, alterReplicaDirResponse1.responses().get(new TopicPartition(this.topic(), 0)));
        Assert.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, alterReplicaDirResponse1.responses().get(new TopicPartition(this.topic(), 1)));
        this.createTopic(this.topic(), 3, 1, this.createTopic$default$4());
        scala.collection.mutable.Map partitionDirs2 = Map$.MODULE$.empty();
        partitionDirs2.put((Object)new TopicPartition(this.topic(), 0), (Object)"invalidDir");
        partitionDirs2.put((Object)new TopicPartition(this.topic(), 1), (Object)validDir2);
        AlterReplicaLogDirsResponse alterReplicaDirResponse2 = this.sendAlterReplicaLogDirsRequest((Map<TopicPartition, String>)partitionDirs2.toMap(Predef$.MODULE$.$conforms()), this.sendAlterReplicaLogDirsRequest$default$2());
        Assert.assertEquals((Object)Errors.LOG_DIR_NOT_FOUND, alterReplicaDirResponse2.responses().get(new TopicPartition(this.topic(), 0)));
        Assert.assertEquals((Object)Errors.NONE, alterReplicaDirResponse2.responses().get(new TopicPartition(this.topic(), 1)));
        ((KafkaServer)this.servers().head()).logDirFailureChannel().maybeAddOfflineLogDir(offlineDir, (Function0 & Serializable & scala.Serializable)() -> "", new IOException());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !((KafkaServer)this.servers().head()).logManager().isLogDirOnline(offlineDir), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("timed out waiting for ").append(offlineDir).append(" to be offline").toString(), 3000L, TestUtils$.MODULE$.waitUntilTrue$default$4());
        scala.collection.mutable.Map partitionDirs3 = Map$.MODULE$.empty();
        partitionDirs3.put((Object)new TopicPartition(this.topic(), 0), (Object)"invalidDir");
        partitionDirs3.put((Object)new TopicPartition(this.topic(), 1), (Object)validDir3);
        partitionDirs3.put((Object)new TopicPartition(this.topic(), 2), (Object)offlineDir);
        AlterReplicaLogDirsResponse alterReplicaDirResponse3 = this.sendAlterReplicaLogDirsRequest((Map<TopicPartition, String>)partitionDirs3.toMap(Predef$.MODULE$.$conforms()), this.sendAlterReplicaLogDirsRequest$default$2());
        Assert.assertEquals((Object)Errors.LOG_DIR_NOT_FOUND, alterReplicaDirResponse3.responses().get(new TopicPartition(this.topic(), 0)));
        Assert.assertEquals((Object)Errors.KAFKA_STORAGE_ERROR, alterReplicaDirResponse3.responses().get(new TopicPartition(this.topic(), 1)));
        Assert.assertEquals((Object)Errors.KAFKA_STORAGE_ERROR, alterReplicaDirResponse3.responses().get(new TopicPartition(this.topic(), 2)));
    }

    private AlterReplicaLogDirsResponse sendAlterReplicaLogDirsRequest(Map<TopicPartition, String> partitionDirs, SocketServer socketServer) {
        AlterReplicaLogDirsRequest request = (AlterReplicaLogDirsRequest)new AlterReplicaLogDirsRequest.Builder((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(partitionDirs).asJava()).build();
        ByteBuffer response = this.connectAndSend((AbstractRequest)request, ApiKeys.ALTER_REPLICA_LOG_DIRS, socketServer, this.connectAndSend$default$4(), this.connectAndSend$default$5());
        return AlterReplicaLogDirsResponse.parse((ByteBuffer)response, (short)request.version());
    }

    private SocketServer sendAlterReplicaLogDirsRequest$default$2() {
        return this.controllerSocketServer();
    }

    public AlterReplicaLogDirsRequestTest() {
        this.logDirCount = 5;
        this.brokerCount = 1;
        this.topic = "topic";
    }
}

