/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import kafka.network.RequestChannel;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManager$;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.ClientQuotaManagerTest$UserClient$;
import kafka.server.ClientRequestQuotaManager;
import kafka.server.ConfigEntityName$;
import kafka.server.QuotaType;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Sanitizer;
import org.apache.kafka.common.utils.Time;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\tuh\u0001B A\u0001\u0015CQ\u0001\u0014\u0001\u0005\u00025Cq\u0001\u0015\u0001C\u0002\u0013%\u0011\u000b\u0003\u0004`\u0001\u0001\u0006IA\u0015\u0005\bA\u0002\u0011\r\u0011\"\u0003b\u0011\u00199\u0007\u0001)A\u0005E\"9\u0001\u000e\u0001b\u0001\n\u0013I\u0007BB7\u0001A\u0003%!\u000eC\u0004o\u0001\u0001\u0007I\u0011A8\t\u000fM\u0004\u0001\u0019!C\u0001i\"1!\u0010\u0001Q!\nADQa\u001f\u0001\u0005\u0002qDq!!\u0003\u0001\t\u0003\tY\u0001C\u0004\u0002&\u0001!I!a\n\t\u0013\u0005M\u0004!%A\u0005\n\u0005U\u0004bBAH\u0001\u0011%\u0011\u0011\u0013\u0005\b\u0003\u000b\u0004A\u0011BAd\u0011\u001d\ti\u000e\u0001C\u0005\u0003?DaAa%\u0001\t\u0003a\bB\u0002BO\u0001\u0011\u0005A\u0010\u0003\u0004\u0003\"\u0002!\t\u0001 \u0005\u0007\u0005K\u0003A\u0011\u0001?\t\r\t%\u0006\u0001\"\u0001}\u0011\u0019\u0011i\u000b\u0001C\u0001y\"1!\u0011\u0017\u0001\u0005\u0002qDaA!.\u0001\t\u0003a\bB\u0002B]\u0001\u0011\u0005A\u0010\u0003\u0004\u0003>\u0002!\t\u0001 \u0005\u0007\u0005\u0003\u0004A\u0011\u0001?\u0007\r\u0005-\b\u0001RAw\u0011)\ty*\bBK\u0002\u0013\u0005\u00111 \u0005\u000b\u0003{l\"\u0011#Q\u0001\n\u0005\u0005\u0006BCA];\tU\r\u0011\"\u0001\u0002|\"Q\u0011q`\u000f\u0003\u0012\u0003\u0006I!!)\t\u0015\t\u0005QD!f\u0001\n\u0003\u0011\u0019\u0001\u0003\u0006\u0003\fu\u0011\t\u0012)A\u0005\u0005\u000bA!B!\u0004\u001e\u0005+\u0007I\u0011\u0001B\u0002\u0011)\u0011y!\bB\tB\u0003%!Q\u0001\u0005\u0007\u0019v!\tA!\u0005\t\u000f\tmQ\u0004\"\u0001\u0003\u001e!I!qF\u000f\u0002\u0002\u0013\u0005!\u0011\u0007\u0005\n\u0005wi\u0012\u0013!C\u0001\u0005{A\u0011B!\u0011\u001e#\u0003%\tA!\u0010\t\u0013\t\rS$%A\u0005\u0002\t\u0015\u0003\"\u0003B%;E\u0005I\u0011\u0001B#\u0011%\u0011Y%HA\u0001\n\u0003\u0012i\u0005\u0003\u0005\u0003Pu\t\t\u0011\"\u0001p\u0011%\u0011\t&HA\u0001\n\u0003\u0011\u0019\u0006C\u0005\u0003^u\t\t\u0011\"\u0011\u0003`!I!QN\u000f\u0002\u0002\u0013\u0005!q\u000e\u0005\n\u0005sj\u0012\u0011!C!\u0005wB\u0011B! \u001e\u0003\u0003%\tEa \t\u0013\t\u0005U$!A\u0005B\t\ru!\u0003Bc\u0001\u0005\u0005\t\u0012\u0002Bd\r%\tY\u000fAA\u0001\u0012\u0013\u0011I\r\u0003\u0004Mm\u0011\u0005!q\u001b\u0005\n\u0005{2\u0014\u0011!C#\u0005\u007fB\u0011B!77\u0003\u0003%\tIa7\t\u0013\t\u0015h'%A\u0005\u0002\t\u0015\u0003\"\u0003BtmE\u0005I\u0011\u0001B#\u0011%\u0011IONA\u0001\n\u0003\u0013Y\u000fC\u0005\u0003zZ\n\n\u0011\"\u0001\u0003F!I!1 \u001c\u0012\u0002\u0013\u0005!Q\t\u0002\u0017\u00072LWM\u001c;Rk>$\u0018-T1oC\u001e,'\u000fV3ti*\u0011\u0011IQ\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\r\u000bQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\rB\u0011qIS\u0007\u0002\u0011*\t\u0011*A\u0003tG\u0006d\u0017-\u0003\u0002L\u0011\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001(\u0011\u0005=\u0003Q\"\u0001!\u0002\tQLW.Z\u000b\u0002%B\u00111+X\u0007\u0002)*\u0011QKV\u0001\u0006kRLGn\u001d\u0006\u0003/b\u000baaY8n[>t'BA\"Z\u0015\tQ6,\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00029\u0006\u0019qN]4\n\u0005y#&\u0001C'pG.$\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0002\u000f5,GO]5dgV\t!\r\u0005\u0002dK6\tAM\u0003\u0002a-&\u0011a\r\u001a\u0002\b\u001b\u0016$(/[2t\u0003!iW\r\u001e:jGN\u0004\u0013AB2p]\u001aLw-F\u0001k!\ty5.\u0003\u0002m\u0001\nA2\t\\5f]R\fVo\u001c;b\u001b\u0006t\u0017mZ3s\u0007>tg-[4\u0002\u000f\r|gNZ5hA\u0005aa.^7DC2d'-Y2lgV\t\u0001\u000f\u0005\u0002Hc&\u0011!\u000f\u0013\u0002\u0004\u0013:$\u0018\u0001\u00058v[\u000e\u000bG\u000e\u001c2bG.\u001cx\fJ3r)\t)\b\u0010\u0005\u0002Hm&\u0011q\u000f\u0013\u0002\u0005+:LG\u000fC\u0004z\u0013\u0005\u0005\t\u0019\u00019\u0002\u0007a$\u0013'A\u0007ok6\u001c\u0015\r\u001c7cC\u000e\\7\u000fI\u0001\ti\u0016\f'\u000fR8x]R\tQ\u000f\u000b\u0002\f}B\u0019q0!\u0002\u000e\u0005\u0005\u0005!bAA\u00027\u0006)!.\u001e8ji&!\u0011qAA\u0001\u0005\u0015\te\r^3s\u0003!\u0019\u0017\r\u001c7cC\u000e\\GcA;\u0002\u000e!9\u0011q\u0002\u0007A\u0002\u0005E\u0011\u0001\u0003:fgB|gn]3\u0011\t\u0005M\u0011q\u0004\b\u0005\u0003+\tY\"\u0004\u0002\u0002\u0018)\u0019\u0011\u0011\u0004\"\u0002\u000f9,Go^8sW&!\u0011QDA\f\u00039\u0011V-];fgR\u001c\u0005.\u00198oK2LA!!\t\u0002$\tA!+Z:q_:\u001cXM\u0003\u0003\u0002\u001e\u0005]\u0011\u0001\u00042vS2$'+Z9vKN$X\u0003BA\u0015\u0003k!b!a\u000b\u0002T\u0005\u0015\u0004cB$\u0002.\u0005E\u0012QJ\u0005\u0004\u0003_A%A\u0002+va2,'\u0007\u0005\u0003\u00024\u0005UB\u0002\u0001\u0003\b\u0003oi!\u0019AA\u001d\u0005\u0005!\u0016\u0003BA\u001e\u0003\u0003\u00022aRA\u001f\u0013\r\ty\u0004\u0013\u0002\b\u001d>$\b.\u001b8h!\u0011\t\u0019%!\u0013\u000e\u0005\u0005\u0015#bAA$-\u0006A!/Z9vKN$8/\u0003\u0003\u0002L\u0005\u0015#aD!cgR\u0014\u0018m\u0019;SKF,Xm\u001d;\u0011\t\u0005M\u0011qJ\u0005\u0005\u0003#\n\u0019CA\u0004SKF,Xm\u001d;\t\u000f\u0005US\u00021\u0001\u0002X\u00059!-^5mI\u0016\u0014\bCBA-\u0003?\n\tD\u0004\u0003\u0002D\u0005m\u0013\u0002BA/\u0003\u000b\nq\"\u00112tiJ\f7\r\u001e*fcV,7\u000f^\u0005\u0005\u0003C\n\u0019GA\u0004Ck&dG-\u001a:\u000b\t\u0005u\u0013Q\t\u0005\n\u0003Oj\u0001\u0013!a\u0001\u0003S\nA\u0002\\5ti\u0016tWM\u001d(b[\u0016\u0004B!a\u001b\u0002p5\u0011\u0011Q\u000e\u0006\u0004\u000331\u0016\u0002BA9\u0003[\u0012A\u0002T5ti\u0016tWM\u001d(b[\u0016\faCY;jY\u0012\u0014V-];fgR$C-\u001a4bk2$HEM\u000b\u0005\u0003o\ni)\u0006\u0002\u0002z)\"\u0011\u0011NA>W\t\ti\b\u0005\u0003\u0002\u0000\u0005%UBAAA\u0015\u0011\t\u0019)!\"\u0002\u0013Ut7\r[3dW\u0016$'bAAD\u0011\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005-\u0015\u0011\u0011\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,GaBA\u001c\u001d\t\u0007\u0011\u0011H\u0001\f[\u0006L(-\u001a*fG>\u0014H\rF\u0005q\u0003'\u000bi*a.\u0002<\"9\u0011QS\bA\u0002\u0005]\u0015\u0001D9v_R\fW*\u00198bO\u0016\u0014\bcA(\u0002\u001a&\u0019\u00111\u0014!\u0003%\rc\u0017.\u001a8u#V|G/Y'b]\u0006<WM\u001d\u0005\b\u0003?{\u0001\u0019AAQ\u0003\u0011)8/\u001a:\u0011\t\u0005\r\u0016\u0011\u0017\b\u0005\u0003K\u000bi\u000bE\u0002\u0002(\"k!!!+\u000b\u0007\u0005-F)\u0001\u0004=e>|GOP\u0005\u0004\u0003_C\u0015A\u0002)sK\u0012,g-\u0003\u0003\u00024\u0006U&AB*ue&twMC\u0002\u00020\"Cq!!/\u0010\u0001\u0004\t\t+\u0001\u0005dY&,g\u000e^%e\u0011\u001d\til\u0004a\u0001\u0003\u007f\u000bQA^1mk\u0016\u00042aRAa\u0013\r\t\u0019\r\u0013\u0002\u0007\t>,(\r\\3\u0002\u0011QD'o\u001c;uY\u0016$2\"^Ae\u0003\u0017\fi-a4\u0002T\"9\u0011Q\u0013\tA\u0002\u0005]\u0005bBAP!\u0001\u0007\u0011\u0011\u0015\u0005\b\u0003s\u0003\u0002\u0019AAQ\u0011\u0019\t\t\u000e\u0005a\u0001a\u0006qA\u000f\u001b:piRdW\rV5nK6\u001b\bbBAk!\u0001\u0007\u0011q[\u0001\u001aG\"\fgN\\3m)\"\u0014x\u000e\u001e;mS:<7)\u00197mE\u0006\u001c7\u000e\u0005\u0004H\u00033\f\t\"^\u0005\u0004\u00037D%!\u0003$v]\u000e$\u0018n\u001c82\u0003A!Xm\u001d;Rk>$\u0018\rU1sg&tw\rF\u0006v\u0003C\f\u0019Oa\"\u0003\f\n=\u0005\"\u00025\u0012\u0001\u0004Q\u0007bBAs#\u0001\u0007\u0011q]\u0001\bG2LWM\u001c;2!\r\tI/H\u0007\u0002\u0001\tQQk]3s\u00072LWM\u001c;\u0014\ru1\u0015q^A{!\r9\u0015\u0011_\u0005\u0004\u0003gD%a\u0002)s_\u0012,8\r\u001e\t\u0004\u000f\u0006]\u0018bAA}\u0011\na1+\u001a:jC2L'0\u00192mKV\u0011\u0011\u0011U\u0001\u0006kN,'\u000fI\u0001\nG2LWM\u001c;JI\u0002\n!bY8oM&<Wk]3s+\t\u0011)\u0001E\u0003H\u0005\u000f\t\t+C\u0002\u0003\n!\u0013aa\u00149uS>t\u0017aC2p]\u001aLw-V:fe\u0002\nabY8oM&<7\t\\5f]RLE-A\bd_:4\u0017nZ\"mS\u0016tG/\u00133!))\t9Oa\u0005\u0003\u0016\t]!\u0011\u0004\u0005\b\u0003?3\u0003\u0019AAQ\u0011\u001d\tIL\na\u0001\u0003CC\u0011B!\u0001'!\u0003\u0005\rA!\u0002\t\u0013\t5a\u0005%AA\u0002\t\u0015\u0011aF:b]&$\u0018N_3e\u0007>tg-[4DY&,g\u000e^%e+\t\u0011y\u0002E\u0003H\u0005\u000f\u0011\t\u0003\u0005\u0003\u0003$\t5RB\u0001B\u0013\u0015\u0011\u00119C!\u000b\u0002\t1\fgn\u001a\u0006\u0003\u0005W\tAA[1wC&!\u00111\u0017B\u0013\u0003\u0011\u0019w\u000e]=\u0015\u0015\u0005\u001d(1\u0007B\u001b\u0005o\u0011I\u0004C\u0005\u0002 \"\u0002\n\u00111\u0001\u0002\"\"I\u0011\u0011\u0018\u0015\u0011\u0002\u0003\u0007\u0011\u0011\u0015\u0005\n\u0005\u0003A\u0003\u0013!a\u0001\u0005\u000bA\u0011B!\u0004)!\u0003\u0005\rA!\u0002\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!q\b\u0016\u0005\u0003C\u000bY(\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!q\t\u0016\u0005\u0005\u000b\tY(\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\u0011\t#\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\tU#1\f\t\u0004\u000f\n]\u0013b\u0001B-\u0011\n\u0019\u0011I\\=\t\u000fe|\u0013\u0011!a\u0001a\u0006y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003bA1!1\rB5\u0005+j!A!\u001a\u000b\u0007\t\u001d\u0004*\u0001\u0006d_2dWm\u0019;j_:LAAa\u001b\u0003f\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\u0011\tHa\u001e\u0011\u0007\u001d\u0013\u0019(C\u0002\u0003v!\u0013qAQ8pY\u0016\fg\u000e\u0003\u0005zc\u0005\u0005\t\u0019\u0001B+\u0003!A\u0017m\u001d5D_\u0012,G#\u00019\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"A!\t\u0002\r\u0015\fX/\u00197t)\u0011\u0011\tH!\"\t\u0011e$\u0014\u0011!a\u0001\u0005+BqA!#\u0012\u0001\u0004\t9/A\u0004dY&,g\u000e\u001e\u001a\t\u000f\t5\u0015\u00031\u0001\u0002h\u0006a!/\u00198e_6\u001cE.[3oi\"9!\u0011S\tA\u0002\u0005\u001d\u0018a\u00053fM\u0006,H\u000e^\"p]\u001aLwm\u00117jK:$\u0018\u0001\u0007;fgR\u001cE.[3oi&#\u0017+^8uCB\u000b'o]5oO\"\u001a!Ca&\u0011\u0007}\u0014I*\u0003\u0003\u0003\u001c\u0006\u0005!\u0001\u0002+fgR\fA\u0003^3tiV\u001bXM])v_R\f\u0007+\u0019:tS:<\u0007fA\n\u0003\u0018\u0006aB/Z:u+N,'o\u00117jK:$\u0018\nZ)v_R\f\u0007+\u0019:tS:<\u0007f\u0001\u000b\u0003\u0018\u0006aC/Z:u+N,'/U;pi\u0006\u0004\u0016M]:j]\u001e<\u0016\u000e\u001e5EK\u001a\fW\u000f\u001c;DY&,g\u000e^%e#V|G/\u0019\u0015\u0004+\t]\u0015\u0001\u000e;fgR,6/\u001a:DY&,g\u000e^)v_R\f\u0007+\u0019:tS:<\u0017\nZ,ji\"$UMZ1vYR\u001cE.[3oi&#\u0017+^8uC\"\u001aaCa&\u00023Q,7\u000f^)v_R\f7i\u001c8gS\u001e\u0004&/Z2fI\u0016t7-\u001a\u0015\u0004/\t]\u0015A\u0005;fgR\fVo\u001c;b-&|G.\u0019;j_:D3\u0001\u0007BL\u0003\r\"Xm\u001d;SKF,Xm\u001d;QKJ\u001cWM\u001c;bO\u0016\fVo\u001c;b-&|G.\u0019;j_:D3!\u0007BL\u0003q!Xm\u001d;FqBL'/\u001a+ie>$H\u000f\\3US6,7+\u001a8t_JD3A\u0007BL\u0003Y!Xm\u001d;FqBL'/Z)v_R\f7+\u001a8t_J\u001c\bfA\u000e\u0003\u0018\u0006AB/Z:u\u00072LWM\u001c;JI:{GoU1oSRL'0\u001a3)\u0007q\u00119*\u0001\u0006Vg\u0016\u00148\t\\5f]R\u00042!!;7'\u00151$1ZA{!9\u0011iMa5\u0002\"\u0006\u0005&Q\u0001B\u0003\u0003Ol!Aa4\u000b\u0007\tE\u0007*A\u0004sk:$\u0018.\\3\n\t\tU'q\u001a\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:$DC\u0001Bd\u0003\u0015\t\u0007\u000f\u001d7z))\t9O!8\u0003`\n\u0005(1\u001d\u0005\b\u0003?K\u0004\u0019AAQ\u0011\u001d\tI,\u000fa\u0001\u0003CC\u0011B!\u0001:!\u0003\u0005\rA!\u0002\t\u0013\t5\u0011\b%AA\u0002\t\u0015\u0011aD1qa2LH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIQ\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003n\nU\b#B$\u0003\b\t=\bcC$\u0003r\u0006\u0005\u0016\u0011\u0015B\u0003\u0005\u000bI1Aa=I\u0005\u0019!V\u000f\u001d7fi!I!q\u001f\u001f\u0002\u0002\u0003\u0007\u0011q]\u0001\u0004q\u0012\u0002\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005\u000e")
public class ClientQuotaManagerTest {
    private volatile ClientQuotaManagerTest$UserClient$ UserClient$module;
    private final MockTime time = new MockTime();
    private final Metrics metrics = new Metrics(new MetricConfig(), Collections.emptyList(), (Time)this.time());
    private final ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(500L, ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3());
    private int numCallbacks = 0;

    private ClientQuotaManagerTest$UserClient$ UserClient() {
        if (this.UserClient$module == null) {
            this.UserClient$lzycompute$1();
        }
        return this.UserClient$module;
    }

    private MockTime time() {
        return this.time;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private ClientQuotaManagerConfig config() {
        return this.config;
    }

    public int numCallbacks() {
        return this.numCallbacks;
    }

    public void numCallbacks_$eq(int x$1) {
        this.numCallbacks = x$1;
    }

    @After
    public void tearDown() {
        this.metrics().close();
    }

    public void callback(RequestChannel.Response response) {
        RequestChannel.Response response2 = response;
        if (response2 instanceof RequestChannel.StartThrottlingResponse) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (response2 instanceof RequestChannel.EndThrottlingResponse) {
            this.numCallbacks_$eq(this.numCallbacks() + 1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)response2);
        }
    }

    private <T extends AbstractRequest> Tuple2<T, RequestChannel.Request> buildRequest(AbstractRequest.Builder<T> builder, ListenerName listenerName) {
        AbstractRequest request = builder.build();
        ByteBuffer buffer = request.serialize(new RequestHeader(builder.apiKey(), request.version(), "", 0));
        RequestChannel.Metrics requestChannelMetrics = (RequestChannel.Metrics)EasyMock.createNiceMock(RequestChannel.Metrics.class);
        RequestHeader header = RequestHeader.parse((ByteBuffer)buffer);
        RequestContext context = new RequestContext(header, "1", InetAddress.getLocalHost(), KafkaPrincipal.ANONYMOUS, listenerName, SecurityProtocol.PLAINTEXT);
        return new Tuple2((Object)request, (Object)new RequestChannel.Request(1, context, 0L, MemoryPool.NONE, buffer, requestChannelMetrics));
    }

    private <T extends AbstractRequest> ListenerName buildRequest$default$2() {
        return ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
    }

    private int maybeRecord(ClientQuotaManager quotaManager, String user, String clientId, double value) {
        KafkaPrincipal principal = new KafkaPrincipal("User", user);
        return quotaManager.maybeRecordAndGetThrottleTimeMs(new RequestChannel.Session(principal, null), clientId, value, this.time().milliseconds());
    }

    private void throttle(ClientQuotaManager quotaManager, String user, String clientId, int throttleTimeMs, Function1<RequestChannel.Response, BoxedUnit> channelThrottlingCallback) {
        RequestChannel.Request request;
        Tuple2 tuple2 = this.buildRequest((AbstractRequest.Builder)FetchRequest.Builder.forConsumer((int)0, (int)1000, new HashMap()), this.buildRequest$default$2());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        RequestChannel.Request request2 = request = (RequestChannel.Request)tuple2._2();
        RequestChannel.Request request3 = request2;
        quotaManager.throttle(request3, throttleTimeMs, channelThrottlingCallback);
    }

    private void testQuotaParsing(ClientQuotaManagerConfig config, UserClient client1, UserClient client2, UserClient randomClient, UserClient defaultConfigClient) {
        ClientQuotaManager clientMetrics = new ClientQuotaManager(config, this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6());
        try {
            clientMetrics.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(2000.0, true)));
            clientMetrics.updateQuota(client2.configUser(), client2.configClientId(), client2.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(4000.0, true)));
            Assert.assertEquals((String)new StringBuilder(33).append("Default producer quota should be ").append(config.quotaBytesPerSecondDefault()).toString(), (double)config.quotaBytesPerSecondDefault(), (double)clientMetrics.quota(randomClient.user(), randomClient.clientId()).bound(), (double)0.0);
            Assert.assertEquals((String)"Should return the overridden value (2000)", (double)2000.0, (double)clientMetrics.quota(client1.user(), client1.clientId()).bound(), (double)0.0);
            Assert.assertEquals((String)"Should return the overridden value (4000)", (double)4000.0, (double)clientMetrics.quota(client2.user(), client2.clientId()).bound(), (double)0.0);
            int throttleTimeMs = this.maybeRecord(clientMetrics, client1.user(), client1.clientId(), 2500 * config.numQuotaSamples());
            Assert.assertTrue((String)new StringBuilder(34).append("throttleTimeMs should be > 0. was ").append(throttleTimeMs).toString(), (throttleTimeMs > 0 ? 1 : 0) != 0);
            clientMetrics.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(3000.0, true)));
            Assert.assertEquals((String)"Should return the newly overridden value (3000)", (double)3000.0, (double)clientMetrics.quota(client1.user(), client1.clientId()).bound(), (double)0.0);
            throttleTimeMs = this.maybeRecord(clientMetrics, client1.user(), client1.clientId(), 0.0);
            Assert.assertEquals((String)new StringBuilder(32).append("throttleTimeMs should be 0. was ").append(throttleTimeMs).toString(), (long)0L, (long)throttleTimeMs);
            clientMetrics.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(500.0, true)));
            Assert.assertEquals((String)"Should return the default value (500)", (double)500.0, (double)clientMetrics.quota(client1.user(), client1.clientId()).bound(), (double)0.0);
            throttleTimeMs = this.maybeRecord(clientMetrics, client1.user(), client1.clientId(), 0.0);
            Assert.assertTrue((String)new StringBuilder(34).append("throttleTimeMs should be > 0. was ").append(throttleTimeMs).toString(), (throttleTimeMs > 0 ? 1 : 0) != 0);
            clientMetrics.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)None$.MODULE$);
            clientMetrics.updateQuota(defaultConfigClient.configUser(), defaultConfigClient.configClientId(), defaultConfigClient.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(4000.0, true)));
            Assert.assertEquals((String)"Should return the newly overridden value (4000)", (double)4000.0, (double)clientMetrics.quota(client1.user(), client1.clientId()).bound(), (double)0.0);
            throttleTimeMs = this.maybeRecord(clientMetrics, client1.user(), client1.clientId(), 1000 * config.numQuotaSamples());
            Assert.assertEquals((String)new StringBuilder(32).append("throttleTimeMs should be 0. was ").append(throttleTimeMs).toString(), (long)0L, (long)throttleTimeMs);
        }
        finally {
            clientMetrics.shutdown();
        }
    }

    @Test
    public void testClientIdQuotaParsing() {
        UserClient client1 = new UserClient(this, "ANONYMOUS", "p1", (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)"p1"));
        UserClient client2 = new UserClient(this, "ANONYMOUS", "p2", (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)"p2"));
        UserClient randomClient = new UserClient(this, "ANONYMOUS", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
        this.testQuotaParsing(this.config(), client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserQuotaParsing() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)None$.MODULE$);
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)None$.MODULE$);
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)None$.MODULE$);
        ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(Long.MAX_VALUE, ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3());
        this.testQuotaParsing(config, client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserClientIdQuotaParsing() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)new Some((Object)"p1"));
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)new Some((Object)"p2"));
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
        ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(Long.MAX_VALUE, ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3());
        this.testQuotaParsing(config, client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserQuotaParsingWithDefaultClientIdQuota() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)None$.MODULE$);
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)None$.MODULE$);
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)None$.MODULE$);
        this.testQuotaParsing(this.config(), client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserClientQuotaParsingIdWithDefaultClientIdQuota() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)new Some((Object)"p1"));
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)new Some((Object)"p2"));
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
        this.testQuotaParsing(this.config(), client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testQuotaConfigPrecedence() {
        ClientQuotaManager quotaManager = new ClientQuotaManager(new ClientQuotaManagerConfig(Long.MAX_VALUE, ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3()), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6());
        try {
            quotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(1000.0, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(2000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(3000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(4000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(5000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userB"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(6000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userB"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(7000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userB"), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(8000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userC"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(10000.0, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(9000.0, true)));
            this.checkQuota$1("userA", "client1", 5000, 4500, false, quotaManager);
            this.checkQuota$1("userA", "client2", 4000, 4500, true, quotaManager);
            this.checkQuota$1("userA", "client3", 4000, 0, true, quotaManager);
            this.checkQuota$1("userA", "client1", 5000, 0, false, quotaManager);
            this.checkQuota$1("userB", "client1", 7000, 8000, true, quotaManager);
            this.checkQuota$1("userB", "client2", 8000, 7000, false, quotaManager);
            this.checkQuota$1("userB", "client3", 8000, 7000, false, quotaManager);
            this.checkQuota$1("userD", "client1", 3000, 3500, true, quotaManager);
            this.checkQuota$1("userD", "client2", 3000, 2500, false, quotaManager);
            this.checkQuota$1("userE", "client1", 3000, 2500, false, quotaManager);
            quotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$);
            this.checkQuota$1("userD", "client1", 1000, 0, false, quotaManager);
            this.checkQuota$1("userE", "client4", 1000, 1500, true, quotaManager);
            this.checkQuota$1("userF", "client4", 1000, 800, false, quotaManager);
            this.checkQuota$1("userF", "client5", 1000, 800, true, quotaManager);
            quotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
            this.checkQuota$1("userF", "client4", 2000, 0, false, quotaManager);
            this.checkQuota$1("userF", "client5", 2000, 0, false, quotaManager);
            this.checkQuota$1("userF", "client5", 2000, 2500, true, quotaManager);
            this.checkQuota$1("userG", "client5", 2000, 0, true, quotaManager);
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(8000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(10000.0, true)));
            this.checkQuota$1("userA", "client2", 8000, 0, false, quotaManager);
            this.checkQuota$1("userA", "client2", 8000, 4500, true, quotaManager);
            this.checkQuota$1("userA", "client1", 10000, 0, false, quotaManager);
            this.checkQuota$1("userA", "client1", 10000, 6000, true, quotaManager);
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)None$.MODULE$);
            this.checkQuota$1("userA", "client6", 8000, 0, true, quotaManager);
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client6"), (Option)new Some((Object)"client6"), (Option)new Some((Object)new Quota(11000.0, true)));
            this.checkQuota$1("userA", "client6", 11000, 8500, false, quotaManager);
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(12000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client6"), (Option)new Some((Object)"client6"), (Option)None$.MODULE$);
            this.checkQuota$1("userA", "client6", 12000, 4000, true, quotaManager);
        }
        finally {
            quotaManager.shutdown();
        }
    }

    @Test
    public void testQuotaViolation() {
        ClientQuotaManager clientMetrics = new ClientQuotaManager(this.config(), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6());
        KafkaMetric queueSizeMetric = (KafkaMetric)this.metrics().metrics().get(this.metrics().metricName("queue-size", "Produce", ""));
        try {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                Assert.assertEquals((long)0L, (long)this.maybeRecord(clientMetrics, "ANONYMOUS", "unknown", 400.0));
                this.time().sleep(1000L);
            });
            Assert.assertEquals((long)0L, (long)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            this.time().sleep(500L);
            int sleepTime = this.maybeRecord(clientMetrics, "ANONYMOUS", "unknown", 2300.0);
            Assert.assertEquals((String)"Should be throttled", (long)2100L, (long)sleepTime);
            this.throttle(clientMetrics, "ANONYMOYUS", "unknown", sleepTime, (Function1<RequestChannel.Response, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
                this.callback(response);
                return BoxedUnit.UNIT;
            });
            Assert.assertEquals((long)1L, (long)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            clientMetrics.throttledChannelReaper().doWork();
            Assert.assertEquals((long)0L, (long)this.numCallbacks());
            this.time().sleep((long)sleepTime);
            clientMetrics.throttledChannelReaper().doWork();
            Assert.assertEquals((long)0L, (long)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            Assert.assertEquals((long)1L, (long)this.numCallbacks());
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                this.maybeRecord(clientMetrics, "ANONYMOUS", "unknown", 400.0);
                this.time().sleep(1000L);
            });
            Assert.assertEquals((String)"Should be unthrottled since bursty sample has rolled over", (long)0L, (long)this.maybeRecord(clientMetrics, "ANONYMOUS", "unknown", 0.0));
        }
        finally {
            clientMetrics.shutdown();
        }
    }

    @Test
    public void testRequestPercentageQuotaViolation() {
        ClientRequestQuotaManager quotaManager = new ClientRequestQuotaManager(this.config(), this.metrics(), (Time)this.time(), "", (Option)None$.MODULE$);
        quotaManager.updateQuota((Option)new Some((Object)"ANONYMOUS"), (Option)new Some((Object)"test-client"), (Option)new Some((Object)"test-client"), (Option)new Some((Object)Quota.upperBound((double)1.0)));
        KafkaMetric queueSizeMetric = (KafkaMetric)this.metrics().metrics().get(this.metrics().metricName("queue-size", "Request", ""));
        try {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                Assert.assertEquals((long)0L, (long)this.maybeRecord((ClientQuotaManager)quotaManager, "ANONYMOUS", "test-client", ClientQuotaManagerTest.millisToPercent$1(4.0)));
                this.time().sleep(1000L);
            });
            Assert.assertEquals((long)0L, (long)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            this.time().sleep(500L);
            int throttleTime = this.maybeRecord((ClientQuotaManager)quotaManager, "ANONYMOUS", "test-client", ClientQuotaManagerTest.millisToPercent$1(67.1));
            Assert.assertEquals((String)"Should be throttled", (long)210L, (long)throttleTime);
            this.throttle((ClientQuotaManager)quotaManager, "ANONYMOYUS", "test-client", throttleTime, (Function1<RequestChannel.Response, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
                this.callback(response);
                return BoxedUnit.UNIT;
            });
            Assert.assertEquals((long)1L, (long)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            quotaManager.throttledChannelReaper().doWork();
            Assert.assertEquals((long)0L, (long)this.numCallbacks());
            this.time().sleep((long)throttleTime);
            quotaManager.throttledChannelReaper().doWork();
            Assert.assertEquals((long)0L, (long)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            Assert.assertEquals((long)1L, (long)this.numCallbacks());
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 11).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                this.maybeRecord((ClientQuotaManager)quotaManager, "ANONYMOUS", "test-client", ClientQuotaManagerTest.millisToPercent$1(4.0));
                this.time().sleep(1000L);
            });
            Assert.assertEquals((String)"Should be unthrottled since bursty sample has rolled over", (long)0L, (long)this.maybeRecord((ClientQuotaManager)quotaManager, "ANONYMOUS", "test-client", 0.0));
            Assert.assertEquals((long)1000L, (long)this.maybeRecord((ClientQuotaManager)quotaManager, "ANONYMOUS", "test-client", ClientQuotaManagerTest.millisToPercent$1(500.0)));
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                this.time().sleep(1000L);
                Assert.assertEquals((long)1000L, (long)this.maybeRecord((ClientQuotaManager)quotaManager, "ANONYMOUS", "test-client", 0.0));
            });
            this.time().sleep(1000L);
            Assert.assertEquals((String)"Should be unthrottled since bursty sample has rolled over", (long)0L, (long)this.maybeRecord((ClientQuotaManager)quotaManager, "ANONYMOUS", "test-client", 0.0));
        }
        finally {
            quotaManager.shutdown();
        }
    }

    @Test
    public void testExpireThrottleTimeSensor() {
        ClientQuotaManager clientMetrics = new ClientQuotaManager(this.config(), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6());
        try {
            this.maybeRecord(clientMetrics, "ANONYMOUS", "client1", 100.0);
            this.metrics().removeSensor("ProduceThrottleTime-:client1");
            int throttleTime = this.maybeRecord(clientMetrics, "ANONYMOUS", "client1", 10000.0);
            Assert.assertTrue((String)"Should be throttled", (throttleTime > 0 ? 1 : 0) != 0);
            Sensor throttleTimeSensor = this.metrics().getSensor("ProduceThrottleTime-:client1");
            Assert.assertTrue((String)"Throttle time sensor should exist", (throttleTimeSensor != null ? 1 : 0) != 0);
            Assert.assertTrue((String)"Throttle time sensor should exist", (throttleTimeSensor != null ? 1 : 0) != 0);
        }
        finally {
            clientMetrics.shutdown();
        }
    }

    @Test
    public void testExpireQuotaSensors() {
        ClientQuotaManager clientMetrics = new ClientQuotaManager(this.config(), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6());
        try {
            this.maybeRecord(clientMetrics, "ANONYMOUS", "client1", 100.0);
            this.metrics().removeSensor("ProduceThrottleTime-:client1");
            this.metrics().removeSensor("Produce-ANONYMOUS:client1");
            int throttleTime = this.maybeRecord(clientMetrics, "ANONYMOUS", "client1", 10000.0);
            Assert.assertTrue((String)"Should be throttled", (throttleTime > 0 ? 1 : 0) != 0);
            Sensor throttleTimeSensor = this.metrics().getSensor("ProduceThrottleTime-:client1");
            Assert.assertTrue((String)"Throttle time sensor should exist", (throttleTimeSensor != null ? 1 : 0) != 0);
            Sensor byteRateSensor = this.metrics().getSensor("Produce-:client1");
            Assert.assertTrue((String)"Byte rate sensor should exist", (byteRateSensor != null ? 1 : 0) != 0);
        }
        finally {
            clientMetrics.shutdown();
        }
    }

    @Test
    public void testClientIdNotSanitized() {
        ClientQuotaManager clientMetrics = new ClientQuotaManager(this.config(), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6());
        String clientId = "client@#$%";
        try {
            this.maybeRecord(clientMetrics, "ANONYMOUS", clientId, 100.0);
            Sensor throttleTimeSensor = this.metrics().getSensor(new StringBuilder(21).append("ProduceThrottleTime-:").append(clientId).toString());
            Assert.assertTrue((String)"Throttle time sensor should exist", (throttleTimeSensor != null ? 1 : 0) != 0);
            Sensor byteRateSensor = this.metrics().getSensor(new StringBuilder(9).append("Produce-:").append(clientId).toString());
            Assert.assertTrue((String)"Byte rate sensor should exist", (byteRateSensor != null ? 1 : 0) != 0);
        }
        finally {
            clientMetrics.shutdown();
        }
    }

    private final void UserClient$lzycompute$1() {
        ClientQuotaManagerTest clientQuotaManagerTest = this;
        synchronized (clientQuotaManagerTest) {
            if (this.UserClient$module == null) {
                this.UserClient$module = new ClientQuotaManagerTest$UserClient$(this);
            }
        }
    }

    private final void checkQuota$1(String user, String clientId, int expectedBound, int value, boolean expectThrottle, ClientQuotaManager quotaManager$1) {
        Assert.assertEquals((double)expectedBound, (double)quotaManager$1.quota(user, clientId).bound(), (double)0.0);
        int throttleTimeMs = this.maybeRecord(quotaManager$1, user, clientId, value * this.config().numQuotaSamples());
        if (expectThrottle) {
            Assert.assertTrue((String)new StringBuilder(34).append("throttleTimeMs should be > 0. was ").append(throttleTimeMs).toString(), (throttleTimeMs > 0 ? 1 : 0) != 0);
        } else {
            Assert.assertEquals((String)new StringBuilder(32).append("throttleTimeMs should be 0. was ").append(throttleTimeMs).toString(), (long)0L, (long)throttleTimeMs);
        }
    }

    private static final double millisToPercent$1(double millis) {
        return millis * (double)1000 * (double)1000 * ClientQuotaManagerConfig$.MODULE$.NanosToPercentagePerSecond();
    }

    public class UserClient
    implements Product,
    scala.Serializable {
        private final String user;
        private final String clientId;
        private final Option<String> configUser;
        private final Option<String> configClientId;
        public final /* synthetic */ ClientQuotaManagerTest $outer;

        public String user() {
            return this.user;
        }

        public String clientId() {
            return this.clientId;
        }

        public Option<String> configUser() {
            return this.configUser;
        }

        public Option<String> configClientId() {
            return this.configClientId;
        }

        public Option<String> sanitizedConfigClientId() {
            return this.configClientId().map((Function1 & Serializable & scala.Serializable)x -> {
                String string = x;
                String string2 = ConfigEntityName$.MODULE$.Default();
                return !(string != null ? !string.equals(string2) : string2 != null) ? ConfigEntityName$.MODULE$.Default() : Sanitizer.sanitize((String)x);
            });
        }

        public UserClient copy(String user, String clientId, Option<String> configUser, Option<String> configClientId) {
            return new UserClient(this.kafka$server$ClientQuotaManagerTest$UserClient$$$outer(), user, clientId, configUser, configClientId);
        }

        public String copy$default$1() {
            return this.user();
        }

        public String copy$default$2() {
            return this.clientId();
        }

        public Option<String> copy$default$3() {
            return this.configUser();
        }

        public Option<String> copy$default$4() {
            return this.configClientId();
        }

        public String productPrefix() {
            return "UserClient";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            Option<String> option;
            int n = x$1;
            switch (n) {
                case 0: {
                    option = this.user();
                    break;
                }
                case 1: {
                    option = this.clientId();
                    break;
                }
                case 2: {
                    option = this.configUser();
                    break;
                }
                case 3: {
                    option = this.configClientId();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return option;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof UserClient;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof UserClient)) return false;
            if (((UserClient)object).kafka$server$ClientQuotaManagerTest$UserClient$$$outer() != this.kafka$server$ClientQuotaManagerTest$UserClient$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            UserClient userClient = (UserClient)x$1;
            String string = this.user();
            String string2 = userClient.user();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.clientId();
            String string4 = userClient.clientId();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            Option<String> option = this.configUser();
            Option<String> option2 = userClient.configUser();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<String> option3 = this.configClientId();
            Option<String> option4 = userClient.configClientId();
            if (option3 == null) {
                if (option4 != null) {
                    return false;
                }
            } else if (!option3.equals(option4)) return false;
            if (!userClient.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ ClientQuotaManagerTest kafka$server$ClientQuotaManagerTest$UserClient$$$outer() {
            return this.$outer;
        }

        public UserClient(ClientQuotaManagerTest $outer, String user, String clientId, Option<String> configUser, Option<String> configClientId) {
            this.user = user;
            this.clientId = clientId;
            this.configUser = configUser;
            this.configClientId = configClientId;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

