/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import kafka.server.DelayedFuture;
import kafka.server.DelayedFuturePurgatory;
import kafka.server.DelayedOperation;
import kafka.server.DelayedOperationPurgatory;
import kafka.server.DelayedOperationPurgatory$;
import kafka.server.DelayedOperationTest;
import kafka.server.DelayedOperationTest$MockDelayedOperation$;
import kafka.utils.CoreUtils$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.utils.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Set$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005Ef\u0001\u0002\u0015*\u00019BQ!\u000e\u0001\u0005\u0002YBq!\u000f\u0001A\u0002\u0013\u0005!\bC\u0004u\u0001\u0001\u0007I\u0011A;\t\r]\u0004\u0001\u0015)\u0003<\u0011\u001dA\b\u00011A\u0005\u0002eDqA \u0001A\u0002\u0013\u0005q\u0010C\u0004\u0002\u0004\u0001\u0001\u000b\u0015\u0002>\t\r\u0005\u0015\u0001\u0001\"\u0001p\u0011\u0019\tI\u0002\u0001C\u0001_\"1\u00111\u0005\u0001\u0005\u0002=Da!!\f\u0001\t\u0003y\u0007BBA\u0019\u0001\u0011\u0005q\u000e\u0003\u0004\u00026\u0001!\ta\u001c\u0005\u0007\u0003s\u0001A\u0011A8\t\r\u0005u\u0002\u0001\"\u0001p\u0011\u0019\t\t\u0005\u0001C\u0001_\"1\u0011Q\t\u0001\u0005\u0002=Da!!\u0013\u0001\t\u0003y\u0007BBA'\u0001\u0011\u0005q\u000eC\u0004\u0002R\u0001!\t!a\u0015\t\u000f\u0005\r\u0004\u0001\"\u0003\u0002f\u0019!\u0001\t\u0001\u0001B\u0011%)eC!A!\u0002\u00131\u0015\n\u0003\u0005K-\t\u0005\t\u0015!\u0003L\u0011!QfC!b\u0001\n\u0003Y\u0006\u0002\u0003/\u0017\u0005\u0003\u0005\u000b\u0011B&\t\u000bU2B\u0011A/\t\u000f\u00054\u0002\u0019!C\u0001E\"9aM\u0006a\u0001\n\u00039\u0007BB7\u0017A\u0003&1\rC\u0003o-\u0011\u0005q\u000eC\u0003q-\u0011\u0005\u0013\u000fC\u0003s-\u0011\u0005s\u000eC\u0003t-\u0011\u0005snB\u0005\u0002\u0010\u0002\t\t\u0011#\u0001\u0002\u0012\u001aA\u0001\tAA\u0001\u0012\u0003\t\u0019\n\u0003\u00046I\u0011\u0005\u0011Q\u0013\u0005\n\u0003/#\u0013\u0013!C\u0001\u00033C\u0011\"a,%#\u0003%\t!!'\u0003)\u0011+G.Y=fI>\u0003XM]1uS>tG+Z:u\u0015\tQ3&\u0001\u0004tKJ4XM\u001d\u0006\u0002Y\u0005)1.\u00194lC\u000e\u00011C\u0001\u00010!\t\u00014'D\u00012\u0015\u0005\u0011\u0014!B:dC2\f\u0017B\u0001\u001b2\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012a\u000e\t\u0003q\u0001i\u0011!K\u0001\naV\u0014x-\u0019;pef,\u0012a\u000f\t\u0004qqr\u0014BA\u001f*\u0005e!U\r\\1zK\u0012|\u0005/\u001a:bi&|g\u000eU;sO\u0006$xN]=\u0011\u0005}2R\"\u0001\u0001\u0003)5{7m\u001b#fY\u0006LX\rZ(qKJ\fG/[8o'\t1\"\t\u0005\u00029\u0007&\u0011A)\u000b\u0002\u0011\t\u0016d\u0017-_3e\u001fB,'/\u0019;j_:\fq\u0001Z3mCfl5\u000f\u0005\u00021\u000f&\u0011\u0001*\r\u0002\u0005\u0019>tw-\u0003\u0002F\u0007\u00069An\\2l\u001fB$\bc\u0001\u0019M\u001d&\u0011Q*\r\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005=CV\"\u0001)\u000b\u0005E\u0013\u0016!\u00027pG.\u001c(BA*U\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003+Z\u000bA!\u001e;jY*\tq+\u0001\u0003kCZ\f\u0017BA-Q\u00055\u0011V-\u001a8ue\u0006tG\u000fT8dW\u0006y!/Z:q_:\u001cX\rT8dW>\u0003H/F\u0001L\u0003A\u0011Xm\u001d9p]N,Gj\\2l\u001fB$\b\u0005\u0006\u0003?=~\u0003\u0007\"B#\u001c\u0001\u00041\u0005b\u0002&\u001c!\u0003\u0005\ra\u0013\u0005\b5n\u0001\n\u00111\u0001L\u0003-\u0019w.\u001c9mKR\f'\r\\3\u0016\u0003\r\u0004\"\u0001\r3\n\u0005\u0015\f$a\u0002\"p_2,\u0017M\\\u0001\u0010G>l\u0007\u000f\\3uC\ndWm\u0018\u0013fcR\u0011\u0001n\u001b\t\u0003a%L!A[\u0019\u0003\tUs\u0017\u000e\u001e\u0005\bYv\t\t\u00111\u0001d\u0003\rAH%M\u0001\rG>l\u0007\u000f\\3uC\ndW\rI\u0001\u0010C^\f\u0017\u000e^#ya&\u0014\u0018\r^5p]R\t\u0001.A\u0006uef\u001cu.\u001c9mKR,G#A2\u0002\u0019=tW\t\u001f9je\u0006$\u0018n\u001c8\u0002\u0015=t7i\\7qY\u0016$X-A\u0007qkJ<\u0017\r^8ss~#S-\u001d\u000b\u0003QZDq\u0001\\\u0002\u0002\u0002\u0003\u00071(\u0001\u0006qkJ<\u0017\r^8ss\u0002\nq\"\u001a=fGV$xN]*feZL7-Z\u000b\u0002uB\u00111\u0010`\u0007\u0002%&\u0011QP\u0015\u0002\u0010\u000bb,7-\u001e;peN+'O^5dK\u0006\u0019R\r_3dkR|'oU3sm&\u001cWm\u0018\u0013fcR\u0019\u0001.!\u0001\t\u000f14\u0011\u0011!a\u0001u\u0006\u0001R\r_3dkR|'oU3sm&\u001cW\rI\u0001\u0006g\u0016$X\u000b\u001d\u0015\u0004\u0011\u0005%\u0001\u0003BA\u0006\u0003+i!!!\u0004\u000b\t\u0005=\u0011\u0011C\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0003\u0003'\t1a\u001c:h\u0013\u0011\t9\"!\u0004\u0003\r\t+gm\u001c:f\u0003!!X-\u0019:E_^t\u0007fA\u0005\u0002\u001eA!\u00111BA\u0010\u0013\u0011\t\t#!\u0004\u0003\u000b\u00053G/\u001a:\u0002/Q,7\u000f\u001e*fcV,7\u000f^*bi&\u001ch-Y2uS>t\u0007f\u0001\u0006\u0002(A!\u00111BA\u0015\u0013\u0011\tY#!\u0004\u0003\tQ+7\u000f^\u0001\u0012i\u0016\u001cHOU3rk\u0016\u001cH/\u0012=qSJL\bfA\u0006\u0002(\u0005\tB/Z:u\t\u0016d\u0017-_3e\rV$XO]3)\u00071\t9#\u0001\tuKN$(+Z9vKN$\b+\u001e:hK\"\u001aQ\"a\n\u0002]MDw.\u001e7e\u0007\u0006t7-\u001a7G_J\\U-\u001f*fiV\u0014h.\u001b8h\u0007\u0006t7-\u001a7mK\u0012|\u0005/\u001a:bi&|gn\u001d\u0015\u0004\u001d\u0005\u001d\u0012!O:i_VdGMU3ukJtg*\u001b7Pa\u0016\u0014\u0018\r^5p]N|enQ1oG\u0016dgi\u001c:LKf<\u0006.\u001a8LKf$u.Z:oi\u0016C\u0018n\u001d;)\u0007=\t9#A\u000fuKN$HK]=D_6\u0004H.\u001a;f\u0019>\u001c7nQ8oi\u0016tG/[8oQ\r\u0001\u0012qE\u0001#i\u0016\u001cH\u000f\u0016:z\u0007>l\u0007\u000f\\3uK^KG\u000f['vYRL\u0007\u000f\\3UQJ,\u0017\rZ:)\u0007E\t9#\u0001\ruKN$H)\u001a7bs\u0016$w\n]3sCRLwN\u001c'pG.D3AEA\u0014\u0003\u0001\"Xm\u001d;EK2\f\u00170\u001a3Pa\u0016\u0014\u0018\r^5p]2{7m[(wKJ\u0014\u0018\u000eZ3)\u0007M\t9#\u0001\u000ewKJLg-\u001f#fY\u0006LX\rZ(qKJ\fG/[8o\u0019>\u001c7\u000eF\u0003i\u0003+\ny\u0006\u0003\u0005\u0002XQ!\t\u0019AA-\u0003QiwnY6EK2\f\u00170\u001a3Pa\u0016\u0014\u0018\r^5p]B!\u0001'a\u0017?\u0013\r\ti&\r\u0002\ty\tLh.Y7f}!1\u0011\u0011\r\u000bA\u0002\r\fq\"\\5t[\u0006$8\r[3e\u0019>\u001c7n]\u0001\u0013eVtwJ\\!o_RDWM\u001d+ie\u0016\fG\r\u0006\u0004\u0002h\u0005\u0015\u00151\u0012\u0019\u0005\u0003S\n\u0019\bE\u0003|\u0003W\ny'C\u0002\u0002nI\u0013aAR;ukJ,\u0007\u0003BA9\u0003gb\u0001\u0001B\u0006\u0002vU\t\t\u0011!A\u0003\u0002\u0005]$aA0%eE!\u0011\u0011PA@!\r\u0001\u00141P\u0005\u0004\u0003{\n$a\u0002(pi\"Lgn\u001a\t\u0004a\u0005\u0005\u0015bAABc\t\u0019\u0011I\\=\t\u0011\u0005\u001dU\u0003\"a\u0001\u0003\u0013\u000b1AZ;o!\u0011\u0001\u00141\f5\t\r\u00055U\u00031\u0001d\u00039\u0019\bn\\;mI\u000e{W\u000e\u001d7fi\u0016\fA#T8dW\u0012+G.Y=fI>\u0003XM]1uS>t\u0007CA %'\t!s\u0006\u0006\u0002\u0002\u0012\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII*\"!a'+\u0007-\u000bij\u000b\u0002\u0002 B!\u0011\u0011UAV\u001b\t\t\u0019K\u0003\u0003\u0002&\u0006\u001d\u0016!C;oG\",7m[3e\u0015\r\tI+M\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAW\u0003G\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%g\u0001")
public class DelayedOperationTest {
    private volatile DelayedOperationTest$MockDelayedOperation$ MockDelayedOperation$module;
    private DelayedOperationPurgatory<MockDelayedOperation> purgatory = null;
    private ExecutorService executorService = null;

    public DelayedOperationTest$MockDelayedOperation$ MockDelayedOperation() {
        if (this.MockDelayedOperation$module == null) {
            this.MockDelayedOperation$lzycompute$1();
        }
        return this.MockDelayedOperation$module;
    }

    public DelayedOperationPurgatory<MockDelayedOperation> purgatory() {
        return this.purgatory;
    }

    public void purgatory_$eq(DelayedOperationPurgatory<MockDelayedOperation> x$1) {
        this.purgatory = x$1;
    }

    public ExecutorService executorService() {
        return this.executorService;
    }

    public void executorService_$eq(ExecutorService x$1) {
        this.executorService = x$1;
    }

    @Before
    public void setUp() {
        this.purgatory_$eq((DelayedOperationPurgatory<MockDelayedOperation>)DelayedOperationPurgatory$.MODULE$.apply("mock", DelayedOperationPurgatory$.MODULE$.apply$default$2(), DelayedOperationPurgatory$.MODULE$.apply$default$3(), DelayedOperationPurgatory$.MODULE$.apply$default$4(), DelayedOperationPurgatory$.MODULE$.apply$default$5()));
    }

    @After
    public void tearDown() {
        block0: {
            this.purgatory().shutdown();
            if (this.executorService() == null) break block0;
            this.executorService().shutdown();
        }
    }

    @Test
    public void testRequestSatisfaction() {
        MockDelayedOperation r1 = new MockDelayedOperation(this, 100000L, this.MockDelayedOperation().$lessinit$greater$default$2(), this.MockDelayedOperation().$lessinit$greater$default$3());
        MockDelayedOperation r2 = new MockDelayedOperation(this, 100000L, this.MockDelayedOperation().$lessinit$greater$default$2(), this.MockDelayedOperation().$lessinit$greater$default$3());
        Assert.assertEquals((String)"With no waiting requests, nothing should be satisfied", (long)0L, (long)this.purgatory().checkAndComplete((Object)"test1"));
        Assert.assertFalse((String)"r1 not satisfied and hence watched", (boolean)this.purgatory().tryCompleteElseWatch((DelayedOperation)r1, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1"})));
        Assert.assertEquals((String)"Still nothing satisfied", (long)0L, (long)this.purgatory().checkAndComplete((Object)"test1"));
        Assert.assertFalse((String)"r2 not satisfied and hence watched", (boolean)this.purgatory().tryCompleteElseWatch((DelayedOperation)r2, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test2"})));
        Assert.assertEquals((String)"Still nothing satisfied", (long)0L, (long)this.purgatory().checkAndComplete((Object)"test2"));
        r1.completable_$eq(true);
        Assert.assertEquals((String)"r1 satisfied", (long)1L, (long)this.purgatory().checkAndComplete((Object)"test1"));
        Assert.assertEquals((String)"Nothing satisfied", (long)0L, (long)this.purgatory().checkAndComplete((Object)"test1"));
        r2.completable_$eq(true);
        Assert.assertEquals((String)"r2 satisfied", (long)1L, (long)this.purgatory().checkAndComplete((Object)"test2"));
        Assert.assertEquals((String)"Nothing satisfied", (long)0L, (long)this.purgatory().checkAndComplete((Object)"test2"));
    }

    @Test
    public void testRequestExpiry() {
        long expiration = 20L;
        long start = Time.SYSTEM.hiResClockMs();
        MockDelayedOperation r1 = new MockDelayedOperation(this, expiration, this.MockDelayedOperation().$lessinit$greater$default$2(), this.MockDelayedOperation().$lessinit$greater$default$3());
        MockDelayedOperation r2 = new MockDelayedOperation(this, 200000L, this.MockDelayedOperation().$lessinit$greater$default$2(), this.MockDelayedOperation().$lessinit$greater$default$3());
        Assert.assertFalse((String)"r1 not satisfied and hence watched", (boolean)this.purgatory().tryCompleteElseWatch((DelayedOperation)r1, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1"})));
        Assert.assertFalse((String)"r2 not satisfied and hence watched", (boolean)this.purgatory().tryCompleteElseWatch((DelayedOperation)r2, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test2"})));
        r1.awaitExpiration();
        long elapsed = Time.SYSTEM.hiResClockMs() - start;
        Assert.assertTrue((String)"r1 completed due to expiration", (boolean)r1.isCompleted());
        Assert.assertFalse((String)"r2 hasn't completed", (boolean)r2.isCompleted());
        Assert.assertTrue((String)new StringBuilder(37).append("Time for expiration ").append(elapsed).append(" should at least ").append(expiration).toString(), (elapsed >= expiration ? 1 : 0) != 0);
    }

    @Test
    public void testDelayedFuture() {
        String purgatoryName = "testDelayedFuture";
        DelayedFuturePurgatory purgatory = new DelayedFuturePurgatory(purgatoryName, 0);
        AtomicInteger result = new AtomicInteger();
        Assert.assertFalse((String)"Unnecessary thread created", (boolean)DelayedOperationTest.hasExecutorThread$1(purgatoryName));
        .colon.colon futures1 = new .colon.colon(CompletableFuture.completedFuture(BoxesRunTime.boxToInteger((int)10)), (List)new .colon.colon(CompletableFuture.completedFuture(BoxesRunTime.boxToInteger((int)11)), (List)Nil$.MODULE$));
        DelayedFuture r1 = purgatory.tryCompleteElseWatch(100000L, (List)futures1, (Function0)((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DelayedOperationTest.$anonfun$testDelayedFuture$5((List)futures1, result)));
        Assert.assertTrue((String)"r1 not completed", (boolean)r1.isCompleted());
        Assert.assertEquals((long)21L, (long)result.get());
        Assert.assertFalse((String)"Unnecessary thread created", (boolean)DelayedOperationTest.hasExecutorThread$1(purgatoryName));
        result.set(-1);
        .colon.colon futures2 = new .colon.colon(new CompletableFuture(), (List)new .colon.colon(new CompletableFuture(), (List)Nil$.MODULE$));
        DelayedFuture r2 = purgatory.tryCompleteElseWatch(100000L, (List)futures2, (Function0)((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DelayedOperationTest.$anonfun$testDelayedFuture$6((List)futures2, result)));
        Assert.assertFalse((String)"r2 should be incomplete", (boolean)r2.isCompleted());
        ((CompletableFuture)futures2.head()).complete(Predef$.MODULE$.int2Integer(20));
        Assert.assertFalse((boolean)r2.isCompleted());
        Assert.assertEquals((long)-1L, (long)result.get());
        ((CompletableFuture)futures2.apply(1)).complete(Predef$.MODULE$.int2Integer(21));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> r2.isCompleted(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "r2 not completed", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> result.get() == 41, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "callback not invoked", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        Assert.assertTrue((String)"Thread not created for executing delayed task", (boolean)DelayedOperationTest.hasExecutorThread$1(purgatoryName));
        result.set(-1);
        .colon.colon futures3 = new .colon.colon(new CompletableFuture(), (List)new .colon.colon(CompletableFuture.completedFuture(BoxesRunTime.boxToInteger((int)31)), (List)Nil$.MODULE$));
        DelayedFuture r3 = purgatory.tryCompleteElseWatch(100000L, (List)futures3, (Function0)((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DelayedOperationTest.$anonfun$testDelayedFuture$11((List)futures3, result)));
        Assert.assertFalse((String)"r3 should be incomplete", (boolean)r3.isCompleted());
        Assert.assertEquals((long)-1L, (long)result.get());
        ((CompletableFuture)futures3.head()).complete(Predef$.MODULE$.int2Integer(30));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> r3.isCompleted(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "r3 not completed", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> result.get() == 61, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "callback not invoked", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        result.set(-1);
        long start = Time.SYSTEM.hiResClockMs();
        long expirationMs = 2000L;
        .colon.colon futures4 = new .colon.colon(new CompletableFuture(), (List)new .colon.colon(new CompletableFuture(), (List)Nil$.MODULE$));
        DelayedFuture r4 = purgatory.tryCompleteElseWatch(expirationMs, (List)futures4, (Function0)((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DelayedOperationTest.$anonfun$testDelayedFuture$16((List)futures4, result)));
        ((CompletableFuture)futures4.head()).complete(Predef$.MODULE$.int2Integer(40));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)((JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> DelayedOperationTest.$anonfun$testDelayedFuture$17((List)futures4)), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "r4 futures not expired", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        Assert.assertTrue((String)"r4 not completed after timeout", (boolean)r4.isCompleted());
        long elapsed = Time.SYSTEM.hiResClockMs() - start;
        Assert.assertTrue((String)new StringBuilder(37).append("Time for expiration ").append(elapsed).append(" should at least ").append(expirationMs).toString(), (elapsed >= expirationMs ? 1 : 0) != 0);
        Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)40), ((CompletableFuture)futures4.head()).get());
        Assert.assertEquals(TimeoutException.class, ((Throwable)Assertions$.MODULE$.intercept(() -> DelayedOperationTest.$anonfun$testDelayedFuture$19((List)futures4), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("DelayedOperationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141))).getCause().getClass());
        Assert.assertEquals((long)40L, (long)result.get());
    }

    @Test
    public void testRequestPurge() {
        MockDelayedOperation r1 = new MockDelayedOperation(this, 100000L, this.MockDelayedOperation().$lessinit$greater$default$2(), this.MockDelayedOperation().$lessinit$greater$default$3());
        MockDelayedOperation r2 = new MockDelayedOperation(this, 100000L, this.MockDelayedOperation().$lessinit$greater$default$2(), this.MockDelayedOperation().$lessinit$greater$default$3());
        MockDelayedOperation r3 = new MockDelayedOperation(this, 100000L, this.MockDelayedOperation().$lessinit$greater$default$2(), this.MockDelayedOperation().$lessinit$greater$default$3());
        this.purgatory().tryCompleteElseWatch((DelayedOperation)r1, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1"}));
        this.purgatory().tryCompleteElseWatch((DelayedOperation)r2, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1", "test2"}));
        this.purgatory().tryCompleteElseWatch((DelayedOperation)r3, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1", "test2", "test3"}));
        Assert.assertEquals((String)"Purgatory should have 3 total delayed operations", (long)3L, (long)this.purgatory().numDelayed());
        Assert.assertEquals((String)"Purgatory should have 6 watched elements", (long)6L, (long)this.purgatory().watched());
        r2.completable_$eq(true);
        r2.tryComplete();
        Assert.assertEquals((String)new StringBuilder(60).append("Purgatory should have 2 total delayed operations instead of ").append(this.purgatory().numDelayed()).toString(), (long)2L, (long)this.purgatory().numDelayed());
        r3.completable_$eq(true);
        r3.tryComplete();
        Assert.assertEquals((String)new StringBuilder(60).append("Purgatory should have 1 total delayed operations instead of ").append(this.purgatory().numDelayed()).toString(), (long)1L, (long)this.purgatory().numDelayed());
        this.purgatory().checkAndComplete((Object)"test1");
        Assert.assertEquals((String)new StringBuilder(52).append("Purgatory should have 4 watched elements instead of ").append(this.purgatory().watched()).toString(), (long)4L, (long)this.purgatory().watched());
        this.purgatory().checkAndComplete((Object)"test2");
        Assert.assertEquals((String)new StringBuilder(52).append("Purgatory should have 2 watched elements instead of ").append(this.purgatory().watched()).toString(), (long)2L, (long)this.purgatory().watched());
        this.purgatory().checkAndComplete((Object)"test3");
        Assert.assertEquals((String)new StringBuilder(52).append("Purgatory should have 1 watched elements instead of ").append(this.purgatory().watched()).toString(), (long)1L, (long)this.purgatory().watched());
    }

    @Test
    public void shouldCancelForKeyReturningCancelledOperations() {
        this.purgatory().tryCompleteElseWatch((DelayedOperation)new MockDelayedOperation(this, 10000L, this.MockDelayedOperation().$lessinit$greater$default$2(), this.MockDelayedOperation().$lessinit$greater$default$3()), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key"})));
        this.purgatory().tryCompleteElseWatch((DelayedOperation)new MockDelayedOperation(this, 10000L, this.MockDelayedOperation().$lessinit$greater$default$2(), this.MockDelayedOperation().$lessinit$greater$default$3()), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key"})));
        this.purgatory().tryCompleteElseWatch((DelayedOperation)new MockDelayedOperation(this, 10000L, this.MockDelayedOperation().$lessinit$greater$default$2(), this.MockDelayedOperation().$lessinit$greater$default$3()), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key2"})));
        List cancelledOperations = this.purgatory().cancelForKey((Object)"key");
        Assert.assertEquals((long)2L, (long)cancelledOperations.size());
        Assert.assertEquals((long)1L, (long)this.purgatory().numDelayed());
        Assert.assertEquals((long)1L, (long)this.purgatory().watched());
    }

    @Test
    public void shouldReturnNilOperationsOnCancelForKeyWhenKeyDoesntExist() {
        List cancelledOperations = this.purgatory().cancelForKey((Object)"key");
        Assert.assertEquals((Object)Nil$.MODULE$, (Object)cancelledOperations);
    }

    @Test
    public void testTryCompleteLockContention() {
        this.executorService_$eq(Executors.newSingleThreadExecutor());
        AtomicInteger completionAttemptsRemaining = new AtomicInteger(Integer.MAX_VALUE);
        Semaphore tryCompleteSemaphore = new Semaphore(1);
        String key = "key";
        MockDelayedOperation op = new MockDelayedOperation(this, completionAttemptsRemaining, tryCompleteSemaphore){
            private final AtomicInteger completionAttemptsRemaining$1;
            private final Semaphore tryCompleteSemaphore$1;

            public boolean tryComplete() {
                boolean bl;
                boolean shouldComplete = this.completionAttemptsRemaining$1.decrementAndGet() <= 0;
                this.tryCompleteSemaphore$1.acquire();
                try {
                    bl = shouldComplete ? this.forceComplete() : false;
                }
                finally {
                    this.tryCompleteSemaphore$1.release();
                }
                return bl;
            }
            {
                this.completionAttemptsRemaining$1 = completionAttemptsRemaining$1;
                this.tryCompleteSemaphore$1 = tryCompleteSemaphore$1;
                super($outer, 100000L, (Option<ReentrantLock>)None$.MODULE$, (Option<ReentrantLock>)None$.MODULE$);
            }
        };
        this.purgatory().tryCompleteElseWatch((DelayedOperation)op, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{key})));
        completionAttemptsRemaining.set(2);
        tryCompleteSemaphore.acquire();
        Future<?> future = this.runOnAnotherThread((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.purgatory().checkAndComplete((Object)key), false);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> tryCompleteSemaphore.hasQueuedThreads(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Not attempting to complete", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.purgatory().checkAndComplete((Object)key);
        Assert.assertFalse((String)"Operation should not have completed", (boolean)op.isCompleted());
        tryCompleteSemaphore.release();
        future.get(10L, TimeUnit.SECONDS);
        Assert.assertTrue((String)"Operation should have completed", (boolean)op.isCompleted());
    }

    @Test
    public void testTryCompleteWithMultipleThreads() {
        ScheduledExecutorService executor = Executors.newScheduledThreadPool(20);
        this.executorService_$eq(executor);
        Random random = new Random();
        int maxDelayMs = 10;
        int completionAttempts = 20;
        IndexedSeq ops = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).map((Function1 & Serializable & scala.Serializable)index -> {
            public class Kafka_server_DelayedOperationTest$TestDelayOperation$1
            extends MockDelayedOperation {
                private final String key;
                private final AtomicInteger completionAttemptsRemaining;
                private final Random random$1;
                private final int maxDelayMs$1;

                public String key() {
                    return this.key;
                }

                public AtomicInteger completionAttemptsRemaining() {
                    return this.completionAttemptsRemaining;
                }

                public boolean tryComplete() {
                    boolean shouldComplete = this.completable();
                    Thread.sleep(this.random$1.nextInt(this.maxDelayMs$1));
                    return shouldComplete ? this.forceComplete() : false;
                }

                public Kafka_server_DelayedOperationTest$TestDelayOperation$1(DelayedOperationTest $outer, int index, int completionAttempts$1, Random random$1, int maxDelayMs$1) {
                    this.random$1 = random$1;
                    this.maxDelayMs$1 = maxDelayMs$1;
                    super($outer, 10000L, $outer.MockDelayedOperation().$lessinit$greater$default$2(), $outer.MockDelayedOperation().$lessinit$greater$default$3());
                    this.key = new StringBuilder(3).append("key").append(index).toString();
                    this.completionAttemptsRemaining = new AtomicInteger(completionAttempts$1);
                }
            }
            return DelayedOperationTest.$anonfun$testTryCompleteWithMultipleThreads$1(this, completionAttempts, random, maxDelayMs, BoxesRunTime.unboxToInt((Object)index));
        }, IndexedSeq$.MODULE$.canBuildFrom());
        ((IterableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), completionAttempts).flatMap((Function1 & Serializable & scala.Serializable)x$5 -> DelayedOperationTest.$anonfun$testTryCompleteWithMultipleThreads$2(this, ops, random, maxDelayMs, executor, BoxesRunTime.unboxToInt((Object)x$5)), IndexedSeq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)future -> future.get());
        ops.foreach((Function1 & Serializable & scala.Serializable)op -> {
            DelayedOperationTest.$anonfun$testTryCompleteWithMultipleThreads$5(op);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testDelayedOperationLock() {
        this.verifyDelayedOperationLock((Function0<MockDelayedOperation>)(Function0 & Serializable & scala.Serializable)() -> new MockDelayedOperation(this, 100000L, this.MockDelayedOperation().$lessinit$greater$default$2(), this.MockDelayedOperation().$lessinit$greater$default$3()), false);
    }

    @Test
    public void testDelayedOperationLockOverride() {
        this.verifyDelayedOperationLock((Function0<MockDelayedOperation>)(Function0 & Serializable & scala.Serializable)() -> this.newMockOperation$1(), false);
        this.verifyDelayedOperationLock((Function0<MockDelayedOperation>)(Function0 & Serializable & scala.Serializable)() -> new MockDelayedOperation(this, 100000L, (Option<ReentrantLock>)None$.MODULE$, (Option<ReentrantLock>)new Some((Object)new ReentrantLock())), true);
    }

    public void verifyDelayedOperationLock(Function0<MockDelayedOperation> mockDelayedOperation, boolean mismatchedLocks) {
        String key = "key";
        this.executorService_$eq(Executors.newSingleThreadExecutor());
        ObjectRef ops = ObjectRef.create((Object)this.createDelayedOperations$1(2, mockDelayedOperation, key));
        this.checkAndComplete$1((Seq)ops.elem, (Seq)ops.elem, key);
        ops.elem = this.createDelayedOperations$1(2, mockDelayedOperation, key);
        CoreUtils$.MODULE$.inLock(((DelayedOperation)((Seq)ops.elem).apply(1)).lock(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkAndComplete$1((Seq)ops$2.elem, (Seq)ops$2.elem, key));
        ops.elem = this.createDelayedOperations$1(2, mockDelayedOperation, key);
        this.runOnAnotherThread((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((DelayedOperation)((Seq)ops$2.elem).apply(0)).lock().lock(), true);
        try {
            this.checkAndComplete$1((Seq)ops.elem, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((Seq)ops.elem).apply(1))})), key);
        }
        catch (Throwable throwable) {
            this.runOnAnotherThread((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((DelayedOperation)((Seq)ops$2.elem).apply(0)).lock().unlock(), true);
            this.checkAndComplete$1((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((Seq)ops.elem).apply(0))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((Seq)ops.elem).apply(0))})), key);
            throw throwable;
        }
        this.runOnAnotherThread((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((DelayedOperation)((Seq)ops$2.elem).apply(0)).lock().unlock(), true);
        this.checkAndComplete$1((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((Seq)ops.elem).apply(0))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((Seq)ops.elem).apply(0))})), key);
        ops.elem = this.createDelayedOperations$1(2, mockDelayedOperation, key);
        ((MockDelayedOperation)((Object)((Seq)ops.elem).apply(0))).responseLockOpt().foreach((Function1 & Serializable & scala.Serializable)lock -> {
            DelayedOperationTest.$anonfun$verifyDelayedOperationLock$9(this, ops, mismatchedLocks, key, lock);
            return BoxedUnit.UNIT;
        });
        ops.elem = DelayedOperationTest.createCompletableOperations$1(2, mockDelayedOperation);
        ((Seq)ops.elem).foreach((Function1 & Serializable & scala.Serializable)op -> {
            DelayedOperationTest.$anonfun$verifyDelayedOperationLock$12(this, key, op);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private Future<?> runOnAnotherThread(Function0<BoxedUnit> fun, boolean shouldComplete) {
        void var3_3;
        Object object;
        Future<?> future = this.executorService().submit(new Runnable(null, fun){
            private final Function0 fun$1;

            public void run() {
                this.fun$1.apply$mcV$sp();
            }
            {
                this.fun$1 = fun$1;
            }
        });
        if (shouldComplete) {
            object = future.get();
        } else {
            Assert.assertFalse((String)"Should not have completed", (boolean)future.isDone());
            object = BoxedUnit.UNIT;
        }
        return var3_3;
    }

    private final void MockDelayedOperation$lzycompute$1() {
        DelayedOperationTest delayedOperationTest = this;
        synchronized (delayedOperationTest) {
            if (this.MockDelayedOperation$module == null) {
                this.MockDelayedOperation$module = new DelayedOperationTest$MockDelayedOperation$(this);
            }
        }
    }

    private static final boolean hasExecutorThread$1(String purgatoryName$1) {
        return ((IterableLike)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(Thread.getAllStackTraces().keySet()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getName(), Set$.MODULE$.canBuildFrom())).exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.contains(new StringBuilder(16).append("DelayedExecutor-").append(purgatoryName$1).toString())));
    }

    public static final /* synthetic */ int $anonfun$testDelayedFuture$4(CompletableFuture x$4) {
        return (Integer)x$4.get();
    }

    private static final void updateResult$1(List futures, AtomicInteger result$1) {
        result$1.set(BoxesRunTime.unboxToInt((Object)((TraversableOnce)((List)futures.filterNot((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isCompletedExceptionally()))).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)DelayedOperationTest.$anonfun$testDelayedFuture$4(x$4)), List$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)));
    }

    public static final /* synthetic */ void $anonfun$testDelayedFuture$5(List futures1$1, AtomicInteger result$1) {
        DelayedOperationTest.updateResult$1(futures1$1, result$1);
    }

    public static final /* synthetic */ void $anonfun$testDelayedFuture$6(List futures2$1, AtomicInteger result$1) {
        DelayedOperationTest.updateResult$1(futures2$1, result$1);
    }

    public static final /* synthetic */ void $anonfun$testDelayedFuture$11(List futures3$1, AtomicInteger result$1) {
        DelayedOperationTest.updateResult$1(futures3$1, result$1);
    }

    public static final /* synthetic */ void $anonfun$testDelayedFuture$16(List futures4$1, AtomicInteger result$1) {
        DelayedOperationTest.updateResult$1(futures4$1, result$1);
    }

    public static final /* synthetic */ boolean $anonfun$testDelayedFuture$17(List futures4$1) {
        return ((CompletableFuture)futures4$1.apply(1)).isDone();
    }

    public static final /* synthetic */ Integer $anonfun$testDelayedFuture$19(List futures4$1) {
        return (Integer)((CompletableFuture)futures4$1.apply(1)).get();
    }

    public static final /* synthetic */ TestDelayOperation.1 $anonfun$testTryCompleteWithMultipleThreads$1(DelayedOperationTest $this, int completionAttempts$1, Random random$1, int maxDelayMs$1, int index) {
        Kafka_server_DelayedOperationTest$TestDelayOperation$1 op = new Kafka_server_DelayedOperationTest$TestDelayOperation$1($this, index, completionAttempts$1, random$1, maxDelayMs$1);
        $this.purgatory().tryCompleteElseWatch((DelayedOperation)op, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{op.key()})));
        return op;
    }

    private final Future scheduleTryComplete$1(TestDelayOperation.1 op, long delayMs, ScheduledExecutorService executor$1) {
        return executor$1.schedule(new Runnable(this, op){
            private final /* synthetic */ DelayedOperationTest $outer;
            private final Kafka_server_DelayedOperationTest$TestDelayOperation$1 op$1;

            public void run() {
                if (this.op$1.completionAttemptsRemaining().decrementAndGet() == 0) {
                    this.op$1.completable_$eq(true);
                }
                this.$outer.purgatory().checkAndComplete((Object)this.op$1.key());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.op$1 = op$1;
            }
        }, delayMs, TimeUnit.MILLISECONDS);
    }

    public static final /* synthetic */ IndexedSeq $anonfun$testTryCompleteWithMultipleThreads$2(DelayedOperationTest $this, IndexedSeq ops$1, Random random$1, int maxDelayMs$1, ScheduledExecutorService executor$1, int x$5) {
        return (IndexedSeq)ops$1.map((Function1 & Serializable & scala.Serializable)op -> {
            return $this.scheduleTryComplete$1((Kafka_server_DelayedOperationTest$TestDelayOperation$1)((Object)op), random$1.nextInt(maxDelayMs$1), executor$1);
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ void $anonfun$testTryCompleteWithMultipleThreads$5(TestDelayOperation.1 op) {
        Assert.assertTrue((String)"Operation should have completed", (boolean)op.isCompleted());
    }

    private final MockDelayedOperation newMockOperation$1() {
        ReentrantLock lock = new ReentrantLock();
        return new MockDelayedOperation(this, 100000L, (Option<ReentrantLock>)new Some((Object)lock), (Option<ReentrantLock>)new Some((Object)lock));
    }

    public static final /* synthetic */ MockDelayedOperation $anonfun$verifyDelayedOperationLock$1(DelayedOperationTest $this, Function0 mockDelayedOperation$1, String key$2, int x$6) {
        MockDelayedOperation op = (MockDelayedOperation)((Object)mockDelayedOperation$1.apply());
        $this.purgatory().tryCompleteElseWatch((DelayedOperation)op, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{key$2})));
        Assert.assertFalse((String)"Not completable", (boolean)op.isCompleted());
        return op;
    }

    private final Seq createDelayedOperations$1(int count, Function0 mockDelayedOperation$1, String key$2) {
        return (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), count).map((Function1 & Serializable & scala.Serializable)x$6 -> DelayedOperationTest.$anonfun$verifyDelayedOperationLock$1(this, mockDelayedOperation$1, key$2, BoxesRunTime.unboxToInt((Object)x$6)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ MockDelayedOperation $anonfun$verifyDelayedOperationLock$2(Function0 mockDelayedOperation$1, int x$7) {
        void var2_2;
        MockDelayedOperation op = (MockDelayedOperation)((Object)mockDelayedOperation$1.apply());
        op.completable_$eq(true);
        return var2_2;
    }

    private static final Seq createCompletableOperations$1(int count, Function0 mockDelayedOperation$1) {
        return (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), count).map((Function1 & Serializable & scala.Serializable)x$7 -> DelayedOperationTest.$anonfun$verifyDelayedOperationLock$2(mockDelayedOperation$1, BoxesRunTime.unboxToInt((Object)x$7)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ void $anonfun$verifyDelayedOperationLock$4(MockDelayedOperation op) {
        Assert.assertTrue((String)"Should have completed", (boolean)op.isCompleted());
    }

    public static final /* synthetic */ void $anonfun$verifyDelayedOperationLock$5(MockDelayedOperation op) {
        Assert.assertFalse((String)"Should not have completed", (boolean)op.isCompleted());
    }

    private final void checkAndComplete$1(Seq completableOps, Seq expectedComplete, String key$2) {
        completableOps.foreach((Function1 & Serializable & scala.Serializable)op -> {
            op.completable_$eq(true);
            return BoxedUnit.UNIT;
        });
        int completed = this.purgatory().checkAndComplete((Object)key$2);
        Assert.assertEquals((long)expectedComplete.size(), (long)completed);
        expectedComplete.foreach((Function1 & Serializable & scala.Serializable)op -> {
            DelayedOperationTest.$anonfun$verifyDelayedOperationLock$4(op);
            return BoxedUnit.UNIT;
        });
        Set expectedNotComplete = (Set)completableOps.toSet().$minus$minus((GenTraversableOnce)expectedComplete);
        expectedNotComplete.foreach((Function1 & Serializable & scala.Serializable)op -> {
            DelayedOperationTest.$anonfun$verifyDelayedOperationLock$5(op);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$verifyDelayedOperationLock$9(DelayedOperationTest $this, ObjectRef ops$2, boolean mismatchedLocks$1, String key$2, ReentrantLock lock) {
        $this.runOnAnotherThread((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> lock.lock(), true);
        try {
            try {
                $this.checkAndComplete$1((Seq)ops$2.elem, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((Seq)ops$2.elem).apply(1))})), key$2);
                Assert.assertFalse((String)"Should have failed with mismatched locks", (boolean)mismatchedLocks$1);
            }
            catch (IllegalStateException e) {
                Assert.assertTrue((String)"Should not have failed with valid locks", (boolean)mismatchedLocks$1);
            }
        }
        catch (Throwable throwable) {
            $this.runOnAnotherThread((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> lock.unlock(), true);
            $this.checkAndComplete$1((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((Seq)ops$2.elem).apply(0))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((Seq)ops$2.elem).apply(0))})), key$2);
            throw throwable;
        }
        $this.runOnAnotherThread((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> lock.unlock(), true);
        $this.checkAndComplete$1((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((Seq)ops$2.elem).apply(0))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((Seq)ops$2.elem).apply(0))})), key$2);
    }

    public static final /* synthetic */ void $anonfun$verifyDelayedOperationLock$12(DelayedOperationTest $this, String key$2, MockDelayedOperation op) {
        Assert.assertTrue((String)"Should have completed", (boolean)$this.purgatory().tryCompleteElseWatch((DelayedOperation)op, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{key$2}))));
        Assert.assertTrue((String)"Should have completed", (boolean)op.isCompleted());
    }

    public class MockDelayedOperation
    extends DelayedOperation {
        private final Option<ReentrantLock> responseLockOpt;
        private boolean completable;
        public final /* synthetic */ DelayedOperationTest $outer;

        public Option<ReentrantLock> responseLockOpt() {
            return this.responseLockOpt;
        }

        public boolean completable() {
            return this.completable;
        }

        public void completable_$eq(boolean x$1) {
            this.completable = x$1;
        }

        public synchronized void awaitExpiration() {
            this.wait();
        }

        public boolean tryComplete() {
            return this.completable() ? this.forceComplete() : false;
        }

        public void onExpiration() {
        }

        public void onComplete() {
            this.responseLockOpt().foreach((Function1 & Serializable & scala.Serializable)lock -> {
                MockDelayedOperation.$anonfun$onComplete$1(lock);
                return BoxedUnit.UNIT;
            });
            MockDelayedOperation mockDelayedOperation = this;
            synchronized (mockDelayedOperation) {
                this.notify();
            }
        }

        public /* synthetic */ DelayedOperationTest kafka$server$DelayedOperationTest$MockDelayedOperation$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ void $anonfun$onComplete$1(ReentrantLock lock) {
            if (!lock.tryLock()) {
                throw new IllegalStateException("Response callback lock could not be acquired in callback");
            }
        }

        public MockDelayedOperation(DelayedOperationTest $outer, long delayMs, Option<ReentrantLock> lockOpt, Option<ReentrantLock> responseLockOpt) {
            this.responseLockOpt = responseLockOpt;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(delayMs, lockOpt);
            this.completable = false;
        }
    }
}

