/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.ApiVersion;
import kafka.cluster.Partition;
import kafka.log.AppendOrigin;
import kafka.log.CleanerConfig;
import kafka.log.CleanerConfig$;
import kafka.log.Log;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.server.BrokerTopicStats;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.server.MetadataCache;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.utils.KafkaScheduler;
import kafka.utils.KafkaScheduler$;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005ma\u0001B\t\u0013\u0001]AQA\b\u0001\u0005\u0002}AqA\t\u0001C\u0002\u0013\u00051\u0005\u0003\u0004.\u0001\u0001\u0006I\u0001\n\u0005\b]\u0001\u0011\r\u0011\"\u00010\u0011\u0019A\u0004\u0001)A\u0005a!9\u0011\b\u0001b\u0001\n\u0003Q\u0004BB!\u0001A\u0003%1\bC\u0004C\u0001\t\u0007I\u0011A\"\t\r-\u0003\u0001\u0015!\u0003E\u0011\u001da\u0005A1A\u0005\u00025CaA\u0015\u0001!\u0002\u0013q\u0005\"B*\u0001\t\u0003!\u0006\"B1\u0001\t\u0003!\u0006\"\u00024\u0001\t\u0003!\u0006\"\u00025\u0001\t\u0013I\u0007\"B<\u0001\t\u0013A(\u0001\b%jO\"<\u0018\r^3s[\u0006\u00148\u000eU3sg&\u001cH/\u001a8dKR+7\u000f\u001e\u0006\u0003'Q\taa]3sm\u0016\u0014(\"A\u000b\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0007\t\u00033qi\u0011A\u0007\u0006\u00027\u0005)1oY1mC&\u0011QD\u0007\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005\u0001\u0003CA\u0011\u0001\u001b\u0005\u0011\u0012aB2p]\u001aLwm]\u000b\u0002IA\u0019Q\u0005\u000b\u0016\u000e\u0003\u0019R!a\n\u000e\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002*M\t\u00191+Z9\u0011\u0005\u0005Z\u0013B\u0001\u0017\u0013\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u0011\r|gNZ5hg\u0002\nQ\u0001^8qS\u000e,\u0012\u0001\r\t\u0003cYj\u0011A\r\u0006\u0003gQ\nA\u0001\\1oO*\tQ'\u0001\u0003kCZ\f\u0017BA\u001c3\u0005\u0019\u0019FO]5oO\u00061Ao\u001c9jG\u0002\n\u0001B_6DY&,g\u000e^\u000b\u0002wA\u0011AhP\u0007\u0002{)\u0011a\bF\u0001\u0003u.L!\u0001Q\u001f\u0003\u001b-\u000bgm[1[W\u000ec\u0017.\u001a8u\u0003%Q8n\u00117jK:$\b%A\u0006m_\u001el\u0015M\\1hKJ\u001cX#\u0001#\u0011\u0007\u0015BS\t\u0005\u0002G\u00136\tqI\u0003\u0002I)\u0005\u0019An\\4\n\u0005);%A\u0003'pO6\u000bg.Y4fe\u0006aAn\\4NC:\fw-\u001a:tA\u0005)Bn\\4ESJ4\u0015-\u001b7ve\u0016\u001c\u0005.\u00198oK2\u001cX#\u0001(\u0011\u0007\u0015Bs\n\u0005\u0002\"!&\u0011\u0011K\u0005\u0002\u0015\u0019><G)\u001b:GC&dWO]3DQ\u0006tg.\u001a7\u0002-1|w\rR5s\r\u0006LG.\u001e:f\u0007\"\fgN\\3mg\u0002\n\u0001\u0002^3be\u0012|wO\u001c\u000b\u0002+B\u0011\u0011DV\u0005\u0003/j\u0011A!\u00168ji\"\u0012A\"\u0017\t\u00035~k\u0011a\u0017\u0006\u00039v\u000bQA[;oSRT\u0011AX\u0001\u0004_J<\u0017B\u00011\\\u0005\u0015\te\r^3s\u0003-\"Xm\u001d;IS\u001eDw+\u0019;fe6\f'o\u001b)feNL7\u000f^3oG\u0016\u001c\u0016N\\4mKB\u000b'\u000f^5uS>t\u0007FA\u0007d!\tQF-\u0003\u0002f7\n!A+Z:u\u00039\"Xm\u001d;IS\u001eDw+\u0019;fe6\f'o\u001b)feNL7\u000f^3oG\u0016lU\u000f\u001c;ja2,\u0007+\u0019:uSRLwN\\:)\u00059\u0019\u0017AB1qa\u0016tG\rF\u0002VUJDQa[\bA\u00021\f\u0011\u0002]1si&$\u0018n\u001c8\u0011\u00055\u0004X\"\u00018\u000b\u0005=$\u0012aB2mkN$XM]\u0005\u0003c:\u0014\u0011\u0002U1si&$\u0018n\u001c8\t\u000bM|\u0001\u0019\u0001;\u0002\u000b\r|WO\u001c;\u0011\u0005e)\u0018B\u0001<\u001b\u0005\rIe\u000e^\u0001\u0007Q^lgi\u001c:\u0015\red\u00181AA\r!\tI\"0\u0003\u0002|5\t!Aj\u001c8h\u0011\u0015i\b\u00031\u0001\u007f\u00039\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ\u0004\"!I@\n\u0007\u0005\u0005!C\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\t\r9\u0002\u0002\u0019AA\u0003!\u0011\t9!!\u0006\u000f\t\u0005%\u0011\u0011\u0003\t\u0004\u0003\u0017QRBAA\u0007\u0015\r\tyAF\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005M!$\u0001\u0004Qe\u0016$WMZ\u0005\u0004o\u0005]!bAA\n5!)1\u000e\u0005a\u0001i\u0002")
public class HighwatermarkPersistenceTest {
    private final Seq<KafkaConfig> configs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(2, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16()).map((Function1 & Serializable & scala.Serializable)props -> KafkaConfig$.MODULE$.fromProps(props), Seq$.MODULE$.canBuildFrom());
    private final String topic;
    private final KafkaZkClient zkClient = (KafkaZkClient)EasyMock.createMock(KafkaZkClient.class);
    private final Seq<LogManager> logManagers = (Seq)this.configs().map((Function1 & Serializable & scala.Serializable)config -> {
        Seq x$12 = (Seq)config.logDirs().map((Function1 & Serializable & scala.Serializable)x$1 -> new File((String)x$1), Seq$.MODULE$.canBuildFrom());
        CleanerConfig x$2 = new CleanerConfig(CleanerConfig$.MODULE$.apply$default$1(), CleanerConfig$.MODULE$.apply$default$2(), CleanerConfig$.MODULE$.apply$default$3(), CleanerConfig$.MODULE$.apply$default$4(), CleanerConfig$.MODULE$.apply$default$5(), CleanerConfig$.MODULE$.apply$default$6(), CleanerConfig$.MODULE$.apply$default$7(), CleanerConfig$.MODULE$.apply$default$8(), CleanerConfig$.MODULE$.apply$default$9());
        LogConfig x$3 = TestUtils$.MODULE$.createLogManager$default$2();
        MockTime x$4 = TestUtils$.MODULE$.createLogManager$default$4();
        return TestUtils$.MODULE$.createLogManager((Seq<File>)x$12, x$3, x$2, x$4);
    }, Seq$.MODULE$.canBuildFrom());
    private final Seq<LogDirFailureChannel> logDirFailureChannels = (Seq)this.configs().map((Function1 & Serializable & scala.Serializable)config -> new LogDirFailureChannel(config.logDirs().size()), Seq$.MODULE$.canBuildFrom());

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public String topic() {
        return this.topic;
    }

    public KafkaZkClient zkClient() {
        return this.zkClient;
    }

    public Seq<LogManager> logManagers() {
        return this.logManagers;
    }

    public Seq<LogDirFailureChannel> logDirFailureChannels() {
        return this.logDirFailureChannels;
    }

    @After
    public void teardown() {
        this.logManagers().foreach((Function1 & Serializable & scala.Serializable)manager -> {
            HighwatermarkPersistenceTest.$anonfun$teardown$1(manager);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testHighWatermarkPersistenceSinglePartition() {
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        KafkaScheduler scheduler = new KafkaScheduler(2, KafkaScheduler$.MODULE$.$lessinit$greater$default$2(), KafkaScheduler$.MODULE$.$lessinit$greater$default$3());
        scheduler.startup();
        Metrics metrics = new Metrics();
        MockTime time = new MockTime();
        ReplicaManager replicaManager = new ReplicaManager((KafkaConfig)this.configs().head(), metrics, (Time)time, this.zkClient(), (Scheduler)scheduler, (LogManager)this.logManagers().head(), new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate((KafkaConfig)this.configs().head(), metrics, (Time)time, ""), new BrokerTopicStats(), new MetadataCache(((KafkaConfig)this.configs().head()).brokerId()), (LogDirFailureChannel)this.logDirFailureChannels().head(), ReplicaManager$.MODULE$.$lessinit$greater$default$12());
        replicaManager.startup();
        try {
            replicaManager.checkpointHighWatermarks();
            long fooPartition0Hw = this.hwmFor(replicaManager, this.topic(), 0);
            Assert.assertEquals((long)0L, (long)fooPartition0Hw);
            TopicPartition tp0 = new TopicPartition(this.topic(), 0);
            Partition partition0 = replicaManager.createPartition(tp0);
            LogManager qual$1 = (LogManager)this.logManagers().head();
            TopicPartition x$1 = new TopicPartition(this.topic(), 0);
            LogConfig x$2 = LogConfig$.MODULE$.apply();
            boolean x$3 = qual$1.getOrCreateLog$default$3();
            boolean x$4 = qual$1.getOrCreateLog$default$4();
            Log log0 = qual$1.getOrCreateLog(x$1, x$2, x$3, x$4);
            partition0.setLog(log0, false);
            partition0.updateAssignmentAndIsr((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{((KafkaConfig)this.configs().head()).brokerId(), ((KafkaConfig)this.configs().last()).brokerId()})), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{((KafkaConfig)this.configs().head()).brokerId()})));
            replicaManager.checkpointHighWatermarks();
            fooPartition0Hw = this.hwmFor(replicaManager, this.topic(), 0);
            Assert.assertEquals((long)log0.highWatermark(), (long)fooPartition0Hw);
            partition0.localLogOrException().updateHighWatermark(5L);
            replicaManager.checkpointHighWatermarks();
            fooPartition0Hw = this.hwmFor(replicaManager, this.topic(), 0);
            Assert.assertEquals((long)log0.highWatermark(), (long)fooPartition0Hw);
            EasyMock.verify((Object[])new Object[]{this.zkClient()});
        }
        finally {
            replicaManager.shutdown(false);
            metrics.close();
            scheduler.shutdown();
        }
    }

    @Test
    public void testHighWatermarkPersistenceMultiplePartitions() {
        String topic1 = "foo1";
        String topic2 = "foo2";
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        KafkaScheduler scheduler = new KafkaScheduler(2, KafkaScheduler$.MODULE$.$lessinit$greater$default$2(), KafkaScheduler$.MODULE$.$lessinit$greater$default$3());
        scheduler.startup();
        Metrics metrics = new Metrics();
        MockTime time = new MockTime();
        ReplicaManager replicaManager = new ReplicaManager((KafkaConfig)this.configs().head(), metrics, (Time)time, this.zkClient(), (Scheduler)scheduler, (LogManager)this.logManagers().head(), new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate((KafkaConfig)this.configs().head(), metrics, (Time)time, ""), new BrokerTopicStats(), new MetadataCache(((KafkaConfig)this.configs().head()).brokerId()), (LogDirFailureChannel)this.logDirFailureChannels().head(), ReplicaManager$.MODULE$.$lessinit$greater$default$12());
        replicaManager.startup();
        try {
            replicaManager.checkpointHighWatermarks();
            long topic1Partition0Hw = this.hwmFor(replicaManager, topic1, 0);
            Assert.assertEquals((long)0L, (long)topic1Partition0Hw);
            TopicPartition t1p0 = new TopicPartition(topic1, 0);
            Partition topic1Partition0 = replicaManager.createPartition(t1p0);
            LogManager qual$1 = (LogManager)this.logManagers().head();
            TopicPartition x$1 = t1p0;
            LogConfig x$2 = LogConfig$.MODULE$.apply();
            boolean x$3 = qual$1.getOrCreateLog$default$3();
            boolean x$4 = qual$1.getOrCreateLog$default$4();
            Log topic1Log0 = qual$1.getOrCreateLog(x$1, x$2, x$3, x$4);
            topic1Partition0.setLog(topic1Log0, false);
            replicaManager.checkpointHighWatermarks();
            topic1Partition0Hw = this.hwmFor(replicaManager, topic1, 0);
            Assert.assertEquals((long)topic1Log0.highWatermark(), (long)topic1Partition0Hw);
            this.append(topic1Partition0, 5);
            topic1Partition0.localLogOrException().updateHighWatermark(5L);
            replicaManager.checkpointHighWatermarks();
            topic1Partition0Hw = this.hwmFor(replicaManager, topic1, 0);
            Assert.assertEquals((long)5L, (long)topic1Log0.highWatermark());
            Assert.assertEquals((long)5L, (long)topic1Partition0Hw);
            TopicPartition t2p0 = new TopicPartition(topic2, 0);
            Partition topic2Partition0 = replicaManager.createPartition(t2p0);
            LogManager qual$2 = (LogManager)this.logManagers().head();
            TopicPartition x$5 = t2p0;
            LogConfig x$6 = LogConfig$.MODULE$.apply();
            boolean x$7 = qual$2.getOrCreateLog$default$3();
            boolean x$8 = qual$2.getOrCreateLog$default$4();
            Log topic2Log0 = qual$2.getOrCreateLog(x$5, x$6, x$7, x$8);
            topic2Partition0.setLog(topic2Log0, false);
            replicaManager.checkpointHighWatermarks();
            long topic2Partition0Hw = this.hwmFor(replicaManager, topic2, 0);
            Assert.assertEquals((long)topic2Log0.highWatermark(), (long)topic2Partition0Hw);
            this.append(topic2Partition0, 15);
            topic2Partition0.localLogOrException().updateHighWatermark(15L);
            Assert.assertEquals((long)15L, (long)topic2Log0.highWatermark());
            this.append(topic1Partition0, 5);
            topic1Partition0.localLogOrException().updateHighWatermark(10L);
            Assert.assertEquals((long)10L, (long)topic1Log0.highWatermark());
            replicaManager.checkpointHighWatermarks();
            topic2Partition0Hw = this.hwmFor(replicaManager, topic2, 0);
            Assert.assertEquals((long)15L, (long)topic2Partition0Hw);
            topic1Partition0Hw = this.hwmFor(replicaManager, topic1, 0);
            Assert.assertEquals((long)10L, (long)topic1Partition0Hw);
            EasyMock.verify((Object[])new Object[]{this.zkClient()});
        }
        finally {
            replicaManager.shutdown(false);
            metrics.close();
            scheduler.shutdown();
        }
    }

    private void append(Partition partition, int count) {
        MemoryRecords records = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)((Iterable)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), count).map((Function1 & Serializable & scala.Serializable)i -> HighwatermarkPersistenceTest.$anonfun$append$1(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
        Log qual$1 = partition.localLogOrException();
        MemoryRecords x$1 = records;
        int x$2 = 0;
        AppendOrigin x$3 = qual$1.appendAsLeader$default$3();
        ApiVersion x$4 = qual$1.appendAsLeader$default$4();
        qual$1.appendAsLeader(x$1, x$2, x$3, x$4);
    }

    private long hwmFor(ReplicaManager replicaManager, String topic, int partition) {
        return BoxesRunTime.unboxToLong((Object)((OffsetCheckpointFile)replicaManager.highWatermarkCheckpoints().apply((Object)new File((String)replicaManager.config().logDirs().head()).getAbsolutePath())).read().getOrElse((Object)new TopicPartition(topic, partition), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
    }

    public static final /* synthetic */ void $anonfun$teardown$2(File dir) {
        Utils.delete((File)dir);
    }

    public static final /* synthetic */ void $anonfun$teardown$1(LogManager manager) {
        manager.liveLogDirs().foreach((Function1 & Serializable & scala.Serializable)dir -> {
            HighwatermarkPersistenceTest.$anonfun$teardown$2(dir);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ SimpleRecord $anonfun$append$1(int i) {
        return new SimpleRecord(String.valueOf(BoxesRunTime.boxToInteger((int)i)).getBytes());
    }

    public HighwatermarkPersistenceTest() {
        this.topic = "foo";
    }
}

