/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.MetricName;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Properties;
import kafka.log.LogConfig$;
import kafka.message.ZStdCompressionCodec$;
import kafka.server.BaseRequestTest;
import kafka.server.BrokerTopicStats$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ProduceRequest;
import org.apache.kafka.common.requests.ProduceResponse;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.mutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001I4Aa\u0003\u0007\u0001#!)a\u0003\u0001C\u0001/!9\u0011\u0004\u0001b\u0001\n\u0003Q\u0002BB\u0019\u0001A\u0003%1\u0004C\u00033\u0001\u0011\u00051\u0007C\u0003B\u0001\u0011\u00051\u0007C\u0003D\u0001\u0011\u00051\u0007C\u0003F\u0001\u0011%a\tC\u0003[\u0001\u0011\u00051\u0007C\u0003]\u0001\u0011\u00051\u0007C\u0003_\u0001\u0011%qL\u0001\nQe>$WoY3SKF,Xm\u001d;UKN$(BA\u0007\u000f\u0003\u0019\u0019XM\u001d<fe*\tq\"A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\u0011\u0002CA\n\u0015\u001b\u0005a\u0011BA\u000b\r\u0005=\u0011\u0015m]3SKF,Xm\u001d;UKN$\u0018A\u0002\u001fj]&$h\bF\u0001\u0019!\t\u0019\u0002!A\u0007nKR\u0014\u0018nY:LKf\u001cV\r^\u000b\u00027A\u0019AdI\u0013\u000e\u0003uQ!AH\u0010\u0002\u000f5,H/\u00192mK*\u0011\u0001%I\u0001\u000bG>dG.Z2uS>t'\"\u0001\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011j\"aA*fiB\u0011aeL\u0007\u0002O)\u0011\u0001&K\u0001\u0005G>\u0014XM\u0003\u0002+W\u00059Q.\u001a;sS\u000e\u001c(B\u0001\u0017.\u0003\u0019I\u0018-\\7fe*\ta&A\u0002d_6L!\u0001M\u0014\u0003\u00155+GO]5d\u001d\u0006lW-\u0001\bnKR\u0014\u0018nY:LKf\u001cV\r\u001e\u0011\u00021Q,7\u000f^*j[BdW\r\u0015:pIV\u001cWMU3rk\u0016\u001cH\u000fF\u00015!\t)d'D\u0001\"\u0013\t9\u0014E\u0001\u0003V]&$\bF\u0001\u0003:!\tQt(D\u0001<\u0015\taT(A\u0003kk:LGOC\u0001?\u0003\ry'oZ\u0005\u0003\u0001n\u0012A\u0001V3ti\u0006yB/Z:u!J|G-^2f/&$\b.\u00138wC2LG\rV5nKN$\u0018-\u001c9)\u0005\u0015I\u0014a\u0006;fgR\u0004&o\u001c3vG\u0016$vNT8o%\u0016\u0004H.[2bQ\t1\u0011(A\u0013de\u0016\fG/\u001a+pa&\u001c\u0017I\u001c3GS:$\u0007+\u0019:uSRLwN\\,ji\"dU-\u00193feR\u0011q)\u0014\t\u0005k!S%*\u0003\u0002JC\t1A+\u001e9mKJ\u0002\"!N&\n\u00051\u000b#aA%oi\")aj\u0002a\u0001\u001f\u0006)Ao\u001c9jGB\u0011\u0001k\u0016\b\u0003#V\u0003\"AU\u0011\u000e\u0003MS!\u0001\u0016\t\u0002\rq\u0012xn\u001c;?\u0013\t1\u0016%\u0001\u0004Qe\u0016$WMZ\u0005\u00031f\u0013aa\u0015;sS:<'B\u0001,\"\u0003q!Xm\u001d;D_J\u0014X\u000f\u001d;MuR\u0002&o\u001c3vG\u0016\u0014V-];fgRD#\u0001C\u001d\u0002-Q,7\u000f\u001e.T)\u0012\u0003&o\u001c3vG\u0016\u0014V-];fgRD#!C\u001d\u0002%M,g\u000e\u001a)s_\u0012,8-\u001a*fcV,7\u000f\u001e\u000b\u0004A.l\u0007CA1j\u001b\u0005\u0011'BA2e\u0003!\u0011X-];fgR\u001c(BA3g\u0003\u0019\u0019w.\\7p]*\u0011qb\u001a\u0006\u0003Qv\na!\u00199bG\",\u0017B\u00016c\u0005=\u0001&o\u001c3vG\u0016\u0014Vm\u001d9p]N,\u0007\"\u00027\u000b\u0001\u0004Q\u0015\u0001\u00037fC\u0012,'/\u00133\t\u000b9T\u0001\u0019A8\u0002\u000fI,\u0017/^3tiB\u0011\u0011\r]\u0005\u0003c\n\u0014a\u0002\u0015:pIV\u001cWMU3rk\u0016\u001cH\u000f")
public class ProduceRequestTest
extends BaseRequestTest {
    private final Set<MetricName> metricsKeySet = (Set)JavaConverters$.MODULE$.asScalaSetConverter(Metrics.defaultRegistry().allMetrics().keySet()).asScala();

    public Set<MetricName> metricsKeySet() {
        return this.metricsKeySet;
    }

    @Test
    public void testSimpleProduceRequest() {
        Tuple2<Object, Object> tuple2 = this.createTopicAndFindPartitionWithLeader("topic");
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int partition = tuple2._1$mcI$sp();
        int leader = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(partition, leader);
        Tuple2.mcII.sp sp3 = sp2;
        int partition2 = sp3._1$mcI$sp();
        int leader2 = sp3._2$mcI$sp();
        this.sendAndCheck$1(MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(System.currentTimeMillis(), "key".getBytes(), "value".getBytes())}), 0L, partition2, leader2);
        this.sendAndCheck$1(MemoryRecords.withRecords((CompressionType)CompressionType.GZIP, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(System.currentTimeMillis(), "key1".getBytes(), "value1".getBytes()), new SimpleRecord(System.currentTimeMillis(), "key2".getBytes(), "value2".getBytes())}), 1L, partition2, leader2);
    }

    @Test
    public void testProduceWithInvalidTimestamp() {
        String topic = "topic";
        int partition = 0;
        Properties topicConfig = new Properties();
        topicConfig.setProperty(LogConfig$.MODULE$.MessageTimestampDifferenceMaxMsProp(), "1000");
        scala.collection.immutable.Map<Object, Object> partitionToLeader = TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 1, (Seq<KafkaServer>)this.servers(), topicConfig);
        int leader = BoxesRunTime.unboxToInt((Object)partitionToLeader.apply((Object)BoxesRunTime.boxToInteger((int)partition)));
        MemoryRecords records = ProduceRequestTest.createRecords$1((byte)2, System.currentTimeMillis() - 1001L, CompressionType.GZIP);
        TopicPartition topicPartition = new TopicPartition("topic", partition);
        scala.collection.immutable.Map partitionRecords = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)records)}));
        ProduceResponse produceResponse = this.sendProduceRequest(leader, (ProduceRequest)ProduceRequest.Builder.forCurrentMagic((short)-1, (int)3000, (java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)partitionRecords).asJava())).build());
        Tuple2 tuple2 = (Tuple2)((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(produceResponse.responses()).asScala()).head();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition tp = (TopicPartition)tuple2._1();
        ProduceResponse.PartitionResponse partitionResponse = (ProduceResponse.PartitionResponse)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)tp, (Object)partitionResponse);
        Tuple2 tuple23 = tuple22;
        TopicPartition tp2 = (TopicPartition)tuple23._1();
        ProduceResponse.PartitionResponse partitionResponse2 = (ProduceResponse.PartitionResponse)tuple23._2();
        Assert.assertEquals((Object)topicPartition, (Object)tp2);
        Assert.assertEquals((Object)Errors.INVALID_TIMESTAMP, (Object)partitionResponse2.error);
        Assert.assertEquals((long)1L, (long)partitionResponse2.recordErrors.size());
        Assert.assertEquals((long)0L, (long)((ProduceResponse.RecordError)partitionResponse2.recordErrors.get((int)0)).batchIndex);
        Assert.assertNull((Object)((ProduceResponse.RecordError)partitionResponse2.recordErrors.get((int)0)).message);
        Assert.assertNotNull((Object)partitionResponse2.errorMessage);
    }

    @Test
    public void testProduceToNonReplica() {
        String topic = "topic";
        int partition = 0;
        scala.collection.immutable.Map<Object, Object> partitionToLeader = TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 1, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        int leader = BoxesRunTime.unboxToInt((Object)partitionToLeader.apply((Object)BoxesRunTime.boxToInteger((int)partition)));
        Option nonReplicaOpt = this.servers().find((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ProduceRequestTest.$anonfun$testProduceToNonReplica$1(leader, x$4)));
        Assert.assertTrue((boolean)nonReplicaOpt.isDefined());
        int nonReplicaId = ((KafkaServer)nonReplicaOpt.get()).config().brokerId();
        MemoryRecords records = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("key".getBytes(), "value".getBytes())});
        TopicPartition topicPartition = new TopicPartition("topic", partition);
        scala.collection.immutable.Map partitionRecords = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)records)}));
        ProduceRequest produceRequest = (ProduceRequest)ProduceRequest.Builder.forCurrentMagic((short)-1, (int)3000, (java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)partitionRecords).asJava())).build();
        ProduceResponse produceResponse = this.sendProduceRequest(nonReplicaId, produceRequest);
        Assert.assertEquals((long)1L, (long)produceResponse.responses().size());
        Assert.assertEquals((Object)Errors.NOT_LEADER_FOR_PARTITION, (Object)((ProduceResponse.PartitionResponse)((Tuple2)((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)produceResponse.responses()).asScala()).head())._2()).error);
    }

    private Tuple2<Object, Object> createTopicAndFindPartitionWithLeader(String topic) {
        scala.collection.immutable.Map<Object, Object> partitionToLeader = TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 3, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        return (Tuple2)partitionToLeader.collectFirst((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<Object, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    int partition = A1._1$mcI$sp();
                    int leader = A1._2$mcI$sp();
                    if (leader != -1) {
                        object = new Tuple2.mcII.sp(partition, leader);
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<Object, Object> x1) {
                int leader;
                Tuple2<Object, Object> tuple2 = x1;
                boolean bl = tuple2 != null && (leader = tuple2._2$mcI$sp()) != -1;
                return bl;
            }
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> Assertions$.MODULE$.fail(new StringBuilder(28).append("No leader elected for topic ").append(topic).toString(), new Position("ProduceRequestTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133)));
    }

    @Test
    public void testCorruptLz4ProduceRequest() {
        Tuple2<Object, Object> tuple2 = this.createTopicAndFindPartitionWithLeader("topic");
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int partition = tuple2._1$mcI$sp();
        int leader = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(partition, leader);
        Tuple2.mcII.sp sp3 = sp2;
        int partition2 = sp3._1$mcI$sp();
        int leader2 = sp3._2$mcI$sp();
        int timestamp = 1000000;
        MemoryRecords memoryRecords = MemoryRecords.withRecords((CompressionType)CompressionType.LZ4, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord((long)timestamp, "key".getBytes(), "value".getBytes())});
        int lz4ChecksumOffset = 6;
        memoryRecords.buffer().array()[61 + lz4ChecksumOffset] = 0;
        TopicPartition topicPartition = new TopicPartition("topic", partition2);
        scala.collection.immutable.Map partitionRecords = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)memoryRecords)}));
        ProduceResponse produceResponse = this.sendProduceRequest(leader2, (ProduceRequest)ProduceRequest.Builder.forCurrentMagic((short)-1, (int)3000, (java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)partitionRecords).asJava())).build());
        Assert.assertEquals((long)1L, (long)produceResponse.responses().size());
        Tuple2 tuple22 = (Tuple2)((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(produceResponse.responses()).asScala()).head();
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        TopicPartition tp = (TopicPartition)tuple22._1();
        ProduceResponse.PartitionResponse partitionResponse = (ProduceResponse.PartitionResponse)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)tp, (Object)partitionResponse);
        Tuple2 tuple24 = tuple23;
        TopicPartition tp2 = (TopicPartition)tuple24._1();
        ProduceResponse.PartitionResponse partitionResponse2 = (ProduceResponse.PartitionResponse)tuple24._2();
        Assert.assertEquals((Object)topicPartition, (Object)tp2);
        Assert.assertEquals((Object)Errors.CORRUPT_MESSAGE, (Object)partitionResponse2.error);
        Assert.assertEquals((long)-1L, (long)partitionResponse2.baseOffset);
        Assert.assertEquals((long)-1L, (long)partitionResponse2.logAppendTime);
        Assert.assertEquals((long)this.metricsKeySet().count((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ProduceRequestTest.$anonfun$testCorruptLz4ProduceRequest$1(x$7))), (long)1L);
        Assert.assertTrue((TestUtils$.MODULE$.meterCount(String.valueOf(BrokerTopicStats$.MODULE$.InvalidMessageCrcRecordsPerSec())) > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testZSTDProduceRequest() {
        String topic = "topic";
        int partition = 0;
        Properties topicConfig = new Properties();
        topicConfig.setProperty(LogConfig$.MODULE$.CompressionTypeProp(), ZStdCompressionCodec$.MODULE$.name());
        scala.collection.immutable.Map<Object, Object> partitionToLeader = TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 1, (Seq<KafkaServer>)this.servers(), topicConfig);
        int leader = BoxesRunTime.unboxToInt((Object)partitionToLeader.apply((Object)BoxesRunTime.boxToInteger((int)partition)));
        MemoryRecords memoryRecords = MemoryRecords.withRecords((CompressionType)CompressionType.ZSTD, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(System.currentTimeMillis(), "key".getBytes(), "value".getBytes())});
        TopicPartition topicPartition = new TopicPartition("topic", partition);
        scala.collection.immutable.Map partitionRecords = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)memoryRecords)}));
        ProduceResponse res1 = this.sendProduceRequest(leader, (ProduceRequest)new ProduceRequest.Builder(7, 7, -1, 3000, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)partitionRecords).asJava(), null).build());
        Tuple2 tuple2 = (Tuple2)((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(res1.responses()).asScala()).head();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition tp1 = (TopicPartition)tuple2._1();
        ProduceResponse.PartitionResponse partitionResponse1 = (ProduceResponse.PartitionResponse)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)tp1, (Object)partitionResponse1);
        Tuple2 tuple23 = tuple22;
        TopicPartition tp12 = (TopicPartition)tuple23._1();
        ProduceResponse.PartitionResponse partitionResponse12 = (ProduceResponse.PartitionResponse)tuple23._2();
        Assert.assertEquals((Object)topicPartition, (Object)tp12);
        Assert.assertEquals((Object)Errors.NONE, (Object)partitionResponse12.error);
        Assert.assertEquals((long)0L, (long)partitionResponse12.baseOffset);
        Assert.assertEquals((long)-1L, (long)partitionResponse12.logAppendTime);
        ProduceResponse res2 = this.sendProduceRequest(leader, new ProduceRequest.Builder(3, 3, -1, 3000, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)partitionRecords).asJava(), null).buildUnsafe((short)3));
        Tuple2 tuple24 = (Tuple2)((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(res2.responses()).asScala()).head();
        if (tuple24 == null) {
            throw new MatchError((Object)tuple24);
        }
        TopicPartition tp2 = (TopicPartition)tuple24._1();
        ProduceResponse.PartitionResponse partitionResponse2 = (ProduceResponse.PartitionResponse)tuple24._2();
        Tuple2 tuple25 = new Tuple2((Object)tp2, (Object)partitionResponse2);
        Tuple2 tuple26 = tuple25;
        TopicPartition tp22 = (TopicPartition)tuple26._1();
        ProduceResponse.PartitionResponse partitionResponse22 = (ProduceResponse.PartitionResponse)tuple26._2();
        Assert.assertEquals((Object)topicPartition, (Object)tp22);
        Assert.assertEquals((Object)Errors.UNSUPPORTED_COMPRESSION_TYPE, (Object)partitionResponse22.error);
    }

    private ProduceResponse sendProduceRequest(int leaderId, ProduceRequest request) {
        ByteBuffer response = this.connectAndSend((AbstractRequest)request, ApiKeys.PRODUCE, this.brokerSocketServer(leaderId), this.connectAndSend$default$4(), this.connectAndSend$default$5());
        return ProduceResponse.parse((ByteBuffer)response, (short)request.version());
    }

    private final ProduceResponse.PartitionResponse sendAndCheck$1(MemoryRecords memoryRecords, long expectedOffset, int partition$1, int leader$1) {
        TopicPartition topicPartition = new TopicPartition("topic", partition$1);
        scala.collection.immutable.Map partitionRecords = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)memoryRecords)}));
        ProduceResponse produceResponse = this.sendProduceRequest(leader$1, (ProduceRequest)ProduceRequest.Builder.forCurrentMagic((short)-1, (int)3000, (java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)partitionRecords).asJava())).build());
        Assert.assertEquals((long)1L, (long)produceResponse.responses().size());
        Tuple2 tuple2 = (Tuple2)((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(produceResponse.responses()).asScala()).head();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition tp = (TopicPartition)tuple2._1();
        ProduceResponse.PartitionResponse partitionResponse = (ProduceResponse.PartitionResponse)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)tp, (Object)partitionResponse);
        Tuple2 tuple23 = tuple22;
        TopicPartition tp2 = (TopicPartition)tuple23._1();
        ProduceResponse.PartitionResponse partitionResponse2 = (ProduceResponse.PartitionResponse)tuple23._2();
        Assert.assertEquals((Object)topicPartition, (Object)tp2);
        Assert.assertEquals((Object)Errors.NONE, (Object)partitionResponse2.error);
        Assert.assertEquals((long)expectedOffset, (long)partitionResponse2.baseOffset);
        Assert.assertEquals((long)-1L, (long)partitionResponse2.logAppendTime);
        Assert.assertTrue((boolean)partitionResponse2.recordErrors.isEmpty());
        return partitionResponse2;
    }

    private static final MemoryRecords createRecords$1(byte magicValue, long timestamp, CompressionType codec) {
        ByteBuffer buf = ByteBuffer.allocate(512);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buf, (byte)magicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.appendWithOffset(0L, timestamp, null, "hello".getBytes());
        builder.appendWithOffset(1L, timestamp, null, "there".getBytes());
        builder.appendWithOffset(2L, timestamp, null, "beautiful".getBytes());
        return builder.build();
    }

    private static final long createRecords$default$2$1() {
        return -1L;
    }

    public static final /* synthetic */ boolean $anonfun$testProduceToNonReplica$1(int leader$2, KafkaServer x$4) {
        return x$4.config().brokerId() != leader$2;
    }

    public static final /* synthetic */ boolean $anonfun$testCorruptLz4ProduceRequest$1(MetricName x$7) {
        return x$7.getMBeanName().endsWith(String.valueOf(BrokerTopicStats$.MODULE$.InvalidMessageCrcRecordsPerSec()));
    }
}

