/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.EndPoint;
import kafka.metrics.KafkaMetricsGroup;
import kafka.network.AbstractServerThread;
import kafka.network.Acceptor$DelayedCloseSocket$;
import kafka.network.ConnectionQuotas;
import kafka.network.ConnectionThrottledException;
import kafka.network.Processor;
import kafka.network.Processor$;
import kafka.network.RequestChannel;
import kafka.network.SocketServer;
import kafka.network.TooManyConnectionsException;
import kafka.security.CredentialProvider;
import kafka.server.ApiVersionManager;
import kafka.server.KafkaConfig;
import kafka.utils.CoreUtils$;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.PriorityQueue;
import scala.math.Ordered;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.control.ControlThrowable;

@ScalaSignature(bytes="\u0006\u0001\rugAB*U\u0003\u00031\u0006\f\u0003\u0005d\u0001\t\u0015\r\u0011\"\u0001f\u0011!I\u0007A!A!\u0002\u00131\u0007\u0002\u00036\u0001\u0005\u000b\u0007I\u0011A6\t\u0011I\u0004!\u0011!Q\u0001\n1D\u0001b\u001d\u0001\u0003\u0002\u0004%\t\u0001\u001e\u0005\tw\u0002\u0011\t\u0019!C\u0001y\"I\u00111\u0002\u0001\u0003\u0002\u0003\u0006K!\u001e\u0005\u000b\u0003\u001b\u0001!\u0011!Q\u0001\n\u0005=\u0001BCA\u000b\u0001\t\u0005\t\u0015!\u0003\u0002\u0018!Q\u0011Q\u0004\u0001\u0003\u0002\u0003\u0006I!a\b\t\u0015\u0005e\u0002A!A!\u0002\u0013\tY\u0004\u0003\u0006\u0002B\u0001\u0011\t\u0011)A\u0005\u0003\u0007B\u0011\u0002\u0019\u0001\u0003\u0002\u0003\u0006I!!\u0013\t\u0015\u0005M\u0003A!A!\u0002\u0013\t)\u0006\u0003\u0006\u0002b\u0001\u0011\t\u0011)A\u0005\u0003GB!\"!\u001b\u0001\u0005\u0003\u0005\u000b\u0011BA6\u0011)\t9\b\u0001B\u0001B\u0003%\u0011\u0011\u0010\u0005\b\u0003\u007f\u0002A\u0011AAA\u0011\u001d\ty\n\u0001D\u0001\u0003CCq!!/\u0001\r\u0003\t\t\u000bC\u0005\u0002<\u0002\u0011\r\u0011\"\u0003\u0002>\"A\u0011q\u001a\u0001!\u0002\u0013\ty\fC\u0005\u0002R\u0002\u0011\r\u0011\"\u0003\u0002>\"A\u00111\u001b\u0001!\u0002\u0013\ty\fC\u0005\u0002V\u0002\u0011\r\u0011\"\u0003\u0002>\"A\u0011q\u001b\u0001!\u0002\u0013\ty\fC\u0005\u0002Z\u0002\u0011\r\u0011\"\u0003\u0002\\\"A\u0011Q\u001e\u0001!\u0002\u0013\ti\u000e\u0003\u0006\u0002p\u0002\u0011\r\u0011\"\u0001U\u0003cD\u0001\"!?\u0001A\u0003%\u00111\u001f\u0005\u000b\u0003w\u0004!\u0019!C\u0001)\u0006u\b\u0002\u0003B\u000b\u0001\u0001\u0006I!a@\t\u0013\t]\u0001A1A\u0005\n\te\u0001\u0002\u0003B\u0018\u0001\u0001\u0006IAa\u0007\t\u0013\tE\u0002A1A\u0005\n\tM\u0002\u0002\u0003B&\u0001\u0001\u0006IA!\u000e\t\u0013\t5\u0003A1A\u0005\n\t=\u0003\u0002\u0003B,\u0001\u0001\u0006IA!\u0015\t\u0013\te\u0003\u00011A\u0005\n\tm\u0003\"\u0003B/\u0001\u0001\u0007I\u0011\u0002B0\u0011!\u0011\u0019\u0007\u0001Q!\n\u0005=\u0001B\u0003B3\u0001\t\u0007I\u0011\u0001+\u0003h!A1Q\u0004\u0001!\u0002\u0013\u0011IGB\u0004\u0003t\u0001\u0001EK!\u001e\t\u0015\tmEF!f\u0001\n\u0003\u0011i\n\u0003\u0006\u0003&2\u0012\t\u0012)A\u0005\u0005?C!Ba*-\u0005+\u0007I\u0011\u0001BU\u0011)\u0011\t\f\fB\tB\u0003%!1\u0016\u0005\b\u0003\u007fbC\u0011\u0001BZ\u0011\u001d\u0011I\f\fC!\u0005wC\u0011B!1-\u0003\u0003%\tAa1\t\u0013\t%G&%A\u0005\u0002\t-\u0007\"\u0003BqYE\u0005I\u0011\u0001Br\u0011%\u00119\u000fLA\u0001\n\u0003\u0012I\u000fC\u0005\u0003p2\n\t\u0011\"\u0001\u0003\\!I!\u0011\u001f\u0017\u0002\u0002\u0013\u0005!1\u001f\u0005\n\u0005{d\u0013\u0011!C!\u0005\u007fD\u0011b!\u0003-\u0003\u0003%\taa\u0003\t\u0013\r=A&!A\u0005B\rE\u0001\"CB\nY\u0005\u0005I\u0011IB\u000b\u0011%\u00199\u0002LA\u0001\n\u0003\u001aIb\u0002\u0006\u0004 \u0001\t\t\u0011#\u0001U\u0007C1!Ba\u001d\u0001\u0003\u0003E\t\u0001VB\u0012\u0011\u001d\tyh\u0010C\u0001\u0007cA\u0011ba\u0005@\u0003\u0003%)e!\u0006\t\u0013\rMr(!A\u0005\u0002\u000eU\u0002\"CB\u001e\u007f\u0005\u0005I\u0011QB\u001f\u0011!\u0019y\u0005\u0001C\u0001)\u000eE\u0003bBB(\u0001\u0011%11\u000b\u0005\t\u0007;\u0002A\u0011\u0001+\u0004`!91Q\r\u0001\u0005B\rE\u0003bBB4\u0001\u0011\u00053\u0011\u000b\u0005\b\u0007S\u0002A\u0011AB)\u0011\u001d\u0019Y\u0007\u0001C\u0005\u0007[Bqa!\u001f\u0001\t\u0013\u0019\t\u0006C\u0004\u0004|\u0001!Ia! \t\u000f\r-\u0005\u0001\"\u0005\u0004\u000e\"911\u0013\u0001\u0005\n\rE\u0003bBBK\u0001\u0011%1q\u0013\u0005\b\u0007G\u0003A\u0011AB)\u0011\u001d\u0019i\u000b\u0001C\u0001\u0007_Cqa!.\u0001\t\u0003\u00199L\u0001\u0005BG\u000e,\u0007\u000f^8s\u0015\t)f+A\u0004oKR<xN]6\u000b\u0003]\u000bQa[1gW\u0006\u001c2\u0001A-^!\tQ6,D\u0001U\u0013\taFK\u0001\u000bBEN$(/Y2u'\u0016\u0014h/\u001a:UQJ,\u0017\r\u001a\t\u0003=\u0006l\u0011a\u0018\u0006\u0003AZ\u000bq!\\3ue&\u001c7/\u0003\u0002c?\n\t2*\u00194lC6+GO]5dg\u001e\u0013x.\u001e9\u0002\u0019M|7m[3u'\u0016\u0014h/\u001a:\u0004\u0001U\ta\r\u0005\u0002[O&\u0011\u0001\u000e\u0016\u0002\r'>\u001c7.\u001a;TKJ4XM]\u0001\u000eg>\u001c7.\u001a;TKJ4XM\u001d\u0011\u0002\u0011\u0015tG\rU8j]R,\u0012\u0001\u001c\t\u0003[Bl\u0011A\u001c\u0006\u0003_Z\u000bqa\u00197vgR,'/\u0003\u0002r]\nAQI\u001c3Q_&tG/A\u0005f]\u0012\u0004v.\u001b8uA\u000511m\u001c8gS\u001e,\u0012!\u001e\t\u0003mfl\u0011a\u001e\u0006\u0003qZ\u000baa]3sm\u0016\u0014\u0018B\u0001>x\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u0015\r|gNZ5h?\u0012*\u0017\u000fF\u0002~\u0003\u000f\u00012A`A\u0002\u001b\u0005y(BAA\u0001\u0003\u0015\u00198-\u00197b\u0013\r\t)a \u0002\u0005+:LG\u000f\u0003\u0005\u0002\n\u0019\t\t\u00111\u0001v\u0003\rAH%M\u0001\bG>tg-[4!\u0003\u0019qw\u000eZ3JIB\u0019a0!\u0005\n\u0007\u0005MqPA\u0002J]R\f\u0001cY8o]\u0016\u001cG/[8o#V|G/Y:\u0011\u0007i\u000bI\"C\u0002\u0002\u001cQ\u0013\u0001cQ8o]\u0016\u001cG/[8o#V|G/Y:\u0002\tQLW.\u001a\t\u0005\u0003C\t)$\u0004\u0002\u0002$)!\u0011QEA\u0014\u0003\u0015)H/\u001b7t\u0015\u0011\tI#a\u000b\u0002\r\r|W.\\8o\u0015\r9\u0016Q\u0006\u0006\u0005\u0003_\t\t$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003g\t1a\u001c:h\u0013\u0011\t9$a\t\u0003\tQKW.Z\u0001\u0015SN\u0004&/\u001b<jY\u0016<W\r\u001a'jgR,g.\u001a:\u0011\u0007y\fi$C\u0002\u0002@}\u0014qAQ8pY\u0016\fg.\u0001\bsKF,Xm\u001d;DQ\u0006tg.\u001a7\u0011\u0007i\u000b)%C\u0002\u0002HQ\u0013aBU3rk\u0016\u001cHo\u00115b]:,G\u000e\u0005\u0003\u0002L\u0005=SBAA'\u0015\r\u0001\u0017qE\u0005\u0005\u0003#\niEA\u0004NKR\u0014\u0018nY:\u0002%\r\u0014X\rZ3oi&\fG\u000e\u0015:pm&$WM\u001d\t\u0005\u0003/\ni&\u0004\u0002\u0002Z)\u0019\u00111\f,\u0002\u0011M,7-\u001e:jifLA!a\u0018\u0002Z\t\u00112I]3eK:$\u0018.\u00197Qe>4\u0018\u000eZ3s\u0003)awnZ\"p]R,\u0007\u0010\u001e\t\u0005\u0003C\t)'\u0003\u0003\u0002h\u0005\r\"A\u0003'pO\u000e{g\u000e^3yi\u0006QQ.Z7pef\u0004vn\u001c7\u0011\t\u00055\u00141O\u0007\u0003\u0003_RA!!\u001d\u0002(\u00051Q.Z7pefLA!!\u001e\u0002p\tQQ*Z7pef\u0004vn\u001c7\u0002#\u0005\u0004\u0018NV3sg&|g.T1oC\u001e,'\u000fE\u0002w\u0003wJ1!! x\u0005E\t\u0005/\u001b,feNLwN\\'b]\u0006<WM]\u0001\u0007y%t\u0017\u000e\u001e \u00159\u0005\r\u0015QQAD\u0003\u0013\u000bY)!$\u0002\u0010\u0006E\u00151SAK\u0003/\u000bI*a'\u0002\u001eB\u0011!\f\u0001\u0005\u0006GJ\u0001\rA\u001a\u0005\u0006UJ\u0001\r\u0001\u001c\u0005\u0006gJ\u0001\r!\u001e\u0005\b\u0003\u001b\u0011\u0002\u0019AA\b\u0011\u001d\t)B\u0005a\u0001\u0003/Aq!!\b\u0013\u0001\u0004\ty\u0002C\u0004\u0002:I\u0001\r!a\u000f\t\u000f\u0005\u0005#\u00031\u0001\u0002D!1\u0001M\u0005a\u0001\u0003\u0013Bq!a\u0015\u0013\u0001\u0004\t)\u0006C\u0004\u0002bI\u0001\r!a\u0019\t\u000f\u0005%$\u00031\u0001\u0002l!9\u0011q\u000f\nA\u0002\u0005e\u0014\u0001D7fiJL7\r\u0015:fM&DHCAAR!\u0011\t)+a-\u000f\t\u0005\u001d\u0016q\u0016\t\u0004\u0003S{XBAAV\u0015\r\ti\u000bZ\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005Ev0\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003k\u000b9L\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003c{\u0018\u0001\u0004;ie\u0016\fG\r\u0015:fM&D\u0018AD:f]\u0012\u0014UO\u001a4feNK'0Z\u000b\u0003\u0003\u007f\u0003B!!1\u0002L6\u0011\u00111\u0019\u0006\u0005\u0003\u000b\f9-\u0001\u0003mC:<'BAAe\u0003\u0011Q\u0017M^1\n\t\u00055\u00171\u0019\u0002\b\u0013:$XmZ3s\u0003=\u0019XM\u001c3Ck\u001a4WM]*ju\u0016\u0004\u0013A\u0004:fGZ\u0014UO\u001a4feNK'0Z\u0001\u0010e\u0016\u001cgOQ;gM\u0016\u00148+\u001b>fA\u0005\tB.[:uK:\u0014\u0015mY6m_\u001e\u001c\u0016N_3\u0002%1L7\u000f^3o\u0005\u0006\u001c7\u000e\\8h'&TX\rI\u0001\f]&|7+\u001a7fGR|'/\u0006\u0002\u0002^B!\u0011q\\Au\u001b\t\t\tO\u0003\u0003\u0002d\u0006\u0015\u0018\u0001C2iC:tW\r\\:\u000b\t\u0005\u001d\u0018qY\u0001\u0004]&|\u0017\u0002BAv\u0003C\u0014\u0001bU3mK\u000e$xN]\u0001\r]&|7+\u001a7fGR|'\u000fI\u0001\u000eg\u0016\u0014h/\u001a:DQ\u0006tg.\u001a7\u0016\u0005\u0005M\b\u0003BAp\u0003kLA!a>\u0002b\n\u00192+\u001a:wKJ\u001cvnY6fi\u000eC\u0017M\u001c8fY\u0006q1/\u001a:wKJ\u001c\u0005.\u00198oK2\u0004\u0013A\u00039s_\u000e,7o]8sgV\u0011\u0011q \t\u0007\u0005\u0003\u0011YAa\u0004\u000e\u0005\t\r!\u0002\u0002B\u0003\u0005\u000f\tq!\\;uC\ndWMC\u0002\u0003\n}\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011iAa\u0001\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\t\u00045\nE\u0011b\u0001B\n)\nI\u0001K]8dKN\u001cxN]\u0001\faJ|7-Z:t_J\u001c\b%A\tqe>\u001cWm]:peN\u001cF/\u0019:uK\u0012,\"Aa\u0007\u0011\t\tu!1F\u0007\u0003\u0005?QAA!\t\u0003$\u00051\u0011\r^8nS\u000eTAA!\n\u0003(\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\t%\u0012qY\u0001\u0005kRLG.\u0003\u0003\u0003.\t}!!D!u_6L7MQ8pY\u0016\fg.\u0001\nqe>\u001cWm]:peN\u001cF/\u0019:uK\u0012\u0004\u0013!\b2m_\u000e\\W\r\u001a)fe\u000e,g\u000e^'fi\u0016\u0014X*\u001a;sS\u000et\u0015-\\3\u0016\u0005\tU\u0002\u0003\u0002B\u001c\u0005\u000fj!A!\u000f\u000b\t\tm\"QH\u0001\u0005G>\u0014XMC\u0002a\u0005\u007fQAA!\u0011\u0003D\u00051\u00110Y7nKJT!A!\u0012\u0002\u0007\r|W.\u0003\u0003\u0003J\te\"AC'fiJL7MT1nK\u0006q\"\r\\8dW\u0016$\u0007+\u001a:dK:$X*\u001a;fe6+GO]5d\u001d\u0006lW\rI\u0001\u0014E2|7m[3e!\u0016\u00148-\u001a8u\u001b\u0016$XM]\u000b\u0003\u0005#\u0002BAa\u000e\u0003T%!!Q\u000bB\u001d\u0005\u0015iU\r^3s\u0003Q\u0011Gn\\2lK\u0012\u0004VM]2f]RlU\r^3sA\u0005)2-\u001e:sK:$\bK]8dKN\u001cxN]%oI\u0016DXCAA\b\u0003e\u0019WO\u001d:f]R\u0004&o\\2fgN|'/\u00138eKb|F%Z9\u0015\u0007u\u0014\t\u0007C\u0005\u0002\n!\n\t\u00111\u0001\u0002\u0010\u000512-\u001e:sK:$\bK]8dKN\u001cxN]%oI\u0016D\b%\u0001\tuQJ|G\u000f\u001e7fIN{7m[3ugV\u0011!\u0011\u000e\t\u0007\u0005\u0003\u0011YGa\u001c\n\t\t5$1\u0001\u0002\u000e!JLwN]5usF+X-^3\u0011\u0007\tED&D\u0001\u0001\u0005I!U\r\\1zK\u0012\u001cEn\\:f'>\u001c7.\u001a;\u0014\u00131\u00129H! \u0003\u0010\nU\u0005c\u0001@\u0003z%\u0019!1P@\u0003\r\u0005s\u0017PU3g!\u0019\u0011yH!#\u0003p9!!\u0011\u0011BC\u001d\u0011\tIKa!\n\u0005\u0005\u0005\u0011b\u0001BD\u007f\u00069\u0001/Y2lC\u001e,\u0017\u0002\u0002BF\u0005\u001b\u0013qa\u0014:eKJ,GMC\u0002\u0003\b~\u00042A BI\u0013\r\u0011\u0019j \u0002\b!J|G-^2u!\rq(qS\u0005\u0004\u00053{(\u0001D*fe&\fG.\u001b>bE2,\u0017AB:pG.,G/\u0006\u0002\u0003 B!\u0011q\u001cBQ\u0013\u0011\u0011\u0019+!9\u0003\u001bM{7m[3u\u0007\"\fgN\\3m\u0003\u001d\u0019xnY6fi\u0002\n\u0011#\u001a8e)\"\u0014x\u000e\u001e;mKRKW.Z't+\t\u0011Y\u000bE\u0002\u007f\u0005[K1Aa,\u0000\u0005\u0011auN\\4\u0002%\u0015tG\r\u00165s_R$H.\u001a+j[\u0016l5\u000f\t\u000b\u0007\u0005_\u0012)La.\t\u000f\tm\u0015\u00071\u0001\u0003 \"9!qU\u0019A\u0002\t-\u0016aB2p[B\f'/\u001a\u000b\u0005\u0003\u001f\u0011i\fC\u0004\u0003@J\u0002\rAa\u001c\u0002\tQD\u0017\r^\u0001\u0005G>\u0004\u0018\u0010\u0006\u0004\u0003p\t\u0015'q\u0019\u0005\n\u00057\u001b\u0004\u0013!a\u0001\u0005?C\u0011Ba*4!\u0003\u0005\rAa+\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!Q\u001a\u0016\u0005\u0005?\u0013ym\u000b\u0002\u0003RB!!1\u001bBo\u001b\t\u0011)N\u0003\u0003\u0003X\ne\u0017!C;oG\",7m[3e\u0015\r\u0011Yn`\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002Bp\u0005+\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"A!:+\t\t-&qZ\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\t-\b\u0003BAa\u0005[LA!!.\u0002D\u0006a\u0001O]8ek\u000e$\u0018I]5us\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003\u0002B{\u0005w\u00042A B|\u0013\r\u0011Ip \u0002\u0004\u0003:L\b\"CA\u0005q\u0005\u0005\t\u0019AA\b\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAB\u0001!\u0019\u0019\u0019a!\u0002\u0003v6\u0011!qA\u0005\u0005\u0007\u000f\u00119A\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA\u001e\u0007\u001bA\u0011\"!\u0003;\u0003\u0003\u0005\rA!>\u0002\u0011!\f7\u000f[\"pI\u0016$\"!a\u0004\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"Aa;\u0002\r\u0015\fX/\u00197t)\u0011\tYda\u0007\t\u0013\u0005%Q(!AA\u0002\tU\u0018!\u0005;ie>$H\u000f\\3e'>\u001c7.\u001a;tA\u0005\u0011B)\u001a7bs\u0016$7\t\\8tKN{7m[3u!\r\u0011\thP\n\u0006\u007f\r\u0015\"Q\u0013\t\u000b\u0007O\u0019iCa(\u0003,\n=TBAB\u0015\u0015\r\u0019Yc`\u0001\beVtG/[7f\u0013\u0011\u0019yc!\u000b\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0006\u0002\u0004\"\u0005)\u0011\r\u001d9msR1!qNB\u001c\u0007sAqAa'C\u0001\u0004\u0011y\nC\u0004\u0003(\n\u0003\rAa+\u0002\u000fUt\u0017\r\u001d9msR!1qHB&!\u0015q8\u0011IB#\u0013\r\u0019\u0019e \u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000fy\u001c9Ea(\u0003,&\u00191\u0011J@\u0003\rQ+\b\u000f\\33\u0011%\u0019ieQA\u0001\u0002\u0004\u0011y'A\u0002yIA\nqb\u001d;beR\u0004&o\\2fgN|'o\u001d\u000b\u0002{R\u0019Qp!\u0016\t\u000f\u0005mX\t1\u0001\u0004XA111AB-\u0005\u001fIAaa\u0017\u0003\b\t\u00191+Z9\u0002!I,Wn\u001c<f!J|7-Z:t_J\u001cHcA?\u0004b!911\r$A\u0002\u0005=\u0011a\u0003:f[>4XmQ8v]R\f\u0001#\u001b8ji&\fG/Z*ikR$wn\u001e8\u0002\u001b\u0005<\u0018-\u001b;TQV$Hm\\<o\u0003\r\u0011XO\\\u0001\u0011_B,gnU3sm\u0016\u00148k\\2lKR$\u0002\"a=\u0004p\rM4q\u000f\u0005\b\u0007cR\u0005\u0019AAR\u0003\u0011Awn\u001d;\t\u000f\rU$\n1\u0001\u0002\u0010\u0005!\u0001o\u001c:u\u0011\u001d\t)N\u0013a\u0001\u0003\u001f\tA#Y2dKB$h*Z<D_:tWm\u0019;j_:\u001c\u0018AB1dG\u0016\u0004H\u000f\u0006\u0003\u0004\u0000\r\u0005\u0005#\u0002@\u0004B\t}\u0005bBBB\u0019\u0002\u00071QQ\u0001\u0004W\u0016L\b\u0003BAp\u0007\u000fKAa!#\u0002b\na1+\u001a7fGRLwN\\&fs\u0006q2m\u001c8gS\u001e,(/Z!dG\u0016\u0004H/\u001a3T_\u000e\\W\r^\"iC:tW\r\u001c\u000b\u0004{\u000e=\u0005bBBI\u001b\u0002\u0007!qT\u0001\u000eg>\u001c7.\u001a;DQ\u0006tg.\u001a7\u00023\rdwn]3UQJ|G\u000f\u001e7fI\u000e{gN\\3di&|gn]\u0001\u0014CN\u001c\u0018n\u001a8OK^\u001cuN\u001c8fGRLwN\u001c\u000b\t\u0003w\u0019Ija'\u0004 \"91\u0011S(A\u0002\t}\u0005bBBO\u001f\u0002\u0007!qB\u0001\naJ|7-Z:t_JDqa!)P\u0001\u0004\tY$\u0001\u0005nCf\u0014En\\2l\u0003\u00199\u0018m[3va\"\u001a\u0001ka*\u0011\t\u0005\u00057\u0011V\u0005\u0005\u0007W\u000b\u0019M\u0001\u0005Pm\u0016\u0014(/\u001b3f\u00035\tG\r\u001a)s_\u000e,7o]8sgR\u0019Qp!-\t\u000f\rM\u0016\u000b1\u0001\u0002\u0010\u0005AAo\\\"sK\u0006$X-\u0001\u0007oK^\u0004&o\\2fgN|'\u000f\u0006\u0005\u0003\u0010\re6QXBf\u0011\u001d\u0019YL\u0015a\u0001\u0003\u001f\t!!\u001b3\t\u000f\r}&\u000b1\u0001\u0004B\u0006aA.[:uK:,'OT1nKB!11YBd\u001b\t\u0019)MC\u0002V\u0003OIAa!3\u0004F\naA*[:uK:,'OT1nK\"91Q\u001a*A\u0002\r=\u0017\u0001E:fGV\u0014\u0018\u000e^=Qe>$xnY8m!\u0011\u0019\tn!7\u000e\u0005\rM'\u0002BBk\u0007/\fA!Y;uQ*!\u00111LA\u0014\u0013\u0011\u0019Yna5\u0003!M+7-\u001e:jif\u0004&o\u001c;pG>d\u0007")
public abstract class Acceptor
extends AbstractServerThread
implements KafkaMetricsGroup {
    private volatile Acceptor$DelayedCloseSocket$ DelayedCloseSocket$module;
    private final SocketServer socketServer;
    private final EndPoint endPoint;
    private KafkaConfig config;
    private final int nodeId;
    private final ConnectionQuotas connectionQuotas;
    private final Time time;
    private final boolean isPrivilegedListener;
    private final RequestChannel requestChannel;
    private final Metrics metrics;
    private final CredentialProvider credentialProvider;
    private final LogContext logContext;
    private final MemoryPool memoryPool;
    private final ApiVersionManager apiVersionManager;
    private final Integer sendBufferSize;
    private final Integer recvBufferSize;
    private final Integer listenBacklogSize;
    private final Selector nioSelector;
    private final ServerSocketChannel serverChannel;
    private final ArrayBuffer<Processor> processors;
    private final AtomicBoolean processorsStarted;
    private final MetricName blockedPercentMeterMetricName;
    private final Meter blockedPercentMeter;
    private int currentProcessorIndex;
    private final PriorityQueue<DelayedCloseSocket> throttledSockets;

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Meter newMeter(MetricName metricName, String eventType, TimeUnit timeUnit) {
        return KafkaMetricsGroup.newMeter$(this, metricName, eventType, timeUnit);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    public Acceptor$DelayedCloseSocket$ DelayedCloseSocket() {
        if (this.DelayedCloseSocket$module == null) {
            this.DelayedCloseSocket$lzycompute$1();
        }
        return this.DelayedCloseSocket$module;
    }

    public SocketServer socketServer() {
        return this.socketServer;
    }

    public EndPoint endPoint() {
        return this.endPoint;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    public abstract String metricPrefix();

    public abstract String threadPrefix();

    private Integer sendBufferSize() {
        return this.sendBufferSize;
    }

    private Integer recvBufferSize() {
        return this.recvBufferSize;
    }

    private Integer listenBacklogSize() {
        return this.listenBacklogSize;
    }

    private Selector nioSelector() {
        return this.nioSelector;
    }

    public ServerSocketChannel serverChannel() {
        return this.serverChannel;
    }

    public ArrayBuffer<Processor> processors() {
        return this.processors;
    }

    private AtomicBoolean processorsStarted() {
        return this.processorsStarted;
    }

    private MetricName blockedPercentMeterMetricName() {
        return this.blockedPercentMeterMetricName;
    }

    private Meter blockedPercentMeter() {
        return this.blockedPercentMeter;
    }

    private int currentProcessorIndex() {
        return this.currentProcessorIndex;
    }

    private void currentProcessorIndex_$eq(int x$1) {
        this.currentProcessorIndex = x$1;
    }

    public PriorityQueue<DelayedCloseSocket> throttledSockets() {
        return this.throttledSockets;
    }

    public synchronized void startProcessors() {
        if (!this.processorsStarted().getAndSet(true)) {
            this.startProcessors((Seq<Processor>)this.processors());
        }
    }

    private synchronized void startProcessors(Seq<Processor> processors) {
        processors.foreach((Function1 & Serializable & scala.Serializable)processor -> {
            Acceptor.$anonfun$startProcessors$1(this, processor);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void removeProcessors(int removeCount) {
        ArrayBuffer toRemove = (ArrayBuffer)this.processors().takeRight(removeCount);
        this.processors().remove(this.processors().size() - removeCount, removeCount);
        toRemove.foreach((Function1 & Serializable & scala.Serializable)x$11 -> {
            x$11.initiateShutdown();
            return BoxedUnit.UNIT;
        });
        toRemove.foreach((Function1 & Serializable & scala.Serializable)x$12 -> {
            x$12.awaitShutdown();
            return BoxedUnit.UNIT;
        });
        toRemove.foreach((Function1 & Serializable & scala.Serializable)processor -> {
            this.requestChannel.removeProcessor(processor.id());
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void initiateShutdown() {
        super.initiateShutdown();
        synchronized (this) {
            this.processors().foreach((Function1 & Serializable & scala.Serializable)x$13 -> {
                x$13.initiateShutdown();
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    @Override
    public void awaitShutdown() {
        super.awaitShutdown();
        synchronized (this) {
            this.processors().foreach((Function1 & Serializable & scala.Serializable)x$14 -> {
                x$14.awaitShutdown();
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        this.serverChannel().register(this.nioSelector(), 16);
        this.startupComplete();
        try {
            while (this.isRunning()) {
                try {
                    this.acceptNewConnections();
                    this.closeThrottledConnections();
                }
                catch (Throwable throwable) {
                    if (throwable instanceof ControlThrowable) {
                        throw (Throwable)((ControlThrowable)throwable);
                    }
                    if (throwable == null) throw null;
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error occurred", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable);
                    continue;
                    return;
                }
            }
        }
        finally {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Closing server socket, selector, and any throttled sockets.");
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.serverChannel().close(), this, Level.ERROR);
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.nioSelector().close(), this, Level.ERROR);
            this.throttledSockets().foreach((Function1 & Serializable & scala.Serializable)throttledSocket -> {
                this.closeSocket(throttledSocket.socket());
                return BoxedUnit.UNIT;
            });
            this.throttledSockets().clear();
            this.shutdownComplete();
        }
    }

    private ServerSocketChannel openServerSocket(String host, int port, int listenBacklogSize) {
        InetSocketAddress socketAddress = Utils.isBlank((String)host) ? new InetSocketAddress(port) : new InetSocketAddress(host, port);
        ServerSocketChannel serverChannel = ServerSocketChannel.open();
        serverChannel.configureBlocking(false);
        if (!BoxesRunTime.equalsNumObject((Number)this.recvBufferSize(), (Object)BoxesRunTime.boxToInteger((int)-1))) {
            serverChannel.socket().setReceiveBufferSize(Predef$.MODULE$.Integer2int(this.recvBufferSize()));
        }
        try {
            serverChannel.socket().bind(socketAddress, listenBacklogSize);
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Awaiting socket connections on ").append(socketAddress.getHostString()).append(":").append(serverChannel.socket().getLocalPort()).append(".").toString());
        }
        catch (SocketException e) {
            throw new KafkaException(new StringBuilder(36).append("Socket server failed to bind to ").append(socketAddress.getHostString()).append(":").append(port).append(": ").append(e.getMessage()).append(".").toString(), (Throwable)e);
        }
        return serverChannel;
    }

    private void acceptNewConnections() {
        if (this.nioSelector().select(500L) > 0) {
            java.util.Iterator<SelectionKey> iter = this.nioSelector().selectedKeys().iterator();
            while (iter.hasNext() && this.isRunning()) {
                try {
                    SelectionKey key = iter.next();
                    iter.remove();
                    if (key.isAcceptable()) {
                        this.accept(key).foreach((Function1 & Serializable & scala.Serializable)socketChannel -> {
                            Acceptor.$anonfun$acceptNewConnections$1(this, socketChannel);
                            return BoxedUnit.UNIT;
                        });
                        continue;
                    }
                    throw new IllegalStateException("Unrecognized key state for acceptor thread.");
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error while accepting connection", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                }
            }
        }
    }

    private Option<SocketChannel> accept(SelectionKey key) {
        SocketChannel socketChannel = ((ServerSocketChannel)key.channel()).accept();
        try {
            this.connectionQuotas.inc(this.endPoint().listenerName(), socketChannel.socket().getInetAddress(), this.blockedPercentMeter());
            this.configureAcceptedSocketChannel(socketChannel);
            return new Some((Object)socketChannel);
        }
        catch (TooManyConnectionsException e) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(86).append("Rejected connection from ").append(e.ip()).append(", address already has the configured maximum of ").append(e.count()).append(" connections.").toString());
            this.close(this.endPoint().listenerName(), socketChannel);
            return None$.MODULE$;
        }
        catch (ConnectionThrottledException e) {
            InetAddress ip = socketChannel.socket().getInetAddress();
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Delaying closing of connection from ").append(ip).append(" for ").append(e.throttleTimeMs()).append(" ms").toString());
            long endThrottleTimeMs = e.startThrottleTimeMs() + e.throttleTimeMs();
            this.throttledSockets().$plus$eq((Object)new DelayedCloseSocket(this, socketChannel, endThrottleTimeMs));
            return None$.MODULE$;
        }
        catch (IOException e) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Encountered an error while configuring the connection, closing it.", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            this.close(this.endPoint().listenerName(), socketChannel);
            return None$.MODULE$;
        }
    }

    public void configureAcceptedSocketChannel(SocketChannel socketChannel) {
        socketChannel.configureBlocking(false);
        socketChannel.socket().setTcpNoDelay(true);
        socketChannel.socket().setKeepAlive(true);
        if (!BoxesRunTime.equalsNumObject((Number)this.sendBufferSize(), (Object)BoxesRunTime.boxToInteger((int)-1))) {
            socketChannel.socket().setSendBufferSize(Predef$.MODULE$.Integer2int(this.sendBufferSize()));
        }
    }

    private void closeThrottledConnections() {
        long timeMs = this.time.milliseconds();
        while (this.throttledSockets().headOption().exists((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)Acceptor.$anonfun$closeThrottledConnections$1(timeMs, x$15)))) {
            DelayedCloseSocket closingSocket = (DelayedCloseSocket)this.throttledSockets().dequeue();
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Closing socket from ip ").append(closingSocket.socket().getRemoteAddress()).toString());
            this.closeSocket(closingSocket.socket());
        }
    }

    private boolean assignNewConnection(SocketChannel socketChannel, Processor processor, boolean mayBlock) {
        if (processor.accept(socketChannel, mayBlock, this.blockedPercentMeter())) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(138).append("Accepted connection from ").append(socketChannel.socket().getRemoteSocketAddress()).append(" on").append(" ").append(socketChannel.socket().getLocalSocketAddress()).append(" and assigned it to processor ").append(processor.id()).append(",").append(" sendBufferSize [actual|requested]: [").append(socketChannel.socket().getSendBufferSize()).append("|").append(this.sendBufferSize()).append("]").append(" recvBufferSize [actual|requested]: [").append(socketChannel.socket().getReceiveBufferSize()).append("|").append(this.recvBufferSize()).append("]").toString());
            return true;
        }
        return false;
    }

    @Override
    public void wakeup() {
        this.nioSelector().wakeup();
    }

    public void addProcessors(int toCreate) {
        ListenerName listenerName = this.endPoint().listenerName();
        SecurityProtocol securityProtocol = this.endPoint().securityProtocol();
        ArrayBuffer listenerProcessors = new ArrayBuffer();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), toCreate).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            Processor processor = this.newProcessor(this.socketServer().nextProcessorId(), listenerName, securityProtocol);
            listenerProcessors.$plus$eq((Object)processor);
            $this.requestChannel.addProcessor(processor);
        });
        this.processors().$plus$plus$eq((TraversableOnce)listenerProcessors);
        if (this.processorsStarted().get()) {
            this.startProcessors((Seq<Processor>)listenerProcessors);
        }
    }

    public Processor newProcessor(int id, ListenerName listenerName, SecurityProtocol securityProtocol) {
        return new Processor(id, this.time, Predef$.MODULE$.Integer2int(this.config().socketRequestMaxBytes()), this.requestChannel, this.connectionQuotas, Predef$.MODULE$.Long2long(this.config().connectionsMaxIdleMs()), Predef$.MODULE$.Integer2int(this.config().failedAuthenticationDelayMs()), listenerName, securityProtocol, this.config(), this.metrics, this.credentialProvider, this.memoryPool, this.logContext, Processor$.MODULE$.ConnectionQueueSize(), this.isPrivilegedListener, this.apiVersionManager);
    }

    private final void DelayedCloseSocket$lzycompute$1() {
        synchronized (this) {
            if (this.DelayedCloseSocket$module == null) {
                this.DelayedCloseSocket$module = new Acceptor$DelayedCloseSocket$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$startProcessors$1(Acceptor $this, Processor processor) {
        String nonDaemon_name = new StringBuilder(25).append($this.threadPrefix()).append("-kafka-network-thread-").append($this.nodeId).append("-").append($this.endPoint().listenerName()).append("-").append($this.endPoint().securityProtocol()).append("-").append(processor.id()).toString();
        new KafkaThread(nonDaemon_name, (Runnable)processor, false).start();
    }

    public static final /* synthetic */ void $anonfun$acceptNewConnections$1(Acceptor $this, SocketChannel socketChannel) {
        Processor processor;
        int n;
        synchronized ($this) {
            n = $this.processors().length();
        }
        int retriesLeft = n;
        do {
            --retriesLeft;
            synchronized ($this) {
                $this.currentProcessorIndex_$eq($this.currentProcessorIndex() % $this.processors().length());
                processor = (Processor)$this.processors().apply($this.currentProcessorIndex());
            }
            $this.currentProcessorIndex_$eq($this.currentProcessorIndex() + 1);
        } while (!$this.assignNewConnection(socketChannel, processor, retriesLeft == 0));
    }

    public static final /* synthetic */ boolean $anonfun$closeThrottledConnections$1(long timeMs$1, DelayedCloseSocket x$15) {
        return x$15.endThrottleTimeMs() < timeMs$1;
    }

    public Acceptor(SocketServer socketServer, EndPoint endPoint, KafkaConfig config, int nodeId, ConnectionQuotas connectionQuotas, Time time, boolean isPrivilegedListener, RequestChannel requestChannel, Metrics metrics, CredentialProvider credentialProvider, LogContext logContext, MemoryPool memoryPool, ApiVersionManager apiVersionManager) {
        this.socketServer = socketServer;
        this.endPoint = endPoint;
        this.config = config;
        this.nodeId = nodeId;
        this.connectionQuotas = connectionQuotas;
        this.time = time;
        this.isPrivilegedListener = isPrivilegedListener;
        this.requestChannel = requestChannel;
        this.metrics = metrics;
        this.credentialProvider = credentialProvider;
        this.logContext = logContext;
        this.memoryPool = memoryPool;
        this.apiVersionManager = apiVersionManager;
        super(connectionQuotas);
        KafkaMetricsGroup.$init$(this);
        this.sendBufferSize = this.config().socketSendBufferBytes();
        this.recvBufferSize = this.config().socketReceiveBufferBytes();
        this.listenBacklogSize = this.config().socketListenBacklogSize();
        this.nioSelector = Selector.open();
        this.serverChannel = this.openServerSocket(endPoint.host(), endPoint.port(), Predef$.MODULE$.Integer2int(this.listenBacklogSize()));
        this.processors = new ArrayBuffer();
        this.processorsStarted = new AtomicBoolean();
        this.blockedPercentMeterMetricName = this.explicitMetricName("kafka.network", "Acceptor", new StringBuilder(22).append(this.metricPrefix()).append("AcceptorBlockedPercent").toString(), (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.ListenerMetricTag()), (Object)endPoint.listenerName().value())}))));
        this.blockedPercentMeter = this.newMeter(this.blockedPercentMeterMetricName(), "blocked time", TimeUnit.NANOSECONDS);
        this.currentProcessorIndex = 0;
        this.throttledSockets = new PriorityQueue(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
    }

    public class DelayedCloseSocket
    implements Ordered<DelayedCloseSocket>,
    Product,
    scala.Serializable {
        private final SocketChannel socket;
        private final long endThrottleTimeMs;
        public final /* synthetic */ Acceptor $outer;

        public boolean $less(Object that) {
            return Ordered.$less$((Ordered)this, (Object)that);
        }

        public boolean $greater(Object that) {
            return Ordered.$greater$((Ordered)this, (Object)that);
        }

        public boolean $less$eq(Object that) {
            return Ordered.$less$eq$((Ordered)this, (Object)that);
        }

        public boolean $greater$eq(Object that) {
            return Ordered.$greater$eq$((Ordered)this, (Object)that);
        }

        public int compareTo(Object that) {
            return Ordered.compareTo$((Ordered)this, (Object)that);
        }

        public SocketChannel socket() {
            return this.socket;
        }

        public long endThrottleTimeMs() {
            return this.endThrottleTimeMs;
        }

        public int compare(DelayedCloseSocket that) {
            return new RichLong(Predef$.MODULE$.longWrapper(this.endThrottleTimeMs())).compare((Object)BoxesRunTime.boxToLong((long)that.endThrottleTimeMs()));
        }

        public DelayedCloseSocket copy(SocketChannel socket, long endThrottleTimeMs) {
            return new DelayedCloseSocket(this.kafka$network$Acceptor$DelayedCloseSocket$$$outer(), socket, endThrottleTimeMs);
        }

        public SocketChannel copy$default$1() {
            return this.socket();
        }

        public long copy$default$2() {
            return this.endThrottleTimeMs();
        }

        public String productPrefix() {
            return "DelayedCloseSocket";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.socket();
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this.endThrottleTimeMs());
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof DelayedCloseSocket;
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)-889275714, (int)Statics.anyHash((Object)this.socket())), (int)Statics.longHash((long)this.endThrottleTimeMs())), (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            if (!(x$1 instanceof DelayedCloseSocket)) return false;
            if (((DelayedCloseSocket)x$1).kafka$network$Acceptor$DelayedCloseSocket$$$outer() != this.kafka$network$Acceptor$DelayedCloseSocket$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            DelayedCloseSocket delayedCloseSocket = (DelayedCloseSocket)x$1;
            SocketChannel socketChannel = this.socket();
            SocketChannel socketChannel2 = delayedCloseSocket.socket();
            if (socketChannel == null) {
                if (socketChannel2 != null) {
                    return false;
                }
            } else if (!socketChannel.equals(socketChannel2)) return false;
            if (this.endThrottleTimeMs() != delayedCloseSocket.endThrottleTimeMs()) return false;
            if (!delayedCloseSocket.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ Acceptor kafka$network$Acceptor$DelayedCloseSocket$$$outer() {
            return this.$outer;
        }

        public DelayedCloseSocket(Acceptor $outer, SocketChannel socket, long endThrottleTimeMs) {
            this.socket = socket;
            this.endThrottleTimeMs = endThrottleTimeMs;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Ordered.$init$((Ordered)this);
            Product.$init$((Product)this);
        }
    }
}

