/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.suggest.document;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.search.suggest.document.CompletionTokenStream;
import org.apache.lucene.store.OutputStreamDataOutput;
import org.apache.lucene.util.BytesRef;

public class SuggestField
extends Field {
    public static final FieldType FIELD_TYPE = new FieldType();
    static final byte TYPE = 0;
    private final BytesRef surfaceForm;
    private final int weight;

    public SuggestField(String name, String value, int weight) {
        super(name, value, FIELD_TYPE);
        if (weight < 0) {
            throw new IllegalArgumentException("weight must be >= 0");
        }
        if (value.length() == 0) {
            throw new IllegalArgumentException("value must have a length > 0");
        }
        for (int i = 0; i < value.length(); ++i) {
            if (!this.isReserved(value.charAt(i))) continue;
            throw new IllegalArgumentException("Illegal input [" + value + "] UTF-16 codepoint [0x" + Integer.toHexString(value.charAt(i)) + "] at position " + i + " is a reserved character");
        }
        this.surfaceForm = new BytesRef((CharSequence)value);
        this.weight = weight;
    }

    public TokenStream tokenStream(Analyzer analyzer, TokenStream reuse) {
        CompletionTokenStream completionStream = this.wrapTokenStream(super.tokenStream(analyzer, reuse));
        completionStream.setPayload(this.buildSuggestPayload());
        return completionStream;
    }

    protected CompletionTokenStream wrapTokenStream(TokenStream stream) {
        if (stream instanceof CompletionTokenStream) {
            return (CompletionTokenStream)stream;
        }
        return new CompletionTokenStream(stream);
    }

    protected byte type() {
        return 0;
    }

    private BytesRef buildSuggestPayload() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (OutputStreamDataOutput output = new OutputStreamDataOutput((OutputStream)byteArrayOutputStream);){
            output.writeVInt(this.surfaceForm.length);
            output.writeBytes(this.surfaceForm.bytes, this.surfaceForm.offset, this.surfaceForm.length);
            output.writeVInt(this.weight + 1);
            output.writeByte(this.type());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new BytesRef(byteArrayOutputStream.toByteArray());
    }

    private boolean isReserved(char c) {
        switch (c) {
            case '\u0000': 
            case '\u001e': 
            case '\u001f': {
                return true;
            }
        }
        return false;
    }

    static {
        FIELD_TYPE.setTokenized(true);
        FIELD_TYPE.setStored(false);
        FIELD_TYPE.setStoreTermVectors(false);
        FIELD_TYPE.setOmitNorms(false);
        FIELD_TYPE.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
        FIELD_TYPE.freeze();
    }
}

