/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.resolver.filter;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;

public class ScopeArtifactFilter
implements ArtifactFilter {
    private final boolean compileScope;
    private final boolean runtimeScope;
    private final boolean testScope;
    private final boolean providedScope;
    private final boolean systemScope;

    public ScopeArtifactFilter(String scope) {
        if (Artifact.SCOPE_COMPILE.equals(scope)) {
            this.systemScope = true;
            this.providedScope = true;
            this.compileScope = true;
            this.runtimeScope = false;
            this.testScope = false;
        } else if (Artifact.SCOPE_RUNTIME.equals(scope)) {
            this.systemScope = false;
            this.providedScope = false;
            this.compileScope = true;
            this.runtimeScope = true;
            this.testScope = false;
        } else if (Artifact.SCOPE_RUNTIME_PLUS_SYSTEM.equals(scope)) {
            this.systemScope = true;
            this.providedScope = false;
            this.compileScope = true;
            this.runtimeScope = true;
            this.testScope = false;
        } else if (Artifact.SCOPE_TEST.equals(scope)) {
            this.systemScope = true;
            this.providedScope = true;
            this.compileScope = true;
            this.runtimeScope = true;
            this.testScope = true;
        } else {
            this.systemScope = false;
            this.providedScope = false;
            this.compileScope = false;
            this.runtimeScope = false;
            this.testScope = false;
        }
    }

    public boolean include(Artifact artifact) {
        if (Artifact.SCOPE_COMPILE.equals(artifact.getScope())) {
            return this.compileScope;
        }
        if (Artifact.SCOPE_RUNTIME.equals(artifact.getScope())) {
            return this.runtimeScope;
        }
        if (Artifact.SCOPE_TEST.equals(artifact.getScope())) {
            return this.testScope;
        }
        if (Artifact.SCOPE_PROVIDED.equals(artifact.getScope())) {
            return this.providedScope;
        }
        if (Artifact.SCOPE_SYSTEM.equals(artifact.getScope())) {
            return this.systemScope;
        }
        return true;
    }
}

