/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.repository.metadata;

import java.util.ArrayList;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.Plugin;
import org.apache.maven.artifact.repository.metadata.Snapshot;
import org.apache.maven.artifact.repository.metadata.Versioning;

class MetadataUtils {
    MetadataUtils() {
    }

    public static Metadata cloneMetadata(Metadata src) {
        if (src == null) {
            return null;
        }
        Metadata target = new Metadata();
        target.setGroupId(src.getGroupId());
        target.setArtifactId(src.getArtifactId());
        target.setVersion(src.getVersion());
        target.setVersioning(MetadataUtils.cloneVersioning(src.getVersioning()));
        for (Plugin plugin : src.getPlugins()) {
            target.addPlugin(MetadataUtils.clonePlugin(plugin));
        }
        return target;
    }

    public static Plugin clonePlugin(Plugin src) {
        if (src == null) {
            return null;
        }
        Plugin target = new Plugin();
        target.setArtifactId(src.getArtifactId());
        target.setName(src.getName());
        target.setPrefix(src.getPrefix());
        return target;
    }

    public static Versioning cloneVersioning(Versioning src) {
        if (src == null) {
            return null;
        }
        Versioning target = new Versioning();
        target.setLastUpdated(src.getLastUpdated());
        target.setLatest(src.getLatest());
        target.setRelease(src.getRelease());
        target.setSnapshot(MetadataUtils.cloneSnapshot(src.getSnapshot()));
        target.setVersions(new ArrayList(src.getVersions()));
        return target;
    }

    public static Snapshot cloneSnapshot(Snapshot src) {
        if (src == null) {
            return null;
        }
        Snapshot target = new Snapshot();
        target.setBuildNumber(src.getBuildNumber());
        target.setLocalCopy(src.isLocalCopy());
        target.setTimestamp(src.getTimestamp());
        return target;
    }
}

