/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project.interpolation;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.project.interpolation.ModelInterpolationException;
import org.apache.maven.project.interpolation.ModelInterpolator;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.interpolation.EnvarBasedValueSource;
import org.codehaus.plexus.util.interpolation.MapBasedValueSource;
import org.codehaus.plexus.util.interpolation.ObjectBasedValueSource;
import org.codehaus.plexus.util.interpolation.RegexBasedInterpolator;
import org.codehaus.plexus.util.interpolation.ValueSource;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class RegexBasedModelInterpolator
extends AbstractLogEnabled
implements ModelInterpolator {
    public Model interpolate(Model project, Map context) throws ModelInterpolationException {
        return this.interpolate(project, context, true);
    }

    public Model interpolate(Model model, Map context, boolean strict) throws ModelInterpolationException {
        StringWriter sWriter = new StringWriter();
        MavenXpp3Writer writer = new MavenXpp3Writer();
        try {
            writer.write((Writer)sWriter, model);
        }
        catch (IOException e) {
            throw new ModelInterpolationException("Cannot serialize project model for interpolation.", e);
        }
        String serializedModel = sWriter.toString();
        RegexBasedInterpolator interpolator = new RegexBasedInterpolator();
        interpolator.addValueSource((ValueSource)new MapBasedValueSource(context));
        interpolator.addValueSource((ValueSource)new MapBasedValueSource((Map)model.getProperties()));
        interpolator.addValueSource((ValueSource)new ObjectBasedValueSource((Object)model));
        try {
            interpolator.addValueSource((ValueSource)new EnvarBasedValueSource());
        }
        catch (IOException e) {
            this.getLogger().warn("Cannot initialize environment variables resolver. Skipping environmental resolution.");
            this.getLogger().debug("Failed to initialize envar resolver. Skipping environmental resolution.", (Throwable)e);
        }
        serializedModel = interpolator.interpolate(serializedModel, "pom|project");
        StringReader sReader = new StringReader(serializedModel);
        MavenXpp3Reader modelReader = new MavenXpp3Reader();
        try {
            model = modelReader.read((Reader)sReader, strict);
        }
        catch (IOException e) {
            throw new ModelInterpolationException("Cannot read project model from interpolating filter of serialized version.", e);
        }
        catch (XmlPullParserException e) {
            throw new ModelInterpolationException("Cannot read project model from interpolating filter of serialized version.", e);
        }
        return model;
    }
}

