/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.jar.identification.exposers;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.jar.JarEntry;
import org.apache.maven.model.Model;
import org.apache.maven.model.Organization;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.shared.jar.JarAnalyzer;
import org.apache.maven.shared.jar.identification.JarIdentification;
import org.apache.maven.shared.jar.identification.JarIdentificationExposer;
import org.apache.maven.shared.utils.io.IOUtil;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class EmbeddedMavenModelExposer
extends AbstractLogEnabled
implements JarIdentificationExposer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expose(JarIdentification identification, JarAnalyzer jarAnalyzer) {
        List entries = jarAnalyzer.getMavenPomEntries();
        if (entries.isEmpty()) {
            return;
        }
        if (entries.size() > 1) {
            this.getLogger().warn("More than one Maven model entry was found in the JAR, using only the first of: " + entries);
        }
        JarEntry pom = (JarEntry)entries.get(0);
        MavenXpp3Reader pomreader = new MavenXpp3Reader();
        InputStream is = null;
        try {
            Organization org;
            is = jarAnalyzer.getEntryInputStream(pom);
            InputStreamReader isreader = new InputStreamReader(is);
            Model model = pomreader.read((Reader)isreader);
            identification.addAndSetGroupId(model.getGroupId());
            identification.addAndSetArtifactId(model.getArtifactId());
            identification.addAndSetVersion(model.getVersion());
            identification.addAndSetName(model.getName());
            if (model.getName() == null) {
                identification.addAndSetName(model.getArtifactId());
            }
            if ((org = model.getOrganization()) != null) {
                identification.addAndSetVendor(org.getName());
            }
        }
        catch (IOException e) {
            this.getLogger().error("Unable to read model " + pom.getName() + " in " + jarAnalyzer.getFile() + ".", (Throwable)e);
        }
        catch (XmlPullParserException e) {
            this.getLogger().error("Unable to parse model " + pom.getName() + " in " + jarAnalyzer.getFile() + ".", (Throwable)e);
        }
        finally {
            IOUtil.close((InputStream)is);
        }
    }
}

