/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junit;

import java.util.Iterator;
import org.apache.maven.surefire.common.junit3.JUnit3Reflector;
import org.apache.maven.surefire.common.junit3.JUnit3TestChecker;
import org.apache.maven.surefire.junit.JUnitTestSet;
import org.apache.maven.surefire.junit.PojoAndJUnit3Checker;
import org.apache.maven.surefire.junit.PojoTestSet;
import org.apache.maven.surefire.junit.SurefireTestSet;
import org.apache.maven.surefire.providerapi.ProviderParameters;
import org.apache.maven.surefire.providerapi.SurefireProvider;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.Reporter;
import org.apache.maven.surefire.report.ReporterException;
import org.apache.maven.surefire.report.ReporterFactory;
import org.apache.maven.surefire.report.SimpleReportEntry;
import org.apache.maven.surefire.suite.RunResult;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.apache.maven.surefire.util.DirectoryScanner;
import org.apache.maven.surefire.util.ScannerFilter;
import org.apache.maven.surefire.util.TestsToRun;

public class JUnit3Provider
implements SurefireProvider {
    private final ReporterFactory reporterFactory;
    private final ClassLoader testClassLoader;
    private final DirectoryScanner directoryScanner;
    private final PojoAndJUnit3Checker testChecker;
    private final JUnit3TestChecker jUnit3TestChecker;
    private final JUnit3Reflector reflector;
    private TestsToRun testsToRun;

    public JUnit3Provider(ProviderParameters booterParameters) {
        this.reporterFactory = booterParameters.getReporterFactory();
        this.testClassLoader = booterParameters.getTestClassLoader();
        this.directoryScanner = booterParameters.getDirectoryScanner();
        this.reflector = new JUnit3Reflector(this.testClassLoader);
        this.jUnit3TestChecker = new JUnit3TestChecker(this.testClassLoader);
        this.testChecker = new PojoAndJUnit3Checker(this.jUnit3TestChecker);
    }

    public RunResult invoke(Object forkTestSet) throws TestSetFailedException, ReporterException {
        if (this.testsToRun == null) {
            this.testsToRun = forkTestSet == null ? this.scanClassPath() : TestsToRun.fromClass((Class)((Class)forkTestSet));
        }
        Reporter reporter = this.reporterFactory.createReporter();
        Iterator iter = this.testsToRun.iterator();
        while (iter.hasNext()) {
            Class clazz = (Class)iter.next();
            SurefireTestSet surefireTestSet = this.createTestSet(clazz);
            this.executeTestSet(surefireTestSet, reporter, this.testClassLoader);
        }
        return this.reporterFactory.close();
    }

    private SurefireTestSet createTestSet(Class clazz) throws TestSetFailedException {
        return this.reflector.isJUnit3Available() && this.jUnit3TestChecker.accept(clazz) ? new JUnitTestSet(clazz, this.reflector) : new PojoTestSet(clazz);
    }

    private void executeTestSet(SurefireTestSet testSet, Reporter reporter, ClassLoader classLoader) throws ReporterException, TestSetFailedException {
        SimpleReportEntry report = new SimpleReportEntry(this.getClass().getName(), testSet.getName());
        reporter.testSetStarting((ReportEntry)report);
        testSet.execute(reporter, classLoader);
        reporter.testSetCompleted((ReportEntry)report);
    }

    private TestsToRun scanClassPath() {
        return this.directoryScanner.locateTestClasses(this.testClassLoader, (ScannerFilter)this.testChecker);
    }

    public Iterator getSuites() {
        this.testsToRun = this.scanClassPath();
        return this.testsToRun.iterator();
    }

    public Boolean isRunnable() {
        return Boolean.TRUE;
    }
}

