/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata.bookkeeper;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.bookkeeper.discover.RegistrationClient;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.versioning.Version;
import org.apache.bookkeeper.versioning.Versioned;
import org.apache.pulsar.metadata.api.MetadataStore;
import org.apache.pulsar.metadata.api.Notification;
import org.apache.pulsar.metadata.api.NotificationType;

public class PulsarRegistrationClient
implements RegistrationClient {
    private final MetadataStore store;
    private final String ledgersRootPath;
    private final String bookieRegistrationPath;
    private final String bookieAllRegistrationPath;
    private final String bookieReadonlyRegistrationPath;
    private final Map<RegistrationClient.RegistrationListener, Boolean> writableBookiesWatchers = new ConcurrentHashMap<RegistrationClient.RegistrationListener, Boolean>();
    private final Map<RegistrationClient.RegistrationListener, Boolean> readOnlyBookiesWatchers = new ConcurrentHashMap<RegistrationClient.RegistrationListener, Boolean>();

    public PulsarRegistrationClient(MetadataStore store, String ledgersRootPath) {
        this.store = store;
        this.ledgersRootPath = ledgersRootPath;
        this.bookieRegistrationPath = ledgersRootPath + "/" + "available";
        this.bookieAllRegistrationPath = ledgersRootPath + "/" + "cookies";
        this.bookieReadonlyRegistrationPath = this.bookieRegistrationPath + "/" + "readonly";
        store.registerListener(this::updatedBookies);
    }

    public void close() {
    }

    public CompletableFuture<Versioned<Set<BookieId>>> getWritableBookies() {
        return this.getChildren(this.bookieRegistrationPath);
    }

    public CompletableFuture<Versioned<Set<BookieId>>> getAllBookies() {
        CompletableFuture<Versioned<Set<BookieId>>> wb = this.getWritableBookies();
        CompletableFuture<Versioned<Set<BookieId>>> rb = this.getReadOnlyBookies();
        return wb.thenCombine(rb, (rw, ro) -> {
            HashSet res = new HashSet();
            res.addAll((Collection)rw.getValue());
            res.addAll((Collection)ro.getValue());
            return new Versioned(res, Version.NEW);
        });
    }

    public CompletableFuture<Versioned<Set<BookieId>>> getReadOnlyBookies() {
        return this.getChildren(this.bookieReadonlyRegistrationPath);
    }

    private CompletableFuture<Versioned<Set<BookieId>>> getChildren(String path) {
        return ((CompletableFuture)this.store.getChildren(path).thenApply(PulsarRegistrationClient::convertToBookieAddresses)).thenApply(s -> new Versioned(s, Version.NEW));
    }

    public CompletableFuture<Void> watchWritableBookies(RegistrationClient.RegistrationListener registrationListener) {
        this.writableBookiesWatchers.put(registrationListener, Boolean.TRUE);
        return this.getWritableBookies().thenAccept(arg_0 -> ((RegistrationClient.RegistrationListener)registrationListener).onBookiesChanged(arg_0));
    }

    public void unwatchWritableBookies(RegistrationClient.RegistrationListener registrationListener) {
        this.writableBookiesWatchers.remove(registrationListener);
    }

    public CompletableFuture<Void> watchReadOnlyBookies(RegistrationClient.RegistrationListener registrationListener) {
        this.readOnlyBookiesWatchers.put(registrationListener, Boolean.TRUE);
        return this.getReadOnlyBookies().thenAccept(arg_0 -> ((RegistrationClient.RegistrationListener)registrationListener).onBookiesChanged(arg_0));
    }

    public void unwatchReadOnlyBookies(RegistrationClient.RegistrationListener registrationListener) {
        this.readOnlyBookiesWatchers.remove(registrationListener);
    }

    private void updatedBookies(Notification n) {
        if (n.getType() == NotificationType.Created || n.getType() == NotificationType.Deleted) {
            if (n.getPath().startsWith(this.bookieReadonlyRegistrationPath)) {
                this.getReadOnlyBookies().thenAccept(bookies -> this.readOnlyBookiesWatchers.keySet().forEach(w -> w.onBookiesChanged(bookies)));
            } else if (n.getPath().startsWith(this.bookieRegistrationPath)) {
                this.getWritableBookies().thenAccept(bookies -> this.writableBookiesWatchers.keySet().forEach(w -> w.onBookiesChanged(bookies)));
            }
        }
    }

    private static Set<BookieId> convertToBookieAddresses(List<String> children) {
        HashSet<BookieId> newBookieAddrs = new HashSet<BookieId>();
        for (String bookieAddrString : children) {
            if ("readonly".equals(bookieAddrString)) continue;
            BookieId bookieAddr = BookieId.parse((String)bookieAddrString);
            newBookieAddrs.add(bookieAddr);
        }
        return newBookieAddrs;
    }
}

