/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.client.grpc;

import com.google.common.collect.Lists;
import io.grpc.BindableService;
import io.grpc.MethodDescriptor;
import io.grpc.ServerServiceDefinition;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.client.core.disruptor.ShenyuClientRegisterEventPublisher;
import org.apache.shenyu.client.core.exception.ShenyuClientIllegalArgumentException;
import org.apache.shenyu.client.grpc.common.annotation.ShenyuGrpcClient;
import org.apache.shenyu.client.grpc.common.dto.GrpcExt;
import org.apache.shenyu.client.grpc.json.JsonServerServiceInterceptor;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.IpUtils;
import org.apache.shenyu.register.client.api.ShenyuClientRegisterRepository;
import org.apache.shenyu.register.common.config.PropertiesConfig;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.apache.shenyu.register.common.type.DataTypeParent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.lang.NonNull;
import org.springframework.util.ReflectionUtils;

public class GrpcClientEventListener
implements ApplicationListener<ContextRefreshedEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(GrpcClientEventListener.class);
    private final ShenyuClientRegisterEventPublisher publisher = ShenyuClientRegisterEventPublisher.getInstance();
    private final String contextPath;
    private final String ipAndPort;
    private final String host;
    private final int port;
    private final List<ServerServiceDefinition> serviceDefinitions = Lists.newArrayList();

    public GrpcClientEventListener(PropertiesConfig clientConfig, ShenyuClientRegisterRepository shenyuClientRegisterRepository) {
        Properties props = clientConfig.getProps();
        String contextPath = props.getProperty("contextPath");
        String ipAndPort = props.getProperty("ipAndPort");
        String port = props.getProperty("port");
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{contextPath, ipAndPort, port})) {
            throw new ShenyuClientIllegalArgumentException("grpc client must config the contextPath, ipAndPort");
        }
        this.ipAndPort = ipAndPort;
        this.contextPath = contextPath;
        this.host = props.getProperty("host");
        this.port = Integer.parseInt(port);
        this.publisher.start(shenyuClientRegisterRepository);
    }

    public void onApplicationEvent(@NonNull ContextRefreshedEvent contextRefreshedEvent) {
        Map beans = contextRefreshedEvent.getApplicationContext().getBeansOfType(BindableService.class);
        for (Map.Entry entry : beans.entrySet()) {
            this.exportJsonGenericService((BindableService)entry.getValue());
            this.handler(entry.getValue());
        }
    }

    private void handler(Object serviceBean) {
        Method[] methods;
        String packageName;
        Class clazz;
        try {
            clazz = serviceBean.getClass();
        }
        catch (Exception e) {
            LOG.error("failed to get grpc target class", (Throwable)e);
            return;
        }
        if (AopUtils.isAopProxy((Object)serviceBean)) {
            clazz = AopUtils.getTargetClass((Object)serviceBean);
        }
        Class<?> parent = clazz.getSuperclass();
        Class<?> classes = parent.getDeclaringClass();
        try {
            String serviceName = "SERVICE_NAME";
            Field field = classes.getField(serviceName);
            field.setAccessible(true);
            packageName = field.get(null).toString();
        }
        catch (Exception e) {
            LOG.error(String.format("SERVICE_NAME field not found: %s", classes), (Throwable)e);
            return;
        }
        if (StringUtils.isEmpty((CharSequence)packageName)) {
            LOG.error(String.format("grpc SERVICE_NAME can not found: %s", classes));
            return;
        }
        ShenyuGrpcClient beanShenyuClient = (ShenyuGrpcClient)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)clazz, ShenyuGrpcClient.class);
        String basePath = Optional.ofNullable(beanShenyuClient).map(annotation -> (String)StringUtils.defaultIfBlank((CharSequence)beanShenyuClient.path(), (CharSequence)"")).orElse("");
        if (basePath.contains("*")) {
            Method[] methods2;
            for (Method method : methods2 = ReflectionUtils.getDeclaredMethods((Class)clazz)) {
                this.publisher.publishEvent((DataTypeParent)this.buildMetaDataDTO(packageName, beanShenyuClient, method, basePath));
            }
            return;
        }
        for (Method method : methods = ReflectionUtils.getUniqueDeclaredMethods((Class)clazz)) {
            ShenyuGrpcClient methodShenyuClient = (ShenyuGrpcClient)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, ShenyuGrpcClient.class);
            if (!Objects.nonNull(methodShenyuClient)) continue;
            this.publisher.publishEvent((DataTypeParent)this.buildMetaDataDTO(packageName, methodShenyuClient, method, basePath));
        }
    }

    private MetaDataRegisterDTO buildMetaDataDTO(String packageName, ShenyuGrpcClient shenyuGrpcClient, Method method, String basePath) {
        String path = basePath.contains("*") ? this.buildAbsolutePath("/", this.contextPath, basePath.replace("*", ""), method.getName()) : this.buildAbsolutePath("/", this.contextPath, basePath, shenyuGrpcClient.path());
        String desc = shenyuGrpcClient.desc();
        String host = IpUtils.isCompleteHost((String)this.host) ? this.host : IpUtils.getHost((String)this.host);
        String configRuleName = shenyuGrpcClient.ruleName();
        String ruleName = (String)StringUtils.defaultIfBlank((CharSequence)configRuleName, (CharSequence)path);
        String methodName = method.getName();
        Class<?>[] parameterTypesClazz = method.getParameterTypes();
        String parameterTypes = Arrays.stream(parameterTypesClazz).map(Class::getName).collect(Collectors.joining(","));
        MethodDescriptor.MethodType methodType = JsonServerServiceInterceptor.getMethodTypeMap().get(packageName + "/" + methodName);
        return MetaDataRegisterDTO.builder().appName(this.ipAndPort).serviceName(packageName).methodName(methodName).contextPath(this.contextPath).host(host).port(Integer.valueOf(this.port)).path(path).ruleName(ruleName).pathDesc(desc).parameterTypes(parameterTypes).rpcType(RpcTypeEnum.GRPC.getName()).rpcExt(this.buildRpcExt(shenyuGrpcClient, methodType)).enabled(shenyuGrpcClient.enabled()).build();
    }

    private String buildAbsolutePath(String separator, String ... paths) {
        ArrayList<String> pathList = new ArrayList<String>();
        for (String path : paths) {
            if (StringUtils.isBlank((CharSequence)path)) continue;
            String newPath = StringUtils.removeStart((String)path, (String)separator);
            newPath = StringUtils.removeEnd((String)newPath, (String)separator);
            pathList.add(newPath);
        }
        return separator + String.join((CharSequence)separator, pathList);
    }

    private String buildRpcExt(ShenyuGrpcClient shenyuGrpcClient, MethodDescriptor.MethodType methodType) {
        GrpcExt build = GrpcExt.builder().timeout(shenyuGrpcClient.timeout()).methodType(methodType).build();
        return GsonUtils.getInstance().toJson((Object)build);
    }

    private void exportJsonGenericService(BindableService bindableService) {
        ServerServiceDefinition serviceDefinition = bindableService.bindService();
        try {
            ServerServiceDefinition jsonDefinition = JsonServerServiceInterceptor.useJsonMessages(serviceDefinition);
            this.serviceDefinitions.add(serviceDefinition);
            this.serviceDefinitions.add(jsonDefinition);
        }
        catch (Exception e) {
            LOG.error("export json generic service is fail", (Throwable)e);
        }
    }

    public List<ServerServiceDefinition> getServiceDefinitions() {
        return this.serviceDefinitions;
    }
}

