/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.client.tars;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.shenyu.client.core.disruptor.ShenyuClientRegisterEventPublisher;
import org.apache.shenyu.client.core.exception.ShenyuClientIllegalArgumentException;
import org.apache.shenyu.client.tars.common.annotation.ShenyuTarsClient;
import org.apache.shenyu.client.tars.common.annotation.ShenyuTarsService;
import org.apache.shenyu.client.tars.common.dto.TarsRpcExt;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.IpUtils;
import org.apache.shenyu.register.client.api.ShenyuClientRegisterRepository;
import org.apache.shenyu.register.common.config.PropertiesConfig;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.apache.shenyu.register.common.type.DataTypeParent;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.ReflectionUtils;

public class TarsServiceBeanPostProcessor
implements BeanPostProcessor {
    private final LocalVariableTableParameterNameDiscoverer localVariableTableParameterNameDiscoverer = new LocalVariableTableParameterNameDiscoverer();
    private final ShenyuClientRegisterEventPublisher publisher = ShenyuClientRegisterEventPublisher.getInstance();
    private final String contextPath;
    private final String ipAndPort;
    private final String host;
    private final int port;

    public TarsServiceBeanPostProcessor(PropertiesConfig clientConfig, ShenyuClientRegisterRepository shenyuClientRegisterRepository) {
        Properties props = clientConfig.getProps();
        String contextPath = props.getProperty("contextPath");
        this.host = props.getProperty("host");
        String port = props.getProperty("port");
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{contextPath, this.host, port})) {
            throw new ShenyuClientIllegalArgumentException("tars client must config the contextPath, ipAndPort");
        }
        this.contextPath = contextPath;
        this.ipAndPort = this.host + ":" + port;
        this.port = Integer.parseInt(port);
        this.publisher.start(shenyuClientRegisterRepository);
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class clazz = bean.getClass();
        if (AopUtils.isAopProxy(clazz)) {
            clazz = AopUtils.getTargetClass(clazz);
        }
        if (AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)clazz, ShenyuTarsService.class) != null) {
            this.handler(bean);
        }
        return bean;
    }

    private void handler(Object serviceBean) {
        Class clazz = serviceBean.getClass();
        if (AopUtils.isAopProxy((Object)serviceBean)) {
            clazz = AopUtils.getTargetClass((Object)serviceBean);
        }
        Method[] methods = ReflectionUtils.getUniqueDeclaredMethods(clazz);
        String serviceName = clazz.getAnnotation(ShenyuTarsService.class).serviceName();
        for (Method method : methods) {
            ShenyuTarsClient shenyuTarsClient = method.getAnnotation(ShenyuTarsClient.class);
            if (!Objects.nonNull(shenyuTarsClient)) continue;
            this.publisher.publishEvent((DataTypeParent)this.buildMetaDataDTO(serviceName, shenyuTarsClient, method, this.buildRpcExtJson(method)));
        }
    }

    private MetaDataRegisterDTO buildMetaDataDTO(String serviceName, ShenyuTarsClient shenyuTarsClient, Method method, String rpcExt) {
        String ipAndPort = this.ipAndPort;
        String path = this.contextPath + shenyuTarsClient.path();
        String desc = shenyuTarsClient.desc();
        String host = IpUtils.isCompleteHost((String)this.host) ? this.host : IpUtils.getHost((String)this.host);
        String configRuleName = shenyuTarsClient.ruleName();
        String ruleName = "".equals(configRuleName) ? path : configRuleName;
        String methodName = method.getName();
        Class<?>[] parameterTypesClazz = method.getParameterTypes();
        String parameterTypes = Arrays.stream(parameterTypesClazz).map(Class::getName).collect(Collectors.joining(","));
        return MetaDataRegisterDTO.builder().appName(ipAndPort).serviceName(serviceName).methodName(methodName).contextPath(this.contextPath).path(path).host(host).port(Integer.valueOf(this.port)).ruleName(ruleName).pathDesc(desc).parameterTypes(parameterTypes).rpcType(RpcTypeEnum.TARS.getName()).rpcExt(rpcExt).enabled(shenyuTarsClient.enabled()).build();
    }

    private TarsRpcExt.RpcExt buildRpcExt(Method method) {
        String[] paramNames = this.localVariableTableParameterNameDiscoverer.getParameterNames(method);
        ArrayList<Pair<String, String>> params = new ArrayList<Pair<String, String>>();
        if (paramNames != null && paramNames.length > 0) {
            Class<?>[] paramTypes = method.getParameterTypes();
            for (int i = 0; i < paramNames.length; ++i) {
                params.add((Pair<String, String>)Pair.of((Object)paramTypes[i].getName(), (Object)paramNames[i]));
            }
        }
        return new TarsRpcExt.RpcExt(method.getName(), params, method.getReturnType().getName());
    }

    private String buildRpcExtJson(Method method) {
        ArrayList<TarsRpcExt.RpcExt> list = new ArrayList<TarsRpcExt.RpcExt>();
        list.add(this.buildRpcExt(method));
        TarsRpcExt buildList = new TarsRpcExt(list);
        return GsonUtils.getInstance().toJson((Object)buildList);
    }
}

