/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.concurrent;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class MemoryLimitCalculator {
    private static volatile long maxAvailable;
    private static final ScheduledExecutorService SCHEDULER;

    private static void refresh() {
        maxAvailable = Runtime.getRuntime().freeMemory();
    }

    public static long maxAvailable() {
        return maxAvailable;
    }

    public static long calculate(float percentage) {
        if (percentage <= 0.0f || percentage > 1.0f) {
            throw new IllegalArgumentException();
        }
        return (long)((float)MemoryLimitCalculator.maxAvailable() * percentage);
    }

    public static long defaultLimit() {
        return (long)((double)MemoryLimitCalculator.maxAvailable() * 0.8);
    }

    static {
        SCHEDULER = Executors.newSingleThreadScheduledExecutor();
        MemoryLimitCalculator.refresh();
        SCHEDULER.scheduleWithFixedDelay(MemoryLimitCalculator::refresh, 50L, 50L, TimeUnit.MILLISECONDS);
        Runtime.getRuntime().addShutdownHook(new Thread(SCHEDULER::shutdown));
    }
}

