/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import org.apache.shenyu.common.utils.FSTSerializer;
import org.apache.shenyu.common.utils.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializationUtils {
    private static final Logger logger = LoggerFactory.getLogger(SerializationUtils.class);
    private static Serializer g_serializer = new FSTSerializer();

    public static byte[] serialize(Object obj) throws IOException {
        return obj == null ? null : g_serializer.serialize(obj);
    }

    public static byte[] serializeWithoutException(Object obj) {
        try {
            return SerializationUtils.serialize(obj);
        }
        catch (IOException var2) {
            throw new RuntimeException();
        }
    }

    public static byte[] serializeSlightly(Object obj) {
        try {
            return SerializationUtils.serialize(obj);
        }
        catch (IOException var2) {
            logger.error(var2.getMessage(), (Throwable)var2);
            throw new RuntimeException(var2.getMessage());
        }
    }

    public static Object deserialize(byte[] bytes) throws IOException {
        return bytes != null && bytes.length != 0 ? g_serializer.deserialize(bytes) : null;
    }

    public static Object deserializeSlightly(byte[] bytes) {
        if (bytes != null && bytes.length != 0) {
            try {
                return g_serializer.deserialize(bytes);
            }
            catch (IOException var2) {
                logger.error(var2.getMessage(), (Throwable)var2);
                throw new RuntimeException(var2.getMessage());
            }
        }
        return null;
    }

    public static Object deserialize(Object obj) throws IOException {
        return obj == null ? null : g_serializer.deserialize(SerializationUtils.toByteArray(obj));
    }

    public static byte[] toByteArray(Object obj) {
        byte[] bytes = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(obj);
            oos.flush();
            bytes = bos.toByteArray();
            oos.close();
            bos.close();
        }
        catch (IOException var4) {
            var4.printStackTrace();
        }
        return bytes;
    }
}

