/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.disruptor.consumer;

import com.lmax.disruptor.WorkHandler;
import java.util.Objects;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.shenyu.disruptor.consumer.QueueConsumerExecutor;
import org.apache.shenyu.disruptor.consumer.QueueConsumerFactory;
import org.apache.shenyu.disruptor.event.DataEvent;
import org.apache.shenyu.disruptor.event.OrderlyDataEvent;
import org.apache.shenyu.disruptor.thread.OrderlyExecutor;

public class QueueConsumer<T>
implements WorkHandler<DataEvent<T>> {
    private final OrderlyExecutor executor;
    private final QueueConsumerFactory<T> factory;

    public QueueConsumer(OrderlyExecutor executor, QueueConsumerFactory<T> factory) {
        this.executor = executor;
        this.factory = factory;
    }

    public void onEvent(DataEvent<T> t) {
        if (Objects.nonNull(t)) {
            ThreadPoolExecutor executor = this.orderly(t);
            QueueConsumerExecutor<T> queueConsumerExecutor = this.factory.create();
            queueConsumerExecutor.setData(t.getData());
            t.setData(null);
            executor.execute(queueConsumerExecutor);
        }
    }

    private ThreadPoolExecutor orderly(DataEvent<T> t) {
        if (t instanceof OrderlyDataEvent && !this.isEmpty(((OrderlyDataEvent)t).getHash())) {
            return this.executor.select(((OrderlyDataEvent)t).getHash());
        }
        return this.executor;
    }

    private boolean isEmpty(String t) {
        return t == null || t.isEmpty();
    }
}

