/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.alibaba.dubbo;

import com.alibaba.dubbo.remoting.exchange.ResponseCallback;
import com.alibaba.dubbo.remoting.exchange.ResponseFuture;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcContext;
import java.util.Map;
import java.util.Objects;
import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.enums.ResultEnum;
import org.apache.shenyu.plugin.alibaba.dubbo.proxy.AlibabaDubboProxyService;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.dubbo.common.AbstractDubboPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;

public class AlibabaDubboPlugin
extends AbstractDubboPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(AlibabaDubboPlugin.class);
    private final AlibabaDubboProxyService alibabaDubboProxyService;

    public AlibabaDubboPlugin(AlibabaDubboProxyService alibabaDubboProxyService) {
        this.alibabaDubboProxyService = alibabaDubboProxyService;
    }

    protected Mono<Void> doDubboInvoker(ServerWebExchange exchange, ShenyuPluginChain chain, SelectorData selector, RuleData rule, MetaData metaData, String param) {
        RpcContext.getContext().setAttachment("dubboSelectorId", selector.getId());
        RpcContext.getContext().setAttachment("dubboRuleId", rule.getId());
        RpcContext.getContext().setAttachment("dubboRemoteAddress", Objects.requireNonNull(exchange.getRequest().getRemoteAddress()).getAddress().getHostAddress());
        return Mono.create(monoSink -> {
            ResponseFuture future = this.alibabaDubboProxyService.genericInvoker(param, metaData);
            future.setCallback(new ResponseCallback((MonoSink)monoSink, metaData, param){
                final /* synthetic */ MonoSink val$monoSink;
                final /* synthetic */ MetaData val$metaData;
                final /* synthetic */ String val$param;
                {
                    this.val$monoSink = monoSink;
                    this.val$metaData = metaData;
                    this.val$param = string;
                }

                public void done(Object resultObj) {
                    assert (resultObj instanceof Result);
                    Result result = (Result)resultObj;
                    if (result.hasException()) {
                        this.caught(result.getException());
                        return;
                    }
                    this.val$monoSink.success(result.getValue());
                }

                public void caught(Throwable ex) {
                    LOG.error("dubbo failed using async genericInvoker() metaData={} param={}", new Object[]{this.val$metaData, this.val$param, ex});
                    this.val$monoSink.error(ex);
                }
            });
        }).flatMap(response -> {
            exchange.getAttributes().put("rpc_result", Objects.nonNull(response) ? response : "dubbo has not return value!");
            exchange.getAttributes().put("webHandlerClientResponseResultType", ResultEnum.SUCCESS.getName());
            return chain.execute(exchange);
        });
    }

    protected void transmitRpcContext(Map<String, String> rpcContext) {
        rpcContext.forEach((arg_0, arg_1) -> ((RpcContext)RpcContext.getContext()).setAttachment(arg_0, arg_1));
    }
}

