/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.alibaba.dubbo.cache;

import com.alibaba.dubbo.config.ApplicationConfig;
import com.alibaba.dubbo.config.ConsumerConfig;
import com.alibaba.dubbo.config.ReferenceConfig;
import com.alibaba.dubbo.config.RegistryConfig;
import com.alibaba.dubbo.rpc.service.GenericService;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.common.dto.convert.plugin.DubboRegisterConfig;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.plugin.dubbo.common.cache.DubboConfigCache;
import org.apache.shenyu.plugin.dubbo.common.cache.DubboParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AlibabaDubboConfigCache
extends DubboConfigCache {
    private static final Logger LOG = LoggerFactory.getLogger(AlibabaDubboConfigCache.class);
    private ApplicationConfig applicationConfig;
    private RegistryConfig registryConfig;
    private ConsumerConfig consumerConfig;
    private final LoadingCache<String, ReferenceConfig<GenericService>> cache = CacheBuilder.newBuilder().maximumSize(1000L).removalListener(notification -> {
        ReferenceConfig config = (ReferenceConfig)notification.getValue();
        if (Objects.nonNull(config)) {
            config.destroy();
        }
    }).build((CacheLoader)new CacheLoader<String, ReferenceConfig<GenericService>>(){

        @Nonnull
        public ReferenceConfig<GenericService> load(@Nonnull String key) {
            return new ReferenceConfig();
        }
    });

    private AlibabaDubboConfigCache() {
    }

    public static AlibabaDubboConfigCache getInstance() {
        return ApplicationConfigCacheInstance.INSTANCE;
    }

    public void init(DubboRegisterConfig dubboRegisterConfig) {
        if (Objects.isNull(this.applicationConfig)) {
            this.applicationConfig = new ApplicationConfig("shenyu_proxy");
        }
        if (this.needUpdateRegistryConfig(dubboRegisterConfig)) {
            RegistryConfig registryConfigTemp = new RegistryConfig();
            registryConfigTemp.setProtocol(dubboRegisterConfig.getProtocol());
            registryConfigTemp.setId("shenyu_proxy");
            registryConfigTemp.setRegister(Boolean.valueOf(false));
            registryConfigTemp.setAddress(dubboRegisterConfig.getRegister());
            Optional.ofNullable(dubboRegisterConfig.getGroup()).ifPresent(arg_0 -> ((RegistryConfig)registryConfigTemp).setGroup(arg_0));
            this.registryConfig = registryConfigTemp;
        }
        if (Objects.isNull(this.consumerConfig)) {
            this.consumerConfig = new ConsumerConfig();
            Optional.ofNullable(dubboRegisterConfig.getThreadpool()).ifPresent(arg_0 -> ((ConsumerConfig)this.consumerConfig).setThreadpool(arg_0));
            Optional.ofNullable(dubboRegisterConfig.getCorethreads()).ifPresent(arg_0 -> ((ConsumerConfig)this.consumerConfig).setCorethreads(arg_0));
            Optional.ofNullable(dubboRegisterConfig.getThreads()).ifPresent(arg_0 -> ((ConsumerConfig)this.consumerConfig).setThreads(arg_0));
            Optional.ofNullable(dubboRegisterConfig.getQueues()).ifPresent(arg_0 -> ((ConsumerConfig)this.consumerConfig).setQueues(arg_0));
        }
    }

    private boolean needUpdateRegistryConfig(DubboRegisterConfig dubboRegisterConfig) {
        if (Objects.isNull(this.registryConfig)) {
            return true;
        }
        return !Objects.equals(dubboRegisterConfig.getProtocol(), this.registryConfig.getProtocol()) || !Objects.equals(dubboRegisterConfig.getRegister(), this.registryConfig.getAddress()) || !Objects.equals(dubboRegisterConfig.getProtocol(), this.registryConfig.getProtocol());
    }

    public ReferenceConfig<GenericService> initRef(MetaData metaData) {
        try {
            ReferenceConfig referenceConfig = (ReferenceConfig)this.cache.get((Object)metaData.getPath());
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{referenceConfig.getInterface()})) {
                return referenceConfig;
            }
        }
        catch (ExecutionException e) {
            LOG.error("init dubbo ref exception", (Throwable)e);
        }
        return this.build(metaData);
    }

    public ReferenceConfig<GenericService> build(MetaData metaData) {
        if (Objects.isNull(this.applicationConfig) || Objects.isNull(this.registryConfig)) {
            return new ReferenceConfig();
        }
        ReferenceConfig reference = new ReferenceConfig();
        reference.setGeneric(Boolean.valueOf(true));
        reference.setApplication(this.applicationConfig);
        reference.setRegistry(this.registryConfig);
        reference.setConsumer(this.consumerConfig);
        reference.setInterface(metaData.getServiceName());
        reference.setProtocol("dubbo");
        reference.setAsync(Boolean.valueOf(true));
        reference.setCheck(Boolean.valueOf(false));
        reference.setLoadbalance("gray");
        HashMap<String, String> parameters = new HashMap<String, String>(2);
        parameters.put("dispatcher", "direct");
        reference.setParameters(parameters);
        String rpcExt = metaData.getRpcExt();
        DubboParam dubboParam = this.parserToDubboParam(rpcExt);
        if (Objects.nonNull(dubboParam)) {
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dubboParam.getVersion()})) {
                reference.setVersion(dubboParam.getVersion());
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dubboParam.getGroup()})) {
                reference.setGroup(dubboParam.getGroup());
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dubboParam.getUrl()})) {
                reference.setUrl(dubboParam.getUrl());
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dubboParam.getCluster()})) {
                reference.setCluster(dubboParam.getCluster());
            }
            Optional.ofNullable(dubboParam.getTimeout()).ifPresent(arg_0 -> ((ReferenceConfig)reference).setTimeout(arg_0));
            Optional.ofNullable(dubboParam.getRetries()).ifPresent(arg_0 -> ((ReferenceConfig)reference).setRetries(arg_0));
            Optional.ofNullable(dubboParam.getSent()).ifPresent(arg_0 -> ((ReferenceConfig)reference).setSent(arg_0));
        }
        try {
            Object obj = reference.get();
            if (Objects.nonNull(obj)) {
                LOG.info("init alibaba dubbo reference success there meteData is :{}", (Object)metaData);
                this.cache.put((Object)metaData.getPath(), (Object)reference);
            }
        }
        catch (Exception e) {
            LOG.error("init alibaba dubbo refernce exception", (Throwable)e);
        }
        return reference;
    }

    public ReferenceConfig<GenericService> get(String path) {
        try {
            return (ReferenceConfig)this.cache.get((Object)path);
        }
        catch (ExecutionException e) {
            throw new ShenyuException(e.getCause());
        }
    }

    public void invalidate(String path) {
        this.cache.invalidate((Object)path);
    }

    public void invalidateAll() {
        this.cache.invalidateAll();
    }

    static final class ApplicationConfigCacheInstance {
        static final AlibabaDubboConfigCache INSTANCE = new AlibabaDubboConfigCache();

        private ApplicationConfigCacheInstance() {
        }
    }
}

