/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.alibaba.dubbo.proxy;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.extension.ExtensionLoader;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.RpcException;
import com.alibaba.dubbo.rpc.cluster.LoadBalance;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.dto.convert.rule.impl.DubboRuleHandle;
import org.apache.shenyu.loadbalancer.cache.UpstreamCacheManager;
import org.apache.shenyu.loadbalancer.entity.Upstream;
import org.apache.shenyu.loadbalancer.factory.LoadBalancerFactory;
import org.apache.shenyu.plugin.alibaba.dubbo.handler.AlibabaDubboPluginDataHandler;
import org.apache.shenyu.plugin.base.cache.CommonHandleCache;

public class AlibabaDubboGrayLoadBalance
implements LoadBalance {
    public <T> Invoker<T> select(List<Invoker<T>> invokers, URL url, Invocation invocation) throws RpcException {
        String shenyuSelectorId = invocation.getAttachment("dubboSelectorId");
        String shenyuRuleId = invocation.getAttachment("dubboRuleId");
        String remoteAddressIp = invocation.getAttachment("dubboRemoteAddress");
        List dubboUpstreams = (List)((CommonHandleCache)AlibabaDubboPluginDataHandler.SELECTOR_CACHED_HANDLE.get()).obtainHandle((Object)shenyuSelectorId);
        DubboRuleHandle dubboRuleHandle = (DubboRuleHandle)((CommonHandleCache)AlibabaDubboPluginDataHandler.RULE_CACHED_HANDLE.get()).obtainHandle((Object)shenyuRuleId);
        if (CollectionUtils.isNotEmpty((Collection)dubboUpstreams)) {
            Upstream upstream = LoadBalancerFactory.selector((List)UpstreamCacheManager.getInstance().findUpstreamListBySelectorId(shenyuSelectorId), (String)dubboRuleHandle.getLoadbalance(), (String)remoteAddressIp);
            if (StringUtils.isBlank((CharSequence)upstream.getUrl()) && StringUtils.isBlank((CharSequence)upstream.getGroup()) && StringUtils.isBlank((CharSequence)upstream.getVersion())) {
                return ((LoadBalance)ExtensionLoader.getExtensionLoader(LoadBalance.class).getExtension(dubboRuleHandle.getLoadbalance())).select(invokers, url, invocation);
            }
            List<Invoker<T>> invokerGrays = invokers.stream().filter(each -> {
                if (StringUtils.isNotBlank((CharSequence)upstream.getUrl())) {
                    URL eachUrl = each.getUrl();
                    return eachUrl.getAddress().equals(upstream.getUrl());
                }
                return true;
            }).filter(each -> {
                if (StringUtils.isNotBlank((CharSequence)upstream.getGroup())) {
                    URL eachUrl = each.getUrl();
                    return upstream.getGroup().equals(eachUrl.getParameter("group"));
                }
                return true;
            }).filter(each -> {
                if (StringUtils.isNotBlank((CharSequence)upstream.getVersion())) {
                    URL eachUrl = each.getUrl();
                    return upstream.getVersion().equals(eachUrl.getParameter("version"));
                }
                return true;
            }).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(invokerGrays)) {
                return this.select(invokers, url, invocation, dubboRuleHandle.getLoadbalance());
            }
            return this.select(invokerGrays, url, invocation, dubboRuleHandle.getLoadbalance());
        }
        return this.select(invokers, url, invocation, dubboRuleHandle.getLoadbalance());
    }

    private <T> Invoker<T> select(List<Invoker<T>> invokers, URL url, Invocation invocation, String loadbalance) {
        return ((LoadBalance)ExtensionLoader.getExtensionLoader(LoadBalance.class).getExtension(loadbalance)).select(invokers, url, invocation);
    }
}

