/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.base.cache;

import com.google.common.collect.Maps;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.apache.shenyu.common.cache.MemorySafeLRUMap;
import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.common.utils.PathMatchUtils;

public final class MetaDataCache {
    private static final String DIVIDE_CACHE_KEY = "";
    private static final MetaData NULL = new MetaData();
    private static final MetaDataCache INSTANCE = new MetaDataCache();
    private static final ConcurrentMap<String, MetaData> META_DATA_MAP = Maps.newConcurrentMap();
    private static final MemorySafeLRUMap<String, MetaData> CACHE = new MemorySafeLRUMap(0x10000000, 65536);
    private static final ConcurrentMap<String, Set<String>> MAPPING = Maps.newConcurrentMap();

    private MetaDataCache() {
    }

    public static MetaDataCache getInstance() {
        return INSTANCE;
    }

    public void cache(MetaData data) {
        META_DATA_MAP.put(data.getPath(), data);
        this.clean(data.getPath());
    }

    public void remove(MetaData data) {
        META_DATA_MAP.remove(data.getPath());
        this.clean(data.getPath());
    }

    private void clean(String key) {
        Optional.ofNullable(MAPPING.get(key)).ifPresent(paths -> {
            for (String path : paths) {
                CACHE.remove((Object)path);
            }
        });
    }

    public void clean() {
        this.clean(DIVIDE_CACHE_KEY);
    }

    public MetaData obtain(String path) {
        MetaData metaData = Optional.ofNullable(META_DATA_MAP.get(path)).orElseGet(() -> {
            MetaData exist = (MetaData)CACHE.get((Object)path);
            if (Objects.nonNull(exist)) {
                return exist;
            }
            String key = META_DATA_MAP.keySet().stream().filter(k -> PathMatchUtils.match((String)k, (String)path)).findFirst().orElse(DIVIDE_CACHE_KEY);
            MetaData value = (MetaData)META_DATA_MAP.get(key);
            CACHE.put((Object)path, (Object)(Objects.isNull(value) ? NULL : value));
            Set paths = (Set)MAPPING.get(key);
            if (Objects.isNull(paths)) {
                MAPPING.putIfAbsent(key, new ConcurrentSkipListSet());
                paths = (Set)MAPPING.get(key);
            }
            paths.add(path);
            return value;
        });
        return NULL.equals((Object)metaData) ? null : metaData;
    }
}

