/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.cache;

import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.springframework.http.MediaType;

public interface ICache {
    public boolean cacheData(String var1, byte[] var2, long var3);

    public boolean isExist(String var1);

    public byte[] getData(String var1);

    default public boolean cacheContentType(String key, MediaType mediaType, long timeoutSeconds) {
        return this.cacheData(key, this.mediaTypeToBytes(mediaType), timeoutSeconds);
    }

    default public byte[] mediaTypeToBytes(MediaType mediaType) {
        return mediaType.toString().getBytes(StandardCharsets.UTF_8);
    }

    default public MediaType getContentType(String key) {
        byte[] data = this.getData(key);
        if (Objects.isNull(data) || data.length == 0) {
            return MediaType.APPLICATION_JSON;
        }
        return MediaType.valueOf((String)new String(data, StandardCharsets.UTF_8));
    }

    default public void close() {
    }
}

