/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.cryptor.utils;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.shenyu.common.utils.GsonUtils;
import org.springframework.util.CollectionUtils;

public final class JsonUtil {
    private JsonUtil() {
    }

    public static String parser(String json, String fieldName) {
        Map map = GsonUtils.getInstance().toObjectMap(json);
        String str = null;
        if (fieldName.contains(".")) {
            String[] split = fieldName.split("\\.");
            JsonObject jsonObject = (JsonObject)map.get(split[0]);
            for (int i = 1; i < split.length; ++i) {
                if (i == split.length - 1) {
                    str = jsonObject.getAsJsonPrimitive(split[i]).getAsString();
                    continue;
                }
                jsonObject = jsonObject.getAsJsonObject(split[i]);
            }
        } else {
            return map.get(fieldName) == null ? null : map.get(fieldName).toString();
        }
        return str;
    }

    public static List<Pair<String, String>> parser(String json, Set<String> fieldNames) {
        if (CollectionUtils.isEmpty(fieldNames) || StringUtils.isBlank((CharSequence)json)) {
            return Lists.newArrayList();
        }
        return fieldNames.stream().filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).map(field -> Pair.of((Object)field, (Object)JsonUtil.parser(json, field))).filter(pair -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{(CharSequence)pair.getRight()})).collect(Collectors.toList());
    }

    public static JsonElement replaceJsonNode(JsonElement jsonElement, AtomicInteger initDeep, String value, List<String> deepKey) {
        if (CollectionUtils.isEmpty(deepKey)) {
            return jsonElement;
        }
        if (jsonElement.isJsonPrimitive()) {
            return jsonElement;
        }
        if (jsonElement.isJsonArray()) {
            JsonArray jsonArray = jsonElement.getAsJsonArray();
            JsonArray jsonArrayNew = new JsonArray();
            for (JsonElement element : jsonArray) {
                jsonArrayNew.add(JsonUtil.replaceJsonNode(element, initDeep, value, deepKey));
            }
            return jsonArrayNew;
        }
        if (jsonElement.isJsonObject()) {
            JsonObject object = jsonElement.getAsJsonObject();
            JsonObject objectNew = new JsonObject();
            for (Map.Entry entry : object.entrySet()) {
                if (deepKey.get(initDeep.get()).equals(entry.getKey())) {
                    initDeep.incrementAndGet();
                }
                String key = (String)entry.getKey();
                if (initDeep.get() == deepKey.size()) {
                    initDeep.set(deepKey.size() - 1);
                    object.addProperty(key, value);
                }
                JsonElement jsonEle = object.get(key);
                JsonElement jsonElementNew = JsonUtil.replaceJsonNode(jsonEle, initDeep, value, deepKey);
                objectNew.add(key, jsonElementNew);
            }
            return objectNew;
        }
        return jsonElement;
    }
}

