/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.jwt;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import io.jsonwebtoken.Jwt;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.dto.convert.rule.impl.JwtRuleHandle;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.utils.Singleton;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.api.result.DefaultShenyuEntity;
import org.apache.shenyu.plugin.api.result.ShenyuResultEnum;
import org.apache.shenyu.plugin.api.result.ShenyuResultWrap;
import org.apache.shenyu.plugin.api.utils.WebFluxResultUtils;
import org.apache.shenyu.plugin.base.AbstractShenyuPlugin;
import org.apache.shenyu.plugin.jwt.config.JwtConfig;
import org.apache.shenyu.plugin.jwt.enums.JwtEnum;
import org.apache.shenyu.plugin.jwt.exception.ThrowingFunction;
import org.apache.shenyu.plugin.jwt.util.RegexUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.HttpCookie;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpRequestDecorator;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class JwtPlugin
extends AbstractShenyuPlugin {
    private static final Logger log = LoggerFactory.getLogger(JwtPlugin.class);
    private static final String AUTH_TOKEN = "auth-token";
    private static final String NO_AUTH = "noauth";
    private static final String RESP_CODE_SUCCESS = "0000";
    private static final String AUTH2_TOKEN = "Bearer";
    private static final String APPLICATION_JSON_UTF8_VALUE = "json";

    protected Mono<Void> doExecute(ServerWebExchange exchange, ShenyuPluginChain chain, SelectorData selector, RuleData rule) {
        JwtConfig jwtConfig = (JwtConfig)Singleton.INST.get(JwtConfig.class);
        boolean needVerify = this.judgeWhetherVerify(exchange.getRequest().getURI().toString(), jwtConfig.getStaticResources());
        if (needVerify) {
            String referer = exchange.getRequest().getHeaders().getFirst("Referer");
            boolean isCsr = true;
            for (String vReferer : jwtConfig.getVerifyReferers()) {
                if (referer != null && !referer.trim().startsWith(vReferer)) continue;
                isCsr = false;
                break;
            }
            String token = "";
            if (StringUtils.hasLength((String)exchange.getRequest().getHeaders().getFirst(AUTH_TOKEN))) {
                token = exchange.getRequest().getHeaders().getFirst(AUTH_TOKEN);
            } else if (ObjectUtil.isNotEmpty((Object)exchange.getRequest().getCookies().getFirst((Object)AUTH_TOKEN))) {
                token = ((HttpCookie)exchange.getRequest().getCookies().getFirst((Object)AUTH_TOKEN)).getValue();
            }
            log.info("\u83b7\u53d6\u5230\u7684token:[{}]", (Object)token);
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)token)) {
                return this.buildErrorResult(exchange, JwtEnum.TOKEN_VALIDATE_ERROR.getCode(), "\u767b\u5f55\u4fe1\u606f\u65e0\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
            }
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)jwtConfig.getSecretKey())) {
                return this.buildErrorResult(exchange, JwtEnum.TOKEN_VALIDATE_ERROR.getCode(), "\u767b\u5f55\u4fe1\u606f\u65e0\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
            }
            String finalAuthorization = this.compatible(token, null);
            Map<String, Object> jwtBody = this.checkAuthorization(finalAuthorization, jwtConfig.getSecretKey());
            if (null == jwtBody) {
                return this.buildErrorResult(exchange, JwtEnum.TOKEN_VALIDATE_ERROR.getCode(), "\u767b\u5f55\u4fe1\u606f\u65e0\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
            }
            if (isCsr && !referer.equals(jwtBody.get("referer").toString())) {
                log.error("\u7591\u4f3cCSRF\u653b\u51fb\uff0creferer:" + referer);
                String print = "<font size=6 color=red>\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u8bf7\u6c42\u975e\u6cd5\uff0c\u7cfb\u7edf\u62d2\u7edd\u54cd\u5e94!</font>";
                exchange.getResponse().getHeaders().setContentType(MediaType.TEXT_HTML);
                exchange.getResponse().setStatusCode(HttpStatus.FORBIDDEN);
                return exchange.getResponse().writeWith((Publisher)Mono.just((Object)exchange.getResponse().bufferFactory().wrap(print.getBytes(StandardCharsets.UTF_8))).doOnNext(data -> exchange.getResponse().getHeaders().setContentLength((long)data.readableByteCount())));
            }
            JSONObject loginExpTimeReqJson = new JSONObject();
            loginExpTimeReqJson.put("token", (Object)token);
            DefaultShenyuEntity resultEntity = this.httpCompatible(jwtConfig.getGetLoginTimeService(), token, loginExpTimeReqJson);
            if (ShenyuResultEnum.SUCCESS.getCode() != resultEntity.getCode().intValue() || ObjectUtil.isEmpty((Object)resultEntity.getData())) {
                return this.buildErrorResult(exchange, String.valueOf(ShenyuResultEnum.FAIL.getCode()), "\u767b\u5f55\u4fe1\u606f\u65e0\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
            }
            Long loginExpTime = Long.parseLong(JSON.parseObject((String)resultEntity.getData().toString()).getString("expTime"));
            log.info("\u83b7\u53d6\u5230\u7684token\u8fc7\u671f\u65f6\u95f4\uff1a\u3010{}\u3011", (Object)loginExpTime);
            long curTime = System.currentTimeMillis();
            if (curTime > loginExpTime) {
                return this.buildErrorResult(exchange, JwtEnum.TOKEN_VALIDATE_ERROR.getCode(), "\u767b\u5f55\u8d85\u65f6\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
            }
            loginExpTimeReqJson.put("userId", jwtBody.get("userId"));
            loginExpTimeReqJson.put("loginSource", jwtBody.get("loginSource"));
            this.httpCompatible(jwtConfig.getUpdateLoginTimeService(), token, loginExpTimeReqJson);
            JSONObject userInfoReqJson = new JSONObject((Map)loginExpTimeReqJson);
            userInfoReqJson.put("tagId", jwtBody.get("tagId"));
            userInfoReqJson.put("uri", (Object)exchange.getRequest().getURI());
            userInfoReqJson.put("appCode", jwtBody.get("appCode"));
            log.info("\u67e5\u8be2\u7528\u6237\u4fe1\u606f\uff0c\u5165\u53c2\uff1a{}", (Object)userInfoReqJson);
            resultEntity = this.httpCompatible(jwtConfig.getUserInfoService(), token, userInfoReqJson);
            if (ShenyuResultEnum.SUCCESS.getCode() != resultEntity.getCode().intValue() || ObjectUtil.isEmpty((Object)resultEntity.getData())) {
                return this.buildErrorResult(exchange, String.valueOf(ShenyuResultEnum.FAIL.getCode()), "\u767b\u5f55\u4fe1\u606f\u65e0\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
            }
            JSONObject userInfoDetail = JSON.parseObject((String)resultEntity.getData().toString()).getJSONObject("userDetails");
            MediaType mediaType = exchange.getRequest().getHeaders().getContentType();
            if (ObjectUtil.isNotEmpty((Object)mediaType) && mediaType.toString().contains(APPLICATION_JSON_UTF8_VALUE)) {
                return this.injectUserInfo(chain, exchange, jwtBody, userInfoDetail);
            }
        }
        return chain.execute(exchange);
    }

    private DefaultShenyuEntity httpCompatible(String uri, String token, JSONObject requestParam) {
        DefaultShenyuEntity shenyuEntity;
        String result = ((HttpRequest)HttpRequest.post((String)uri).header(AUTH_TOKEN, token)).body(requestParam.toJSONString()).execute().body();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)result)) {
            return new DefaultShenyuEntity(Integer.valueOf(ShenyuResultEnum.FAIL.getCode()), "\u6743\u9650\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a", null);
        }
        try {
            shenyuEntity = (DefaultShenyuEntity)JSON.parseObject((String)result, DefaultShenyuEntity.class);
        }
        catch (Exception e) {
            return new DefaultShenyuEntity(Integer.valueOf(ShenyuResultEnum.FAIL.getCode()), "\u6743\u9650\u63a5\u53e3\u8fd4\u56de\u683c\u5f0f\u5f02\u5e38", null);
        }
        if (ObjectUtil.isNotEmpty((Object)shenyuEntity.getCode())) {
            return shenyuEntity;
        }
        JSONObject resultJson = JSON.parseObject((String)result);
        if (RESP_CODE_SUCCESS.equals(resultJson.getString("respCode"))) {
            shenyuEntity.setCode(Integer.valueOf(ShenyuResultEnum.SUCCESS.getCode()));
            shenyuEntity.setData((Object)resultJson);
            return shenyuEntity;
        }
        return new DefaultShenyuEntity(Integer.valueOf(ShenyuResultEnum.FAIL.getCode()), resultJson.getString("respDesc"), null);
    }

    private Mono<Void> buildErrorResult(ServerWebExchange exchange, String code, String desc) {
        JSONObject respDataJson = new JSONObject();
        respDataJson.put("respCode", (Object)code);
        respDataJson.put("respDesc", (Object)desc);
        Object error = ShenyuResultWrap.error((ServerWebExchange)exchange, (int)ShenyuResultEnum.FAIL.getCode(), (String)desc, (Object)respDataJson);
        return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)JSON.toJSONString((Object)error).getBytes(StandardCharsets.UTF_8));
    }

    private boolean judgeWhetherVerify(String uri, String staticResources) {
        boolean needToken = true;
        if (uri.contains(NO_AUTH)) {
            return false;
        }
        if (org.apache.commons.lang3.StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{staticResources})) {
            String[] split;
            for (String staticResource : split = staticResources.split(";")) {
                if (!RegexUtils.wildcardEquals(staticResource, uri)) continue;
                needToken = false;
            }
        }
        if (RegexUtils.wildcardEquals("**/**/users/signup/**", uri)) {
            needToken = false;
        }
        if (RegexUtils.wildcardEquals("**/**/noauth/**", uri)) {
            needToken = false;
        }
        if (RegexUtils.wildcardEquals("**/**/**/noauth/**", uri)) {
            needToken = false;
        }
        if (RegexUtils.wildcardEquals("**/**/api/token/get", uri)) {
            needToken = false;
        }
        return needToken;
    }

    public String named() {
        return PluginEnum.JWT.getName();
    }

    public int getOrder() {
        return PluginEnum.JWT.getCode();
    }

    private String compatible(String token, String authorization) {
        String finalAuthorization;
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)token)) {
            finalAuthorization = token;
        } else if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)authorization)) {
            finalAuthorization = authorization;
        } else {
            return null;
        }
        return this.isAuth2(finalAuthorization) ? finalAuthorization.split(" ")[1] : finalAuthorization;
    }

    private boolean isAuth2(String authorization) {
        return authorization.contains(AUTH2_TOKEN);
    }

    private Map<String, Object> checkAuthorization(String authorization, String secretKey) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)authorization)) {
            return null;
        }
        JwtParser jwtParser = Jwts.parser();
        if (jwtParser.isSigned(authorization)) {
            jwtParser.setSigningKey(secretKey.getBytes(StandardCharsets.UTF_8));
            Jwt jwt = ThrowingFunction.wrap(() -> jwtParser.parse(authorization));
            if (jwt == null) {
                return null;
            }
            return (Map)jwt.getBody();
        }
        return null;
    }

    private ServerWebExchange converter(ServerWebExchange exchange, Map<String, Object> jwtBody, List<JwtRuleHandle.Convert> converters) {
        ServerHttpRequest modifiedRequest = exchange.getRequest().mutate().headers(httpHeaders -> this.addHeader((HttpHeaders)httpHeaders, jwtBody, converters)).build();
        return exchange.mutate().request(modifiedRequest).build();
    }

    private Mono<Void> injectUserInfo(ShenyuPluginChain chain, ServerWebExchange exchange, Map<String, Object> jwtBody, JSONObject userInfoJson) {
        return DataBufferUtils.join((Publisher)exchange.getRequest().getBody()).flatMap(dataBuffer -> {
            byte[] bytes = new byte[dataBuffer.readableByteCount()];
            dataBuffer.read(bytes);
            DataBufferUtils.release((DataBuffer)dataBuffer);
            String bodyString = new String(bytes, StandardCharsets.UTF_8);
            JSONObject requestPramJSON = JSONObject.parseObject((String)bodyString);
            requestPramJSON.putAll((Map)userInfoJson);
            final Flux cachedFlux = Flux.defer(() -> {
                DataBuffer buffer = exchange.getResponse().bufferFactory().wrap(requestPramJSON.toJSONString().getBytes(StandardCharsets.UTF_8));
                return Mono.just((Object)buffer);
            });
            final HttpHeaders headers = new HttpHeaders();
            headers.putAll((Map)exchange.getRequest().getHeaders());
            headers.remove((Object)"Content-Length");
            headers.set("Transfer-Encoding", "chunked");
            ServerHttpRequestDecorator mutatedRequest = new ServerHttpRequestDecorator(exchange.getRequest()){

                public HttpHeaders getHeaders() {
                    HttpHeaders httpHeaders = new HttpHeaders();
                    httpHeaders.putAll((Map)headers);
                    return httpHeaders;
                }

                public Flux<DataBuffer> getBody() {
                    return cachedFlux;
                }
            };
            ServerWebExchange exchangeNew = exchange.mutate().request((ServerHttpRequest)mutatedRequest).build();
            exchangeNew.getAttributes().put("data", jwtBody);
            return chain.execute(exchangeNew);
        });
    }

    private void addHeader(HttpHeaders headers, Map<String, Object> body, List<JwtRuleHandle.Convert> converters) {
        for (JwtRuleHandle.Convert converter : converters) {
            if (converter.getJwtVal().contains(".")) {
                headers.add(converter.getHeaderVal(), this.parse(body, converter.getJwtVal().split("\\."), new AtomicInteger(0)));
                continue;
            }
            headers.add(converter.getHeaderVal(), String.valueOf(body.get(converter.getJwtVal())));
        }
    }

    private String parse(Map<String, Object> body, String[] split, AtomicInteger deep) {
        for (Map.Entry<String, Object> entry : body.entrySet()) {
            if (deep.get() == split.length - 1) {
                return String.valueOf(body.get(split[deep.get()]));
            }
            if (!entry.getKey().equals(split[deep.get()]) || !(entry.getValue() instanceof Map)) continue;
            deep.incrementAndGet();
            return this.parse((Map)entry.getValue(), split, deep);
        }
        return String.valueOf(body.get(split[deep.get()]));
    }
}

