/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.logging.rocketmq.body;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BodyWriter {
    private static final Logger LOG = LoggerFactory.getLogger(BodyWriter.class);
    private final ByteArrayOutputStream stream = new ByteArrayOutputStream();
    private final WritableByteChannel channel = Channels.newChannel(this.stream);
    private final AtomicBoolean isClosed = new AtomicBoolean(false);

    public void write(ByteBuffer buffer) {
        if (!this.isClosed.get()) {
            try {
                this.channel.write(buffer);
            }
            catch (IOException e) {
                this.isClosed.compareAndSet(false, true);
                LOG.error("write buffer Failed.", (Throwable)e);
            }
        }
    }

    boolean isEmpty() {
        return this.stream.size() == 0;
    }

    public int size() {
        return this.stream.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String output() {
        if (this.isEmpty()) {
            return "";
        }
        try {
            this.isClosed.compareAndSet(false, true);
            String string = new String(this.stream.toByteArray(), StandardCharsets.UTF_8);
            return string;
        }
        catch (Exception e) {
            LOG.error("Write failed: ", (Throwable)e);
            String string = "Write failed: " + e.getMessage();
            return string;
        }
        finally {
            try {
                this.stream.close();
            }
            catch (IOException e) {
                LOG.error("Close stream error: ", (Throwable)e);
            }
            try {
                this.channel.close();
            }
            catch (IOException e) {
                LOG.error("Close channel error: ", (Throwable)e);
            }
        }
    }
}

