/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.logging.rocketmq.body;

import org.apache.shenyu.plugin.logging.rocketmq.body.BodyWriter;
import org.apache.shenyu.plugin.logging.rocketmq.entity.ShenyuRequestLog;
import org.apache.shenyu.plugin.logging.rocketmq.utils.LogCollectConfigUtils;
import org.apache.shenyu.plugin.logging.rocketmq.utils.LogCollectUtils;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpRequestDecorator;
import reactor.core.publisher.Flux;
import reactor.util.annotation.NonNull;

public class LoggingServerHttpRequest
extends ServerHttpRequestDecorator {
    private final ShenyuRequestLog logInfo;

    public LoggingServerHttpRequest(ServerHttpRequest delegate, ShenyuRequestLog logInfo) {
        super(delegate);
        this.logInfo = logInfo;
    }

    @NonNull
    public Flux<DataBuffer> getBody() {
        BodyWriter writer = new BodyWriter();
        return super.getBody().doOnNext(dataBuffer -> {
            if (LogCollectUtils.isNotBinaryType(this.getHeaders())) {
                writer.write(dataBuffer.asByteBuffer().asReadOnlyBuffer());
            }
        }).doFinally(signal -> {
            int size = writer.size();
            String body = writer.output();
            boolean requestBodyTooLarge = LogCollectConfigUtils.isRequestBodyTooLarge(size);
            if (size == 0 || requestBodyTooLarge) {
                return;
            }
            this.logInfo.setRequestBody(body);
        });
    }
}

