/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.logging.rocketmq.body;

import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.common.utils.DateUtils;
import org.apache.shenyu.plugin.api.context.ShenyuContext;
import org.apache.shenyu.plugin.api.result.ShenyuResult;
import org.apache.shenyu.plugin.api.result.ShenyuResultWrap;
import org.apache.shenyu.plugin.logging.rocketmq.DefaultLogCollector;
import org.apache.shenyu.plugin.logging.rocketmq.LogCollector;
import org.apache.shenyu.plugin.logging.rocketmq.body.BodyWriter;
import org.apache.shenyu.plugin.logging.rocketmq.entity.ShenyuRequestLog;
import org.apache.shenyu.plugin.logging.rocketmq.utils.LogCollectConfigUtils;
import org.apache.shenyu.plugin.logging.rocketmq.utils.LogCollectUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpResponseDecorator;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.annotation.NonNull;

public class LoggingServerHttpResponse
extends ServerHttpResponseDecorator {
    private static final Logger LOG = LoggerFactory.getLogger(LoggingServerHttpResponse.class);
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
    private final ShenyuRequestLog logInfo;
    private ServerWebExchange exchange;
    private final LogCollector logCollector;

    public LoggingServerHttpResponse(ServerHttpResponse delegate, ShenyuRequestLog logInfo, LogCollector logCollector) {
        super(delegate);
        this.logInfo = logInfo;
        this.logCollector = logCollector;
    }

    public void setExchange(ServerWebExchange exchange) {
        this.exchange = exchange;
    }

    @NonNull
    public Mono<Void> writeWith(@NonNull Publisher<? extends DataBuffer> body) {
        return super.writeWith(this.appendResponse(body));
    }

    @NonNull
    private Flux<? extends DataBuffer> appendResponse(Publisher<? extends DataBuffer> body) {
        ShenyuContext shenyuContext = (ShenyuContext)this.exchange.getAttribute("context");
        assert (shenyuContext != null);
        if (this.getStatusCode() != null) {
            this.logInfo.setStatus(this.getStatusCode().value());
        }
        this.logInfo.setResponseHeader(LogCollectUtils.getHeaders(this.getHeaders()));
        BodyWriter writer = new BodyWriter();
        this.logInfo.setTraceId(this.getTraceId());
        return Flux.from(body).doOnNext(buffer -> {
            if (LogCollectUtils.isNotBinaryType(this.getHeaders())) {
                writer.write(buffer.asByteBuffer().asReadOnlyBuffer());
            }
        }).doFinally(signal -> this.logResponse(shenyuContext, writer));
    }

    private void logResponse(ShenyuContext shenyuContext, BodyWriter writer) {
        if (StringUtils.isNotBlank((CharSequence)this.getHeaders().getFirst("Content-Length"))) {
            String size = (String)StringUtils.defaultIfEmpty((CharSequence)this.getHeaders().getFirst("Content-Length"), (CharSequence)"0");
            this.logInfo.setResponseContentLength(Integer.parseInt(size));
        } else {
            this.logInfo.setResponseContentLength(writer.size());
        }
        this.logInfo.setTimeLocal(shenyuContext.getStartDateTime().format(DATE_TIME_FORMATTER));
        this.logInfo.setModule(shenyuContext.getModule());
        long costTime = DateUtils.acquireMillisBetween((LocalDateTime)shenyuContext.getStartDateTime(), (LocalDateTime)LocalDateTime.now());
        this.logInfo.setUpstreamResponseTime(costTime);
        this.logInfo.setMethod(shenyuContext.getMethod());
        this.logInfo.setRpcType(shenyuContext.getRpcType());
        if (StringUtils.isNotBlank((CharSequence)shenyuContext.getRpcType())) {
            this.logInfo.setUpstreamIp(this.getUpstreamIp());
        }
        int size = writer.size();
        String body = writer.output();
        if (size > 0 && !LogCollectConfigUtils.isResponseBodyTooLarge(size)) {
            this.logInfo.setResponseBody(body);
        }
        if (this.logCollector != null) {
            this.logCollector.collect(this.logInfo);
        }
    }

    private String getUpstreamIp() {
        ShenyuContext shenyuContext = (ShenyuContext)this.exchange.getAttribute("context");
        assert (shenyuContext != null);
        if (RpcTypeEnum.HTTP.getName().equals(shenyuContext.getRpcType())) {
            URI uri = (URI)this.exchange.getAttribute("httpUri");
            if (uri != null) {
                return uri.getHost();
            }
            return this.getUpstreamIpFromHttpDomain();
        }
        String domain = (String)this.exchange.getAttributes().get("httpDomain");
        if (StringUtils.isNotBlank((CharSequence)domain)) {
            return this.getUpstreamIpFromHttpDomain();
        }
        return "";
    }

    private String getTraceId() {
        return (String)this.exchange.getAttributes().get("shenyu-agent-trace-id");
    }

    public void logError(Throwable throwable) {
        HttpStatus httpStatus = HttpStatus.INTERNAL_SERVER_ERROR;
        if (throwable instanceof ResponseStatusException) {
            httpStatus = ((ResponseStatusException)throwable).getStatus();
        }
        this.logInfo.setStatus(httpStatus.value());
        this.logInfo.setTraceId(this.getTraceId());
        Object result = ShenyuResultWrap.error((ServerWebExchange)this.exchange, (int)httpStatus.value(), (String)httpStatus.getReasonPhrase(), (Object)throwable.getMessage());
        ShenyuResult shenyuResult = ShenyuResultWrap.shenyuResult();
        Object resultData = shenyuResult.format(this.exchange, result);
        Object responseData = shenyuResult.result(this.exchange, resultData);
        assert (null != responseData);
        byte[] bytes = responseData instanceof byte[] ? (byte[])responseData : responseData.toString().getBytes(StandardCharsets.UTF_8);
        this.logInfo.setResponseContentLength(bytes.length);
        ShenyuContext shenyuContext = (ShenyuContext)this.exchange.getAttribute("context");
        assert (shenyuContext != null);
        this.logInfo.setTimeLocal(shenyuContext.getStartDateTime().format(DATE_TIME_FORMATTER));
        this.logInfo.setModule(shenyuContext.getModule());
        long costTime = DateUtils.acquireMillisBetween((LocalDateTime)shenyuContext.getStartDateTime(), (LocalDateTime)LocalDateTime.now());
        this.logInfo.setUpstreamResponseTime(costTime);
        this.logInfo.setResponseHeader(LogCollectUtils.getHeaders(this.exchange.getResponse().getHeaders()));
        this.logInfo.setRpcType(shenyuContext.getRpcType());
        this.logInfo.setMethod(shenyuContext.getMethod());
        if (StringUtils.isNotBlank((CharSequence)shenyuContext.getRpcType())) {
            this.logInfo.setUpstreamIp(this.getUpstreamIp());
        }
        int size = bytes.length;
        String body = new String(bytes, StandardCharsets.UTF_8);
        if (size > 0 && !LogCollectConfigUtils.isResponseBodyTooLarge(size)) {
            this.logInfo.setResponseBody(body);
        }
        if (DefaultLogCollector.getInstance() != null) {
            DefaultLogCollector.getInstance().collect(this.logInfo);
        }
    }

    private String getUpstreamIpFromHttpDomain() {
        String domain = (String)this.exchange.getAttributes().get("httpDomain");
        try {
            if (StringUtils.isNotBlank((CharSequence)domain)) {
                URL url = new URL(domain);
                return url.getHost();
            }
        }
        catch (Exception e) {
            LOG.error("get upstream ip error");
        }
        return "";
    }
}

