/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.logging.rocketmq.handler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.dto.ConditionData;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.enums.SelectorTypeEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.plugin.base.handler.PluginDataHandler;
import org.apache.shenyu.plugin.logging.rocketmq.DefaultLogCollector;
import org.apache.shenyu.plugin.logging.rocketmq.config.LogCollectConfig;
import org.apache.shenyu.plugin.logging.rocketmq.rocketmq.RocketMQLogCollectClient;
import org.apache.shenyu.plugin.logging.rocketmq.utils.LogCollectConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingRocketMQPluginDataHandler
implements PluginDataHandler {
    private static final Logger LOG = LoggerFactory.getLogger(LoggingRocketMQPluginDataHandler.class);
    private static final RocketMQLogCollectClient ROCKET_MQ_LOG_COLLECT_CLIENT = new RocketMQLogCollectClient();
    private static final String EMPTY_JSON = "{}";
    private static final Map<String, List<String>> SELECT_ID_URI_LIST_MAP = new ConcurrentHashMap<String, List<String>>();
    private static final Map<String, LogCollectConfig.LogApiConfig> SELECT_API_CONFIG_MAP = new ConcurrentHashMap<String, LogCollectConfig.LogApiConfig>();

    public void handlerPlugin(PluginData pluginData) {
        LOG.info("handler loggingRocketMQ Plugin data:{}", (Object)GsonUtils.getGson().toJson((Object)pluginData));
        if (pluginData.getEnabled().booleanValue()) {
            LogCollectConfig.GlobalLogConfig globalLogConfig = (LogCollectConfig.GlobalLogConfig)GsonUtils.getInstance().fromJson(pluginData.getConfig(), LogCollectConfig.GlobalLogConfig.class);
            LogCollectConfigUtils.setGlobalConfig(globalLogConfig);
            Properties properties = new Properties();
            properties.setProperty("topic", globalLogConfig.getTopic());
            properties.setProperty("namesrvAddr", globalLogConfig.getNamesrvAddr());
            properties.setProperty("producerGroup", globalLogConfig.getProducerGroup());
            ROCKET_MQ_LOG_COLLECT_CLIENT.initProducer(properties);
            DefaultLogCollector.getInstance().start();
        } else {
            try {
                DefaultLogCollector.getInstance().close();
            }
            catch (Exception e) {
                LOG.error("close log collector error", (Throwable)e);
            }
        }
    }

    public void handlerSelector(SelectorData selectorData) {
        LOG.info("handler loggingRocketMQ selector data:{}", (Object)GsonUtils.getGson().toJson((Object)selectorData));
        String handleJson = selectorData.getHandle();
        if (StringUtils.isEmpty((CharSequence)handleJson) || EMPTY_JSON.equals(handleJson.trim())) {
            return;
        }
        if (selectorData.getType().intValue() != SelectorTypeEnum.CUSTOM_FLOW.getCode() || CollectionUtils.isEmpty((Collection)selectorData.getConditionList())) {
            return;
        }
        LogCollectConfig.LogApiConfig logApiConfig = (LogCollectConfig.LogApiConfig)GsonUtils.getInstance().fromJson(handleJson, LogCollectConfig.LogApiConfig.class);
        if (StringUtils.isBlank((CharSequence)logApiConfig.getTopic()) || StringUtils.isBlank((CharSequence)logApiConfig.getSampleRate())) {
            return;
        }
        ArrayList<String> uriList = new ArrayList<String>();
        for (ConditionData conditionData : selectorData.getConditionList()) {
            if (!"uri".equals(conditionData.getParamType()) || !StringUtils.isNotBlank((CharSequence)conditionData.getParamValue()) || !"match".equals(conditionData.getOperator()) && !"=".equals(conditionData.getOperator())) continue;
            uriList.add(conditionData.getParamValue().trim());
        }
        SELECT_ID_URI_LIST_MAP.put(selectorData.getId(), uriList);
        SELECT_API_CONFIG_MAP.put(selectorData.getId(), logApiConfig);
    }

    public void removeSelector(SelectorData selectorData) {
        LOG.info("handler remove loggingRocketMQ selector data:{}", (Object)GsonUtils.getGson().toJson((Object)selectorData));
        SELECT_ID_URI_LIST_MAP.remove(selectorData.getId());
        SELECT_API_CONFIG_MAP.remove(selectorData.getId());
    }

    public String pluginNamed() {
        return PluginEnum.LOGGING_ROCKETMQ.getName();
    }

    public static RocketMQLogCollectClient getRocketMqLogCollectClient() {
        return ROCKET_MQ_LOG_COLLECT_CLIENT;
    }

    public static Map<String, List<String>> getSelectIdUriListMap() {
        return SELECT_ID_URI_LIST_MAP;
    }

    public static Map<String, LogCollectConfig.LogApiConfig> getSelectApiConfigMap() {
        return SELECT_API_CONFIG_MAP;
    }
}

