/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.logging.rocketmq.rocketmq;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.common.message.Message;
import org.apache.shenyu.common.utils.JsonUtils;
import org.apache.shenyu.plugin.logging.rocketmq.LogConsumeClient;
import org.apache.shenyu.plugin.logging.rocketmq.entity.LZ4CompressData;
import org.apache.shenyu.plugin.logging.rocketmq.entity.ShenyuRequestLog;
import org.apache.shenyu.plugin.logging.rocketmq.utils.LogCollectConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocketMQLogCollectClient
implements LogConsumeClient {
    private static final Logger LOG = LoggerFactory.getLogger(RocketMQLogCollectClient.class);
    private static final String DEFAULT_PRODUCER_GROUP = "shenyu-plugin-logging-rocketmq";
    private DefaultMQProducer producer;
    private String topic;
    private final AtomicBoolean isStarted = new AtomicBoolean(false);

    public void initProducer(Properties props) {
        if (MapUtils.isEmpty((Map)props)) {
            LOG.error("RocketMQ props is empty. failed init RocketMQ producer");
            return;
        }
        if (this.isStarted.get()) {
            this.close();
        }
        String topic = props.getProperty("topic");
        String nameserverAddress = props.getProperty("namesrvAddr");
        String producerGroup = props.getProperty("producerGroup", DEFAULT_PRODUCER_GROUP);
        if (StringUtils.isBlank((CharSequence)topic) || StringUtils.isBlank((CharSequence)nameserverAddress)) {
            LOG.error("init RocketMQLogCollectClient error, please check topic or nameserverAddress");
            return;
        }
        this.topic = topic;
        this.producer = new DefaultMQProducer(producerGroup);
        this.producer.setNamesrvAddr(nameserverAddress);
        this.producer.setRetryTimesWhenSendAsyncFailed(0);
        this.producer.setInstanceName(DEFAULT_PRODUCER_GROUP);
        try {
            this.producer.start();
            LOG.info("init RocketMQLogCollectClient success");
            this.isStarted.set(true);
            Runtime.getRuntime().addShutdownHook(new Thread(this::close));
        }
        catch (Exception e) {
            LOG.error("init RocketMQLogCollectClient error", (Throwable)e);
        }
    }

    @Override
    public void consume(List<ShenyuRequestLog> logs) {
        if (CollectionUtils.isEmpty(logs) || !this.isStarted.get()) {
            return;
        }
        logs.forEach(log -> {
            String logTopic = (String)StringUtils.defaultIfBlank((CharSequence)LogCollectConfigUtils.getTopic(log.getPath()), (CharSequence)this.topic);
            try {
                this.producer.sendOneway(this.toMessage(logTopic, (ShenyuRequestLog)log));
            }
            catch (Exception e) {
                LOG.error("rocketmq push logs error", (Throwable)e);
            }
        });
    }

    private Message toMessage(String logTopic, ShenyuRequestLog log) {
        byte[] bytes = JsonUtils.toJson((Object)log).getBytes(StandardCharsets.UTF_8);
        String compressAlg = (String)StringUtils.defaultIfBlank((CharSequence)LogCollectConfigUtils.getGlobalLogConfig().getCompressAlg(), (CharSequence)"");
        if ("LZ4".equalsIgnoreCase(compressAlg.trim())) {
            LZ4CompressData lz4CompressData = new LZ4CompressData(bytes.length, this.compressedByte(bytes));
            return new Message(logTopic, JsonUtils.toJson((Object)lz4CompressData).getBytes(StandardCharsets.UTF_8));
        }
        return new Message(logTopic, bytes);
    }

    private byte[] compressedByte(byte[] srcByte) {
        LZ4Factory factory = LZ4Factory.fastestInstance();
        LZ4Compressor compressor = factory.fastCompressor();
        return compressor.compress(srcByte);
    }

    @Override
    public void close() {
        if (this.producer != null && this.isStarted.get()) {
            this.producer.shutdown();
            this.isStarted.set(false);
        }
    }
}

