/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.logging.rocketmq.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.plugin.logging.rocketmq.config.LogCollectConfig;
import org.apache.shenyu.plugin.logging.rocketmq.sampler.CountSampler;
import org.apache.shenyu.plugin.logging.rocketmq.sampler.Sampler;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.AntPathMatcher;

public final class LogCollectConfigUtils {
    private static final AntPathMatcher MATCHER = new AntPathMatcher();
    private static LogCollectConfig.GlobalLogConfig globalLogConfig;
    private static final LogCollectConfig.GlobalLogConfig DEFAULT_GLOBAL_LOG_CONFIG;
    private static Map<String, Sampler> apiSamplerMap;
    private static Map<String, String> apiTopicMap;
    private static Sampler globalSampler;

    private LogCollectConfigUtils() {
    }

    public static void setGlobalConfig(LogCollectConfig.GlobalLogConfig config) {
        globalLogConfig = config;
    }

    public static void setSampler(Map<String, String> uriSampleMap) {
        HashMap<String, Sampler> samplerMap = new HashMap<String, Sampler>();
        uriSampleMap.forEach((path, sampler) -> {
            if (StringUtils.isBlank((CharSequence)sampler)) {
                samplerMap.put((String)path, globalSampler);
            } else {
                samplerMap.put((String)path, CountSampler.create(sampler));
            }
        });
        apiSamplerMap = samplerMap;
    }

    public static void setTopic(Map<String, String> uriTopicMap) {
        apiTopicMap = uriTopicMap;
    }

    public static void setGlobalSampler(String sampler) {
        if (StringUtils.isNotBlank((CharSequence)sampler)) {
            try {
                globalSampler = CountSampler.create(sampler);
            }
            catch (Exception e) {
                globalSampler = Sampler.ALWAYS_SAMPLE;
            }
        }
    }

    public static boolean isSampled(ServerHttpRequest request) {
        String path = request.getURI().getPath();
        for (Map.Entry<String, Sampler> entry : apiSamplerMap.entrySet()) {
            String pattern = entry.getKey();
            if (!MATCHER.match(pattern, path)) continue;
            return entry.getValue().isSampled(request);
        }
        if (globalSampler != null) {
            return globalSampler.isSampled(request);
        }
        return true;
    }

    public static boolean isRequestBodyTooLarge(int bodySize) {
        if (Objects.isNull(globalLogConfig)) {
            return false;
        }
        return bodySize > globalLogConfig.getMaxRequestBody();
    }

    public static boolean isResponseBodyTooLarge(int bodySize) {
        if (Objects.isNull(globalLogConfig)) {
            return false;
        }
        return bodySize > globalLogConfig.getMaxResponseBody();
    }

    public static LogCollectConfig.GlobalLogConfig getGlobalLogConfig() {
        return Optional.ofNullable(globalLogConfig).orElse(DEFAULT_GLOBAL_LOG_CONFIG);
    }

    public static String getTopic(String path) {
        for (Map.Entry<String, String> entry : apiTopicMap.entrySet()) {
            String pattern = entry.getKey();
            if (!MATCHER.match(pattern, path)) continue;
            return entry.getValue();
        }
        return "";
    }

    static {
        DEFAULT_GLOBAL_LOG_CONFIG = new LogCollectConfig.GlobalLogConfig();
        apiSamplerMap = new HashMap<String, Sampler>();
        apiTopicMap = new HashMap<String, String>();
        globalSampler = Sampler.ALWAYS_SAMPLE;
    }
}

