/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.oauth2.filter;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.enums.SelectorTypeEnum;
import org.apache.shenyu.plugin.base.cache.BaseDataCache;
import org.apache.shenyu.plugin.base.condition.strategy.MatchStrategyFactory;
import org.springframework.security.web.server.util.matcher.PathPatternParserServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class OAuth2PreFilter
implements WebFilter {
    private static final AtomicBoolean SKIP = new AtomicBoolean(true);
    private final List<ServerWebExchangeMatcher> matchers;

    public OAuth2PreFilter(List<ServerWebExchangeMatcher> matchers) {
        this.matchers = matchers;
    }

    @Nonnull
    public Mono<Void> filter(@Nonnull ServerWebExchange serverWebExchange, @Nonnull WebFilterChain webFilterChain) {
        PluginData pluginData = BaseDataCache.getInstance().obtainPluginData(PluginEnum.OAUTH2.getName());
        boolean enable = Objects.nonNull(pluginData) && pluginData.getEnabled() != false;
        serverWebExchange.getAttributes().put("enable", enable);
        if (enable) {
            this.processPathMatchers(serverWebExchange);
        }
        return webFilterChain.filter(serverWebExchange);
    }

    private void processPathMatchers(ServerWebExchange serverWebExchange) {
        if (Boolean.TRUE.equals(serverWebExchange.getAttributes().get("enable"))) {
            this.buildPathMatchers(serverWebExchange);
        } else {
            this.refreshPathMatchers();
        }
    }

    private Boolean filterSelector(SelectorData selector, ServerWebExchange exchange) {
        if (selector.getType().intValue() == SelectorTypeEnum.CUSTOM_FLOW.getCode()) {
            if (CollectionUtils.isEmpty((Collection)selector.getConditionList())) {
                return false;
            }
            return MatchStrategyFactory.match((Integer)selector.getMatchMode(), (List)selector.getConditionList(), (ServerWebExchange)exchange);
        }
        return true;
    }

    private void buildPathMatchers(ServerWebExchange serverWebExchange) {
        this.refreshPathMatchers();
        List oauth2Selectors = BaseDataCache.getInstance().obtainSelectorData(PluginEnum.OAUTH2.getName());
        if (CollectionUtils.isEmpty((Collection)oauth2Selectors)) {
            serverWebExchange.getAttributes().put("skip", true);
            return;
        }
        SelectorData selectorData = oauth2Selectors.parallelStream().filter(selector -> selector.getEnabled() != false && this.filterSelector((SelectorData)selector, serverWebExchange) != false).findFirst().orElse(null);
        if (Objects.isNull(selectorData)) {
            serverWebExchange.getAttributes().put("skip", true);
            return;
        }
        if (selectorData.getType().equals(SelectorTypeEnum.FULL_FLOW.getCode())) {
            this.matchers.add((ServerWebExchangeMatcher)new PathPatternParserServerWebExchangeMatcher("/**"));
        } else {
            List ruleData = BaseDataCache.getInstance().obtainRuleData(selectorData.getId());
            ruleData.parallelStream().filter(RuleData::getEnabled).forEach(rule -> rule.getConditionDataList().forEach(data -> this.matchers.add((ServerWebExchangeMatcher)new PathPatternParserServerWebExchangeMatcher(data.getParamValue()))));
        }
        SKIP.set(this.matchers.size() <= 1);
        serverWebExchange.getAttributes().put("skip", SKIP.get());
    }

    private void refreshPathMatchers() {
        this.matchers.clear();
        this.matchers.add((ServerWebExchangeMatcher)new PathPatternParserServerWebExchangeMatcher("-"));
    }
}

