/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.rewrite;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.dto.convert.rule.RewriteHandle;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.common.utils.PathMatchUtils;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.base.AbstractShenyuPlugin;
import org.apache.shenyu.plugin.base.utils.CacheKeyUtils;
import org.apache.shenyu.plugin.rewrite.handler.RewritePluginDataHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class RewritePlugin
extends AbstractShenyuPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(RewritePlugin.class);

    protected Mono<Void> doExecute(ServerWebExchange exchange, ShenyuPluginChain chain, SelectorData selector, RuleData rule) {
        String handle = rule.getHandle();
        RewriteHandle rewriteHandle = (RewriteHandle)RewritePluginDataHandler.CACHED_HANDLE.get().obtainHandle((Object)CacheKeyUtils.INST.getKey(rule));
        if (Objects.isNull(rewriteHandle)) {
            LOG.error("uri rewrite rule can not configuration\uff1a{}", (Object)handle);
            return chain.execute(exchange);
        }
        String rewriteUri = exchange.getRequest().getURI().getPath();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{rewriteHandle.getRegex(), rewriteHandle.getReplace()})) {
            rewriteUri = rewriteHandle.getReplace().contains("{") ? PathMatchUtils.replaceAll((String)rewriteHandle.getReplace(), (String)rewriteHandle.getRegex().substring(rewriteHandle.getRegex().indexOf("{")), (String)rewriteUri.substring(rewriteHandle.getRegex().indexOf("{") + 1)) : rewriteUri.replaceAll(rewriteHandle.getRegex(), rewriteHandle.getReplace());
            exchange.getAttributes().put("rewrite_uri", rewriteUri);
        }
        return chain.execute(exchange);
    }

    public boolean skip(ServerWebExchange exchange) {
        return this.skip(exchange, new RpcTypeEnum[]{RpcTypeEnum.DUBBO, RpcTypeEnum.HSF, RpcTypeEnum.GRPC, RpcTypeEnum.TARS, RpcTypeEnum.MOTAN, RpcTypeEnum.SOFA});
    }

    public String named() {
        return PluginEnum.REWRITE.getName();
    }

    public int getOrder() {
        return PluginEnum.REWRITE.getCode();
    }
}

