/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.register.client.consul;

import com.ecwid.consul.v1.kv.KeyValueClient;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.common.utils.ContextPathUtils;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.LogUtils;
import org.apache.shenyu.register.client.api.ShenyuClientRegisterRepository;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.apache.shenyu.register.common.dto.URIRegisterDTO;
import org.apache.shenyu.register.common.path.RegisterPathConstants;
import org.apache.shenyu.spi.Join;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.consul.serviceregistry.ConsulRegistration;

@Join
public class ConsulClientRegisterRepository
implements ShenyuClientRegisterRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsulClientRegisterRepository.class);
    @Autowired
    private ConsulRegistration consulRegistration;
    @Autowired
    private KeyValueClient keyValueClient;

    public void persistInterface(MetaDataRegisterDTO metadata) {
        String rpcType = metadata.getRpcType();
        String contextPath = ContextPathUtils.buildRealNode((String)metadata.getContextPath(), (String)metadata.getAppName());
        this.registerMetadata(rpcType, contextPath, metadata);
        LogUtils.info((Logger)LOGGER, (String)"{} Consul client register success: {}", (Object[])new Object[]{rpcType, metadata});
    }

    public void persistURI(URIRegisterDTO registerDTO) {
        this.registerURI(registerDTO);
    }

    private void registerMetadata(String rpcType, String contextPath, MetaDataRegisterDTO metadata) {
        String metadataNodeName = this.buildMetadataNodeName(metadata);
        String metaDataPath = RegisterPathConstants.buildMetaDataParentPath((String)rpcType, (String)contextPath);
        String realNode = RegisterPathConstants.buildRealNode((String)metaDataPath, (String)metadataNodeName);
        String metadataJson = GsonUtils.getInstance().toJson((Object)metadata);
        this.keyValueClient.setKVValue(realNode, metadataJson);
    }

    private void registerURI(URIRegisterDTO metadata) {
        this.consulRegistration.getService().getMeta().put("uri", GsonUtils.getInstance().toJson((Object)metadata));
    }

    private String buildMetadataNodeName(MetaDataRegisterDTO metadata) {
        String rpcType = metadata.getRpcType();
        String nodeName = RpcTypeEnum.HTTP.getName().equals(rpcType) || RpcTypeEnum.SPRING_CLOUD.getName().equals(rpcType) ? String.join((CharSequence)"-", metadata.getContextPath(), metadata.getRuleName().replace("/", "-")) : RegisterPathConstants.buildNodeName((String)metadata.getServiceName(), (String)metadata.getMethodName());
        return nodeName.startsWith("/") ? nodeName.substring(1) : nodeName;
    }
}

