/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.register.client.nacos;

import com.alibaba.nacos.api.config.ConfigFactory;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingFactory;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.pojo.Instance;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.common.utils.ContextPathUtils;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.register.client.api.ShenyuClientRegisterRepository;
import org.apache.shenyu.register.common.config.ShenyuRegisterCenterConfig;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.apache.shenyu.register.common.dto.URIRegisterDTO;
import org.apache.shenyu.register.common.path.RegisterPathConstants;
import org.apache.shenyu.spi.Join;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Join
public class NacosClientRegisterRepository
implements ShenyuClientRegisterRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(NacosClientRegisterRepository.class);
    private static final String NAMESPACE = "nacosNameSpace";
    private static final String URI_META_DATA = "uriMetadata";
    private ConfigService configService;
    private NamingService namingService;
    private final ConcurrentLinkedQueue<String> metadataCache = new ConcurrentLinkedQueue();

    public NacosClientRegisterRepository() {
    }

    public NacosClientRegisterRepository(ShenyuRegisterCenterConfig config) {
        this.init(config);
    }

    public void init(ShenyuRegisterCenterConfig config) {
        String serverAddr = config.getServerLists();
        Properties properties = config.getProps();
        Properties nacosProperties = new Properties();
        nacosProperties.put("serverAddr", serverAddr);
        nacosProperties.put("namespace", properties.getProperty(NAMESPACE));
        nacosProperties.put("username", properties.getProperty("username", ""));
        nacosProperties.put("password", properties.getProperty("password", ""));
        nacosProperties.put("accessKey", properties.getProperty("accessKey", ""));
        nacosProperties.put("secretKey", properties.getProperty("secretKey", ""));
        try {
            this.configService = ConfigFactory.createConfigService((Properties)nacosProperties);
            this.namingService = NamingFactory.createNamingService((Properties)nacosProperties);
        }
        catch (NacosException e) {
            throw new ShenyuException((Throwable)e);
        }
    }

    public void close() {
        try {
            this.configService.shutDown();
            this.namingService.shutDown();
        }
        catch (NacosException e) {
            LOGGER.error("NacosClientRegisterRepository close error!", (Throwable)e);
        }
    }

    public void persistInterface(MetaDataRegisterDTO metadata) {
        String rpcType = metadata.getRpcType();
        String contextPath = ContextPathUtils.buildRealNode((String)metadata.getContextPath(), (String)metadata.getAppName());
        this.registerConfig(rpcType, contextPath, metadata);
    }

    public void persistURI(URIRegisterDTO registerDTO) {
        String rpcType = registerDTO.getRpcType();
        String contextPath = ContextPathUtils.buildRealNode((String)registerDTO.getContextPath(), (String)registerDTO.getAppName());
        String host = registerDTO.getHost();
        int port = registerDTO.getPort();
        this.registerService(rpcType, contextPath, host, port, registerDTO);
    }

    private synchronized void registerService(String rpcType, String contextPath, String host, int port, URIRegisterDTO registerDTO) {
        Instance instance = new Instance();
        instance.setEphemeral(true);
        instance.setIp(host);
        instance.setPort(port);
        HashMap<String, String> metadataMap = new HashMap<String, String>();
        metadataMap.put("contextPath", contextPath);
        metadataMap.put(URI_META_DATA, GsonUtils.getInstance().toJson((Object)registerDTO));
        instance.setMetadata(metadataMap);
        String serviceName = RegisterPathConstants.buildServiceInstancePath((String)rpcType);
        try {
            this.namingService.registerInstance(serviceName, instance);
        }
        catch (NacosException e) {
            throw new ShenyuException((Throwable)e);
        }
        LOGGER.info("register service uri success: {}", (Object)serviceName);
    }

    private synchronized void registerConfig(String rpcType, String contextPath, MetaDataRegisterDTO metadata) {
        this.metadataCache.add(GsonUtils.getInstance().toJson((Object)metadata));
        String configName = RegisterPathConstants.buildServiceConfigPath((String)rpcType, (String)contextPath);
        try {
            String defaultGroup = "DEFAULT_GROUP";
            if (!this.configService.publishConfig(configName, "DEFAULT_GROUP", GsonUtils.getInstance().toJson(this.metadataCache))) {
                throw new ShenyuException("register metadata fail , please check ");
            }
            LOGGER.info("register metadata success: {}", (Object)metadata.getRuleName());
        }
        catch (NacosException e) {
            throw new ShenyuException((Throwable)e);
        }
    }
}

