/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.register.client.zookeeper;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.I0Itec.zkclient.IZkStateListener;
import org.I0Itec.zkclient.ZkClient;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.common.utils.ContextPathUtils;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.register.client.api.ShenyuClientRegisterRepository;
import org.apache.shenyu.register.common.config.ShenyuRegisterCenterConfig;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.apache.shenyu.register.common.dto.URIRegisterDTO;
import org.apache.shenyu.register.common.path.RegisterPathConstants;
import org.apache.shenyu.spi.Join;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Join
public class ZookeeperClientRegisterRepository
implements ShenyuClientRegisterRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZookeeperClientRegisterRepository.class);
    private ZkClient zkClient;
    private final Map<String, String> nodeDataMap = new HashMap<String, String>();

    public void init(ShenyuRegisterCenterConfig config) {
        Properties props = config.getProps();
        int sessionTimeout = Integer.parseInt(props.getProperty("sessionTimeout", "3000"));
        int connectionTimeout = Integer.parseInt(props.getProperty("connectionTimeout", "3000"));
        this.zkClient = new ZkClient(config.getServerLists(), sessionTimeout, connectionTimeout);
        this.zkClient.subscribeStateChanges((IZkStateListener)new ZkStateListener());
    }

    public void persistInterface(MetaDataRegisterDTO metadata) {
        String rpcType = metadata.getRpcType();
        String contextPath = ContextPathUtils.buildRealNode((String)metadata.getContextPath(), (String)metadata.getAppName());
        this.registerMetadata(rpcType, contextPath, metadata);
        LOGGER.info("{} zookeeper client register success: {}", (Object)rpcType, (Object)metadata);
    }

    public void persistURI(URIRegisterDTO registerDTO) {
        String rpcType = registerDTO.getRpcType();
        String contextPath = ContextPathUtils.buildRealNode((String)registerDTO.getContextPath(), (String)registerDTO.getAppName());
        this.registerURI(rpcType, contextPath, registerDTO);
    }

    public void close() {
        this.zkClient.close();
    }

    private void registerMetadata(String rpcType, String contextPath, MetaDataRegisterDTO metadata) {
        String realNode;
        String metadataNodeName = this.buildMetadataNodeName(metadata);
        String metaDataPath = RegisterPathConstants.buildMetaDataParentPath((String)rpcType, (String)contextPath);
        if (!this.zkClient.exists(metaDataPath)) {
            this.zkClient.createPersistent(metaDataPath, true);
        }
        if (this.zkClient.exists(realNode = RegisterPathConstants.buildRealNode((String)metaDataPath, (String)metadataNodeName))) {
            this.zkClient.writeData(realNode, (Object)GsonUtils.getInstance().toJson((Object)metadata));
        } else {
            this.zkClient.createPersistent(realNode, (Object)GsonUtils.getInstance().toJson((Object)metadata));
        }
    }

    private synchronized void registerURI(String rpcType, String contextPath, URIRegisterDTO registerDTO) {
        String realNode;
        String uriNodeName = this.buildURINodeName(registerDTO);
        String uriPath = RegisterPathConstants.buildURIParentPath((String)rpcType, (String)contextPath);
        if (!this.zkClient.exists(uriPath)) {
            this.zkClient.createPersistent(uriPath, true);
        }
        if (!this.zkClient.exists(realNode = RegisterPathConstants.buildRealNode((String)uriPath, (String)uriNodeName))) {
            String nodeData = GsonUtils.getInstance().toJson((Object)registerDTO);
            this.nodeDataMap.put(realNode, nodeData);
            this.zkClient.createEphemeral(realNode, (Object)nodeData);
        }
    }

    private String buildURINodeName(URIRegisterDTO registerDTO) {
        String host = registerDTO.getHost();
        int port = registerDTO.getPort();
        return String.join((CharSequence)":", host, Integer.toString(port));
    }

    private String buildMetadataNodeName(MetaDataRegisterDTO metadata) {
        String rpcType = metadata.getRpcType();
        String nodeName = RpcTypeEnum.HTTP.getName().equals(rpcType) || RpcTypeEnum.SPRING_CLOUD.getName().equals(rpcType) ? String.join((CharSequence)"-", metadata.getContextPath(), metadata.getRuleName().replace("/", "-")) : RegisterPathConstants.buildNodeName((String)metadata.getServiceName(), (String)metadata.getMethodName());
        return nodeName.startsWith("/") ? nodeName.substring(1) : nodeName;
    }

    private class ZkStateListener
    implements IZkStateListener {
        private ZkStateListener() {
        }

        public void handleStateChanged(Watcher.Event.KeeperState keeperState) {
            if (Watcher.Event.KeeperState.SyncConnected.equals((Object)keeperState)) {
                ZookeeperClientRegisterRepository.this.nodeDataMap.forEach((k, v) -> {
                    if (!ZookeeperClientRegisterRepository.this.zkClient.exists(k)) {
                        ZookeeperClientRegisterRepository.this.zkClient.createEphemeral(k, v);
                        LOGGER.info("zookeeper client register success: {}", v);
                    }
                });
            }
        }

        public void handleNewSession() {
        }

        public void handleSessionEstablishmentError(Throwable throwable) {
        }
    }
}

