/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.register.instance.etcd;

import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.KV;
import io.etcd.jetcd.lease.LeaseGrantResponse;
import io.etcd.jetcd.lease.LeaseKeepAliveResponse;
import io.etcd.jetcd.options.PutOption;
import io.grpc.stub.StreamObserver;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtcdClient {
    public static final Charset UTF_8 = StandardCharsets.UTF_8;
    private static final Logger LOGGER = LoggerFactory.getLogger(EtcdClient.class);
    private final Client client;
    private final long ttl;
    private final long timeout;
    private long globalLeaseId;

    public EtcdClient(String url, long ttl, long timeout) {
        this.client = Client.builder().endpoints(url.split(",")).build();
        this.ttl = ttl;
        this.timeout = timeout;
        this.initLease();
    }

    private void initLease() {
        try {
            this.globalLeaseId = ((LeaseGrantResponse)this.client.getLeaseClient().grant(this.ttl).get()).getID();
            this.client.getLeaseClient().keepAlive(this.globalLeaseId, (StreamObserver)new StreamObserver<LeaseKeepAliveResponse>(){

                public void onNext(LeaseKeepAliveResponse leaseKeepAliveResponse) {
                }

                public void onError(Throwable throwable) {
                    LOGGER.error("keep alive error", throwable);
                }

                public void onCompleted() {
                }
            });
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.error("initLease error.", (Throwable)e);
        }
    }

    public void close() {
        this.client.close();
    }

    public void putEphemeral(String key, String value) {
        try {
            KV kvClient = this.client.getKVClient();
            kvClient.put(ByteSequence.from((String)key, (Charset)UTF_8), ByteSequence.from((String)value, (Charset)UTF_8), PutOption.newBuilder().withLeaseId(this.globalLeaseId).build()).get(this.timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            LOGGER.error("putEphemeral(key:{},value:{}) error.", new Object[]{key, value, e});
        }
    }
}

