/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.springboot.starter.plugin.sign;

import org.apache.shenyu.plugin.api.ShenyuPlugin;
import org.apache.shenyu.plugin.sign.SignPlugin;
import org.apache.shenyu.plugin.sign.api.DefaultSignProvider;
import org.apache.shenyu.plugin.sign.api.SignProvider;
import org.apache.shenyu.plugin.sign.api.SignService;
import org.apache.shenyu.plugin.sign.service.DefaultSignService;
import org.apache.shenyu.plugin.sign.subscriber.SignAuthDataSubscriber;
import org.apache.shenyu.sync.data.api.AuthDataSubscriber;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"shenyu.plugins.sign.enabled"}, havingValue="true", matchIfMissing=true)
public class SignPluginConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={SignService.class}, search=SearchStrategy.ALL)
    public SignService signService() {
        return new DefaultSignService();
    }

    @Bean
    @ConditionalOnMissingBean(value={SignProvider.class}, search=SearchStrategy.ALL)
    public SignProvider signProvider() {
        return new DefaultSignProvider();
    }

    @Bean
    public ShenyuPlugin signPlugin(SignService signService) {
        return new SignPlugin(signService);
    }

    @Bean
    public AuthDataSubscriber signAuthDataSubscriber() {
        return new SignAuthDataSubscriber();
    }
}

