/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.web.filter;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.shenyu.web.filter.AbstractWebFilter;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class ExcludeFilter
extends AbstractWebFilter {
    private final Set<String> paths;

    public ExcludeFilter(List<String> paths) {
        this.paths = new HashSet<String>(paths);
    }

    @Override
    protected Mono<Boolean> doMatcher(ServerWebExchange exchange, WebFilterChain chain) {
        String path = exchange.getRequest().getURI().getPath();
        return Mono.just((Object)this.paths.contains(path));
    }

    @Override
    protected Mono<Void> doFilter(ServerWebExchange exchange) {
        ServerHttpResponse response = exchange.getResponse();
        response.setStatusCode(HttpStatus.OK);
        return Mono.empty();
    }
}

