/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.web.controller;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.common.dto.AppAuthData;
import org.apache.shenyu.sync.data.api.AuthDataSubscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/shenyu"}, produces={"application/json", "application/xml"})
public class LocalAppAuthController {
    private static final Logger LOG = LoggerFactory.getLogger(LocalAppAuthController.class);
    private final List<AuthDataSubscriber> subscribers;

    public LocalAppAuthController(ObjectProvider<List<AuthDataSubscriber>> subscribers) {
        this.subscribers = (List)subscribers.getIfAvailable(ArrayList::new);
    }

    @GetMapping(value={"/auth/delete"})
    public Mono<String> clean(@RequestParam(value="appKey") String appKey) {
        if (CollectionUtils.isEmpty(this.subscribers)) {
            return Mono.just((Object)"success");
        }
        LOG.info("delete apache shenyu local AppAuth data");
        AppAuthData appAuthData = AppAuthData.builder().appKey(appKey).build();
        this.subscribers.forEach(authDataSubscriber -> authDataSubscriber.unSubscribe(appAuthData));
        return Mono.just((Object)"success");
    }

    @PostMapping(value={"/auth/saveOrUpdate"})
    public Mono<String> saveOrUpdate(@RequestBody AppAuthData appAuthData) {
        if (CollectionUtils.isEmpty(this.subscribers)) {
            return Mono.just((Object)"success");
        }
        LOG.info("saveOrUpdate apache shenyu local app auth");
        this.subscribers.forEach(authDataSubscriber -> authDataSubscriber.onSubscribe(appAuthData));
        return Mono.just((Object)"success");
    }
}

