/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.web.loader;

import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.shenyu.web.loader.PluginJarParser;
import org.apache.shenyu.web.loader.ShenyuPluginClassloaderHolder;
import org.apache.shenyu.web.loader.ShenyuPluginPathBuilder;

public class ShenyuExtPathPluginJarLoader {
    private static volatile Set<String> pluginJarName = new HashSet<String>();

    public static synchronized List<PluginJarParser.PluginJar> loadExtendPlugins(String path) throws IOException {
        File[] jarFiles = ShenyuPluginPathBuilder.getPluginFile(path).listFiles(file -> file.getName().endsWith(".jar"));
        if (Objects.isNull(jarFiles)) {
            return Collections.emptyList();
        }
        ArrayList<PluginJarParser.PluginJar> uploadPluginJars = new ArrayList<PluginJarParser.PluginJar>();
        HashSet<String> currentPaths = new HashSet<String>();
        for (File file2 : jarFiles) {
            String absolutePath = file2.getAbsolutePath();
            currentPaths.add(absolutePath);
            if (pluginJarName.contains(absolutePath)) continue;
            byte[] pluginBytes = Files.readAllBytes(Paths.get(absolutePath, new String[0]));
            PluginJarParser.PluginJar uploadPluginJar = PluginJarParser.parseJar(pluginBytes);
            uploadPluginJar.setAbsolutePath(absolutePath);
            uploadPluginJars.add(uploadPluginJar);
        }
        Sets.SetView removePluginSet = Sets.difference(pluginJarName, currentPaths);
        for (String removePath : removePluginSet) {
            ShenyuPluginClassloaderHolder.getSingleton().removePluginClassLoader(removePath);
        }
        pluginJarName = currentPaths;
        return uploadPluginJars;
    }
}

