/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.math.BigDecimal;
import java.util.TimeZone;
import org.apache.spark.SparkException;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.Cast$$anonfun$castArray$1$;
import org.apache.spark.sql.catalyst.expressions.Cast$$anonfun$org$apache$spark$sql$catalyst$expressions$Cast$;
import org.apache.spark.sql.catalyst.expressions.Cast$$anonfun$org$apache$spark$sql$catalyst$expressions$Cast$$castToString$6$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression$class;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.UTF8StringBuilder;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.catalyst.util.StringUtils$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataType$;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.FractionalType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.PythonUserDefinedType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.BigDecimal$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(expr AS type) - Casts the value `expr` to the target data type `type`.", examples="\n    Examples:\n      > SELECT _FUNC_('10' as int);\n       10\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0011%w!B\u0001\u0003\u0011\u0003y\u0011\u0001B\"bgRT!a\u0001\u0003\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003\u000b\u0019\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003\u000f!\t1a]9m\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001\u0001\t\u0003!Ei\u0011A\u0001\u0004\u0006%\tA\ta\u0005\u0002\u0005\u0007\u0006\u001cHoE\u0002\u0012)i\u0001\"!\u0006\r\u000e\u0003YQ\u0011aF\u0001\u0006g\u000e\fG.Y\u0005\u00033Y\u0011a!\u00118z%\u00164\u0007CA\u000b\u001c\u0013\tabC\u0001\u0007TKJL\u0017\r\\5{C\ndW\rC\u0003\u001f#\u0011\u0005q$\u0001\u0004=S:LGO\u0010\u000b\u0002\u001f!)\u0011%\u0005C\u0001E\u000591-\u00198DCN$HcA\u0012']A\u0011Q\u0003J\u0005\u0003KY\u0011qAQ8pY\u0016\fg\u000eC\u0003(A\u0001\u0007\u0001&\u0001\u0003ge>l\u0007CA\u0015-\u001b\u0005Q#BA\u0016\u0007\u0003\u0015!\u0018\u0010]3t\u0013\ti#F\u0001\u0005ECR\fG+\u001f9f\u0011\u0015y\u0003\u00051\u0001)\u0003\t!x\u000eC\u00032#\u0011\u0005!'A\u0007oK\u0016$7\u000fV5nKj{g.\u001a\u000b\u0004GM\"\u0004\"B\u00141\u0001\u0004A\u0003\"B\u00181\u0001\u0004A\u0003\"\u0002\u001c\u0012\t\u00039\u0014aC7bsR\u0013XO\\2bi\u0016$2a\t\u001d:\u0011\u00159S\u00071\u0001)\u0011\u0015yS\u00071\u0001)\u0011\u0015Y\u0014\u0003\"\u0003=\u0003aIG\u000e\\3hC2tU/\\3sS\u000e\u0004&/Z2fI\u0016t7-\u001a\u000b\u0004Gur\u0004\"B\u0014;\u0001\u0004A\u0003\"B\u0018;\u0001\u0004A\u0003\"\u0002!\u0012\t\u0003\t\u0015!\u00044pe\u000e,g*\u001e7mC\ndW\rF\u0002$\u0005\u000eCQaJ A\u0002!BQaL A\u0002!BQ!R\t\u0005\n\u0019\u000bQC]3t_24\u0018M\u00197f\u001dVdG.\u00192jY&$\u0018\u0010F\u0002$\u000f\"CQa\n#A\u0002\rBQa\f#A\u0002\rBqAS\t\u0002\u0002\u0013\u00055*A\u0003baBd\u0017\u0010F\u0004M\t;#y\n\")\u0011\u0005Aie\u0001\u0002\n\u0003\u0001:\u001bb!T(S+rS\u0002C\u0001\tQ\u0013\t\t&AA\bV]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\t\u00012+\u0003\u0002U\u0005\t9B+[7f5>tW-Q<be\u0016,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003-fs!\u0001E,\n\u0005a\u0013\u0011a\u00029bG.\fw-Z\u0005\u00035n\u0013aBT;mY&sGo\u001c7fe\u0006tGO\u0003\u0002Y\u0005A\u0011Q#X\u0005\u0003=Z\u0011q\u0001\u0015:pIV\u001cG\u000f\u0003\u0005a\u001b\nU\r\u0011\"\u0001b\u0003\u0015\u0019\u0007.\u001b7e+\u0005\u0011\u0007C\u0001\td\u0013\t!'A\u0001\u0006FqB\u0014Xm]:j_:D\u0001BZ'\u0003\u0012\u0003\u0006IAY\u0001\u0007G\"LG\u000e\u001a\u0011\t\u0011!l%Q3A\u0005\u0002%\f\u0001\u0002Z1uCRK\b/Z\u000b\u0002Q!A1.\u0014B\tB\u0003%\u0001&A\u0005eCR\fG+\u001f9fA!AQ.\u0014BK\u0002\u0013\u0005a.\u0001\u0006uS6,'l\u001c8f\u0013\u0012,\u0012a\u001c\t\u0004+A\u0014\u0018BA9\u0017\u0005\u0019y\u0005\u000f^5p]B\u00111O\u001e\b\u0003+QL!!\u001e\f\u0002\rA\u0013X\rZ3g\u0013\t9\bP\u0001\u0004TiJLgn\u001a\u0006\u0003kZA\u0001B_'\u0003\u0012\u0003\u0006Ia\\\u0001\fi&lWMW8oK&#\u0007\u0005C\u0003\u001f\u001b\u0012\u0005A\u0010\u0006\u0003M{z|\b\"\u00021|\u0001\u0004\u0011\u0007\"\u00025|\u0001\u0004A\u0003bB7|!\u0003\u0005\ra\u001c\u0005\u0007=5#\t!a\u0001\u0015\u000b1\u000b)!a\u0002\t\r\u0001\f\t\u00011\u0001c\u0011\u0019A\u0017\u0011\u0001a\u0001Q!9\u00111B'\u0005B\u00055\u0011\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003IDq!!\u0005N\t\u0003\n\u0019\"A\ndQ\u0016\u001c7.\u00138qkR$\u0015\r^1UsB,7\u000f\u0006\u0002\u0002\u0016A!\u0011qCA\u000f\u001b\t\tIBC\u0002\u0002\u001c\u0011\t\u0001\"\u00198bYf\u001c\u0018n]\u0005\u0005\u0003?\tIBA\bUsB,7\t[3dWJ+7/\u001e7u\u0011\u001d\t\u0019#\u0014C!\u0003K\t\u0001B\\;mY\u0006\u0014G.Z\u000b\u0002G!9\u0011\u0011F'\u0005B\u0005-\u0012\u0001D<ji\"$\u0016.\\3[_:,Gc\u0001*\u0002.!1Q.a\nA\u0002ID!\"!\rN\u0011\u000b\u0007I\u0011IA\u0013\u0003!\u0011Xm]8mm\u0016$\u0007\"CA\u001b\u001b\"\u0005\t\u0015)\u0003$\u0003%\u0011Xm]8mm\u0016$\u0007\u0005C\u00042\u001b\u0002&I!!\n\t\u0011\u0005mR\n)C\u0005\u0003{\t\u0011BY;jY\u0012\u001c\u0015m\u001d;\u0016\t\u0005}\u0012\u0011\f\u000b\u0007\u0003\u0003\n9%a\u0013\u0011\u0007U\t\u0019%C\u0002\u0002FY\u00111!\u00118z\u0011!\tI%!\u000fA\u0002\u0005\u0005\u0013!A1\t\u0011\u00055\u0013\u0011\ba\u0001\u0003\u001f\nAAZ;oGB9Q#!\u0015\u0002V\u0005\u0005\u0013bAA*-\tIa)\u001e8di&|g.\r\t\u0005\u0003/\nI\u0006\u0004\u0001\u0005\u0011\u0005m\u0013\u0011\bb\u0001\u0003;\u0012\u0011\u0001V\t\u0005\u0003?\n\t\u0005E\u0002\u0016\u0003CJ1!a\u0019\u0017\u0005\u001dqu\u000e\u001e5j]\u001eDC!!\u000f\u0002hA\u0019Q#!\u001b\n\u0007\u0005-dC\u0001\u0004j]2Lg.\u001a\u0005\t\u0003_j\u0005\u0015\"\u0003\u0002r\u0005a1-Y:u)>\u001cFO]5oOR!\u00111OA;!\u001d)\u0012\u0011KA!\u0003\u0003BaaJA7\u0001\u0004A\u0003\u0002CA=\u001b\u0002&I!a\u001f\u0002\u0019\r\f7\u000f\u001e+p\u0005&t\u0017M]=\u0015\t\u0005M\u0014Q\u0010\u0005\u0007O\u0005]\u0004\u0019\u0001\u0015\t\u0011\u0005\u0005U\n)C\u0005\u0003\u0007\u000bQbY1tiR{'i\\8mK\u0006tG\u0003BA:\u0003\u000bCaaJA@\u0001\u0004A\u0003\u0002CAE\u001b\u0002&I!a#\u0002\u001f\r\f7\u000f\u001e+p)&lWm\u001d;b[B$B!a\u001d\u0002\u000e\"1q%a\"A\u0002!B\u0001\"!%NA\u0013%\u00111S\u0001\u0013I\u0016\u001c\u0017.\\1m)>$\u0016.\\3ti\u0006l\u0007\u000f\u0006\u0003\u0002\u0016\u0006m\u0005cA\u000b\u0002\u0018&\u0019\u0011\u0011\u0014\f\u0003\t1{gn\u001a\u0005\t\u0003;\u000by\t1\u0001\u0002 \u0006\tA\rE\u0002*\u0003CK1!a)+\u0005\u001d!UmY5nC2D\u0001\"a*NA\u0013%\u0011\u0011V\u0001\u0012I>,(\r\\3U_RKW.Z:uC6\u0004H\u0003BA!\u0003WC\u0001\"!(\u0002&\u0002\u0007\u0011Q\u0016\t\u0004+\u0005=\u0016bAAY-\t1Ai\\;cY\u0016D\u0001\"!.NA\u0013%\u0011qW\u0001\u0010Y>tw\rV8US6,7\u000f^1naR!\u0011QSA]\u0011!\tY,a-A\u0002\u0005U\u0015!\u0001;\t\u0011\u0005}V\n)C\u0005\u0003\u0003\fq\u0002^5nKN$\u0018-\u001c9U_2{gn\u001a\u000b\u0005\u0003+\u000b\u0019\r\u0003\u0005\u0002F\u0006u\u0006\u0019AAK\u0003\t!8\u000f\u0003\u0005\u0002J6\u0003K\u0011BAf\u0003E!\u0018.\\3ti\u0006l\u0007\u000fV8E_V\u0014G.\u001a\u000b\u0005\u0003[\u000bi\r\u0003\u0005\u0002F\u0006\u001d\u0007\u0019AAK\u0011!\t\t.\u0014Q\u0005\n\u0005M\u0017AC2bgR$v\u000eR1uKR!\u00111OAk\u0011\u00199\u0013q\u001aa\u0001Q!A\u0011\u0011\\'!\n\u0013\tY.\u0001\bdCN$Hk\\%oi\u0016\u0014h/\u00197\u0015\t\u0005M\u0014Q\u001c\u0005\u0007O\u0005]\u0007\u0019\u0001\u0015\t\u0011\u0005\u0005X\n)C\u0005\u0003G\f!bY1tiR{Gj\u001c8h)\u0011\t\u0019(!:\t\r\u001d\ny\u000e1\u0001)\u0011!\tI/\u0014Q\u0005\n\u0005-\u0018!C2bgR$v.\u00138u)\u0011\t\u0019(!<\t\r\u001d\n9\u000f1\u0001)\u0011!\t\t0\u0014Q\u0005\n\u0005M\u0018aC2bgR$vn\u00155peR$B!a\u001d\u0002v\"1q%a<A\u0002!B\u0001\"!?NA\u0013%\u00111`\u0001\u000bG\u0006\u001cH\u000fV8CsR,G\u0003BA:\u0003{DaaJA|\u0001\u0004A\u0003\u0002\u0003B\u0001\u001b\u0002&IAa\u0001\u0002\u001f\rD\u0017M\\4f!J,7-[:j_:$b!a(\u0003\u0006\t%\u0001\u0002\u0003B\u0004\u0003\u007f\u0004\r!a(\u0002\u000bY\fG.^3\t\u0011\t-\u0011q a\u0001\u0005\u001b\t1\u0002Z3dS6\fG\u000eV=qKB\u0019\u0011Fa\u0004\n\u0007\tE!FA\u0006EK\u000eLW.\u00197UsB,\u0007\u0002\u0003B\u000b\u001b\u0002&IAa\u0006\u0002\u0017Q|\u0007K]3dSNLwN\u001c\u000b\u0007\u0003?\u0013IBa\u0007\t\u0011\t\u001d!1\u0003a\u0001\u0003?C\u0001Ba\u0003\u0003\u0014\u0001\u0007!Q\u0002\u0005\t\u0005?i\u0005\u0015\"\u0003\u0003\"\u0005i1-Y:u)>$UmY5nC2$b!a\u001d\u0003$\t\u0015\u0002BB\u0014\u0003\u001e\u0001\u0007\u0001\u0006\u0003\u0005\u0003(\tu\u0001\u0019\u0001B\u0007\u0003\u0019!\u0018M]4fi\"A!1F'!\n\u0013\u0011i#\u0001\u0007dCN$Hk\u001c#pk\ndW\r\u0006\u0003\u0002t\t=\u0002BB\u0014\u0003*\u0001\u0007\u0001\u0006\u0003\u0005\u000345\u0003K\u0011\u0002B\u001b\u0003-\u0019\u0017m\u001d;U_\u001acw.\u0019;\u0015\t\u0005M$q\u0007\u0005\u0007O\tE\u0002\u0019\u0001\u0015\t\u0011\tmR\n)C\u0005\u0005{\t\u0011bY1ti\u0006\u0013(/Y=\u0015\r\u0005M$q\bB\"\u0011\u001d\u0011\tE!\u000fA\u0002!\n\u0001B\u001a:p[RK\b/\u001a\u0005\b\u0005\u000b\u0012I\u00041\u0001)\u0003\u0019!x\u000eV=qK\"A!\u0011J'!\n\u0013\u0011Y%A\u0004dCN$X*\u00199\u0015\r\u0005M$Q\nB+\u0011\u001d9#q\ta\u0001\u0005\u001f\u00022!\u000bB)\u0013\r\u0011\u0019F\u000b\u0002\b\u001b\u0006\u0004H+\u001f9f\u0011\u001dy#q\ta\u0001\u0005\u001fB\u0001B!\u0017NA\u0013%!1L\u0001\u000bG\u0006\u001cHo\u0015;sk\u000e$HCBA:\u0005;\u0012)\u0007C\u0004(\u0005/\u0002\rAa\u0018\u0011\u0007%\u0012\t'C\u0002\u0003d)\u0012!b\u0015;sk\u000e$H+\u001f9f\u0011\u001dy#q\u000ba\u0001\u0005?B\u0001B!\u001bNA\u0013%!1N\u0001\u0005G\u0006\u001cH\u000f\u0006\u0004\u0002t\t5$q\u000e\u0005\u0007O\t\u001d\u0004\u0019\u0001\u0015\t\r=\u00129\u00071\u0001)\u0011)\u0011I'\u0014ECB\u0013%!1O\u000b\u0003\u0003gB!Ba\u001eN\u0011\u0003\u0005\u000b\u0015BA:\u0003\u0015\u0019\u0017m\u001d;!\u0011\u001d\u0011Y(\u0014C)\u0005{\nAB\\;mYN\u000bg-Z#wC2$B!!\u0011\u0003\u0000!A!\u0011\u0011B=\u0001\u0004\t\t%A\u0003j]B,H\u000fC\u0004\u0003\u00066#\tEa\"\u0002\u000f\u001d,gnQ8eKR!!\u0011\u0012BK!\u0011\u0011YI!%\u000e\u0005\t5%b\u0001BH\u0005\u000591m\u001c3fO\u0016t\u0017\u0002\u0002BJ\u0005\u001b\u0013\u0001\"\u0012=qe\u000e{G-\u001a\u0005\t\u0005/\u0013\u0019\t1\u0001\u0003\u001a\u0006\u00191\r\u001e=\u0011\t\t-%1T\u0005\u0005\u0005;\u0013iI\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000f\t\u0005V\n\"\u0011\u0003$\u0006IAm\\$f]\u000e{G-\u001a\u000b\u0007\u0005\u0013\u0013)Ka*\t\u0011\t]%q\u0014a\u0001\u00053C\u0001B!+\u0003 \u0002\u0007!\u0011R\u0001\u0003KZ,\u0001B!,NA\u0003%!q\u0016\u0002\r\u0007\u0006\u001cHOR;oGRLwN\u001c\t\b+\tE&O\u001d:s\u0013\r\u0011\u0019L\u0006\u0002\n\rVt7\r^5p]NB\u0001Ba.NA\u0013%!\u0011X\u0001\u0015]VdGnU1gK\u000e\u000b7\u000f\u001e$v]\u000e$\u0018n\u001c8\u0015\u0011\tm&q\u0018Ba\u0005\u0007\u0004BA!0\u0003,6\tQ\n\u0003\u0004(\u0005k\u0003\r\u0001\u000b\u0005\u0007_\tU\u0006\u0019\u0001\u0015\t\u0011\t]%Q\u0017a\u0001\u00053C\u0001Ba2NA\u0013%!\u0011Z\u0001\tG\u0006\u001cHoQ8eKRy!Oa3\u0003N\n='1\u001bBl\u00057\u0014y\u000e\u0003\u0005\u0003\u0018\n\u0015\u0007\u0019\u0001BM\u0011\u001d\u0011\tI!2A\u0002IDqA!5\u0003F\u0002\u0007!/A\u0006j]B,H/S:Ok2d\u0007b\u0002Bk\u0005\u000b\u0004\rA]\u0001\u0007e\u0016\u001cX\u000f\u001c;\t\u000f\te'Q\u0019a\u0001e\u0006a!/Z:vYRL5OT;mY\"9!Q\u001cBc\u0001\u0004A\u0013A\u0003:fgVdG\u000fV=qK\"A!\u0011\u000eBc\u0001\u0004\u0011Y\fC\u0004\u0003d6#IA!:\u00023]\u0014\u0018\u000e^3BeJ\f\u0017\u0010V8TiJLgn\u001a\"vS2$WM\u001d\u000b\ne\n\u001d(1\u001eBx\u0005gDqA!;\u0003b\u0002\u0007\u0001&\u0001\u0002fi\"9!Q\u001eBq\u0001\u0004\u0011\u0018!B1se\u0006L\bb\u0002By\u0005C\u0004\rA]\u0001\u0007EV4g-\u001a:\t\u0011\t]%\u0011\u001da\u0001\u00053CqAa>N\t\u0013\u0011I0A\fxe&$X-T1q)>\u001cFO]5oO\n+\u0018\u000e\u001c3feRY!Oa?\u0003\u0000\u000e\r1qAB\u0005\u0011\u001d\u0011iP!>A\u0002!\n!a\u001b;\t\u000f\r\u0005!Q\u001fa\u0001Q\u0005\u0011a\u000f\u001e\u0005\b\u0007\u000b\u0011)\u00101\u0001s\u0003\ri\u0017\r\u001d\u0005\b\u0005c\u0014)\u00101\u0001s\u0011!\u00119J!>A\u0002\te\u0005bBB\u0007\u001b\u0012%1qB\u0001\u001boJLG/Z*ueV\u001cG\u000fV8TiJLgn\u001a\"vS2$WM\u001d\u000b\ne\u000eE11FB\u0018\u0007cA\u0001ba\u0005\u0004\f\u0001\u00071QC\u0001\u0003gR\u0004Raa\u0006\u0004&!rAa!\u0007\u0004$9!11DB\u0011\u001b\t\u0019iBC\u0002\u0004 9\ta\u0001\u0010:p_Rt\u0014\"A\f\n\u0005a3\u0012\u0002BB\u0014\u0007S\u00111aU3r\u0015\tAf\u0003C\u0004\u0004.\r-\u0001\u0019\u0001:\u0002\u0007I|w\u000fC\u0004\u0003r\u000e-\u0001\u0019\u0001:\t\u0011\t]51\u0002a\u0001\u00053C\u0001b!\u000eNA\u0013%1qG\u0001\u0011G\u0006\u001cH\u000fV8TiJLgnZ\"pI\u0016$bAa/\u0004:\rm\u0002BB\u0014\u00044\u0001\u0007\u0001\u0006\u0003\u0005\u0003\u0018\u000eM\u0002\u0019\u0001BM\u0011!\u0019y$\u0014Q\u0005\n\r\u0005\u0013\u0001E2bgR$vNQ5oCJL8i\u001c3f)\u0011\u0011Yla\u0011\t\r\u001d\u001ai\u00041\u0001)\u0011!\u00199%\u0014Q\u0005\n\r%\u0013AD2bgR$v\u000eR1uK\u000e{G-\u001a\u000b\u0007\u0005w\u001bYe!\u0014\t\r\u001d\u001a)\u00051\u0001)\u0011!\u00119j!\u0012A\u0002\te\u0005\u0002\u0003B\u0001\u001b\u0002&Ia!\u0015\u0015\u0013I\u001c\u0019f!\u0016\u0004X\rm\u0003bBAO\u0007\u001f\u0002\rA\u001d\u0005\t\u0005\u0017\u0019y\u00051\u0001\u0003\u000e!91\u0011LB(\u0001\u0004\u0011\u0018AB3w!JLW\u000eC\u0004\u0004^\r=\u0003\u0019\u0001:\u0002\r\u00154h*\u001e7m\u0011!\u0019\t'\u0014Q\u0005\n\r\r\u0014!E2bgR$v\u000eR3dS6\fGnQ8eKRA!1XB3\u0007O\u001aI\u0007\u0003\u0004(\u0007?\u0002\r\u0001\u000b\u0005\t\u0005O\u0019y\u00061\u0001\u0003\u000e!A!qSB0\u0001\u0004\u0011I\n\u0003\u0005\u0004n5\u0003K\u0011BB8\u0003M\u0019\u0017m\u001d;U_RKW.Z:uC6\u00048i\u001c3f)\u0019\u0011Yl!\u001d\u0004t!1qea\u001bA\u0002!B\u0001Ba&\u0004l\u0001\u0007!\u0011\u0014\u0005\t\u0007oj\u0005\u0015\"\u0003\u0004z\u0005\u00112-Y:u)>Le\u000e^3sm\u0006d7i\u001c3f)\u0011\u0011Yla\u001f\t\r\u001d\u001a)\b1\u0001)\u0011!\u0019y(\u0014Q\u0005\n\r\u0005\u0015A\u00063fG&l\u0017\r\u001c+p)&lWm\u001d;b[B\u001cu\u000eZ3\u0015\u0007I\u001c\u0019\tC\u0004\u0002\u001e\u000eu\u0004\u0019\u0001:\t\u0011\r\u001dU\n)C\u0005\u0007\u0013\u000b1\u0003\\8oOR{G+[7f'R\fW\u000e]\"pI\u0016$2A]BF\u0011\u001d\u0019ii!\"A\u0002I\f\u0011\u0001\u001c\u0005\t\u0007#k\u0005\u0015\"\u0003\u0004\u0014\u00061B/[7fgR\fW\u000e\u001d+p\u0013:$XmZ3s\u0007>$W\rF\u0002s\u0007+Cq!!2\u0004\u0010\u0002\u0007!\u000f\u0003\u0005\u0004\u001a6\u0003K\u0011BBN\u0003U!\u0018.\\3ti\u0006l\u0007\u000fV8E_V\u0014G.Z\"pI\u0016$2A]BO\u0011\u001d\t)ma&A\u0002ID\u0001b!)NA\u0013%11U\u0001\u0012G\u0006\u001cH\u000fV8C_>dW-\u00198D_\u0012,G\u0003\u0002B^\u0007KCaaJBP\u0001\u0004A\u0003\u0002CBU\u001b\u0002&Iaa+\u0002\u001d\r\f7\u000f\u001e+p\u0005f$XmQ8eKR1!1XBW\u0007_CaaJBT\u0001\u0004A\u0003\u0002\u0003BL\u0007O\u0003\rA!'\t\u0011\rMV\n)C\u0005\u0007k\u000bqbY1tiR{7\u000b[8si\u000e{G-\u001a\u000b\u0007\u0005w\u001b9l!/\t\r\u001d\u001a\t\f1\u0001)\u0011!\u00119j!-A\u0002\te\u0005\u0002CB_\u001b\u0002&Iaa0\u0002\u001b\r\f7\u000f\u001e+p\u0013:$8i\u001c3f)\u0019\u0011Yl!1\u0004D\"1qea/A\u0002!B\u0001Ba&\u0004<\u0002\u0007!\u0011\u0014\u0005\t\u0007\u000fl\u0005\u0015\"\u0003\u0004J\u0006q1-Y:u)>duN\\4D_\u0012,GC\u0002B^\u0007\u0017\u001ci\r\u0003\u0004(\u0007\u000b\u0004\r\u0001\u000b\u0005\t\u0005/\u001b)\r1\u0001\u0003\u001a\"A1\u0011['!\n\u0013\u0019\u0019.A\bdCN$Hk\u001c$m_\u0006$8i\u001c3f)\u0011\u0011Yl!6\t\r\u001d\u001ay\r1\u0001)\u0011!\u0019I.\u0014Q\u0005\n\rm\u0017\u0001E2bgR$v\u000eR8vE2,7i\u001c3f)\u0011\u0011Yl!8\t\r\u001d\u001a9\u000e1\u0001)\u0011!\u0019\t/\u0014Q\u0005\n\r\r\u0018!D2bgR\f%O]1z\u0007>$W\r\u0006\u0005\u0003<\u000e\u00158q]Bu\u0011\u001d\u0011\tea8A\u0002!BqA!\u0012\u0004`\u0002\u0007\u0001\u0006\u0003\u0005\u0003\u0018\u000e}\u0007\u0019\u0001BM\u0011!\u0019i/\u0014Q\u0005\n\r=\u0018aC2bgRl\u0015\r]\"pI\u0016$\u0002Ba/\u0004r\u000eM8Q\u001f\u0005\bO\r-\b\u0019\u0001B(\u0011\u001dy31\u001ea\u0001\u0005\u001fB\u0001Ba&\u0004l\u0002\u0007!\u0011\u0014\u0005\t\u0007sl\u0005\u0015\"\u0003\u0004|\u0006q1-Y:u'R\u0014Xo\u0019;D_\u0012,G\u0003\u0003B^\u0007{\u001cy\u0010\"\u0001\t\u000f\u001d\u001a9\u00101\u0001\u0003`!9qfa>A\u0002\t}\u0003\u0002\u0003BL\u0007o\u0004\rA!'\t\r\u001diE\u0011\tC\u0003+\u0005\u0011\b\"\u0003C\u0005\u001b\u0006\u0005I\u0011\u0001C\u0006\u0003\u0011\u0019w\u000e]=\u0015\u000f1#i\u0001b\u0004\u0005\u0012!A\u0001\rb\u0002\u0011\u0002\u0003\u0007!\r\u0003\u0005i\t\u000f\u0001\n\u00111\u0001)\u0011!iGq\u0001I\u0001\u0002\u0004y\u0007\"\u0003C\u000b\u001bF\u0005I\u0011\u0001C\f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"\u0001\"\u0007+\u0007\t$Yb\u000b\u0002\u0005\u001eA!Aq\u0004C\u0015\u001b\t!\tC\u0003\u0003\u0005$\u0011\u0015\u0012!C;oG\",7m[3e\u0015\r!9CF\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002C\u0016\tC\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%!y#TI\u0001\n\u0003!\t$\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0011M\"f\u0001\u0015\u0005\u001c!IAqG'\u0012\u0002\u0013\u0005A\u0011H\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t!YDK\u0002p\t7A\u0011\u0002b\u0010N\u0003\u0003%\t\u0005\"\u0011\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t!\u0019\u0005\u0005\u0003\u0005F\u0011=SB\u0001C$\u0015\u0011!I\u0005b\u0013\u0002\t1\fgn\u001a\u0006\u0003\t\u001b\nAA[1wC&\u0019q\u000fb\u0012\t\u0013\u0011MS*!A\u0005\u0002\u0011U\u0013\u0001\u00049s_\u0012,8\r^!sSRLXC\u0001C,!\r)B\u0011L\u0005\u0004\t72\"aA%oi\"IAqL'\u0002\u0002\u0013\u0005A\u0011M\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t\t\u0005b\u0019\t\u0015\u0011\u0015DQLA\u0001\u0002\u0004!9&A\u0002yIEB\u0011\u0002\"\u001bN\u0003\u0003%\t\u0005b\u001b\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"\u0001\"\u001c\u0011\r\u0011=DQOA!\u001b\t!\tHC\u0002\u0005tY\t!bY8mY\u0016\u001cG/[8o\u0013\u0011!9\b\"\u001d\u0003\u0011%#XM]1u_JD\u0011\u0002b\u001fN\u0003\u0003%\t\u0001\" \u0002\u0011\r\fg.R9vC2$2a\tC@\u0011)!)\u0007\"\u001f\u0002\u0002\u0003\u0007\u0011\u0011\t\u0005\n\t\u0007k\u0015\u0011!C!\t\u000b\u000ba!Z9vC2\u001cHcA\u0012\u0005\b\"QAQ\rCA\u0003\u0003\u0005\r!!\u0011)\u00175#Y\t\"%\u0005\u0014\u0012]E\u0011\u0014\t\u0004!\u00115\u0015b\u0001CH\u0005\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017E\u0001CK\u00035{f)\u0016(D?\"*\u0007\u0010\u001d:!\u0003N\u0003C/\u001f9fS\u0001j\u0003eQ1tiN\u0004C\u000f[3!m\u0006dW/\u001a\u0011aKb\u0004(\u000f\u0019\u0011u_\u0002\"\b.\u001a\u0011uCJ<W\r\u001e\u0011eCR\f\u0007\u0005^=qK\u0002\u0002G/\u001f9fA:\n\u0001\"\u001a=b[BdWm]\u0011\u0003\t7\u000bqH\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(cA:\u0003%Y:!S:$\u0018f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00112a)\u0001\u0003\u0005C\u0003a\u0013\u0002\u0007!\rC\u0003i\u0013\u0002\u0007\u0001\u0006C\u0004n\u0013B\u0005\t\u0019A8\t\u0013\u0011\u0015\u0016#!A\u0005\u0002\u0012\u001d\u0016aB;oCB\u0004H.\u001f\u000b\u0005\tS#\t\f\u0005\u0003\u0016a\u0012-\u0006CB\u000b\u0005.\nDs.C\u0002\u00050Z\u0011a\u0001V;qY\u0016\u001c\u0004\"\u0003CZ\tG\u000b\t\u00111\u0001M\u0003\rAH\u0005\r\u0005\n\to\u000b\u0012\u0013!C\u0001\ts\tq\"\u00199qYf$C-\u001a4bk2$He\r\u0005\n\tw\u000b\u0012\u0013!C\u0001\ts\t1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001a\u0004\"\u0003C`#\u0005\u0005I\u0011\u0002Ca\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0011\r\u0007\u0003\u0002C#\t\u000bLA\u0001b2\u0005H\t1qJ\u00196fGR\u0004")
public class Cast
extends UnaryExpression
implements TimeZoneAwareExpression,
package.NullIntolerant,
Serializable {
    private final Expression child;
    private final DataType dataType;
    private final Option<String> timeZoneId;
    private boolean resolved;
    private Function1<Object, Object> cast;
    private final transient TimeZone timeZone;
    private volatile byte bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Option<String> $lessinit$greater$default$3() {
        return Cast$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<String> apply$default$3() {
        return Cast$.MODULE$.apply$default$3();
    }

    public static Option<Tuple3<Expression, DataType, Option<String>>> unapply(Cast cast2) {
        return Cast$.MODULE$.unapply(cast2);
    }

    public static boolean forceNullable(DataType dataType2, DataType dataType3) {
        return Cast$.MODULE$.forceNullable(dataType2, dataType3);
    }

    public static boolean mayTruncate(DataType dataType2, DataType dataType3) {
        return Cast$.MODULE$.mayTruncate(dataType2, dataType3);
    }

    public static boolean canCast(DataType dataType2, DataType dataType3) {
        return Cast$.MODULE$.canCast(dataType2, dataType3);
    }

    private boolean resolved$lzycompute() {
        Cast cast2 = this;
        synchronized (cast2) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.resolved = this.childrenResolved() && this.checkInputDataTypes().isSuccess() && (!this.needsTimeZone() || this.timeZoneId().isDefined());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.resolved;
        }
    }

    private Function1 cast$lzycompute() {
        Cast cast2 = this;
        synchronized (cast2) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.cast = this.org$apache$spark$sql$catalyst$expressions$Cast$$cast(this.child().dataType(), this.dataType());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.cast;
        }
    }

    private TimeZone timeZone$lzycompute() {
        Cast cast2 = this;
        synchronized (cast2) {
            if (!this.bitmap$trans$0) {
                this.timeZone = TimeZoneAwareExpression$class.timeZone(this);
                this.bitmap$trans$0 = true;
            }
            return this.timeZone;
        }
    }

    @Override
    public TimeZone timeZone() {
        return this.bitmap$trans$0 ? this.timeZone : this.timeZone$lzycompute();
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public DataType dataType() {
        return this.dataType;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cast(", " as ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.child(), this.dataType().simpleString()}));
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return Cast$.MODULE$.canCast(this.child().dataType(), this.dataType()) ? TypeCheckResult$TypeCheckSuccess$.MODULE$ : new TypeCheckResult.TypeCheckFailure(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cannot cast ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.child().dataType().simpleString(), this.dataType().simpleString()})));
    }

    @Override
    public boolean nullable() {
        return Cast$.MODULE$.forceNullable(this.child().dataType(), this.dataType()) || this.child().nullable();
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$78 = Option$.MODULE$.apply((Object)timeZoneId);
        Expression x$79 = this.copy$default$1();
        DataType x$80 = this.copy$default$2();
        return this.copy(x$79, x$80, (Option<String>)x$78);
    }

    @Override
    public boolean resolved() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.resolved$lzycompute() : this.resolved;
    }

    private boolean needsTimeZone() {
        return Cast$.MODULE$.needsTimeZone(this.child().dataType(), this.dataType());
    }

    public <T> Object org$apache$spark$sql$catalyst$expressions$Cast$$buildCast(Object a, Function1<T, Object> func) {
        return func.apply(a);
    }

    public Function1<Object, Object> org$apache$spark$sql$catalyst$expressions$Cast$$castToString(DataType from) {
        Object object;
        block9: {
            DataType dataType2;
            while (true) {
                if (BinaryType$.MODULE$.equals(dataType2 = from)) {
                    object = new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ Cast $outer;

                        public final Object apply(Object x$1) {
                            return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$buildCast(x$1, new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final UTF8String apply(byte[] x$1) {
                                    return UTF8String.fromBytes((byte[])x$1);
                                }
                            });
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    };
                    break block9;
                }
                if (DateType$.MODULE$.equals(dataType2)) {
                    object = new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ Cast $outer;

                        public final Object apply(Object x$2) {
                            return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$buildCast(x$2, new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final UTF8String apply(int d) {
                                    return UTF8String.fromString((String)DateTimeUtils$.MODULE$.dateToString(d));
                                }
                            });
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    };
                    break block9;
                }
                if (TimestampType$.MODULE$.equals(dataType2)) {
                    object = new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ Cast $outer;

                        public final Object apply(Object x$3) {
                            return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$buildCast(x$3, new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$org$apache$spark$sql$catalyst$expressions$Cast$$castToString$3 $outer;

                                public final UTF8String apply(long t) {
                                    return UTF8String.fromString((String)DateTimeUtils$.MODULE$.timestampToString(t, this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$anonfun$$$outer().timeZone()));
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                        }

                        public /* synthetic */ Cast org$apache$spark$sql$catalyst$expressions$Cast$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    };
                    break block9;
                }
                if (dataType2 instanceof ArrayType) {
                    ArrayType arrayType2 = (ArrayType)dataType2;
                    DataType et = arrayType2.elementType();
                    object = new Serializable(this, et){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ Cast $outer;
                        public final DataType et$1;

                        public final Object apply(Object x$4) {
                            return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$buildCast(x$4, new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$org$apache$spark$sql$catalyst$expressions$Cast$$castToString$4 $outer;

                                public final UTF8String apply(ArrayData array) {
                                    UTF8StringBuilder builder = new UTF8StringBuilder();
                                    builder.append("[");
                                    if (array.numElements() > 0) {
                                        Function1<Object, Object> toUTF8String = this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$anonfun$$$outer().org$apache$spark$sql$catalyst$expressions$Cast$$castToString(this.$outer.et$1);
                                        if (!array.isNullAt(0)) {
                                            builder.append((UTF8String)toUTF8String.apply(array.get(0, this.$outer.et$1)));
                                        }
                                        for (int i = 1; i < array.numElements(); ++i) {
                                            builder.append(",");
                                            if (array.isNullAt(i)) continue;
                                            builder.append(" ");
                                            builder.append((UTF8String)toUTF8String.apply(array.get(i, this.$outer.et$1)));
                                        }
                                    }
                                    builder.append("]");
                                    return builder.build();
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                        }

                        public /* synthetic */ Cast org$apache$spark$sql$catalyst$expressions$Cast$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.et$1 = et$1;
                        }
                    };
                    break block9;
                }
                if (dataType2 instanceof MapType) {
                    MapType mapType2 = (MapType)dataType2;
                    DataType kt = mapType2.keyType();
                    DataType vt = mapType2.valueType();
                    object = new Serializable(this, kt, vt){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ Cast $outer;
                        public final DataType kt$1;
                        public final DataType vt$1;

                        public final Object apply(Object x$5) {
                            return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$buildCast(x$5, new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$org$apache$spark$sql$catalyst$expressions$Cast$$castToString$5 $outer;

                                public final UTF8String apply(MapData map2) {
                                    UTF8StringBuilder builder = new UTF8StringBuilder();
                                    builder.append("[");
                                    if (map2.numElements() > 0) {
                                        ArrayData keyArray = map2.keyArray();
                                        ArrayData valueArray = map2.valueArray();
                                        Function1<Object, Object> keyToUTF8String = this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$anonfun$$$outer().org$apache$spark$sql$catalyst$expressions$Cast$$castToString(this.$outer.kt$1);
                                        Function1<Object, Object> valueToUTF8String = this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$anonfun$$$outer().org$apache$spark$sql$catalyst$expressions$Cast$$castToString(this.$outer.vt$1);
                                        builder.append((UTF8String)keyToUTF8String.apply(keyArray.get(0, this.$outer.kt$1)));
                                        builder.append(" ->");
                                        if (!valueArray.isNullAt(0)) {
                                            builder.append(" ");
                                            builder.append((UTF8String)valueToUTF8String.apply(valueArray.get(0, this.$outer.vt$1)));
                                        }
                                        for (int i = 1; i < map2.numElements(); ++i) {
                                            builder.append(", ");
                                            builder.append((UTF8String)keyToUTF8String.apply(keyArray.get(i, this.$outer.kt$1)));
                                            builder.append(" ->");
                                            if (valueArray.isNullAt(i)) continue;
                                            builder.append(" ");
                                            builder.append((UTF8String)valueToUTF8String.apply(valueArray.get(i, this.$outer.vt$1)));
                                        }
                                    }
                                    builder.append("]");
                                    return builder.build();
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                        }

                        public /* synthetic */ Cast org$apache$spark$sql$catalyst$expressions$Cast$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.kt$1 = kt$1;
                            this.vt$1 = vt$1;
                        }
                    };
                    break block9;
                }
                if (dataType2 instanceof StructType) {
                    StructType structType2 = (StructType)dataType2;
                    StructField[] fields = structType2.fields();
                    object = new Serializable(this, fields){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ Cast $outer;
                        public final StructField[] fields$1;

                        public final Object apply(Object x$6) {
                            return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$buildCast(x$6, new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$org$apache$spark$sql$catalyst$expressions$Cast$$castToString$6 $outer;

                                public final UTF8String apply(InternalRow row) {
                                    UTF8StringBuilder builder = new UTF8StringBuilder();
                                    builder.append("[");
                                    if (row.numFields() > 0) {
                                        DataType[] st = (DataType[])Predef$.MODULE$.refArrayOps((Object[])this.$outer.fields$1).map((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final DataType apply(StructField x$7) {
                                                return x$7.dataType();
                                            }
                                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DataType.class)));
                                        Function1[] toUTF8StringFuncs = (Function1[])Predef$.MODULE$.refArrayOps((Object[])st).map((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ $anonfun$org$apache$spark$sql$catalyst$expressions$Cast$$castToString$6$$anonfun$apply$19 $outer;

                                            public final Function1<Object, Object> apply(DataType from) {
                                                return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$anonfun$$anonfun$$$outer().org$apache$spark$sql$catalyst$expressions$Cast$$anonfun$$$outer().org$apache$spark$sql$catalyst$expressions$Cast$$castToString(from);
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                            }
                                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Function1.class)));
                                        if (!row.isNullAt(0)) {
                                            builder.append((UTF8String)toUTF8StringFuncs[0].apply(row.get(0, st[0])));
                                        }
                                        for (int i = 1; i < row.numFields(); ++i) {
                                            builder.append(",");
                                            if (row.isNullAt(i)) continue;
                                            builder.append(" ");
                                            builder.append((UTF8String)toUTF8StringFuncs[i].apply(row.get(i, st[i])));
                                        }
                                    }
                                    builder.append("]");
                                    return builder.build();
                                }

                                public /* synthetic */ $anonfun$org$apache$spark$sql$catalyst$expressions$Cast$$castToString$6 org$apache$spark$sql$catalyst$expressions$Cast$$anonfun$$anonfun$$$outer() {
                                    return this.$outer;
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                        }

                        public /* synthetic */ Cast org$apache$spark$sql$catalyst$expressions$Cast$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.fields$1 = fields$1;
                        }
                    };
                    break block9;
                }
                if (!(dataType2 instanceof PythonUserDefinedType)) break;
                PythonUserDefinedType pythonUserDefinedType = (PythonUserDefinedType)dataType2;
                from = pythonUserDefinedType.sqlType();
            }
            if (dataType2 instanceof UserDefinedType) {
                UserDefinedType userDefinedType = (UserDefinedType)dataType2;
                object = new Serializable(this, userDefinedType){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Cast $outer;
                    public final UserDefinedType x11$1;

                    public final Object apply(Object x$8) {
                        return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$buildCast(x$8, new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$org$apache$spark$sql$catalyst$expressions$Cast$$castToString$7 $outer;

                            public final UTF8String apply(Object o) {
                                return UTF8String.fromString((String)this.$outer.x11$1.deserialize(o).toString());
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.x11$1 = x11$1;
                    }
                };
            } else {
                object = new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Cast $outer;

                    public final Object apply(Object x$9) {
                        return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$buildCast(x$9, new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final UTF8String apply(Object o) {
                                return UTF8String.fromString((String)o.toString());
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                };
            }
        }
        return object;
    }

    private Function1<Object, Object> castToBinary(DataType from) {
        DataType dataType2 = from;
        if (StringType$.MODULE$.equals(dataType2)) {
            Serializable serializable = new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Cast $outer;

                public final Object apply(Object x$10) {
                    return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$buildCast(x$10, new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final byte[] apply(UTF8String x$11) {
                            return x$11.getBytes();
                        }
                    });
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            };
            return serializable;
        }
        throw new MatchError((Object)dataType2);
    }

    private Function1<Object, Object> castToBoolean(DataType from) {
        DataType dataType2;
        block12: {
            Object object;
            block3: {
                block11: {
                    block10: {
                        block9: {
                            block8: {
                                block7: {
                                    block6: {
                                        block5: {
                                            block4: {
                                                block2: {
                                                    dataType2 = from;
                                                    if (!StringType$.MODULE$.equals(dataType2)) break block2;
                                                    object = new Serializable(this){
                                                        public static final long serialVersionUID = 0L;
                                                        private final /* synthetic */ Cast $outer;

                                                        public final Object apply(Object x$12) {
                                                            return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$buildCast(x$12, new Serializable(this){
                                                                public static final long serialVersionUID = 0L;

                                                                public final Object apply(UTF8String s) {
                                                                    return StringUtils$.MODULE$.isTrueString(s) ? BoxesRunTime.boxToBoolean((boolean)true) : (StringUtils$.MODULE$.isFalseString(s) ? BoxesRunTime.boxToBoolean((boolean)false) : null);
                                                                }
                                                            });
                                                        }
                                                        {
                                                            if ($outer == null) {
                                                                throw null;
                                                            }
                                                            this.$outer = $outer;
                                                        }
                                                    };
                                                    break block3;
                                                }
                                                if (!TimestampType$.MODULE$.equals(dataType2)) break block4;
                                                object = new Serializable(this){
                                                    public static final long serialVersionUID = 0L;
                                                    private final /* synthetic */ Cast $outer;

                                                    public final Object apply(Object x$13) {
                                                        return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$buildCast(x$13, new Serializable(this){
                                                            public static final long serialVersionUID = 0L;

                                                            public final boolean apply(long t) {
                                                                return this.apply$mcZJ$sp(t);
                                                            }

                                                            public boolean apply$mcZJ$sp(long t) {
                                                                return t != 0L;
                                                            }
                                                        });
                                                    }
                                                    {
                                                        if ($outer == null) {
                                                            throw null;
                                                        }
                                                        this.$outer = $outer;
                                                    }
                                                };
                                                break block3;
                                            }
                                            if (!DateType$.MODULE$.equals(dataType2)) break block5;
                                            object = new Serializable(this){
                                                public static final long serialVersionUID = 0L;
                                                private final /* synthetic */ Cast $outer;

                                                public final Object apply(Object x$14) {
                                                    return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$buildCast(x$14, new Serializable(this){
                                                        public static final long serialVersionUID = 0L;

                                                        public final Null$ apply(int d) {
                                                            return null;
                                                        }
                                                    });
                                                }
                                                {
                                                    if ($outer == null) {
                                                        throw null;
                                                    }
                                                    this.$outer = $outer;
                                                }
                                            };
                                            break block3;
                                        }
                                        if (!LongType$.MODULE$.equals(dataType2)) break block6;
                                        object = new Serializable(this){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ Cast $outer;

                                            public final Object apply(Object x$15) {
                                                return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$buildCast(x$15, new Serializable(this){
                                                    public static final long serialVersionUID = 0L;

                                                    public final boolean apply(long x$16) {
                                                        return this.apply$mcZJ$sp(x$16);
                                                    }

                                                    public boolean apply$mcZJ$sp(long x$16) {
                                                        return x$16 != 0L;
                                                    }
                                                });
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                            }
                                        };
                                        break block3;
                                    }
                                    if (!IntegerType$.MODULE$.equals(dataType2)) break block7;
                                    object = new Serializable(this){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ Cast $outer;

                                        public final Object apply(Object x$17) {
                                            return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$buildCast(x$17, new Serializable(this){
                                                public static final long serialVersionUID = 0L;

                                                public final boolean apply(int x$18) {
                                                    return this.apply$mcZI$sp(x$18);
                                                }

                                                public boolean apply$mcZI$sp(int x$18) {
                                                    return x$18 != 0;
                                                }
                                            });
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                        }
                                    };
                                    break block3;
                                }
                                if (!ShortType$.MODULE$.equals(dataType2)) break block8;
                                object = new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ Cast $outer;

                                    public final Object apply(Object x$19) {
                                        return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$buildCast(x$19, new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final boolean apply(short x$20) {
                                                return x$20 != 0;
                                            }
                                        });
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }
                                };
                                break block3;
                            }
                            if (!ByteType$.MODULE$.equals(dataType2)) break block9;
                            object = new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ Cast $outer;

                                public final Object apply(Object x$21) {
                                    return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$buildCast(x$21, new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final boolean apply(byte x$22) {
                                            return x$22 != 0;
                                        }
                                    });
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            };
                            break block3;
                        }
                        if (!DecimalType$.MODULE$.unapply(dataType2)) break block10;
                        object = new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ Cast $outer;

                            public final Object apply(Object x$23) {
                                return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$buildCast(x$23, new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final boolean apply(Decimal x$24) {
                                        return !x$24.isZero();
                                    }
                                });
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        };
                        break block3;
                    }
                    if (!DoubleType$.MODULE$.equals(dataType2)) break block11;
                    object = new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ Cast $outer;

                        public final Object apply(Object x$25) {
                            return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$buildCast(x$25, new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final boolean apply(double x$26) {
                                    return this.apply$mcZD$sp(x$26);
                                }

                                public boolean apply$mcZD$sp(double x$26) {
                                    return x$26 != 0.0;
                                }
                            });
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    };
                    break block3;
                }
                if (!FloatType$.MODULE$.equals(dataType2)) break block12;
                object = new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Cast $outer;

                    public final Object apply(Object x$27) {
                        return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$buildCast(x$27, new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(float x$28) {
                                return this.apply$mcZF$sp(x$28);
                            }

                            public boolean apply$mcZF$sp(float x$28) {
                                return x$28 != 0.0f;
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                };
            }
            return object;
        }
        throw new MatchError((Object)dataType2);
    }

    private Function1<Object, Object> castToTimestamp(DataType from) {
        DataType dataType2;
        block12: {
            Object object;
            block3: {
                block11: {
                    block10: {
                        block9: {
                            block8: {
                                block7: {
                                    block6: {
                                        block5: {
                                            block4: {
                                                block2: {
                                                    dataType2 = from;
                                                    if (!StringType$.MODULE$.equals(dataType2)) break block2;
                                                    object = new Serializable(this){
                                                        public static final long serialVersionUID = 0L;
                                                        private final /* synthetic */ Cast $outer;

                                                        public final Object apply(Object x$29) {
                                                            return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$buildCast(x$29, new Serializable(this){
                                                                public static final long serialVersionUID = 0L;
                                                                private final /* synthetic */ $anonfun$castToTimestamp$1 $outer;

                                                                public final Object apply(UTF8String utfs) {
                                                                    return DateTimeUtils$.MODULE$.stringToTimestamp(utfs, this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$anonfun$$$outer().timeZone()).orNull(Predef$.MODULE$.$conforms());
                                                                }
                                                                {
                                                                    if ($outer == null) {
                                                                        throw null;
                                                                    }
                                                                    this.$outer = $outer;
                                                                }
                                                            });
                                                        }

                                                        public /* synthetic */ Cast org$apache$spark$sql$catalyst$expressions$Cast$$anonfun$$$outer() {
                                                            return this.$outer;
                                                        }
                                                        {
                                                            if ($outer == null) {
                                                                throw null;
                                                            }
                                                            this.$outer = $outer;
                                                        }
                                                    };
                                                    break block3;
                                                }
                                                if (!BooleanType$.MODULE$.equals(dataType2)) break block4;
                                                object = new Serializable(this){
                                                    public static final long serialVersionUID = 0L;
                                                    private final /* synthetic */ Cast $outer;

                                                    public final Object apply(Object x$30) {
                                                        return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$buildCast(x$30, new Serializable(this){
                                                            public static final long serialVersionUID = 0L;

                                                            public final Object apply(boolean b) {
                                                                return b ? (Number)BoxesRunTime.boxToLong((long)1L) : (Number)BoxesRunTime.boxToInteger((int)0);
                                                            }
                                                        });
                                                    }
                                                    {
                                                        if ($outer == null) {
                                                            throw null;
                                                        }
                                                        this.$outer = $outer;
                                                    }
                                                };
                                                break block3;
                                            }
                                            if (!LongType$.MODULE$.equals(dataType2)) break block5;
                                            object = new Serializable(this){
                                                public static final long serialVersionUID = 0L;
                                                private final /* synthetic */ Cast $outer;

                                                public final Object apply(Object x$31) {
                                                    return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$buildCast(x$31, new Serializable(this){
                                                        public static final long serialVersionUID = 0L;
                                                        private final /* synthetic */ $anonfun$castToTimestamp$3 $outer;

                                                        public final long apply(long l) {
                                                            return this.apply$mcJJ$sp(l);
                                                        }

                                                        public long apply$mcJJ$sp(long l) {
                                                            return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$anonfun$$$outer().org$apache$spark$sql$catalyst$expressions$Cast$$longToTimestamp(l);
                                                        }
                                                        {
                                                            if ($outer == null) {
                                                                throw null;
                                                            }
                                                            this.$outer = $outer;
                                                        }
                                                    });
                                                }

                                                public /* synthetic */ Cast org$apache$spark$sql$catalyst$expressions$Cast$$anonfun$$$outer() {
                                                    return this.$outer;
                                                }
                                                {
                                                    if ($outer == null) {
                                                        throw null;
                                                    }
                                                    this.$outer = $outer;
                                                }
                                            };
                                            break block3;
                                        }
                                        if (!IntegerType$.MODULE$.equals(dataType2)) break block6;
                                        object = new Serializable(this){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ Cast $outer;

                                            public final Object apply(Object x$32) {
                                                return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$buildCast(x$32, new Serializable(this){
                                                    public static final long serialVersionUID = 0L;
                                                    private final /* synthetic */ $anonfun$castToTimestamp$4 $outer;

                                                    public final long apply(int i) {
                                                        return this.apply$mcJI$sp(i);
                                                    }

                                                    public long apply$mcJI$sp(int i) {
                                                        return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$anonfun$$$outer().org$apache$spark$sql$catalyst$expressions$Cast$$longToTimestamp(i);
                                                    }
                                                    {
                                                        if ($outer == null) {
                                                            throw null;
                                                        }
                                                        this.$outer = $outer;
                                                    }
                                                });
                                            }

                                            public /* synthetic */ Cast org$apache$spark$sql$catalyst$expressions$Cast$$anonfun$$$outer() {
                                                return this.$outer;
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                            }
                                        };
                                        break block3;
                                    }
                                    if (!ShortType$.MODULE$.equals(dataType2)) break block7;
                                    object = new Serializable(this){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ Cast $outer;

                                        public final Object apply(Object x$33) {
                                            return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$buildCast(x$33, new Serializable(this){
                                                public static final long serialVersionUID = 0L;
                                                private final /* synthetic */ $anonfun$castToTimestamp$5 $outer;

                                                public final long apply(short s) {
                                                    return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$anonfun$$$outer().org$apache$spark$sql$catalyst$expressions$Cast$$longToTimestamp(s);
                                                }
                                                {
                                                    if ($outer == null) {
                                                        throw null;
                                                    }
                                                    this.$outer = $outer;
                                                }
                                            });
                                        }

                                        public /* synthetic */ Cast org$apache$spark$sql$catalyst$expressions$Cast$$anonfun$$$outer() {
                                            return this.$outer;
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                        }
                                    };
                                    break block3;
                                }
                                if (!ByteType$.MODULE$.equals(dataType2)) break block8;
                                object = new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ Cast $outer;

                                    public final Object apply(Object x$34) {
                                        return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$buildCast(x$34, new Serializable(this){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ $anonfun$castToTimestamp$6 $outer;

                                            public final long apply(byte b) {
                                                return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$anonfun$$$outer().org$apache$spark$sql$catalyst$expressions$Cast$$longToTimestamp(b);
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                            }
                                        });
                                    }

                                    public /* synthetic */ Cast org$apache$spark$sql$catalyst$expressions$Cast$$anonfun$$$outer() {
                                        return this.$outer;
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }
                                };
                                break block3;
                            }
                            if (!DateType$.MODULE$.equals(dataType2)) break block9;
                            object = new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ Cast $outer;

                                public final Object apply(Object x$35) {
                                    return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$buildCast(x$35, new Serializable(this){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ $anonfun$castToTimestamp$7 $outer;

                                        public final long apply(int d) {
                                            return this.apply$mcJI$sp(d);
                                        }

                                        public long apply$mcJI$sp(int d) {
                                            return DateTimeUtils$.MODULE$.daysToMillis(d, this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$anonfun$$$outer().timeZone()) * 1000L;
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                        }
                                    });
                                }

                                public /* synthetic */ Cast org$apache$spark$sql$catalyst$expressions$Cast$$anonfun$$$outer() {
                                    return this.$outer;
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            };
                            break block3;
                        }
                        if (!DecimalType$.MODULE$.unapply(dataType2)) break block10;
                        object = new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ Cast $outer;

                            public final Object apply(Object x$36) {
                                return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$buildCast(x$36, new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$castToTimestamp$8 $outer;

                                    public final long apply(Decimal d) {
                                        return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$anonfun$$$outer().org$apache$spark$sql$catalyst$expressions$Cast$$decimalToTimestamp(d);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }
                                });
                            }

                            public /* synthetic */ Cast org$apache$spark$sql$catalyst$expressions$Cast$$anonfun$$$outer() {
                                return this.$outer;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        };
                        break block3;
                    }
                    if (!DoubleType$.MODULE$.equals(dataType2)) break block11;
                    object = new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ Cast $outer;

                        public final Object apply(Object x$37) {
                            return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$buildCast(x$37, new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$castToTimestamp$9 $outer;

                                public final Object apply(double d) {
                                    return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$anonfun$$$outer().org$apache$spark$sql$catalyst$expressions$Cast$$doubleToTimestamp(d);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                        }

                        public /* synthetic */ Cast org$apache$spark$sql$catalyst$expressions$Cast$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    };
                    break block3;
                }
                if (!FloatType$.MODULE$.equals(dataType2)) break block12;
                object = new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Cast $outer;

                    public final Object apply(Object x$38) {
                        return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$buildCast(x$38, new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$castToTimestamp$10 $outer;

                            public final Object apply(float f) {
                                return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$anonfun$$$outer().org$apache$spark$sql$catalyst$expressions$Cast$$doubleToTimestamp(f);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                    }

                    public /* synthetic */ Cast org$apache$spark$sql$catalyst$expressions$Cast$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                };
            }
            return object;
        }
        throw new MatchError((Object)dataType2);
    }

    public long org$apache$spark$sql$catalyst$expressions$Cast$$decimalToTimestamp(Decimal d) {
        return d.toBigDecimal().$times(BigDecimal$.MODULE$.long2bigDecimal(1000000L)).longValue();
    }

    public Object org$apache$spark$sql$catalyst$expressions$Cast$$doubleToTimestamp(double d) {
        return Predef$.MODULE$.double2Double(d).isNaN() || Predef$.MODULE$.double2Double(d).isInfinite() ? null : BoxesRunTime.boxToLong((long)((long)(d * (double)1000000L)));
    }

    public long org$apache$spark$sql$catalyst$expressions$Cast$$longToTimestamp(long t) {
        return t * 1000000L;
    }

    public long org$apache$spark$sql$catalyst$expressions$Cast$$timestampToLong(long ts) {
        return (long)package$.MODULE$.floor((double)ts / (double)1000000L);
    }

    public double org$apache$spark$sql$catalyst$expressions$Cast$$timestampToDouble(long ts) {
        return (double)ts / 1000000.0;
    }

    private Function1<Object, Object> castToDate(DataType from) {
        DataType dataType2;
        block4: {
            Object object;
            block3: {
                block2: {
                    dataType2 = from;
                    if (!StringType$.MODULE$.equals(dataType2)) break block2;
                    object = new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ Cast $outer;

                        public final Object apply(Object x$39) {
                            return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$buildCast(x$39, new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final Object apply(UTF8String s) {
                                    return DateTimeUtils$.MODULE$.stringToDate(s).orNull(Predef$.MODULE$.$conforms());
                                }
                            });
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    };
                    break block3;
                }
                if (!TimestampType$.MODULE$.equals(dataType2)) break block4;
                object = new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Cast $outer;

                    public final Object apply(Object x$40) {
                        return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$buildCast(x$40, new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$castToDate$2 $outer;

                            public final int apply(long t) {
                                return this.apply$mcIJ$sp(t);
                            }

                            public int apply$mcIJ$sp(long t) {
                                return DateTimeUtils$.MODULE$.millisToDays(t / 1000L, this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$anonfun$$$outer().timeZone());
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                    }

                    public /* synthetic */ Cast org$apache$spark$sql$catalyst$expressions$Cast$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                };
            }
            return object;
        }
        throw new MatchError((Object)dataType2);
    }

    private Function1<Object, Object> castToInterval(DataType from) {
        DataType dataType2 = from;
        if (StringType$.MODULE$.equals(dataType2)) {
            Serializable serializable = new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Cast $outer;

                public final Object apply(Object x$41) {
                    return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$buildCast(x$41, new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final CalendarInterval apply(UTF8String s) {
                            return CalendarInterval.fromString((String)s.toString());
                        }
                    });
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            };
            return serializable;
        }
        throw new MatchError((Object)dataType2);
    }

    private Function1<Object, Object> castToLong(DataType from) {
        DataType dataType2;
        block7: {
            Object object;
            block3: {
                block6: {
                    block5: {
                        block4: {
                            block2: {
                                dataType2 = from;
                                if (!StringType$.MODULE$.equals(dataType2)) break block2;
                                UTF8String.LongWrapper result = new UTF8String.LongWrapper();
                                object = new Serializable(this, result){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ Cast $outer;
                                    public final UTF8String.LongWrapper result$1;

                                    public final Object apply(Object x$42) {
                                        return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$buildCast(x$42, new Serializable(this){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ $anonfun$castToLong$1 $outer;

                                            public final Object apply(UTF8String s) {
                                                return s.toLong(this.$outer.result$1) ? BoxesRunTime.boxToLong((long)this.$outer.result$1.value) : null;
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                            }
                                        });
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.result$1 = result$1;
                                    }
                                };
                                break block3;
                            }
                            if (!BooleanType$.MODULE$.equals(dataType2)) break block4;
                            object = new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ Cast $outer;

                                public final Object apply(Object x$43) {
                                    return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$buildCast(x$43, new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final Object apply(boolean b) {
                                            return b ? BoxesRunTime.boxToLong((long)1L) : BoxesRunTime.boxToLong((long)0L);
                                        }
                                    });
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            };
                            break block3;
                        }
                        if (!DateType$.MODULE$.equals(dataType2)) break block5;
                        object = new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ Cast $outer;

                            public final Object apply(Object x$44) {
                                return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$buildCast(x$44, new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final Null$ apply(int d) {
                                        return null;
                                    }
                                });
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        };
                        break block3;
                    }
                    if (!TimestampType$.MODULE$.equals(dataType2)) break block6;
                    object = new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ Cast $outer;

                        public final Object apply(Object x$45) {
                            return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$buildCast(x$45, new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$castToLong$4 $outer;

                                public final long apply(long t) {
                                    return this.apply$mcJJ$sp(t);
                                }

                                public long apply$mcJJ$sp(long t) {
                                    return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$anonfun$$$outer().org$apache$spark$sql$catalyst$expressions$Cast$$timestampToLong(t);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                        }

                        public /* synthetic */ Cast org$apache$spark$sql$catalyst$expressions$Cast$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    };
                    break block3;
                }
                if (!(dataType2 instanceof NumericType)) break block7;
                NumericType numericType = (NumericType)dataType2;
                object = new Serializable(this, numericType){
                    public static final long serialVersionUID = 0L;
                    private final NumericType x6$1;

                    public final long apply(Object b) {
                        return this.x6$1.numeric().toLong(b);
                    }
                    {
                        this.x6$1 = x6$1;
                    }
                };
            }
            return object;
        }
        throw new MatchError((Object)dataType2);
    }

    private Function1<Object, Object> castToInt(DataType from) {
        DataType dataType2;
        block7: {
            Object object;
            block3: {
                block6: {
                    block5: {
                        block4: {
                            block2: {
                                dataType2 = from;
                                if (!StringType$.MODULE$.equals(dataType2)) break block2;
                                UTF8String.IntWrapper result = new UTF8String.IntWrapper();
                                object = new Serializable(this, result){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ Cast $outer;
                                    public final UTF8String.IntWrapper result$2;

                                    public final Object apply(Object x$46) {
                                        return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$buildCast(x$46, new Serializable(this){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ $anonfun$castToInt$1 $outer;

                                            public final Object apply(UTF8String s) {
                                                return s.toInt(this.$outer.result$2) ? BoxesRunTime.boxToInteger((int)this.$outer.result$2.value) : null;
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                            }
                                        });
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.result$2 = result$2;
                                    }
                                };
                                break block3;
                            }
                            if (!BooleanType$.MODULE$.equals(dataType2)) break block4;
                            object = new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ Cast $outer;

                                public final Object apply(Object x$47) {
                                    return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$buildCast(x$47, new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final Object apply(boolean b) {
                                            return b ? BoxesRunTime.boxToInteger((int)1) : BoxesRunTime.boxToInteger((int)0);
                                        }
                                    });
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            };
                            break block3;
                        }
                        if (!DateType$.MODULE$.equals(dataType2)) break block5;
                        object = new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ Cast $outer;

                            public final Object apply(Object x$48) {
                                return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$buildCast(x$48, new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final Null$ apply(int d) {
                                        return null;
                                    }
                                });
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        };
                        break block3;
                    }
                    if (!TimestampType$.MODULE$.equals(dataType2)) break block6;
                    object = new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ Cast $outer;

                        public final Object apply(Object x$49) {
                            return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$buildCast(x$49, new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$castToInt$4 $outer;

                                public final int apply(long t) {
                                    return this.apply$mcIJ$sp(t);
                                }

                                public int apply$mcIJ$sp(long t) {
                                    return (int)this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$anonfun$$$outer().org$apache$spark$sql$catalyst$expressions$Cast$$timestampToLong(t);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                        }

                        public /* synthetic */ Cast org$apache$spark$sql$catalyst$expressions$Cast$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    };
                    break block3;
                }
                if (!(dataType2 instanceof NumericType)) break block7;
                NumericType numericType = (NumericType)dataType2;
                object = new Serializable(this, numericType){
                    public static final long serialVersionUID = 0L;
                    private final NumericType x6$2;

                    public final int apply(Object b) {
                        return this.x6$2.numeric().toInt(b);
                    }
                    {
                        this.x6$2 = x6$2;
                    }
                };
            }
            return object;
        }
        throw new MatchError((Object)dataType2);
    }

    private Function1<Object, Object> castToShort(DataType from) {
        DataType dataType2;
        block7: {
            Object object;
            block3: {
                block6: {
                    block5: {
                        block4: {
                            block2: {
                                dataType2 = from;
                                if (!StringType$.MODULE$.equals(dataType2)) break block2;
                                UTF8String.IntWrapper result = new UTF8String.IntWrapper();
                                object = new Serializable(this, result){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ Cast $outer;
                                    public final UTF8String.IntWrapper result$3;

                                    public final Object apply(Object x$50) {
                                        return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$buildCast(x$50, new Serializable(this){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ $anonfun$castToShort$1 $outer;

                                            public final Object apply(UTF8String s) {
                                                return s.toShort(this.$outer.result$3) ? BoxesRunTime.boxToShort((short)((short)this.$outer.result$3.value)) : null;
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                            }
                                        });
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.result$3 = result$3;
                                    }
                                };
                                break block3;
                            }
                            if (!BooleanType$.MODULE$.equals(dataType2)) break block4;
                            object = new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ Cast $outer;

                                public final Object apply(Object x$51) {
                                    return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$buildCast(x$51, new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final Object apply(boolean b) {
                                            return b ? BoxesRunTime.boxToShort((short)((short)1)) : BoxesRunTime.boxToShort((short)((short)0));
                                        }
                                    });
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            };
                            break block3;
                        }
                        if (!DateType$.MODULE$.equals(dataType2)) break block5;
                        object = new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ Cast $outer;

                            public final Object apply(Object x$52) {
                                return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$buildCast(x$52, new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final Null$ apply(int d) {
                                        return null;
                                    }
                                });
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        };
                        break block3;
                    }
                    if (!TimestampType$.MODULE$.equals(dataType2)) break block6;
                    object = new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ Cast $outer;

                        public final Object apply(Object x$53) {
                            return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$buildCast(x$53, new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$castToShort$4 $outer;

                                public final short apply(long t) {
                                    return (short)this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$anonfun$$$outer().org$apache$spark$sql$catalyst$expressions$Cast$$timestampToLong(t);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                        }

                        public /* synthetic */ Cast org$apache$spark$sql$catalyst$expressions$Cast$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    };
                    break block3;
                }
                if (!(dataType2 instanceof NumericType)) break block7;
                NumericType numericType = (NumericType)dataType2;
                object = new Serializable(this, numericType){
                    public static final long serialVersionUID = 0L;
                    private final NumericType x6$3;

                    public final short apply(Object b) {
                        return (short)this.x6$3.numeric().toInt(b);
                    }
                    {
                        this.x6$3 = x6$3;
                    }
                };
            }
            return object;
        }
        throw new MatchError((Object)dataType2);
    }

    private Function1<Object, Object> castToByte(DataType from) {
        DataType dataType2;
        block7: {
            Object object;
            block3: {
                block6: {
                    block5: {
                        block4: {
                            block2: {
                                dataType2 = from;
                                if (!StringType$.MODULE$.equals(dataType2)) break block2;
                                UTF8String.IntWrapper result = new UTF8String.IntWrapper();
                                object = new Serializable(this, result){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ Cast $outer;
                                    public final UTF8String.IntWrapper result$4;

                                    public final Object apply(Object x$54) {
                                        return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$buildCast(x$54, new Serializable(this){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ $anonfun$castToByte$1 $outer;

                                            public final Object apply(UTF8String s) {
                                                return s.toByte(this.$outer.result$4) ? BoxesRunTime.boxToByte((byte)((byte)this.$outer.result$4.value)) : null;
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                            }
                                        });
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.result$4 = result$4;
                                    }
                                };
                                break block3;
                            }
                            if (!BooleanType$.MODULE$.equals(dataType2)) break block4;
                            object = new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ Cast $outer;

                                public final Object apply(Object x$55) {
                                    return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$buildCast(x$55, new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final Object apply(boolean b) {
                                            return b ? BoxesRunTime.boxToByte((byte)((byte)1)) : BoxesRunTime.boxToByte((byte)((byte)0));
                                        }
                                    });
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            };
                            break block3;
                        }
                        if (!DateType$.MODULE$.equals(dataType2)) break block5;
                        object = new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ Cast $outer;

                            public final Object apply(Object x$56) {
                                return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$buildCast(x$56, new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final Null$ apply(int d) {
                                        return null;
                                    }
                                });
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        };
                        break block3;
                    }
                    if (!TimestampType$.MODULE$.equals(dataType2)) break block6;
                    object = new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ Cast $outer;

                        public final Object apply(Object x$57) {
                            return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$buildCast(x$57, new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$castToByte$4 $outer;

                                public final byte apply(long t) {
                                    return (byte)this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$anonfun$$$outer().org$apache$spark$sql$catalyst$expressions$Cast$$timestampToLong(t);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                        }

                        public /* synthetic */ Cast org$apache$spark$sql$catalyst$expressions$Cast$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    };
                    break block3;
                }
                if (!(dataType2 instanceof NumericType)) break block7;
                NumericType numericType = (NumericType)dataType2;
                object = new Serializable(this, numericType){
                    public static final long serialVersionUID = 0L;
                    private final NumericType x6$4;

                    public final byte apply(Object b) {
                        return (byte)this.x6$4.numeric().toInt(b);
                    }
                    {
                        this.x6$4 = x6$4;
                    }
                };
            }
            return object;
        }
        throw new MatchError((Object)dataType2);
    }

    public Decimal org$apache$spark$sql$catalyst$expressions$Cast$$changePrecision(Decimal value2, DecimalType decimalType) {
        return value2.changePrecision(decimalType.precision(), decimalType.scale()) ? value2 : null;
    }

    public Decimal org$apache$spark$sql$catalyst$expressions$Cast$$toPrecision(Decimal value2, DecimalType decimalType) {
        return value2.toPrecision(decimalType.precision(), decimalType.scale(), value2.toPrecision$default$3());
    }

    private Function1<Object, Object> castToDecimal(DataType from, DecimalType target) {
        DataType dataType2;
        block9: {
            Object object;
            block3: {
                block8: {
                    block7: {
                        block6: {
                            block5: {
                                block4: {
                                    block2: {
                                        dataType2 = from;
                                        if (!StringType$.MODULE$.equals(dataType2)) break block2;
                                        object = new Serializable(this, target){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ Cast $outer;
                                            public final DecimalType target$1;

                                            public final Object apply(Object x$58) {
                                                return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$buildCast(x$58, new Serializable(this){
                                                    public static final long serialVersionUID = 0L;
                                                    private final /* synthetic */ $anonfun$castToDecimal$1 $outer;

                                                    public final Object apply(UTF8String s) {
                                                        Decimal decimal;
                                                        try {
                                                            decimal = this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$anonfun$$$outer().org$apache$spark$sql$catalyst$expressions$Cast$$changePrecision(Decimal$.MODULE$.apply(new BigDecimal(s.toString())), this.$outer.target$1);
                                                        }
                                                        catch (NumberFormatException numberFormatException) {
                                                            decimal = null;
                                                        }
                                                        return decimal;
                                                    }
                                                    {
                                                        if ($outer == null) {
                                                            throw null;
                                                        }
                                                        this.$outer = $outer;
                                                    }
                                                });
                                            }

                                            public /* synthetic */ Cast org$apache$spark$sql$catalyst$expressions$Cast$$anonfun$$$outer() {
                                                return this.$outer;
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                                this.target$1 = target$1;
                                            }
                                        };
                                        break block3;
                                    }
                                    if (!BooleanType$.MODULE$.equals(dataType2)) break block4;
                                    object = new Serializable(this, target){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ Cast $outer;
                                        public final DecimalType target$1;

                                        public final Object apply(Object x$59) {
                                            return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$buildCast(x$59, new Serializable(this){
                                                public static final long serialVersionUID = 0L;
                                                private final /* synthetic */ $anonfun$castToDecimal$2 $outer;

                                                public final Decimal apply(boolean b) {
                                                    return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$anonfun$$$outer().org$apache$spark$sql$catalyst$expressions$Cast$$toPrecision(b ? Decimal$.MODULE$.ONE() : Decimal$.MODULE$.ZERO(), this.$outer.target$1);
                                                }
                                                {
                                                    if ($outer == null) {
                                                        throw null;
                                                    }
                                                    this.$outer = $outer;
                                                }
                                            });
                                        }

                                        public /* synthetic */ Cast org$apache$spark$sql$catalyst$expressions$Cast$$anonfun$$$outer() {
                                            return this.$outer;
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                            this.target$1 = target$1;
                                        }
                                    };
                                    break block3;
                                }
                                if (!DateType$.MODULE$.equals(dataType2)) break block5;
                                object = new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ Cast $outer;

                                    public final Object apply(Object x$60) {
                                        return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$buildCast(x$60, new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final Null$ apply(int d) {
                                                return null;
                                            }
                                        });
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }
                                };
                                break block3;
                            }
                            if (!TimestampType$.MODULE$.equals(dataType2)) break block6;
                            object = new Serializable(this, target){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ Cast $outer;
                                public final DecimalType target$1;

                                public final Object apply(Object x$61) {
                                    return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$buildCast(x$61, new Serializable(this){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ $anonfun$castToDecimal$4 $outer;

                                        public final Decimal apply(long t) {
                                            return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$anonfun$$$outer().org$apache$spark$sql$catalyst$expressions$Cast$$changePrecision(Decimal$.MODULE$.apply(this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$anonfun$$$outer().org$apache$spark$sql$catalyst$expressions$Cast$$timestampToDouble(t)), this.$outer.target$1);
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                        }
                                    });
                                }

                                public /* synthetic */ Cast org$apache$spark$sql$catalyst$expressions$Cast$$anonfun$$$outer() {
                                    return this.$outer;
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.target$1 = target$1;
                                }
                            };
                            break block3;
                        }
                        if (!(dataType2 instanceof DecimalType)) break block7;
                        object = new Serializable(this, target){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ Cast $outer;
                            private final DecimalType target$1;

                            public final Decimal apply(Object b) {
                                return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$toPrecision((Decimal)b, this.target$1);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.target$1 = target$1;
                            }
                        };
                        break block3;
                    }
                    if (!(dataType2 instanceof IntegralType)) break block8;
                    IntegralType integralType = (IntegralType)dataType2;
                    object = new Serializable(this, target, integralType){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ Cast $outer;
                        private final DecimalType target$1;
                        private final IntegralType x7$1;

                        public final Decimal apply(Object b) {
                            return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$changePrecision(Decimal$.MODULE$.apply(this.x7$1.integral().toLong(b)), this.target$1);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.target$1 = target$1;
                            this.x7$1 = x7$1;
                        }
                    };
                    break block3;
                }
                if (!(dataType2 instanceof FractionalType)) break block9;
                FractionalType fractionalType = (FractionalType)dataType2;
                object = new Serializable(this, target, fractionalType){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Cast $outer;
                    private final DecimalType target$1;
                    private final FractionalType x8$1;

                    public final Object apply(Object b) {
                        Decimal decimal;
                        try {
                            decimal = this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$changePrecision(Decimal$.MODULE$.apply(this.x8$1.fractional().toDouble(b)), this.target$1);
                        }
                        catch (NumberFormatException numberFormatException) {
                            decimal = null;
                        }
                        return decimal;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.target$1 = target$1;
                        this.x8$1 = x8$1;
                    }
                };
            }
            return object;
        }
        throw new MatchError((Object)dataType2);
    }

    private Function1<Object, Object> castToDouble(DataType from) {
        DataType dataType2;
        block7: {
            Object object;
            block3: {
                block6: {
                    block5: {
                        block4: {
                            block2: {
                                dataType2 = from;
                                if (!StringType$.MODULE$.equals(dataType2)) break block2;
                                object = new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ Cast $outer;

                                    public final Object apply(Object x$62) {
                                        return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$buildCast(x$62, new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final Object apply(UTF8String s) {
                                                Double d;
                                                try {
                                                    d = BoxesRunTime.boxToDouble((double)new StringOps(Predef$.MODULE$.augmentString(s.toString())).toDouble());
                                                }
                                                catch (NumberFormatException numberFormatException) {
                                                    d = null;
                                                }
                                                return d;
                                            }
                                        });
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }
                                };
                                break block3;
                            }
                            if (!BooleanType$.MODULE$.equals(dataType2)) break block4;
                            object = new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ Cast $outer;

                                public final Object apply(Object x$63) {
                                    return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$buildCast(x$63, new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final Object apply(boolean b) {
                                            return b ? BoxesRunTime.boxToDouble((double)1.0) : BoxesRunTime.boxToDouble((double)0.0);
                                        }
                                    });
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            };
                            break block3;
                        }
                        if (!DateType$.MODULE$.equals(dataType2)) break block5;
                        object = new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ Cast $outer;

                            public final Object apply(Object x$64) {
                                return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$buildCast(x$64, new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final Null$ apply(int d) {
                                        return null;
                                    }
                                });
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        };
                        break block3;
                    }
                    if (!TimestampType$.MODULE$.equals(dataType2)) break block6;
                    object = new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ Cast $outer;

                        public final Object apply(Object x$65) {
                            return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$buildCast(x$65, new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$castToDouble$4 $outer;

                                public final double apply(long t) {
                                    return this.apply$mcDJ$sp(t);
                                }

                                public double apply$mcDJ$sp(long t) {
                                    return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$anonfun$$$outer().org$apache$spark$sql$catalyst$expressions$Cast$$timestampToDouble(t);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                        }

                        public /* synthetic */ Cast org$apache$spark$sql$catalyst$expressions$Cast$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    };
                    break block3;
                }
                if (!(dataType2 instanceof NumericType)) break block7;
                NumericType numericType = (NumericType)dataType2;
                object = new Serializable(this, numericType){
                    public static final long serialVersionUID = 0L;
                    private final NumericType x6$5;

                    public final double apply(Object b) {
                        return this.x6$5.numeric().toDouble(b);
                    }
                    {
                        this.x6$5 = x6$5;
                    }
                };
            }
            return object;
        }
        throw new MatchError((Object)dataType2);
    }

    private Function1<Object, Object> castToFloat(DataType from) {
        DataType dataType2;
        block7: {
            Object object;
            block3: {
                block6: {
                    block5: {
                        block4: {
                            block2: {
                                dataType2 = from;
                                if (!StringType$.MODULE$.equals(dataType2)) break block2;
                                object = new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ Cast $outer;

                                    public final Object apply(Object x$66) {
                                        return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$buildCast(x$66, new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final Object apply(UTF8String s) {
                                                Float f;
                                                try {
                                                    f = BoxesRunTime.boxToFloat((float)new StringOps(Predef$.MODULE$.augmentString(s.toString())).toFloat());
                                                }
                                                catch (NumberFormatException numberFormatException) {
                                                    f = null;
                                                }
                                                return f;
                                            }
                                        });
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }
                                };
                                break block3;
                            }
                            if (!BooleanType$.MODULE$.equals(dataType2)) break block4;
                            object = new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ Cast $outer;

                                public final Object apply(Object x$67) {
                                    return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$buildCast(x$67, new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final Object apply(boolean b) {
                                            return b ? BoxesRunTime.boxToFloat((float)1.0f) : BoxesRunTime.boxToFloat((float)0.0f);
                                        }
                                    });
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            };
                            break block3;
                        }
                        if (!DateType$.MODULE$.equals(dataType2)) break block5;
                        object = new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ Cast $outer;

                            public final Object apply(Object x$68) {
                                return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$buildCast(x$68, new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final Null$ apply(int d) {
                                        return null;
                                    }
                                });
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        };
                        break block3;
                    }
                    if (!TimestampType$.MODULE$.equals(dataType2)) break block6;
                    object = new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ Cast $outer;

                        public final Object apply(Object x$69) {
                            return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$buildCast(x$69, new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$castToFloat$4 $outer;

                                public final float apply(long t) {
                                    return this.apply$mcFJ$sp(t);
                                }

                                public float apply$mcFJ$sp(long t) {
                                    return (float)this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$anonfun$$$outer().org$apache$spark$sql$catalyst$expressions$Cast$$timestampToDouble(t);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                        }

                        public /* synthetic */ Cast org$apache$spark$sql$catalyst$expressions$Cast$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    };
                    break block3;
                }
                if (!(dataType2 instanceof NumericType)) break block7;
                NumericType numericType = (NumericType)dataType2;
                object = new Serializable(this, numericType){
                    public static final long serialVersionUID = 0L;
                    private final NumericType x6$6;

                    public final float apply(Object b) {
                        return this.x6$6.numeric().toFloat(b);
                    }
                    {
                        this.x6$6 = x6$6;
                    }
                };
            }
            return object;
        }
        throw new MatchError((Object)dataType2);
    }

    private Function1<Object, Object> castArray(DataType fromType, DataType toType) {
        Function1<Object, Object> elementCast = this.org$apache$spark$sql$catalyst$expressions$Cast$$cast(fromType, toType);
        return new Serializable(this, fromType, elementCast){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Cast $outer;
            public final DataType fromType$1;
            public final Function1 elementCast$1;

            public final Object apply(Object x$70) {
                return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$buildCast(x$70, new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$castArray$1 $outer;

                    public final GenericArrayData apply(ArrayData array) {
                        Object[] values2 = new Object[array.numElements()];
                        array.foreach(this.$outer.fromType$1, (Function2<Object, Object, BoxedUnit>)new Serializable(this, values2){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$castArray$1$$anonfun$apply$61 $outer;
                            private final Object[] values$1;

                            public final void apply(int i, Object e) {
                                this.values$1[i] = e == null ? null : this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$anonfun$$anonfun$$$outer().elementCast$1.apply(e);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.values$1 = values$1;
                            }
                        });
                        return new GenericArrayData(values2);
                    }

                    public /* synthetic */ $anonfun$castArray$1 org$apache$spark$sql$catalyst$expressions$Cast$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.fromType$1 = fromType$1;
                this.elementCast$1 = elementCast$1;
            }
        };
    }

    private Function1<Object, Object> castMap(MapType from, MapType to) {
        Function1<Object, Object> keyCast = this.castArray(from.keyType(), to.keyType());
        Function1<Object, Object> valueCast = this.castArray(from.valueType(), to.valueType());
        return new Serializable(this, keyCast, valueCast){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Cast $outer;
            public final Function1 keyCast$1;
            public final Function1 valueCast$1;

            public final Object apply(Object x$71) {
                return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$buildCast(x$71, new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$castMap$1 $outer;

                    public final ArrayBasedMapData apply(MapData map2) {
                        ArrayData keys2 = (ArrayData)this.$outer.keyCast$1.apply((Object)map2.keyArray());
                        ArrayData values2 = (ArrayData)this.$outer.valueCast$1.apply((Object)map2.valueArray());
                        return new ArrayBasedMapData(keys2, values2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.keyCast$1 = keyCast$1;
                this.valueCast$1 = valueCast$1;
            }
        };
    }

    private Function1<Object, Object> castStruct(StructType from, StructType to) {
        Function1[] castFuncs = (Function1[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])from.fields()).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])to.fields()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Cast $outer;

            public final Function1<Object, Object> apply(Tuple2<StructField, StructField> x0$3) {
                Tuple2<StructField, StructField> tuple2 = x0$3;
                if (tuple2 != null) {
                    StructField fromField = (StructField)tuple2._1();
                    StructField toField = (StructField)tuple2._2();
                    Function1<Object, Object> function1 = this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$cast(fromField.dataType(), toField.dataType());
                    return function1;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Function1.class)));
        return new Serializable(this, from, castFuncs){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Cast $outer;
            public final StructType from$1;
            public final Function1[] castFuncs$1;

            public final Object apply(Object x$72) {
                return this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$buildCast(x$72, new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$castStruct$1 $outer;

                    /*
                     * WARNING - void declaration
                     */
                    public final GenericInternalRow apply(InternalRow row) {
                        void var2_2;
                        GenericInternalRow newRow = new GenericInternalRow(this.$outer.from$1.fields().length);
                        for (int i = 0; i < row.numFields(); ++i) {
                            newRow.update(i, row.isNullAt(i) ? null : this.$outer.castFuncs$1[i].apply(row.get(i, this.$outer.from$1.apply(i).dataType())));
                        }
                        return var2_2;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.from$1 = from$1;
                this.castFuncs$1 = castFuncs$1;
            }
        };
    }

    public Function1<Object, Object> org$apache$spark$sql$catalyst$expressions$Cast$$cast(DataType from, DataType to) {
        DataType dataType2;
        boolean bl;
        block24: {
            Object object;
            block5: {
                Object object2;
                block7: {
                    UserDefinedType userDefinedType;
                    block23: {
                        block22: {
                            block21: {
                                block20: {
                                    block19: {
                                        block18: {
                                            block17: {
                                                block16: {
                                                    block15: {
                                                        block14: {
                                                            block13: {
                                                                block12: {
                                                                    block11: {
                                                                        block10: {
                                                                            block9: {
                                                                                block8: {
                                                                                    block6: {
                                                                                        block4: {
                                                                                            if (!DataType$.MODULE$.equalsStructurally(from, to, DataType$.MODULE$.equalsStructurally$default$3())) break block4;
                                                                                            object = new Serializable(this){
                                                                                                public static final long serialVersionUID = 0L;

                                                                                                public final Object apply(Object x) {
                                                                                                    return Predef$.MODULE$.identity(x);
                                                                                                }
                                                                                            };
                                                                                            break block5;
                                                                                        }
                                                                                        bl = false;
                                                                                        userDefinedType = null;
                                                                                        DataType dataType3 = dataType2 = to;
                                                                                        DataType dataType4 = from;
                                                                                        if (dataType3 != null ? !dataType3.equals(dataType4) : dataType4 != null) break block6;
                                                                                        object2 = new Serializable(this){
                                                                                            public static final long serialVersionUID = 0L;

                                                                                            public final Object apply(Object x) {
                                                                                                return Predef$.MODULE$.identity(x);
                                                                                            }
                                                                                        };
                                                                                        break block7;
                                                                                    }
                                                                                    if (!StringType$.MODULE$.equals(dataType2)) break block8;
                                                                                    object2 = this.org$apache$spark$sql$catalyst$expressions$Cast$$castToString(from);
                                                                                    break block7;
                                                                                }
                                                                                if (!BinaryType$.MODULE$.equals(dataType2)) break block9;
                                                                                object2 = this.castToBinary(from);
                                                                                break block7;
                                                                            }
                                                                            if (!DateType$.MODULE$.equals(dataType2)) break block10;
                                                                            object2 = this.castToDate(from);
                                                                            break block7;
                                                                        }
                                                                        if (!(dataType2 instanceof DecimalType)) break block11;
                                                                        DecimalType decimalType = (DecimalType)dataType2;
                                                                        object2 = this.castToDecimal(from, decimalType);
                                                                        break block7;
                                                                    }
                                                                    if (!TimestampType$.MODULE$.equals(dataType2)) break block12;
                                                                    object2 = this.castToTimestamp(from);
                                                                    break block7;
                                                                }
                                                                if (!CalendarIntervalType$.MODULE$.equals(dataType2)) break block13;
                                                                object2 = this.castToInterval(from);
                                                                break block7;
                                                            }
                                                            if (!BooleanType$.MODULE$.equals(dataType2)) break block14;
                                                            object2 = this.castToBoolean(from);
                                                            break block7;
                                                        }
                                                        if (!ByteType$.MODULE$.equals(dataType2)) break block15;
                                                        object2 = this.castToByte(from);
                                                        break block7;
                                                    }
                                                    if (!ShortType$.MODULE$.equals(dataType2)) break block16;
                                                    object2 = this.castToShort(from);
                                                    break block7;
                                                }
                                                if (!IntegerType$.MODULE$.equals(dataType2)) break block17;
                                                object2 = this.castToInt(from);
                                                break block7;
                                            }
                                            if (!FloatType$.MODULE$.equals(dataType2)) break block18;
                                            object2 = this.castToFloat(from);
                                            break block7;
                                        }
                                        if (!LongType$.MODULE$.equals(dataType2)) break block19;
                                        object2 = this.castToLong(from);
                                        break block7;
                                    }
                                    if (!DoubleType$.MODULE$.equals(dataType2)) break block20;
                                    object2 = this.castToDouble(from);
                                    break block7;
                                }
                                if (!(dataType2 instanceof ArrayType)) break block21;
                                ArrayType arrayType2 = (ArrayType)dataType2;
                                object2 = this.castArray(((ArrayType)from).elementType(), arrayType2.elementType());
                                break block7;
                            }
                            if (!(dataType2 instanceof MapType)) break block22;
                            MapType mapType2 = (MapType)dataType2;
                            object2 = this.castMap((MapType)from, mapType2);
                            break block7;
                        }
                        if (!(dataType2 instanceof StructType)) break block23;
                        StructType structType2 = (StructType)dataType2;
                        object2 = this.castStruct((StructType)from, structType2);
                        break block7;
                    }
                    if (!(dataType2 instanceof UserDefinedType)) break block24;
                    bl = true;
                    userDefinedType = (UserDefinedType)dataType2;
                    Class clazz = userDefinedType.userClass();
                    Class clazz2 = ((UserDefinedType)from).userClass();
                    if (clazz != null ? !clazz.equals(clazz2) : clazz2 != null) break block24;
                    object2 = new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Object apply(Object x) {
                            return Predef$.MODULE$.identity(x);
                        }
                    };
                }
                object = object2;
            }
            return object;
        }
        if (bl) {
            throw new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot cast ", " to ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{from, to})));
        }
        throw new MatchError((Object)dataType2);
    }

    private Function1<Object, Object> cast() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.cast$lzycompute() : this.cast;
    }

    @Override
    public Object nullSafeEval(Object input) {
        return this.cast().apply(input);
    }

    @Override
    public ExprCode genCode(CodegenContext ctx) {
        return DataType$.MODULE$.equalsStructurally(this.child().dataType(), this.dataType(), DataType$.MODULE$.equalsStructurally$default$3()) ? this.child().genCode(ctx) : super.genCode(ctx);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode eval2 = this.child().genCode(ctx);
        Function3<String, String, String, String> nullSafeCast = this.org$apache$spark$sql$catalyst$expressions$Cast$$nullSafeCastFunction(this.child().dataType(), this.dataType(), ctx);
        return ev.copy(new StringBuilder().append((Object)eval2.code()).append((Object)this.org$apache$spark$sql$catalyst$expressions$Cast$$castCode(ctx, eval2.value(), eval2.isNull(), ev.value(), ev.isNull(), this.dataType(), nullSafeCast)).toString(), ev.copy$default$2(), ev.copy$default$3());
    }

    public Function3<String, String, String, String> org$apache$spark$sql$catalyst$expressions$Cast$$nullSafeCastFunction(DataType from, DataType to, CodegenContext ctx) {
        DataType dataType2;
        boolean bl;
        block23: {
            Object object;
            block5: {
                UserDefinedType userDefinedType;
                block22: {
                    block21: {
                        block20: {
                            block19: {
                                block18: {
                                    block17: {
                                        block16: {
                                            block15: {
                                                block14: {
                                                    block13: {
                                                        block12: {
                                                            block11: {
                                                                block10: {
                                                                    block9: {
                                                                        block8: {
                                                                            block7: {
                                                                                block6: {
                                                                                    block4: {
                                                                                        bl = false;
                                                                                        userDefinedType = null;
                                                                                        dataType2 = to;
                                                                                        DataType dataType3 = from;
                                                                                        NullType$ nullType$ = NullType$.MODULE$;
                                                                                        if (dataType3 != null ? !dataType3.equals(nullType$) : nullType$ != null) break block4;
                                                                                        object = new Serializable(this){
                                                                                            public static final long serialVersionUID = 0L;

                                                                                            public final String apply(String c, String evPrim, String evNull) {
                                                                                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = true;"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{evNull}));
                                                                                            }
                                                                                        };
                                                                                        break block5;
                                                                                    }
                                                                                    DataType dataType4 = to;
                                                                                    DataType dataType5 = from;
                                                                                    if (dataType4 != null ? !dataType4.equals(dataType5) : dataType5 != null) break block6;
                                                                                    object = new Serializable(this){
                                                                                        public static final long serialVersionUID = 0L;

                                                                                        public final String apply(String c, String evPrim, String evNull) {
                                                                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = ", ";"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{evPrim, c}));
                                                                                        }
                                                                                    };
                                                                                    break block5;
                                                                                }
                                                                                if (!StringType$.MODULE$.equals(dataType2)) break block7;
                                                                                object = this.org$apache$spark$sql$catalyst$expressions$Cast$$castToStringCode(from, ctx);
                                                                                break block5;
                                                                            }
                                                                            if (!BinaryType$.MODULE$.equals(dataType2)) break block8;
                                                                            object = this.castToBinaryCode(from);
                                                                            break block5;
                                                                        }
                                                                        if (!DateType$.MODULE$.equals(dataType2)) break block9;
                                                                        object = this.castToDateCode(from, ctx);
                                                                        break block5;
                                                                    }
                                                                    if (!(dataType2 instanceof DecimalType)) break block10;
                                                                    DecimalType decimalType = (DecimalType)dataType2;
                                                                    object = this.castToDecimalCode(from, decimalType, ctx);
                                                                    break block5;
                                                                }
                                                                if (!TimestampType$.MODULE$.equals(dataType2)) break block11;
                                                                object = this.castToTimestampCode(from, ctx);
                                                                break block5;
                                                            }
                                                            if (!CalendarIntervalType$.MODULE$.equals(dataType2)) break block12;
                                                            object = this.castToIntervalCode(from);
                                                            break block5;
                                                        }
                                                        if (!BooleanType$.MODULE$.equals(dataType2)) break block13;
                                                        object = this.castToBooleanCode(from);
                                                        break block5;
                                                    }
                                                    if (!ByteType$.MODULE$.equals(dataType2)) break block14;
                                                    object = this.castToByteCode(from, ctx);
                                                    break block5;
                                                }
                                                if (!ShortType$.MODULE$.equals(dataType2)) break block15;
                                                object = this.castToShortCode(from, ctx);
                                                break block5;
                                            }
                                            if (!IntegerType$.MODULE$.equals(dataType2)) break block16;
                                            object = this.castToIntCode(from, ctx);
                                            break block5;
                                        }
                                        if (!FloatType$.MODULE$.equals(dataType2)) break block17;
                                        object = this.castToFloatCode(from);
                                        break block5;
                                    }
                                    if (!LongType$.MODULE$.equals(dataType2)) break block18;
                                    object = this.castToLongCode(from, ctx);
                                    break block5;
                                }
                                if (!DoubleType$.MODULE$.equals(dataType2)) break block19;
                                object = this.castToDoubleCode(from);
                                break block5;
                            }
                            if (!(dataType2 instanceof ArrayType)) break block20;
                            ArrayType arrayType2 = (ArrayType)dataType2;
                            object = this.castArrayCode(((ArrayType)from).elementType(), arrayType2.elementType(), ctx);
                            break block5;
                        }
                        if (!(dataType2 instanceof MapType)) break block21;
                        MapType mapType2 = (MapType)dataType2;
                        object = this.castMapCode((MapType)from, mapType2, ctx);
                        break block5;
                    }
                    if (!(dataType2 instanceof StructType)) break block22;
                    StructType structType2 = (StructType)dataType2;
                    object = this.castStructCode((StructType)from, structType2, ctx);
                    break block5;
                }
                if (!(dataType2 instanceof UserDefinedType)) break block23;
                bl = true;
                userDefinedType = (UserDefinedType)dataType2;
                Class clazz = userDefinedType.userClass();
                Class clazz2 = ((UserDefinedType)from).userClass();
                if (clazz != null ? !clazz.equals(clazz2) : clazz2 != null) break block23;
                object = new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String c, String evPrim, String evNull) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = ", ";"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{evPrim, c}));
                    }
                };
            }
            return object;
        }
        if (bl) {
            throw new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot cast ", " to ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{from, to})));
        }
        throw new MatchError((Object)dataType2);
    }

    public String org$apache$spark$sql$catalyst$expressions$Cast$$castCode(CodegenContext ctx, String input, String inputIsNull, String result, String resultIsNull, DataType resultType, Function3<String, String, String, String> cast2) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n      boolean ", " = ", ";\n      ", " ", " = ", ";\n      if (!", ") {\n        ", "\n      }\n    "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultIsNull, inputIsNull, ctx.javaType(resultType), result, ctx.defaultValue(resultType), inputIsNull, cast2.apply((Object)input, (Object)result, (Object)resultIsNull)}));
    }

    public String org$apache$spark$sql$catalyst$expressions$Cast$$writeArrayToStringBuilder(DataType et, String array, String buffer, CodegenContext ctx) {
        Function3<String, String, String, String> elementToStringCode = this.org$apache$spark$sql$catalyst$expressions$Cast$$castToStringCode(et, ctx);
        String funcName = ctx.freshName("elementToString");
        String elementToStringFunc = ctx.addNewFunction(funcName, new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |private UTF8String ", "(", " element) {\n         |  UTF8String elementStr = null;\n         |  ", "\n         |  return elementStr;\n         |}\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{funcName, ctx.javaType(et), elementToStringCode.apply((Object)"element", (Object)"elementStr", null)})))).stripMargin(), ctx.addNewFunction$default$3());
        String loopIndex = ctx.freshName("loopIndex");
        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n       |", ".append(\"[\");\n       |if (", ".numElements() > 0) {\n       |  if (!", ".isNullAt(0)) {\n       |    ", ".append(", "(", "));\n       |  }\n       |  for (int ", " = 1; ", " < ", ".numElements(); ", "++) {\n       |    ", ".append(\",\");\n       |    if (!", ".isNullAt(", ")) {\n       |      ", ".append(\" \");\n       |      ", ".append(", "(", "));\n       |    }\n       |  }\n       |}\n       |", ".append(\"]\");\n     "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{buffer, array, array, buffer, elementToStringFunc, ctx.getValue(array, et, "0"), loopIndex, loopIndex, array, loopIndex, buffer, array, loopIndex, buffer, buffer, elementToStringFunc, ctx.getValue(array, et, loopIndex), buffer})))).stripMargin();
    }

    public String org$apache$spark$sql$catalyst$expressions$Cast$$writeMapToStringBuilder(DataType kt, DataType vt, String map2, String buffer, CodegenContext ctx) {
        String keyToStringFunc = this.dataToStringFunc$1("keyToString", kt, ctx);
        String valueToStringFunc = this.dataToStringFunc$1("valueToString", vt, ctx);
        String loopIndex = ctx.freshName("loopIndex");
        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n       |", ".append(\"[\");\n       |if (", ".numElements() > 0) {\n       |  ", ".append(", "(", "));\n       |  ", ".append(\" ->\");\n       |  if (!", ".valueArray().isNullAt(0)) {\n       |    ", ".append(\" \");\n       |    ", ".append(", "(", "));\n       |  }\n       |  for (int ", " = 1; ", " < ", ".numElements(); ", "++) {\n       |    ", ".append(\", \");\n       |    ", ".append(", "(", "));\n       |    ", ".append(\" ->\");\n       |    if (!", ".valueArray().isNullAt(", ")) {\n       |      ", ".append(\" \");\n       |      ", ".append(", "(\n       |        ", "));\n       |    }\n       |  }\n       |}\n       |", ".append(\"]\");\n     "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{buffer, map2, buffer, keyToStringFunc, ctx.getValue(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".keyArray()"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{map2})), kt, "0"), buffer, map2, buffer, buffer, valueToStringFunc, ctx.getValue(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".valueArray()"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{map2})), vt, "0"), loopIndex, loopIndex, map2, loopIndex, buffer, buffer, keyToStringFunc, ctx.getValue(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".keyArray()"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{map2})), kt, loopIndex), buffer, map2, loopIndex, buffer, buffer, valueToStringFunc, ctx.getValue(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".valueArray()"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{map2})), vt, loopIndex), buffer})))).stripMargin();
    }

    public String org$apache$spark$sql$catalyst$expressions$Cast$$writeStructToStringBuilder(Seq<DataType> st, String row, String buffer, CodegenContext ctx) {
        Seq structToStringCode = (Seq)((TraversableLike)st.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this, row, buffer, ctx){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Cast $outer;
            private final String row$1;
            private final String buffer$1;
            private final CodegenContext ctx$6;

            public final String apply(Tuple2<DataType, Object> x0$4) {
                Tuple2<DataType, Object> tuple2 = x0$4;
                if (tuple2 != null) {
                    DataType ft = (DataType)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    Function3<String, String, String, String> fieldToStringCode = this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$castToStringCode(ft, this.ctx$6);
                    String field = this.ctx$6.freshName("field");
                    String fieldStr = this.ctx$6.freshName("fieldStr");
                    String string = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", "\n         |if (!", ".isNullAt(", ")) {\n         |  ", "\n         |\n         |  // Append ", " field into the string buffer\n         |  ", " ", " = ", ";\n         |  UTF8String ", " = null;\n         |  ", "\n         |  ", ".append(", ");\n         |}\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{i != 0 ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".append(\",\");"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.buffer$1})) : "", this.row$1, BoxesRunTime.boxToInteger((int)i), i != 0 ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".append(\" \");"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.buffer$1})) : "", BoxesRunTime.boxToInteger((int)i), this.ctx$6.javaType(ft), field, this.ctx$6.getValue(this.row$1, ft, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}))), fieldStr, fieldToStringCode.apply((Object)field, (Object)fieldStr, null), this.buffer$1, fieldStr})))).stripMargin();
                    return string;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.row$1 = row$1;
                this.buffer$1 = buffer$1;
                this.ctx$6 = ctx$6;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Tuple2 tuple2 = new Tuple2((Object)"InternalRow", (Object)row);
        Tuple2 tuple22 = new Tuple2((Object)UTF8StringBuilder.class.getName(), (Object)buffer);
        String writeStructCode = ctx.splitExpressions((Seq<String>)structToStringCode, "fieldToString", (Seq<Tuple2<String, String>>)Nil$.MODULE$.$colon$colon((Object)tuple22).$colon$colon((Object)tuple2), ctx.splitExpressions$default$4(), ctx.splitExpressions$default$5(), ctx.splitExpressions$default$6());
        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n       |", ".append(\"[\");\n       |", "\n       |", ".append(\"]\");\n     "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{buffer, writeStructCode, buffer})))).stripMargin();
    }

    public Function3<String, String, String, String> org$apache$spark$sql$catalyst$expressions$Cast$$castToStringCode(DataType from, CodegenContext ctx) {
        Object object;
        block9: {
            DataType dataType2;
            while (true) {
                if (BinaryType$.MODULE$.equals(dataType2 = from)) {
                    object = new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(String c, String evPrim, String evNull) {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = UTF8String.fromBytes(", ");"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{evPrim, c}));
                        }
                    };
                    break block9;
                }
                if (DateType$.MODULE$.equals(dataType2)) {
                    object = new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(String c, String evPrim, String evNull) {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = UTF8String.fromString(\n          org.apache.spark.sql.catalyst.util.DateTimeUtils.dateToString(", "));"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{evPrim, c}));
                        }
                    };
                    break block9;
                }
                if (TimestampType$.MODULE$.equals(dataType2)) {
                    String tz = ctx.addReferenceObj("timeZone", this.timeZone(), ctx.addReferenceObj$default$3());
                    object = new Serializable(this, tz){
                        public static final long serialVersionUID = 0L;
                        private final String tz$1;

                        public final String apply(String c, String evPrim, String evNull) {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = UTF8String.fromString(\n          org.apache.spark.sql.catalyst.util.DateTimeUtils.timestampToString(", ", ", "));"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{evPrim, c, this.tz$1}));
                        }
                        {
                            this.tz$1 = tz$1;
                        }
                    };
                    break block9;
                }
                if (dataType2 instanceof ArrayType) {
                    ArrayType arrayType2 = (ArrayType)dataType2;
                    DataType et = arrayType2.elementType();
                    object = new Serializable(this, ctx, et){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ Cast $outer;
                        private final CodegenContext ctx$1;
                        private final DataType et$2;

                        public final String apply(String c, String evPrim, String evNull) {
                            String buffer = this.ctx$1.freshName("buffer");
                            String bufferClass = UTF8StringBuilder.class.getName();
                            String writeArrayElemCode = this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$writeArrayToStringBuilder(this.et$2, c, buffer, this.ctx$1);
                            return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |", " ", " = new ", "();\n             |", ";\n             |", " = ", ".build();\n           "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bufferClass, buffer, bufferClass, writeArrayElemCode, evPrim, buffer})))).stripMargin();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.ctx$1 = ctx$1;
                            this.et$2 = et$2;
                        }
                    };
                    break block9;
                }
                if (dataType2 instanceof MapType) {
                    MapType mapType2 = (MapType)dataType2;
                    DataType kt = mapType2.keyType();
                    DataType vt = mapType2.valueType();
                    object = new Serializable(this, ctx, kt, vt){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ Cast $outer;
                        private final CodegenContext ctx$1;
                        private final DataType kt$2;
                        private final DataType vt$2;

                        public final String apply(String c, String evPrim, String evNull) {
                            String buffer = this.ctx$1.freshName("buffer");
                            String bufferClass = UTF8StringBuilder.class.getName();
                            String writeMapElemCode = this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$writeMapToStringBuilder(this.kt$2, this.vt$2, c, buffer, this.ctx$1);
                            return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |", " ", " = new ", "();\n             |", ";\n             |", " = ", ".build();\n           "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bufferClass, buffer, bufferClass, writeMapElemCode, evPrim, buffer})))).stripMargin();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.ctx$1 = ctx$1;
                            this.kt$2 = kt$2;
                            this.vt$2 = vt$2;
                        }
                    };
                    break block9;
                }
                if (dataType2 instanceof StructType) {
                    StructType structType2 = (StructType)dataType2;
                    StructField[] fields = structType2.fields();
                    object = new Serializable(this, ctx, fields){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ Cast $outer;
                        private final CodegenContext ctx$1;
                        private final StructField[] fields$2;

                        public final String apply(String c, String evPrim, String evNull) {
                            String row = this.ctx$1.freshName("row");
                            String buffer = this.ctx$1.freshName("buffer");
                            String bufferClass = UTF8StringBuilder.class.getName();
                            String writeStructCode = this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$writeStructToStringBuilder((Seq<DataType>)((Seq)Predef$.MODULE$.refArrayOps((Object[])this.fields$2).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final DataType apply(StructField x$75) {
                                    return x$75.dataType();
                                }
                            }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()))), row, buffer, this.ctx$1);
                            return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |InternalRow ", " = ", ";\n             |", " ", " = new ", "();\n             |", "\n             |", " = ", ".build();\n           "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{row, c, bufferClass, buffer, bufferClass, writeStructCode, evPrim, buffer})))).stripMargin();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.ctx$1 = ctx$1;
                            this.fields$2 = fields$2;
                        }
                    };
                    break block9;
                }
                if (!(dataType2 instanceof PythonUserDefinedType)) break;
                PythonUserDefinedType pythonUserDefinedType = (PythonUserDefinedType)dataType2;
                from = pythonUserDefinedType.sqlType();
            }
            if (dataType2 instanceof UserDefinedType) {
                UserDefinedType userDefinedType = (UserDefinedType)dataType2;
                String udtRef = ctx.addReferenceObj("udt", userDefinedType, ctx.addReferenceObj$default$3());
                object = new Serializable(this, udtRef){
                    public static final long serialVersionUID = 0L;
                    private final String udtRef$1;

                    public final String apply(String c, String evPrim, String evNull) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = UTF8String.fromString(", ".deserialize(", ").toString());"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{evPrim, this.udtRef$1, c}));
                    }
                    {
                        this.udtRef$1 = udtRef$1;
                    }
                };
            } else {
                object = new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String c, String evPrim, String evNull) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = UTF8String.fromString(String.valueOf(", "));"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{evPrim, c}));
                    }
                };
            }
        }
        return object;
    }

    private Function3<String, String, String, String> castToBinaryCode(DataType from) {
        DataType dataType2 = from;
        if (StringType$.MODULE$.equals(dataType2)) {
            Serializable serializable = new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(String c, String evPrim, String evNull) {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = ", ".getBytes();"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{evPrim, c}));
                }
            };
            return serializable;
        }
        throw new MatchError((Object)dataType2);
    }

    private Function3<String, String, String, String> castToDateCode(DataType from, CodegenContext ctx) {
        Object object;
        DataType dataType2 = from;
        if (StringType$.MODULE$.equals(dataType2)) {
            String intOpt = ctx.freshName("intOpt");
            object = new Serializable(this, intOpt){
                public static final long serialVersionUID = 0L;
                private final String intOpt$1;

                public final String apply(String c, String evPrim, String evNull) {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        scala.Option<Integer> ", " =\n          org.apache.spark.sql.catalyst.util.DateTimeUtils.stringToDate(", ");\n        if (", ".isDefined()) {\n          ", " = ((Integer) ", ".get()).intValue();\n        } else {\n          ", " = true;\n        }\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.intOpt$1, c, this.intOpt$1, evPrim, this.intOpt$1, evNull}));
                }
                {
                    this.intOpt$1 = intOpt$1;
                }
            };
        } else if (TimestampType$.MODULE$.equals(dataType2)) {
            String tz = ctx.addReferenceObj("timeZone", this.timeZone(), ctx.addReferenceObj$default$3());
            object = new Serializable(this, tz){
                public static final long serialVersionUID = 0L;
                private final String tz$2;

                public final String apply(String c, String evPrim, String evNull) {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = org.apache.spark.sql.catalyst.util.DateTimeUtils.millisToDays(", " / 1000L, ", ");"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{evPrim, c, this.tz$2}));
                }
                {
                    this.tz$2 = tz$2;
                }
            };
        } else {
            object = new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(String c, String evPrim, String evNull) {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = true;"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{evNull}));
                }
            };
        }
        return object;
    }

    public String org$apache$spark$sql$catalyst$expressions$Cast$$changePrecision(String d, DecimalType decimalType, String evPrim, String evNull) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n      if (", ".changePrecision(", ", ", ")) {\n        ", " = ", ";\n      } else {\n        ", " = true;\n      }\n    "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{d, BoxesRunTime.boxToInteger((int)decimalType.precision()), BoxesRunTime.boxToInteger((int)decimalType.scale()), evPrim, d, evNull}));
    }

    private Function3<String, String, String, String> castToDecimalCode(DataType from, DecimalType target, CodegenContext ctx) {
        DataType dataType2;
        block9: {
            Object object;
            block3: {
                String tmp;
                block8: {
                    block7: {
                        block6: {
                            block5: {
                                block4: {
                                    block2: {
                                        tmp = ctx.freshName("tmpDecimal");
                                        dataType2 = from;
                                        if (!StringType$.MODULE$.equals(dataType2)) break block2;
                                        object = new Serializable(this, target, tmp){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ Cast $outer;
                                            private final DecimalType target$2;
                                            private final String tmp$1;

                                            public final String apply(String c, String evPrim, String evNull) {
                                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n            try {\n              Decimal ", " = Decimal.apply(new java.math.BigDecimal(", ".toString()));\n              ", "\n            } catch (java.lang.NumberFormatException e) {\n              ", " = true;\n            }\n          "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tmp$1, c, this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$changePrecision(this.tmp$1, this.target$2, evPrim, evNull), evNull}));
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                                this.target$2 = target$2;
                                                this.tmp$1 = tmp$1;
                                            }
                                        };
                                        break block3;
                                    }
                                    if (!BooleanType$.MODULE$.equals(dataType2)) break block4;
                                    object = new Serializable(this, target, tmp){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ Cast $outer;
                                        private final DecimalType target$2;
                                        private final String tmp$1;

                                        public final String apply(String c, String evPrim, String evNull) {
                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n            Decimal ", " = ", " ? Decimal.apply(1) : Decimal.apply(0);\n            ", "\n          "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tmp$1, c, this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$changePrecision(this.tmp$1, this.target$2, evPrim, evNull)}));
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                            this.target$2 = target$2;
                                            this.tmp$1 = tmp$1;
                                        }
                                    };
                                    break block3;
                                }
                                if (!DateType$.MODULE$.equals(dataType2)) break block5;
                                object = new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply(String c, String evPrim, String evNull) {
                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = true;"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{evNull}));
                                    }
                                };
                                break block3;
                            }
                            if (!TimestampType$.MODULE$.equals(dataType2)) break block6;
                            object = new Serializable(this, target, tmp){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ Cast $outer;
                                private final DecimalType target$2;
                                private final String tmp$1;

                                public final String apply(String c, String evPrim, String evNull) {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n            Decimal ", " = Decimal.apply(\n              scala.math.BigDecimal.valueOf(", "));\n            ", "\n          "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tmp$1, this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$timestampToDoubleCode(c), this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$changePrecision(this.tmp$1, this.target$2, evPrim, evNull)}));
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.target$2 = target$2;
                                    this.tmp$1 = tmp$1;
                                }
                            };
                            break block3;
                        }
                        if (!DecimalType$.MODULE$.unapply(dataType2)) break block7;
                        object = new Serializable(this, target, tmp){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ Cast $outer;
                            private final DecimalType target$2;
                            private final String tmp$1;

                            public final String apply(String c, String evPrim, String evNull) {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n            Decimal ", " = ", ".clone();\n            ", "\n          "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tmp$1, c, this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$changePrecision(this.tmp$1, this.target$2, evPrim, evNull)}));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.target$2 = target$2;
                                this.tmp$1 = tmp$1;
                            }
                        };
                        break block3;
                    }
                    if (!(dataType2 instanceof IntegralType)) break block8;
                    object = new Serializable(this, target, tmp){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ Cast $outer;
                        private final DecimalType target$2;
                        private final String tmp$1;

                        public final String apply(String c, String evPrim, String evNull) {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n            Decimal ", " = Decimal.apply((long) ", ");\n            ", "\n          "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tmp$1, c, this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$changePrecision(this.tmp$1, this.target$2, evPrim, evNull)}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.target$2 = target$2;
                            this.tmp$1 = tmp$1;
                        }
                    };
                    break block3;
                }
                if (!(dataType2 instanceof FractionalType)) break block9;
                object = new Serializable(this, target, tmp){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Cast $outer;
                    private final DecimalType target$2;
                    private final String tmp$1;

                    public final String apply(String c, String evPrim, String evNull) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n            try {\n              Decimal ", " = Decimal.apply(scala.math.BigDecimal.valueOf((double) ", "));\n              ", "\n            } catch (java.lang.NumberFormatException e) {\n              ", " = true;\n            }\n          "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tmp$1, c, this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$changePrecision(this.tmp$1, this.target$2, evPrim, evNull), evNull}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.target$2 = target$2;
                        this.tmp$1 = tmp$1;
                    }
                };
            }
            return object;
        }
        throw new MatchError((Object)dataType2);
    }

    private Function3<String, String, String, String> castToTimestampCode(DataType from, CodegenContext ctx) {
        DataType dataType2;
        block9: {
            Object object;
            block3: {
                block8: {
                    block7: {
                        block6: {
                            block5: {
                                block4: {
                                    block2: {
                                        dataType2 = from;
                                        if (!StringType$.MODULE$.equals(dataType2)) break block2;
                                        String tz = ctx.addReferenceObj("timeZone", this.timeZone(), ctx.addReferenceObj$default$3());
                                        String longOpt = ctx.freshName("longOpt");
                                        object = new Serializable(this, tz, longOpt){
                                            public static final long serialVersionUID = 0L;
                                            private final String tz$3;
                                            private final String longOpt$1;

                                            public final String apply(String c, String evPrim, String evNull) {
                                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          scala.Option<Long> ", " =\n            org.apache.spark.sql.catalyst.util.DateTimeUtils.stringToTimestamp(", ", ", ");\n          if (", ".isDefined()) {\n            ", " = ((Long) ", ".get()).longValue();\n          } else {\n            ", " = true;\n          }\n         "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.longOpt$1, c, this.tz$3, this.longOpt$1, evPrim, this.longOpt$1, evNull}));
                                            }
                                            {
                                                this.tz$3 = tz$3;
                                                this.longOpt$1 = longOpt$1;
                                            }
                                        };
                                        break block3;
                                    }
                                    if (!BooleanType$.MODULE$.equals(dataType2)) break block4;
                                    object = new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply(String c, String evPrim, String evNull) {
                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = ", " ? 1L : 0L;"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{evPrim, c}));
                                        }
                                    };
                                    break block3;
                                }
                                if (!(dataType2 instanceof IntegralType)) break block5;
                                object = new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ Cast $outer;

                                    public final String apply(String c, String evPrim, String evNull) {
                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = ", ";"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{evPrim, this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$longToTimeStampCode(c)}));
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }
                                };
                                break block3;
                            }
                            if (!DateType$.MODULE$.equals(dataType2)) break block6;
                            String tz = ctx.addReferenceObj("timeZone", this.timeZone(), ctx.addReferenceObj$default$3());
                            object = new Serializable(this, tz){
                                public static final long serialVersionUID = 0L;
                                private final String tz$4;

                                public final String apply(String c, String evPrim, String evNull) {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = org.apache.spark.sql.catalyst.util.DateTimeUtils.daysToMillis(", ", ", ") * 1000;"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{evPrim, c, this.tz$4}));
                                }
                                {
                                    this.tz$4 = tz$4;
                                }
                            };
                            break block3;
                        }
                        if (!DecimalType$.MODULE$.unapply(dataType2)) break block7;
                        object = new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ Cast $outer;

                            public final String apply(String c, String evPrim, String evNull) {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = ", ";"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{evPrim, this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$decimalToTimestampCode(c)}));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        };
                        break block3;
                    }
                    if (!DoubleType$.MODULE$.equals(dataType2)) break block8;
                    object = new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(String c, String evPrim, String evNull) {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          if (Double.isNaN(", ") || Double.isInfinite(", ")) {\n            ", " = true;\n          } else {\n            ", " = (long)(", " * 1000000L);\n          }\n        "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c, c, evNull, evPrim, c}));
                        }
                    };
                    break block3;
                }
                if (!FloatType$.MODULE$.equals(dataType2)) break block9;
                object = new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String c, String evPrim, String evNull) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          if (Float.isNaN(", ") || Float.isInfinite(", ")) {\n            ", " = true;\n          } else {\n            ", " = (long)(", " * 1000000L);\n          }\n        "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c, c, evNull, evPrim, c}));
                    }
                };
            }
            return object;
        }
        throw new MatchError((Object)dataType2);
    }

    private Function3<String, String, String, String> castToIntervalCode(DataType from) {
        DataType dataType2 = from;
        if (StringType$.MODULE$.equals(dataType2)) {
            Serializable serializable = new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(String c, String evPrim, String evNull) {
                    return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = CalendarInterval.fromString(", ".toString());\n           if(", " == null) {\n             ", " = true;\n           }\n         "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{evPrim, c, evPrim, evNull})))).stripMargin();
                }
            };
            return serializable;
        }
        throw new MatchError((Object)dataType2);
    }

    public String org$apache$spark$sql$catalyst$expressions$Cast$$decimalToTimestampCode(String d) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ".toBigDecimal().bigDecimal().multiply(new java.math.BigDecimal(1000000L))).longValue()"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{d}));
    }

    public String org$apache$spark$sql$catalyst$expressions$Cast$$longToTimeStampCode(String l) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " * 1000000L"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{l}));
    }

    public String org$apache$spark$sql$catalyst$expressions$Cast$$timestampToIntegerCode(String ts) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"java.lang.Math.floor((double) ", " / 1000000L)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ts}));
    }

    public String org$apache$spark$sql$catalyst$expressions$Cast$$timestampToDoubleCode(String ts) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " / 1000000.0"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ts}));
    }

    private Function3<String, String, String, String> castToBooleanCode(DataType from) {
        DataType dataType2;
        block7: {
            Object object;
            block3: {
                block6: {
                    block5: {
                        block4: {
                            block2: {
                                dataType2 = from;
                                if (!StringType$.MODULE$.equals(dataType2)) break block2;
                                String stringUtils = new StringOps(Predef$.MODULE$.augmentString(StringUtils$.MODULE$.getClass().getName())).stripSuffix("$");
                                object = new Serializable(this, stringUtils){
                                    public static final long serialVersionUID = 0L;
                                    private final String stringUtils$1;

                                    public final String apply(String c, String evPrim, String evNull) {
                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          if (", ".isTrueString(", ")) {\n            ", " = true;\n          } else if (", ".isFalseString(", ")) {\n            ", " = false;\n          } else {\n            ", " = true;\n          }\n        "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.stringUtils$1, c, evPrim, this.stringUtils$1, c, evPrim, evNull}));
                                    }
                                    {
                                        this.stringUtils$1 = stringUtils$1;
                                    }
                                };
                                break block3;
                            }
                            if (!TimestampType$.MODULE$.equals(dataType2)) break block4;
                            object = new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply(String c, String evPrim, String evNull) {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = ", " != 0;"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{evPrim, c}));
                                }
                            };
                            break block3;
                        }
                        if (!DateType$.MODULE$.equals(dataType2)) break block5;
                        object = new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(String c, String evPrim, String evNull) {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = true;"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{evNull}));
                            }
                        };
                        break block3;
                    }
                    if (!DecimalType$.MODULE$.unapply(dataType2)) break block6;
                    object = new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(String c, String evPrim, String evNull) {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = !", ".isZero();"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{evPrim, c}));
                        }
                    };
                    break block3;
                }
                if (!(dataType2 instanceof NumericType)) break block7;
                object = new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String c, String evPrim, String evNull) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = ", " != 0;"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{evPrim, c}));
                    }
                };
            }
            return object;
        }
        throw new MatchError((Object)dataType2);
    }

    private Function3<String, String, String, String> castToByteCode(DataType from, CodegenContext ctx) {
        DataType dataType2;
        block8: {
            Object object;
            block3: {
                block7: {
                    block6: {
                        block5: {
                            block4: {
                                block2: {
                                    dataType2 = from;
                                    if (!StringType$.MODULE$.equals(dataType2)) break block2;
                                    String wrapper = ctx.freshName("intWrapper");
                                    object = new Serializable(this, wrapper){
                                        public static final long serialVersionUID = 0L;
                                        private final String wrapper$1;

                                        public final String apply(String c, String evPrim, String evNull) {
                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          UTF8String.IntWrapper ", " = new UTF8String.IntWrapper();\n          if (", ".toByte(", ")) {\n            ", " = (byte) ", ".value;\n          } else {\n            ", " = true;\n          }\n          ", " = null;\n        "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.wrapper$1, c, this.wrapper$1, evPrim, this.wrapper$1, evNull, this.wrapper$1}));
                                        }
                                        {
                                            this.wrapper$1 = wrapper$1;
                                        }
                                    };
                                    break block3;
                                }
                                if (!BooleanType$.MODULE$.equals(dataType2)) break block4;
                                object = new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply(String c, String evPrim, String evNull) {
                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = ", " ? (byte) 1 : (byte) 0;"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{evPrim, c}));
                                    }
                                };
                                break block3;
                            }
                            if (!DateType$.MODULE$.equals(dataType2)) break block5;
                            object = new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply(String c, String evPrim, String evNull) {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = true;"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{evNull}));
                                }
                            };
                            break block3;
                        }
                        if (!TimestampType$.MODULE$.equals(dataType2)) break block6;
                        object = new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ Cast $outer;

                            public final String apply(String c, String evPrim, String evNull) {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = (byte) ", ";"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{evPrim, this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$timestampToIntegerCode(c)}));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        };
                        break block3;
                    }
                    if (!DecimalType$.MODULE$.unapply(dataType2)) break block7;
                    object = new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(String c, String evPrim, String evNull) {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = ", ".toByte();"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{evPrim, c}));
                        }
                    };
                    break block3;
                }
                if (!(dataType2 instanceof NumericType)) break block8;
                object = new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String c, String evPrim, String evNull) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = (byte) ", ";"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{evPrim, c}));
                    }
                };
            }
            return object;
        }
        throw new MatchError((Object)dataType2);
    }

    private Function3<String, String, String, String> castToShortCode(DataType from, CodegenContext ctx) {
        DataType dataType2;
        block8: {
            Object object;
            block3: {
                block7: {
                    block6: {
                        block5: {
                            block4: {
                                block2: {
                                    dataType2 = from;
                                    if (!StringType$.MODULE$.equals(dataType2)) break block2;
                                    String wrapper = ctx.freshName("intWrapper");
                                    object = new Serializable(this, wrapper){
                                        public static final long serialVersionUID = 0L;
                                        private final String wrapper$2;

                                        public final String apply(String c, String evPrim, String evNull) {
                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          UTF8String.IntWrapper ", " = new UTF8String.IntWrapper();\n          if (", ".toShort(", ")) {\n            ", " = (short) ", ".value;\n          } else {\n            ", " = true;\n          }\n          ", " = null;\n        "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.wrapper$2, c, this.wrapper$2, evPrim, this.wrapper$2, evNull, this.wrapper$2}));
                                        }
                                        {
                                            this.wrapper$2 = wrapper$2;
                                        }
                                    };
                                    break block3;
                                }
                                if (!BooleanType$.MODULE$.equals(dataType2)) break block4;
                                object = new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply(String c, String evPrim, String evNull) {
                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = ", " ? (short) 1 : (short) 0;"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{evPrim, c}));
                                    }
                                };
                                break block3;
                            }
                            if (!DateType$.MODULE$.equals(dataType2)) break block5;
                            object = new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply(String c, String evPrim, String evNull) {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = true;"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{evNull}));
                                }
                            };
                            break block3;
                        }
                        if (!TimestampType$.MODULE$.equals(dataType2)) break block6;
                        object = new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ Cast $outer;

                            public final String apply(String c, String evPrim, String evNull) {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = (short) ", ";"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{evPrim, this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$timestampToIntegerCode(c)}));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        };
                        break block3;
                    }
                    if (!DecimalType$.MODULE$.unapply(dataType2)) break block7;
                    object = new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(String c, String evPrim, String evNull) {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = ", ".toShort();"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{evPrim, c}));
                        }
                    };
                    break block3;
                }
                if (!(dataType2 instanceof NumericType)) break block8;
                object = new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String c, String evPrim, String evNull) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = (short) ", ";"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{evPrim, c}));
                    }
                };
            }
            return object;
        }
        throw new MatchError((Object)dataType2);
    }

    private Function3<String, String, String, String> castToIntCode(DataType from, CodegenContext ctx) {
        DataType dataType2;
        block8: {
            Object object;
            block3: {
                block7: {
                    block6: {
                        block5: {
                            block4: {
                                block2: {
                                    dataType2 = from;
                                    if (!StringType$.MODULE$.equals(dataType2)) break block2;
                                    String wrapper = ctx.freshName("intWrapper");
                                    object = new Serializable(this, wrapper){
                                        public static final long serialVersionUID = 0L;
                                        private final String wrapper$3;

                                        public final String apply(String c, String evPrim, String evNull) {
                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          UTF8String.IntWrapper ", " = new UTF8String.IntWrapper();\n          if (", ".toInt(", ")) {\n            ", " = ", ".value;\n          } else {\n            ", " = true;\n          }\n          ", " = null;\n        "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.wrapper$3, c, this.wrapper$3, evPrim, this.wrapper$3, evNull, this.wrapper$3}));
                                        }
                                        {
                                            this.wrapper$3 = wrapper$3;
                                        }
                                    };
                                    break block3;
                                }
                                if (!BooleanType$.MODULE$.equals(dataType2)) break block4;
                                object = new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply(String c, String evPrim, String evNull) {
                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = ", " ? 1 : 0;"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{evPrim, c}));
                                    }
                                };
                                break block3;
                            }
                            if (!DateType$.MODULE$.equals(dataType2)) break block5;
                            object = new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply(String c, String evPrim, String evNull) {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = true;"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{evNull}));
                                }
                            };
                            break block3;
                        }
                        if (!TimestampType$.MODULE$.equals(dataType2)) break block6;
                        object = new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ Cast $outer;

                            public final String apply(String c, String evPrim, String evNull) {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = (int) ", ";"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{evPrim, this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$timestampToIntegerCode(c)}));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        };
                        break block3;
                    }
                    if (!DecimalType$.MODULE$.unapply(dataType2)) break block7;
                    object = new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(String c, String evPrim, String evNull) {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = ", ".toInt();"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{evPrim, c}));
                        }
                    };
                    break block3;
                }
                if (!(dataType2 instanceof NumericType)) break block8;
                object = new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String c, String evPrim, String evNull) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = (int) ", ";"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{evPrim, c}));
                    }
                };
            }
            return object;
        }
        throw new MatchError((Object)dataType2);
    }

    private Function3<String, String, String, String> castToLongCode(DataType from, CodegenContext ctx) {
        DataType dataType2;
        block8: {
            Object object;
            block3: {
                block7: {
                    block6: {
                        block5: {
                            block4: {
                                block2: {
                                    dataType2 = from;
                                    if (!StringType$.MODULE$.equals(dataType2)) break block2;
                                    String wrapper = ctx.freshName("longWrapper");
                                    object = new Serializable(this, wrapper){
                                        public static final long serialVersionUID = 0L;
                                        private final String wrapper$4;

                                        public final String apply(String c, String evPrim, String evNull) {
                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          UTF8String.LongWrapper ", " = new UTF8String.LongWrapper();\n          if (", ".toLong(", ")) {\n            ", " = ", ".value;\n          } else {\n            ", " = true;\n          }\n          ", " = null;\n        "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.wrapper$4, c, this.wrapper$4, evPrim, this.wrapper$4, evNull, this.wrapper$4}));
                                        }
                                        {
                                            this.wrapper$4 = wrapper$4;
                                        }
                                    };
                                    break block3;
                                }
                                if (!BooleanType$.MODULE$.equals(dataType2)) break block4;
                                object = new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply(String c, String evPrim, String evNull) {
                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = ", " ? 1L : 0L;"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{evPrim, c}));
                                    }
                                };
                                break block3;
                            }
                            if (!DateType$.MODULE$.equals(dataType2)) break block5;
                            object = new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply(String c, String evPrim, String evNull) {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = true;"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{evNull}));
                                }
                            };
                            break block3;
                        }
                        if (!TimestampType$.MODULE$.equals(dataType2)) break block6;
                        object = new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ Cast $outer;

                            public final String apply(String c, String evPrim, String evNull) {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = (long) ", ";"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{evPrim, this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$timestampToIntegerCode(c)}));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        };
                        break block3;
                    }
                    if (!DecimalType$.MODULE$.unapply(dataType2)) break block7;
                    object = new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(String c, String evPrim, String evNull) {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = ", ".toLong();"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{evPrim, c}));
                        }
                    };
                    break block3;
                }
                if (!(dataType2 instanceof NumericType)) break block8;
                object = new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String c, String evPrim, String evNull) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = (long) ", ";"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{evPrim, c}));
                    }
                };
            }
            return object;
        }
        throw new MatchError((Object)dataType2);
    }

    private Function3<String, String, String, String> castToFloatCode(DataType from) {
        DataType dataType2;
        block8: {
            Object object;
            block3: {
                block7: {
                    block6: {
                        block5: {
                            block4: {
                                block2: {
                                    dataType2 = from;
                                    if (!StringType$.MODULE$.equals(dataType2)) break block2;
                                    object = new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply(String c, String evPrim, String evNull) {
                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          try {\n            ", " = Float.valueOf(", ".toString());\n          } catch (java.lang.NumberFormatException e) {\n            ", " = true;\n          }\n        "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{evPrim, c, evNull}));
                                        }
                                    };
                                    break block3;
                                }
                                if (!BooleanType$.MODULE$.equals(dataType2)) break block4;
                                object = new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply(String c, String evPrim, String evNull) {
                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = ", " ? 1.0f : 0.0f;"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{evPrim, c}));
                                    }
                                };
                                break block3;
                            }
                            if (!DateType$.MODULE$.equals(dataType2)) break block5;
                            object = new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply(String c, String evPrim, String evNull) {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = true;"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{evNull}));
                                }
                            };
                            break block3;
                        }
                        if (!TimestampType$.MODULE$.equals(dataType2)) break block6;
                        object = new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ Cast $outer;

                            public final String apply(String c, String evPrim, String evNull) {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = (float) (", ");"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{evPrim, this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$timestampToDoubleCode(c)}));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        };
                        break block3;
                    }
                    if (!DecimalType$.MODULE$.unapply(dataType2)) break block7;
                    object = new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(String c, String evPrim, String evNull) {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = ", ".toFloat();"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{evPrim, c}));
                        }
                    };
                    break block3;
                }
                if (!(dataType2 instanceof NumericType)) break block8;
                object = new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String c, String evPrim, String evNull) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = (float) ", ";"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{evPrim, c}));
                    }
                };
            }
            return object;
        }
        throw new MatchError((Object)dataType2);
    }

    private Function3<String, String, String, String> castToDoubleCode(DataType from) {
        DataType dataType2;
        block8: {
            Object object;
            block3: {
                block7: {
                    block6: {
                        block5: {
                            block4: {
                                block2: {
                                    dataType2 = from;
                                    if (!StringType$.MODULE$.equals(dataType2)) break block2;
                                    object = new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply(String c, String evPrim, String evNull) {
                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          try {\n            ", " = Double.valueOf(", ".toString());\n          } catch (java.lang.NumberFormatException e) {\n            ", " = true;\n          }\n        "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{evPrim, c, evNull}));
                                        }
                                    };
                                    break block3;
                                }
                                if (!BooleanType$.MODULE$.equals(dataType2)) break block4;
                                object = new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply(String c, String evPrim, String evNull) {
                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = ", " ? 1.0d : 0.0d;"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{evPrim, c}));
                                    }
                                };
                                break block3;
                            }
                            if (!DateType$.MODULE$.equals(dataType2)) break block5;
                            object = new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply(String c, String evPrim, String evNull) {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = true;"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{evNull}));
                                }
                            };
                            break block3;
                        }
                        if (!TimestampType$.MODULE$.equals(dataType2)) break block6;
                        object = new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ Cast $outer;

                            public final String apply(String c, String evPrim, String evNull) {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = ", ";"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{evPrim, this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$timestampToDoubleCode(c)}));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        };
                        break block3;
                    }
                    if (!DecimalType$.MODULE$.unapply(dataType2)) break block7;
                    object = new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(String c, String evPrim, String evNull) {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = ", ".toDouble();"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{evPrim, c}));
                        }
                    };
                    break block3;
                }
                if (!(dataType2 instanceof NumericType)) break block8;
                object = new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String c, String evPrim, String evNull) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = (double) ", ";"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{evPrim, c}));
                    }
                };
            }
            return object;
        }
        throw new MatchError((Object)dataType2);
    }

    private Function3<String, String, String, String> castArrayCode(DataType fromType, DataType toType, CodegenContext ctx) {
        Function3<String, String, String, String> elementCast = this.org$apache$spark$sql$catalyst$expressions$Cast$$nullSafeCastFunction(fromType, toType, ctx);
        String arrayClass = GenericArrayData.class.getName();
        String fromElementNull = ctx.freshName("feNull");
        String fromElementPrim = ctx.freshName("fePrim");
        String toElementNull = ctx.freshName("teNull");
        String toElementPrim = ctx.freshName("tePrim");
        String size = ctx.freshName("n");
        String j = ctx.freshName("j");
        String values2 = ctx.freshName("values");
        return new Serializable(this, fromType, toType, ctx, elementCast, arrayClass, fromElementNull, fromElementPrim, toElementNull, toElementPrim, size, j, values2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Cast $outer;
            private final DataType fromType$2;
            private final DataType toType$1;
            private final CodegenContext ctx$2;
            private final Function3 elementCast$2;
            private final String arrayClass$1;
            private final String fromElementNull$1;
            private final String fromElementPrim$1;
            private final String toElementNull$1;
            private final String toElementPrim$1;
            private final String size$1;
            private final String j$1;
            private final String values$2;

            public final String apply(String c, String evPrim, String evNull) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        final int ", " = ", ".numElements();\n        final Object[] ", " = new Object[", "];\n        for (int ", " = 0; ", " < ", "; ", " ++) {\n          if (", ".isNullAt(", ")) {\n            ", "[", "] = null;\n          } else {\n            boolean ", " = false;\n            ", " ", " =\n              ", ";\n            ", "\n            if (", ") {\n              ", "[", "] = null;\n            } else {\n              ", "[", "] = ", ";\n            }\n          }\n        }\n        ", " = new ", "(", ");\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.size$1, c, this.values$2, this.size$1, this.j$1, this.j$1, this.size$1, this.j$1, c, this.j$1, this.values$2, this.j$1, this.fromElementNull$1, this.ctx$2.javaType(this.fromType$2), this.fromElementPrim$1, this.ctx$2.getValue(c, this.fromType$2, this.j$1), this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$castCode(this.ctx$2, this.fromElementPrim$1, this.fromElementNull$1, this.toElementPrim$1, this.toElementNull$1, this.toType$1, (Function3<String, String, String, String>)this.elementCast$2), this.toElementNull$1, this.values$2, this.j$1, this.values$2, this.j$1, this.toElementPrim$1, evPrim, this.arrayClass$1, this.values$2}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.fromType$2 = fromType$2;
                this.toType$1 = toType$1;
                this.ctx$2 = ctx$2;
                this.elementCast$2 = elementCast$2;
                this.arrayClass$1 = arrayClass$1;
                this.fromElementNull$1 = fromElementNull$1;
                this.fromElementPrim$1 = fromElementPrim$1;
                this.toElementNull$1 = toElementNull$1;
                this.toElementPrim$1 = toElementPrim$1;
                this.size$1 = size$1;
                this.j$1 = j$1;
                this.values$2 = values$2;
            }
        };
    }

    private Function3<String, String, String, String> castMapCode(MapType from, MapType to, CodegenContext ctx) {
        Function3<String, String, String, String> keysCast = this.castArrayCode(from.keyType(), to.keyType(), ctx);
        Function3<String, String, String, String> valuesCast = this.castArrayCode(from.valueType(), to.valueType(), ctx);
        String mapClass = ArrayBasedMapData.class.getName();
        String keys2 = ctx.freshName("keys");
        String convertedKeys = ctx.freshName("convertedKeys");
        String convertedKeysNull = ctx.freshName("convertedKeysNull");
        String values2 = ctx.freshName("values");
        String convertedValues = ctx.freshName("convertedValues");
        String convertedValuesNull = ctx.freshName("convertedValuesNull");
        return new Serializable(this, to, ctx, keysCast, valuesCast, mapClass, keys2, convertedKeys, convertedKeysNull, values2, convertedValues, convertedValuesNull){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Cast $outer;
            private final MapType to$1;
            private final CodegenContext ctx$3;
            private final Function3 keysCast$1;
            private final Function3 valuesCast$1;
            private final String mapClass$1;
            private final String keys$1;
            private final String convertedKeys$1;
            private final String convertedKeysNull$1;
            private final String values$3;
            private final String convertedValues$1;
            private final String convertedValuesNull$1;

            public final String apply(String c, String evPrim, String evNull) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        final ArrayData ", " = ", ".keyArray();\n        final ArrayData ", " = ", ".valueArray();\n        ", "\n        ", "\n\n        ", " = new ", "(", ", ", ");\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.keys$1, c, this.values$3, c, this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$castCode(this.ctx$3, this.keys$1, "false", this.convertedKeys$1, this.convertedKeysNull$1, ArrayType$.MODULE$.apply(this.to$1.keyType()), (Function3<String, String, String, String>)this.keysCast$1), this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$castCode(this.ctx$3, this.values$3, "false", this.convertedValues$1, this.convertedValuesNull$1, ArrayType$.MODULE$.apply(this.to$1.valueType()), (Function3<String, String, String, String>)this.valuesCast$1), evPrim, this.mapClass$1, this.convertedKeys$1, this.convertedValues$1}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.to$1 = to$1;
                this.ctx$3 = ctx$3;
                this.keysCast$1 = keysCast$1;
                this.valuesCast$1 = valuesCast$1;
                this.mapClass$1 = mapClass$1;
                this.keys$1 = keys$1;
                this.convertedKeys$1 = convertedKeys$1;
                this.convertedKeysNull$1 = convertedKeysNull$1;
                this.values$3 = values$3;
                this.convertedValues$1 = convertedValues$1;
                this.convertedValuesNull$1 = convertedValuesNull$1;
            }
        };
    }

    private Function3<String, String, String, String> castStructCode(StructType from, StructType to, CodegenContext ctx) {
        Function3[] fieldsCasts = (Function3[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])from.fields()).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])to.fields()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(this, ctx){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Cast $outer;
            private final CodegenContext ctx$4;

            public final Function3<String, String, String, String> apply(Tuple2<StructField, StructField> x0$5) {
                Tuple2<StructField, StructField> tuple2 = x0$5;
                if (tuple2 != null) {
                    StructField fromField = (StructField)tuple2._1();
                    StructField toField = (StructField)tuple2._2();
                    Function3<String, String, String, String> function3 = this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$nullSafeCastFunction(fromField.dataType(), toField.dataType(), this.ctx$4);
                    return function3;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.ctx$4 = ctx$4;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Function3.class)));
        String rowClass = GenericInternalRow.class.getName();
        String tmpResult = ctx.freshName("tmpResult");
        String tmpInput = ctx.freshName("tmpInput");
        String[] fieldsEvalCode = (String[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])fieldsCasts).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(this, from, to, ctx, tmpResult, tmpInput){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Cast $outer;
            private final StructType from$2;
            private final StructType to$2;
            private final CodegenContext ctx$4;
            private final String tmpResult$1;
            private final String tmpInput$1;

            public final String apply(Tuple2<Function3<String, String, String, String>, Object> x0$6) {
                Tuple2<Function3<String, String, String, String>, Object> tuple2 = x0$6;
                if (tuple2 != null) {
                    Function3 cast2 = (Function3)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    String fromFieldPrim = this.ctx$4.freshName("ffp");
                    String fromFieldNull = this.ctx$4.freshName("ffn");
                    String toFieldPrim = this.ctx$4.freshName("tfp");
                    String toFieldNull = this.ctx$4.freshName("tfn");
                    String fromType = this.ctx$4.javaType(this.from$2.fields()[i].dataType());
                    String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        boolean ", " = ", ".isNullAt(", ");\n        if (", ") {\n          ", ".setNullAt(", ");\n        } else {\n          ", " ", " =\n            ", ";\n          ", "\n          if (", ") {\n            ", ".setNullAt(", ");\n          } else {\n            ", ";\n          }\n        }\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fromFieldNull, this.tmpInput$1, BoxesRunTime.boxToInteger((int)i), fromFieldNull, this.tmpResult$1, BoxesRunTime.boxToInteger((int)i), fromType, fromFieldPrim, this.ctx$4.getValue(this.tmpInput$1, this.from$2.fields()[i].dataType(), ((Object)BoxesRunTime.boxToInteger((int)i)).toString()), this.$outer.org$apache$spark$sql$catalyst$expressions$Cast$$castCode(this.ctx$4, fromFieldPrim, fromFieldNull, toFieldPrim, toFieldNull, this.to$2.fields()[i].dataType(), (Function3<String, String, String, String>)cast2), toFieldNull, this.tmpResult$1, BoxesRunTime.boxToInteger((int)i), this.ctx$4.setColumn(this.tmpResult$1, this.to$2.fields()[i].dataType(), i, toFieldPrim)}));
                    return string;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.from$2 = from$2;
                this.to$2 = to$2;
                this.ctx$4 = ctx$4;
                this.tmpResult$1 = tmpResult$1;
                this.tmpInput$1 = tmpInput$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        Tuple2 tuple2 = new Tuple2((Object)"InternalRow", (Object)tmpInput);
        Tuple2 tuple22 = new Tuple2((Object)rowClass, (Object)tmpResult);
        String fieldsEvalCodes = ctx.splitExpressions((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])fieldsEvalCode), "castStruct", (Seq<Tuple2<String, String>>)Nil$.MODULE$.$colon$colon((Object)tuple22).$colon$colon((Object)tuple2), ctx.splitExpressions$default$4(), ctx.splitExpressions$default$5(), ctx.splitExpressions$default$6());
        return new Serializable(this, fieldsCasts, rowClass, tmpResult, tmpInput, fieldsEvalCodes){
            public static final long serialVersionUID = 0L;
            private final Function3[] fieldsCasts$1;
            private final String rowClass$1;
            private final String tmpResult$1;
            private final String tmpInput$1;
            private final String fieldsEvalCodes$1;

            public final String apply(String input, String result, String resultIsNull) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        final ", " ", " = new ", "(", ");\n        final InternalRow ", " = ", ";\n        ", "\n        ", " = ", ";\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.rowClass$1, this.tmpResult$1, this.rowClass$1, BoxesRunTime.boxToInteger((int)this.fieldsCasts$1.length), this.tmpInput$1, input, this.fieldsEvalCodes$1, result, this.tmpResult$1}));
            }
            {
                this.fieldsCasts$1 = fieldsCasts$1;
                this.rowClass$1 = rowClass$1;
                this.tmpResult$1 = tmpResult$1;
                this.tmpInput$1 = tmpInput$1;
                this.fieldsEvalCodes$1 = fieldsEvalCodes$1;
            }
        };
    }

    @Override
    public String sql() {
        DataType dataType2 = this.dataType();
        boolean bl = dataType2 instanceof ArrayType ? true : (dataType2 instanceof MapType ? true : dataType2 instanceof StructType);
        String string = bl ? this.child().sql() : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.child().sql(), this.dataType().sql()}));
        return string;
    }

    public Cast copy(Expression child, DataType dataType2, Option<String> timeZoneId) {
        return new Cast(child, dataType2, timeZoneId);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public DataType copy$default$2() {
        return this.dataType();
    }

    public Option<String> copy$default$3() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "Cast";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 2: {
                object = this.timeZoneId();
                break;
            }
            case 1: {
                object = this.dataType();
                break;
            }
            case 0: {
                object = this.child();
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Cast;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Cast)) return false;
        boolean bl = true;
        if (!bl) return false;
        Cast cast2 = (Cast)x$1;
        Expression expression = this.child();
        Expression expression2 = cast2.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        DataType dataType2 = this.dataType();
        DataType dataType3 = cast2.dataType();
        if (dataType2 == null) {
            if (dataType3 != null) {
                return false;
            }
        } else if (!dataType2.equals(dataType3)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = cast2.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!cast2.canEqual(this)) return false;
        return true;
    }

    private final String dataToStringFunc$1(String func, DataType dataType2, CodegenContext ctx$5) {
        String funcName = ctx$5.freshName(func);
        Function3<String, String, String, String> dataToStringCode = this.org$apache$spark$sql$catalyst$expressions$Cast$$castToStringCode(dataType2, ctx$5);
        return ctx$5.addNewFunction(funcName, new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |private UTF8String ", "(", " data) {\n           |  UTF8String dataStr = null;\n           |  ", "\n           |  return dataStr;\n           |}\n         "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{funcName, ctx$5.javaType(dataType2), dataToStringCode.apply((Object)"data", (Object)"dataStr", null)})))).stripMargin(), ctx$5.addNewFunction$default$3());
    }

    public Cast(Expression child, DataType dataType2, Option<String> timeZoneId) {
        this.child = child;
        this.dataType = dataType2;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression$class.$init$(this);
    }

    public Cast(Expression child, DataType dataType2) {
        this(child, dataType2, (Option<String>)None$.MODULE$);
    }
}

