/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.If$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(expr1, expr2, expr3) - If `expr1` evaluates to true, then returns `expr2`; otherwise returns `expr3`.", examples="\n    Examples:\n      > SELECT _FUNC_(1 < 2, 'a', 'b');\n       a\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005mg\u0001B\u0001\u0003\u0001>\u0011!!\u00134\u000b\u0005\r!\u0011aC3yaJ,7o]5p]NT!!\u0002\u0004\u0002\u0011\r\fG/\u00197zgRT!a\u0002\u0005\u0002\u0007M\fHN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\t\u00155A\u0011\u0011CE\u0007\u0002\u0005%\u00111C\u0001\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007CA\u000b\u0019\u001b\u00051\"\"A\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005e1\"a\u0002)s_\u0012,8\r\u001e\t\u0003+mI!\u0001\b\f\u0003\u0019M+'/[1mSj\f'\r\\3\t\u0011y\u0001!Q3A\u0005\u0002}\t\u0011\u0002\u001d:fI&\u001c\u0017\r^3\u0016\u0003AA\u0001\"\t\u0001\u0003\u0012\u0003\u0006I\u0001E\u0001\u000baJ,G-[2bi\u0016\u0004\u0003\u0002C\u0012\u0001\u0005+\u0007I\u0011A\u0010\u0002\u0013Q\u0014X/\u001a,bYV,\u0007\u0002C\u0013\u0001\u0005#\u0005\u000b\u0011\u0002\t\u0002\u0015Q\u0014X/\u001a,bYV,\u0007\u0005\u0003\u0005(\u0001\tU\r\u0011\"\u0001 \u0003)1\u0017\r\\:f-\u0006dW/\u001a\u0005\tS\u0001\u0011\t\u0012)A\u0005!\u0005Ya-\u00197tKZ\u000bG.^3!\u0011\u0015Y\u0003\u0001\"\u0001-\u0003\u0019a\u0014N\\5u}Q!QFL\u00181!\t\t\u0002\u0001C\u0003\u001fU\u0001\u0007\u0001\u0003C\u0003$U\u0001\u0007\u0001\u0003C\u0003(U\u0001\u0007\u0001\u0003C\u00033\u0001\u0011\u00053'\u0001\u0005dQ&dGM]3o+\u0005!\u0004cA\u001b>!9\u0011ag\u000f\b\u0003oij\u0011\u0001\u000f\u0006\u0003s9\ta\u0001\u0010:p_Rt\u0014\"A\f\n\u0005q2\u0012a\u00029bG.\fw-Z\u0005\u0003}}\u00121aU3r\u0015\tad\u0003C\u0003B\u0001\u0011\u0005#)\u0001\u0005ok2d\u0017M\u00197f+\u0005\u0019\u0005CA\u000bE\u0013\t)eCA\u0004C_>dW-\u00198\t\u000b\u001d\u0003A\u0011\t%\u0002'\rDWmY6J]B,H\u000fR1uCRK\b/Z:\u0015\u0003%\u0003\"AS'\u000e\u0003-S!\u0001\u0014\u0003\u0002\u0011\u0005t\u0017\r\\=tSNL!AT&\u0003\u001fQK\b/Z\"iK\u000e\\'+Z:vYRDQ\u0001\u0015\u0001\u0005BE\u000b\u0001\u0002Z1uCRK\b/Z\u000b\u0002%B\u00111KV\u0007\u0002)*\u0011QKB\u0001\u0006if\u0004Xm]\u0005\u0003/R\u0013\u0001\u0002R1uCRK\b/\u001a\u0005\u00063\u0002!\tEW\u0001\u0005KZ\fG\u000e\u0006\u0002\\=B\u0011Q\u0003X\u0005\u0003;Z\u00111!\u00118z\u0011\u001dy\u0006\f%AA\u0002\u0001\fQ!\u001b8qkR\u0004\"!\u00192\u000e\u0003\u0011I!a\u0019\u0003\u0003\u0017%sG/\u001a:oC2\u0014vn\u001e\u0005\u0006K\u0002!\tEZ\u0001\nI><UM\\\"pI\u0016$2aZ7s!\tA7.D\u0001j\u0015\tQ'!A\u0004d_\u0012,w-\u001a8\n\u00051L'\u0001C#yaJ\u001cu\u000eZ3\t\u000b9$\u0007\u0019A8\u0002\u0007\r$\b\u0010\u0005\u0002ia&\u0011\u0011/\u001b\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u0015\u0019H\r1\u0001h\u0003\t)g\u000fC\u0003v\u0001\u0011\u0005c/\u0001\u0005u_N#(/\u001b8h)\u00059\bC\u0001=|\u001d\t)\u00120\u0003\u0002{-\u00051\u0001K]3eK\u001aL!\u0001`?\u0003\rM#(/\u001b8h\u0015\tQh\u0003C\u0003\b\u0001\u0011\u0005s0F\u0001x\u0011%\t\u0019\u0001AA\u0001\n\u0003\t)!\u0001\u0003d_BLHcB\u0017\u0002\b\u0005%\u00111\u0002\u0005\t=\u0005\u0005\u0001\u0013!a\u0001!!A1%!\u0001\u0011\u0002\u0003\u0007\u0001\u0003\u0003\u0005(\u0003\u0003\u0001\n\u00111\u0001\u0011\u0011%\ty\u0001AI\u0001\n\u0003\t\t\"\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005M!f\u0001\t\u0002\u0016-\u0012\u0011q\u0003\t\u0005\u00033\t\u0019#\u0004\u0002\u0002\u001c)!\u0011QDA\u0010\u0003%)hn\u00195fG.,GMC\u0002\u0002\"Y\t!\"\u00198o_R\fG/[8o\u0013\u0011\t)#a\u0007\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0002*\u0001\t\n\u0011\"\u0001\u0002\u0012\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0004\"CA\u0017\u0001E\u0005I\u0011AA\t\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIMB\u0011\"!\r\u0001\u0003\u0003%\t%a\r\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t)\u0004\u0005\u0003\u00028\u0005\u0005SBAA\u001d\u0015\u0011\tY$!\u0010\u0002\t1\fgn\u001a\u0006\u0003\u0003\u007f\tAA[1wC&\u0019A0!\u000f\t\u0013\u0005\u0015\u0003!!A\u0005\u0002\u0005\u001d\u0013\u0001\u00049s_\u0012,8\r^!sSRLXCAA%!\r)\u00121J\u0005\u0004\u0003\u001b2\"aA%oi\"I\u0011\u0011\u000b\u0001\u0002\u0002\u0013\u0005\u00111K\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\rY\u0016Q\u000b\u0005\u000b\u0003/\ny%!AA\u0002\u0005%\u0013a\u0001=%c!I\u00111\f\u0001\u0002\u0002\u0013\u0005\u0013QL\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011q\f\t\u0006\u0003C\n9gW\u0007\u0003\u0003GR1!!\u001a\u0017\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003S\n\u0019G\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011%\ti\u0007AA\u0001\n\u0003\ty'\u0001\u0005dC:,\u0015/^1m)\r\u0019\u0015\u0011\u000f\u0005\n\u0003/\nY'!AA\u0002mC\u0011\"!\u001e\u0001\u0003\u0003%\t%a\u001e\u0002\r\u0015\fX/\u00197t)\r\u0019\u0015\u0011\u0010\u0005\n\u0003/\n\u0019(!AA\u0002mC3\u0002AA?\u0003\u0007\u000b))!#\u0002\fB\u0019\u0011#a \n\u0007\u0005\u0005%AA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005\u001d\u0015\u0001\\0G+:\u001bu\fK3yaJ\fD\u0006I3yaJ\u0014D\u0006I3yaJ\u001c\u0014\u0006I\u0017!\u0013\u001a\u0004\u0003-\u001a=qeF\u0002\u0007%\u001a<bYV\fG/Z:!i>\u0004CO];fY\u0001\"\b.\u001a8!e\u0016$XO\u001d8tA\u0001,\u0007\u0010\u001d:3An\u0002s\u000e\u001e5fe^L7/\u001a\u0011sKR,(O\\:!A\u0016D\bO]\u001aa]\u0005AQ\r_1na2,7/\t\u0002\u0002\u000e\u0006\u0011%\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0019!y\u0001\u0012D\u0006I\u0014bO1\u0002sEY\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\n'\u0002\t\u0011\b\u0013\u0005E%!!A\t\u0002\u0005M\u0015AA%g!\r\t\u0012Q\u0013\u0004\t\u0003\t\t\t\u0011#\u0001\u0002\u0018N)\u0011QSAM5AA\u00111TAQ!A\u0001R&\u0004\u0002\u0002\u001e*\u0019\u0011q\u0014\f\u0002\u000fI,h\u000e^5nK&!\u00111UAO\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\u0005\bW\u0005UE\u0011AAT)\t\t\u0019\nC\u0005v\u0003+\u000b\t\u0011\"\u0012\u0002,R\u0011\u0011Q\u0007\u0005\u000b\u0003_\u000b)*!A\u0005\u0002\u0006E\u0016!B1qa2LHcB\u0017\u00024\u0006U\u0016q\u0017\u0005\u0007=\u00055\u0006\u0019\u0001\t\t\r\r\ni\u000b1\u0001\u0011\u0011\u00199\u0013Q\u0016a\u0001!!Q\u00111XAK\u0003\u0003%\t)!0\u0002\u000fUt\u0017\r\u001d9msR!\u0011qXAf!\u0015)\u0012\u0011YAc\u0013\r\t\u0019M\u0006\u0002\u0007\u001fB$\u0018n\u001c8\u0011\rU\t9\r\u0005\t\u0011\u0013\r\tIM\u0006\u0002\u0007)V\u0004H.Z\u001a\t\u0013\u00055\u0017\u0011XA\u0001\u0002\u0004i\u0013a\u0001=%a!Q\u0011\u0011[AK\u0003\u0003%I!a5\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003+\u0004B!a\u000e\u0002X&!\u0011\u0011\\A\u001d\u0005\u0019y%M[3di\u0002")
public class If
extends Expression
implements Serializable {
    private final Expression predicate;
    private final Expression trueValue;
    private final Expression falseValue;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(If if_) {
        return If$.MODULE$.unapply(if_);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, If> tupled() {
        return If$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, If>>> curried() {
        return If$.MODULE$.curried();
    }

    public Expression predicate() {
        return this.predicate;
    }

    public Expression trueValue() {
        return this.trueValue;
    }

    public Expression falseValue() {
        return this.falseValue;
    }

    @Override
    public Seq<Expression> children() {
        Expression expression = this.predicate();
        Expression expression2 = this.trueValue();
        Expression expression3 = this.falseValue();
        return Nil$.MODULE$.$colon$colon((Object)expression3).$colon$colon((Object)expression2).$colon$colon((Object)expression);
    }

    @Override
    public boolean nullable() {
        return this.trueValue().nullable() || this.falseValue().nullable();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        DataType dataType2 = this.predicate().dataType();
        BooleanType$ booleanType$ = BooleanType$.MODULE$;
        return !(dataType2 != null ? !dataType2.equals(booleanType$) : booleanType$ != null) ? (this.trueValue().dataType().sameType(this.falseValue().dataType()) ? TypeCheckResult$TypeCheckSuccess$.MODULE$ : new TypeCheckResult.TypeCheckFailure(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"differing types in '", "' "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.sql()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", " and ", ")."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.trueValue().dataType().simpleString(), this.falseValue().dataType().simpleString()}))).toString())) : new TypeCheckResult.TypeCheckFailure(new StringBuilder().append((Object)"type of predicate expression in If should be boolean, ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"not ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.predicate().dataType().simpleString()}))).toString());
    }

    @Override
    public DataType dataType() {
        return this.trueValue().dataType();
    }

    @Override
    public Object eval(InternalRow input) {
        return Boolean.TRUE.equals(this.predicate().eval(input)) ? this.trueValue().eval(input) : this.falseValue().eval(input);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode condEval = this.predicate().genCode(ctx);
        ExprCode trueEval = this.trueValue().genCode(ctx);
        ExprCode falseEval = this.falseValue().genCode(ctx);
        String code = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", "\n         |boolean ", " = false;\n         |", " ", " = ", ";\n         |if (!", " && ", ") {\n         |  ", "\n         |  ", " = ", ";\n         |  ", " = ", ";\n         |} else {\n         |  ", "\n         |  ", " = ", ";\n         |  ", " = ", ";\n         |}\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{condEval.code(), ev.isNull(), ctx.javaType(this.dataType()), ev.value(), ctx.defaultValue(this.dataType()), condEval.isNull(), condEval.value(), trueEval.code(), ev.isNull(), trueEval.isNull(), ev.value(), trueEval.value(), falseEval.code(), ev.isNull(), falseEval.isNull(), ev.value(), falseEval.value()})))).stripMargin();
        return ev.copy(code, ev.copy$default$2(), ev.copy$default$3());
    }

    @Override
    public String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"if (", ") ", " else ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.predicate(), this.trueValue(), this.falseValue()}));
    }

    @Override
    public String sql() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(IF(", ", ", ", ", "))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.predicate().sql(), this.trueValue().sql(), this.falseValue().sql()}));
    }

    public If copy(Expression predicate, Expression trueValue, Expression falseValue) {
        return new If(predicate, trueValue, falseValue);
    }

    public Expression copy$default$1() {
        return this.predicate();
    }

    public Expression copy$default$2() {
        return this.trueValue();
    }

    public Expression copy$default$3() {
        return this.falseValue();
    }

    @Override
    public String productPrefix() {
        return "If";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 2: {
                expression = this.falseValue();
                break;
            }
            case 1: {
                expression = this.trueValue();
                break;
            }
            case 0: {
                expression = this.predicate();
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof If;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof If)) return false;
        boolean bl = true;
        if (!bl) return false;
        If if_ = (If)x$1;
        Expression expression = this.predicate();
        Expression expression2 = if_.predicate();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.trueValue();
        Expression expression4 = if_.trueValue();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.falseValue();
        Expression expression6 = if_.falseValue();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!if_.canEqual(this)) return false;
        return true;
    }

    public If(Expression predicate, Expression trueValue, Expression falseValue) {
        this.predicate = predicate;
        this.trueValue = trueValue;
        this.falseValue = falseValue;
    }
}

